deferred class
	--
	-- The tclmidi syntax of events, how they are parsed and how they are
	-- written.
	--
	EVENT_SYNTAX

feature -- Initialization
	make(c: like context) is
			-- create event parsing/format features
		require
			not_void: c /= Void
		do
			context := c
		ensure
			context_set: context = c
		end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- fill in event fields with data from arguments
		require
			not_void: e /= Void and then args /= Void
			proper_type: proper_event(e)
		deferred
		end

feature -- Format
	format(time: INTEGER; e: EVENT): STRING is
			-- print the event in tclmidi format
		require
			not_negative: time >= 0
			not_void: e /= Void
			proper_type: proper_event(e)
		do
			!!Result.copy(time.to_string)
			Result.append(" ")
			Result.append(event_name(e))
			Result.append(" ")
			Result.append(format_data(e))
		end

	is_printable(e: EVENT): BOOLEAN is
			-- the event will print something
		do
			Result := True
		end

feature -- Access
	error: BOOLEAN
	error_description: STRING
	context: COMMAND_CONTEXT
	event_name(e: EVENT): STRING is deferred end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- Does the event e match our type expectations?
		require
			not_void: e /= Void
		deferred
		end

feature {EVENT_SYNTAX} -- Implementation
	off_by_one: BOOLEAN is
			-- Is old style where counting began at 0, not 1?
		do
			if context.compatibility_mode /= Void then
				if context.compatibility_mode.has_prefix("3.") or else
					context.compatibility_mode.is_equal("3") or else
					context.compatibility_mode.has_prefix("2.") or else
					context.compatibility_mode.is_equal("2") or else
					context.compatibility_mode.has_prefix("1.") or else
					context.compatibility_mode.is_equal("1") then
						Result := True
				end
			end
		end

	format_data(e: EVENT): STRING is
			-- print the data part of an event in tclmidi format
		require
			not_void: e /= Void
			proper_type: proper_event(e)
		deferred
		end

end -- EVENT_SYNTAX
