class
	--
	-- tclmidi syntax for channel type events
	--
	SYNTAX_CHANNEL

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "Channel" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			chan: CHANNEL_EVENT
			chan_num: INTEGER
		do
			chan ?= e

			-- third argument should be channel number
			error := False
			if not args.item(3).is_integer then
				if args.item(3).is_equal("*") then
					chan.set_channel_wildcard
				else
					error := True
					!!error_description.copy("Invalid channel '")
					error_description.append(args.item(3))
					error_description.append("'")
				end
			else
				chan_num := args.item(3).to_integer
				if off_by_one then
					chan_num := chan_num + 1
				end
				if chan_num >= 1 or else chan_num <= 16 then
					chan.set_channel(chan_num)
				else
					error := True
					!!error_description.copy("Invalid channel value '")
					error_description.append(args.item(3))
					error_description.append("': should be in range ")
					if off_by_one then
						error_description.append("0 to 15")
					else
						error_description.append("1 to 16")
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			chan: CHANNEL_EVENT
			chan_num: INTEGER
		do
			chan ?= e
			if chan.channel_wildcard then
				!!Result.copy("*")
			else
				chan_num := chan.channel
				if off_by_one then
					chan_num := chan_num - 1
				end
				!!Result.copy(chan_num.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a CHANNEL_EVENT?
		local
			chan: CHANNEL_EVENT
		do
			chan ?= e
			Result := chan /= Void
		end

end -- SYNTAX_CHANNEL
