class
	--
	-- tclmidi syntax for channel_pressure events
	--
	SYNTAX_CHANNEL_PRESSURE

inherit
	SYNTAX_CHANNEL
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "ChannelPressure" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a channel event from arguments
		local
			chan_pres: CHANNEL_PRESSURE_EVENT
			pres: INTEGER
		do
			error := False
			if args.count /= 4 then
				error := True
				error_description := "wrong number of args: should be %
					%'time ChannelPressure channel pressure'";
			else
				precursor(e, args)
				if not error then
					chan_pres ?= e

					-- fourth argument should be pressure
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							chan_pres.set_pressure_wildcard
						else
							error := True
							!!error_description.copy("Invalid pressure '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						pres := args.item(4).to_integer
						if pres >= 0 and then pres <= 128 then
							chan_pres.set_pressure(pres)
						else
							error := True
							!!error_description.copy("Invalid pressure value '")
							error_description.append(args.item(4))
							error_description.append("': should be in range %
								%0 to 128")
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			chan_pres: CHANNEL_PRESSURE_EVENT
		do
			Result := precursor(e)

			chan_pres ?= e
			Result.append(" ")
			if chan_pres.pressure_wildcard then
				Result.append("*")
			else
				Result.append(chan_pres.pressure.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a CHANNEL_PRESSURE_EVENT?
		local
			chan_pres: CHANNEL_PRESSURE_EVENT
		do
			chan_pres ?= e
			Result := chan_pres /= Void
		end

end -- SYNTAX_CHANNEL_PRESSURE
