class
	--
	-- tclmidi syntax for meta_end_of_track events
	--
	SYNTAX_META_END_OF_TRACK

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaEndOfTrack" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create an EOT event
		do
			error := False
			if args.count /= 2 then
				error := True
				error_description := "wrong number of args: should be %
					%'time MetaEndOfTrack'";
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		do
			!!Result.copy("")
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_END_OF_TRACK_EVENT?
		local
			eot: META_END_OF_TRACK_EVENT
		do
			eot ?= e
			Result := eot /= Void
		end

end -- SYNTAX_META_END_OF_TRACK
