class
	--
	-- tclmidi syntax for meta_text events
	--
	SYNTAX_META_TEXT

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaText" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a meta text event from arguments
		local
			text: META_TEXT_EVENT
		do
			error := False
			if args.count /= 3 then
				error := True
				!!error_description.copy("wrong number of args: should be %
					%'time ")
				error_description.append(event_name(e))
				error_description.append(" text'")
			else
				text ?= e

				if args.item(3).is_equal("*") then
					text.set_text_wildcard
				else
					text.set_text(args.item(3))
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			text: META_TEXT_EVENT
		do
			text ?= e
			if text.text_wildcard then
				!!Result.copy("*")
			else
				if not text.text.has(' ') then
					!!Result.copy(text.text)
				else
					!!Result.copy("{")
					Result.append(text.text)
					Result.append("}")
				end
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_TEXT_EVENT?
		local
			text: META_TEXT_EVENT
		do
			text ?= e
			Result := text /= Void
		end

end -- SYNTAX_META_TEXT
