class
	--
	-- tclmidi syntax for meta_time events
	--
	SYNTAX_META_TIME

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaTime" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a meta time event from arguments
		local
			time: META_TIME_EVENT
			n, d, c, ts: INTEGER
		do
			error := False
			if args.count /= 6 then
				error := True
				error_description := "wrong number of args: should be %
					%'time MetaTime numerator denominator clocks/beat %
					%32nds/quarter'";
			else
				time ?= e

				if not args.item(3).is_integer then
					if args.item(3).is_equal("*") then
						time.set_numerator_wildcard
					else
						error := True
						!!error_description.copy("Invalid numerator '")
						error_description.append(args.item(3))
						error_description.append("'")
					end
				else
					n := args.item(3).to_integer
					if n >= 1 and then n <= 255 then
						time.set_numerator(n)
					else
						error := True
						!!error_description.copy("Invalid numerator value '")
						error_description.append(args.item(3))
						error_description.append("': should be between 1 %
							%and 255")
					end
				end

				if not error then
					if not args.item(4).is_integer then
						if args.item(4).is_equal("*") then
							time.set_denominator_wildcard
						else
							error := True
							!!error_description.copy("Invalid denominator '")
							error_description.append(args.item(4))
							error_description.append("'")
						end
					else
						d := args.item(4).to_integer
						if d >= 0 and then time.is_power_of_two(d) then
							time.set_denominator(d)
						else
							error := True
							!!error_description.copy("Invalid denominator %
								%value '")
							error_description.append(args.item(4))
							error_description.append("': should be greater %
								%than 0 and a power of two")
						end
					end
				end

				if not error then
					if not args.item(5).is_integer then
						if args.item(5).is_equal("*") then
							time.set_clocks_wildcard
						else
							error := True
							!!error_description.copy("Invalid clocks '")
							error_description.append(args.item(5))
							error_description.append("'")
						end
					else
						c := args.item(5).to_integer
						if c >= 0 and then c <= 255 then
							time.set_clocks(c)
						else
							error := True
							!!error_description.copy("Invalid clocks value '")
							error_description.append(args.item(5))
							error_description.append("': should be in range 0 %
								%to 255")
						end
					end
				end

				if not error then
					if not args.item(6).is_integer then
						if args.item(6).is_equal("*") then
							time.set_thirty_seconds_wildcard
						else
							error := True
							!!error_description.copy("Invalid 32nds '")
							error_description.append(args.item(6))
							error_description.append("'")
						end
					else
						ts := args.item(6).to_integer
						if ts >= 0 and then ts <= 255 then
							time.set_thirty_seconds(ts)
						else
							error := True
							!!error_description.copy("Invalid 32nds value '")
							error_description.append(args.item(6))
							error_description.append("': should be in range 0 %
								%to 255")
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			time: META_TIME_EVENT
		do
			time ?= e
			if time.numerator_wildcard then
				!!Result.copy("*")
			else
				!!Result.copy(time.numerator.to_string)
			end

			Result.append(" ")
			if time.denominator_wildcard then
				Result.append("*")
			else
				Result.append(time.denominator.to_string)
			end

			Result.append(" ")
			if time.clocks_wildcard then
				Result.append("*")
			else
				Result.append(time.clocks.to_string)
			end

			Result.append(" ")
			if time.thirty_seconds_wildcard then
				Result.append("*")
			else
				Result.append(time.thirty_seconds.to_string)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_TIME_EVENT?
		local
			time: META_TIME_EVENT
		do
			time ?= e
			Result := time /= Void
		end

end -- SYNTAX_META_TIME
