class
	--
	-- tclmidi syntax for meta_unknown events
	--
	SYNTAX_META_UNKNOWN

inherit
	EVENT_SYNTAX
		redefine
			event_name, parse, format_data, proper_event
		end

creation
	make

feature -- Access
	event_name(e: EVENT): STRING is do Result := "MetaUnknown" end

feature -- Parse
	parse(e: EVENT; args: ARRAY[STRING]) is
			-- create a meta unknown event from arguments
		local
			uk: META_UNKNOWN_EVENT
			code, i: INTEGER
			tcl_list: TCL_LIST
			data_list: ARRAY[STRING]
			data: ARRAY[INTEGER]
		do
			error := False
			if args.count /= 4 then
				error := True
				error_description := "wrong number of args: should be %
					%'time MetaUnknown code data'";
			else
				uk ?= e

				if not args.item(3).is_integer then
					if args.item(3).is_equal("*") then
						uk.set_code_wildcard
					else
						error := True
						!!error_description.copy("Invalid code '")
						error_description.append(args.item(3))
						error_description.append("'")
					end
				else
					code := args.item(3).to_integer
					if code >= 0 and then code <= 255 then
						uk.set_code(code)
					else
						error := True
						!!error_description.copy("Invalid code value '")
						error_description.append(args.item(3))
						error_description.append("': should be between 0 %
							%and 255")
					end
				end

				if not error then
					if args.item(4).is_equal("*") then
						uk.set_data_wildcard
					else
						!!tcl_list.make_from_list(context.tcl_interp,
							args.item(4))
						tcl_list.split
						if tcl_list.error then
							error := True
						else
							data_list := tcl_list.split_list
							!!data.make(1, data_list.count)
							from
								i := 1
							until
								i > data_list.count or else error
							loop
								if not data_list.item(i).is_integer then
									error := True
									!!error_description.copy("Invalid data %
										%value '")
									error_description.append(data_list.item(i))
									error_description.append("'")
								else
									data.put(data_list.item(i).to_integer, i)
								end
					
								i := i + 1
							end
							if not error then
								uk.set_data(data)
							end
						end
					end
				end
			end
		end

feature -- Format
	format_data(e: EVENT): STRING is
		local
			uk: META_UNKNOWN_EVENT
			tcl_list: TCL_LIST
			data_list: ARRAY[STRING]
			i: INTEGER
		do
			uk ?= e
			if uk.code_wildcard then
				!!Result.copy("*")
			else
				!!Result.copy(uk.code.to_string)
			end

			Result.append(" ")
			if uk.data_wildcard then
				Result.append("*")
			else
				!!data_list.make(1, uk.data.count)
				from
					i := 1
				until
					i > uk.data.count
				loop
					data_list.put(uk.data.item(i).to_string, i)
					i := i + 1
				end
				!!tcl_list.make_from_split(context.tcl_interp, data_list)
				tcl_list.merge
				Result.append(tcl_list.list)
			end
		end

feature -- Sanity
	proper_event(e: EVENT): BOOLEAN is
			-- is e really a META_UNKNOWN_EVENT?
		local
			uk: META_UNKNOWN_EVENT
		do
			uk ?= e
			Result := uk /= Void
		end

end -- SYNTAX_META_UNKNOWN
