class
	--
	-- A Tcl_Channel - can be used for reading or writing
	--
	TCL_CHANNEL

feature -- Access
	channel: POINTER

feature -- Element Change
	set_channel(c: like channel) is
			-- set the channel
		do
			channel := c
		ensure
			channel_set: channel = c
		end

feature -- C linkage
	call_tcl_get_channel(interp: POINTER; name: STRING; mode: STRING;
	    chan: like Current) is
			-- call the Tcl_GetChannel C function
		external "C_WithoutCurrent"
		alias "c_tcl_get_channel"
		end

	call_tcl_eof(chan: like channel; eof: INTEGER_REF) is
			-- call the Tcl_Eof C function
		external "C_WithoutCurrent"
		alias "c_tcl_eof"
		end

	call_tcl_read(chan: like channel; buf: ARRAY[CHARACTER];
		num_to_read: INTEGER) is
			-- call the Tcl_Read C function
		external "C_WithoutCurrent"
		alias "c_tcl_read"
		end

	call_tcl_write(chan: like channel; buf: ARRAY[CHARACTER];
		num_to_write: INTEGER) is
			-- call the Tcl_Write C function
		external "C_WithoutCurrent"
		alias "c_tcl_write"
		end

	call_tcl_flush(chan: like channel) is
			-- call the Tcl_Flush C function
		external "C_WithoutCurrent"
		alias "c_tcl_flush"
		end

	call_tcl_set_channel_option(interp: POINTER; chan: like channel;
		option_name: STRING; option_value: STRING) is
			-- call the Tcl_SetChannelOption C function
		external "C_WithoutCurrent"
		alias "c_tcl_set_channel_option"
		end

end -- TCL_CHANNEL
