#include <stdio.h>
#include <tcl.h>
#include "eiffel.h"

void
c_tcl_get_channel(Tcl_Interp *interp, void *filename, void *mode,
    void *eiffel_tcl_channel)
{
	char *filename_str, *mode_str;
	int i, m;
	char *c;
	Tcl_Channel channel;

	filename_str = eiffel_string_to_external(filename);
	mode_str = eiffel_string_to_external(mode);

	m = 0;
	for (c = mode_str; *c != '\0'; c++) {
		switch (*c) {
		case 'r':
		case 'R':
			m |= TCL_READABLE;
			break;
		case 'w':
		case 'W':
			m |= TCL_WRITABLE;
			break;
		}
	}

	channel = Tcl_GetChannel(interp, filename_str, &m);

	eiffel_set_channel(eiffel_tcl_channel, channel);
}

void
c_tcl_eof(Tcl_Channel channel, void *eof)
{
	int ret;

	ret = Tcl_Eof(channel);

	eiffel_set_integer(eof, ret);
}

void
c_tcl_read(Tcl_Channel channel, void *e_array, int num_to_read)
{
	char *buf;
	int i, num_read;

	buf = Tcl_Alloc(num_to_read);
	num_read = Tcl_Read(channel, buf, num_to_read);
	for (i = 0; i < num_read; i++)
		eiffel_array_put_char(e_array, buf[i], i + 1);
	Tcl_Free(buf);
}

void
c_tcl_write(Tcl_Channel channel, void *e_array, int num_to_write)
{
	char *buf;
	int i, num_written;

	buf = Tcl_Alloc(num_to_write);
	for (i = 0; i < num_to_write; i++)
		buf[i] = eiffel_array_get_char(e_array, i + 1);
	Tcl_Write(channel, buf, num_to_write);
	Tcl_Free(buf);
}

void
c_tcl_flush(Tcl_Channel channel)
{

	Tcl_Flush(channel);
}

void
c_tcl_set_channel_option(Tcl_Interp *interp, Tcl_Channel channel,
    void *option_name, void *option_value)
{
	char *option_name_str, *option_value_str;

	option_name_str = eiffel_string_to_external(option_name);
	option_value_str = eiffel_string_to_external(option_value);
	Tcl_SetChannelOption(interp, channel, option_name_str,
	    option_value_str);
}
