#
#  finance.uk.yahoo.com stock service
#  for european markets
#  yahoo provides a nice 'csv' format, easy to parse
#  decimal values returned by yahoo

proc finance.uk.yahoo.com {} {
    global ticker_symbols data
    set i 0
    set symbol_list ""
    while {[info exists ticker_symbols([incr i])]} {
	lappend symbol_list [string toupper $ticker_symbols($i)]
    }
    if {[llength $symbol_list] == 0} {
        return 0
    }
    foreach sym $symbol_list {
        set newdata($sym,last) ""
        set newdata($sym,sign) ""
        set newdata($sym,delta) ""
    }
    set symvar [cgi_cgi_set s $symbol_list]
    set timeout [expr {3 * 60000}]
    set id [http::geturl \
        http://finance.uk.yahoo.com/quote.csv?d=s&$symvar \
	-timeout $timeout]
    if {"[http::wait $id]" != "ok"} {
	return 0
    }
    set html [http::data $id]
    catch {unset $id}
    foreach line [lrange [split $html \n] 1 end] {
	# further split on comma to separate quote values
	set datavals [split $line ,]
	if {[llength $datavals] != 8} continue
	foreach {sym last datetime change low high close vol} $datavals {
	    break
	}
	# remove double quotes around symbols
	regsub -all \" $sym    {} sym
	regsub -all \" $last   {} last
	regsub -all \" $change {} change
	# make sure symbol and quote values are valid
	if {[string length $sym] == 0} continue
	if {[scan $last   %f v] != 1}  continue
	if {[scan $change %f v] != 1}  continue

	set newdata($sym,last) $last
        if {$change > 0} {
	    set newdata($sym,sign) +
	} elseif {$change < 0} {
	    set newdata($sym,sign) -
	} else {
	    set newdata($sym,sign) =
	}
	set newdata($sym,delta) $change
    }
    array set data [array get newdata]
    return 1
}


