#
#  www2.marketwatch.com stock service, formerly www.quote.com
#  provides a typical html table buried in the page, lots of
#  parsing to get the values
#  fractional values returned by quote.com, no daily change on mutual funds

proc www2.marketwatch.com {} {
    global ticker_symbols data
    set i 0
    set symbol_list ""
    while {[info exists ticker_symbols([incr i])]} {
	lappend symbol_list $ticker_symbols($i)
    }
    if {[llength $symbol_list] == 0} {
        return 0
    }
    if {[llength $symbol_list] == 1} {
	# a single symbol returns a different format, add a bogus symbol
	lappend symbol_list BOGUSTICK
    }
    set symvar [cgi_cgi_set symb $symbol_list]
    # strip out possible tcl quotes
    regsub -all {{|}} $symvar {} symvar
    regsub -all {\$} $symvar %24 symvar
    set timeout [expr {3 * 60000}]    
    set id [http::geturl \
       http://www2.marketwatch.com/quotes/multiquote.asp?orig=%2Fquotes%2Fmultiquote.asp&source=htx%2Fhttp2_mw&${symvar}&mode=quote \
	-timeout $timeout]
    if {"[http::wait $id]" != "ok"} {
	return 0
    }
    set html [http::data $id]
    catch {unset $id}
    # find start of quote table, stock or fund, throw away beginning portion
    if {[regexp -indices {Last} $html indx]} {
	set html [string range $html [lindex $indx 1] end]
    }
    # clean up newlines and special characters
    regsub -all \n $html { } html
    regsub -all \r $html { } html
    regsub -all {&nbsp;} $html { } html
    # make each table row a newline so with can split on it
    regsub -all -nocase {</tr>} $html \n html
    foreach line [lrange [split $html \n] 1 end] {
	# if we hit another TABLE line, we've got all info, break out
	#if {[regexp -nocase TABLE $line]} break
	# make the table data tags a newline so we can further split it
	regsub -all -nocase {</td>} $line \n line
	# remove all other html tags
        regsub -all {<[^>]*>} $line { } line
	# remove any left over html tag stuff
	regsub -all {>} $line {} line
	# make multiple whitespace into a single space
	regsub -all "\[ \t\]\[ \t\]?" $line { } line
	# make fractional values neater by eliminating spaces around /
	regsub -all " / " $line / line
	set quoteline  [split $line \n]
	# stock and mutual funds come back in different tables :(
	if {[llength $quoteline] == 10} {
	    # stock line: pick out symbol, last, and quote
	    foreach {sym last change} $quoteline {
	        break
	    }
	} else {
	    continue
	}
	set sym [string trim $sym]
	# make sure we don't get our bogus symbol, or any other bad symbols
	if {[string compare $sym BOGUSTICK] == 0} continue
	if {[string length $sym] == 0} continue
	if {[scan $last   %f v] != 1}    continue

	set newdata($sym,last) [string trim $last]
	# look at the + or - in the change string
	regsub {n/a} $change {} change
        if {[regexp -- - $change]} {
	    set newdata($sym,sign) -
	} elseif {[regexp -- \\+ $change]} {
	    set newdata($sym,sign) +
	} else {
	    set newdata($sym,sign) =
	}
	regsub -- {(-|\+)( *)} $change \\1 change
	set newdata($sym,delta) [string trim $change]
    }
    catch {unset data}
    global data
    array set data [array get newdata]
    return 1
}


proc www2.marketwatch.com_lookup {str} {
    if {[string length $str] == 0} { 
        return ""
    }   
    set symco_list ""
    set symvar [cgi_cgi_set symb $str]        
    set timeout [expr {3 * 60000}]
    set id [http::geturl \ 
        http://www2.marketwatch.com/lookup/lookup.asp?orig=&source=htx%2Fhttp2_mw&$symvar
        -timeout $timeout]
    if {"[http::wait $id]" != "ok"} {
        return ""
    }
    set html [http::data $id]
    catch {unset $id}
    if {[regexp -nocase {Symbol not found} $html]} {   
        return ""
    }
    if {[regexp -indices {Exchange} $html indx]} {
        set html [string range $html [lindex $indx 1] end]
    }
    # clean up newlines and special characters
    regsub -all \n $html { } html
    regsub -all \r $html { } html
    regsub -all {&nbsp;} $html { } html
    # make each table row a newline so with can split on it
    regsub -all -nocase {</tr>} $html \n html
    foreach line [lrange [split $html \n] 1 end] {
        # make the table data tags a newline so we can further split it
        regsub -all -nocase {</td>} $line \n line
        # remove all other html tags
        regsub -all {<[^>]*>} $line { } line
        # remove any left over html tag stuff
        regsub -all {>} $line {} line
        # make multiple whitespace into a single space
        regsub -all "\[ \t\]\[ \t\]?" $line { } line
        set line [split $line \n]
        if {[llength $line] == 5} {
            set sym [string trim [lindex $line 2]]
            set co  "[string trim [lindex $line 0]]"
            lappend symco_list $sym $co
        }
    }
    return $symco_list
}

