#############################################################
# RTF.spec 
# SGML-to-RTF translation specification for Cost
# $Id: RTF.spec,v 1.8 1998/12/24 03:23:12 joe Exp $
# $Date: 1998/12/24 03:23:12 $
#############################################################
#
# Copyright (C) 1996 Joe English
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted.
#
# THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#############################################################
# RATFINK lives at <URL:http://www.flightlab.com/cost/ratfink/>
#############################################################

require rtflib.tcl

proc rtf:warning {text} {
    puts stderr "RTF warning: $text\n at [whereami]"
}

proc whereami {} {
    set result ""
    foreachNode rootpath el {
       lappend result "[q gi]([childNumber])"
    }
    return $result
}

proc rtf:warnUnmapped {gi} {
    global undefgis
    if ![info exists undefgis($gi)] {
	rtf:warning "Don't know how to process element <$gi>" 
	set undefgis($gi) 1
    }
}

global rtfSpec ; set rtfSpec "rtfSpec"

proc identity {text} { return $text }

environment rtfEnv { 
    sdataFilter identity
    cdataFilter identity
    RE	" " 
    currentStyle default
}
proc rtf:convert {specname} {
    global rtfSpec
    set oldSpec $rtfSpec
    set rtfSpec $specname
    rtfConvert
    set rtfSpec $oldSpec
}

proc rtf:currentParaStyle {} {
    global rtfSpec
    foreachNode ancestor el {
	if [$rtfSpec has continuedStyle] {
	    return [$rtfSpec get continuedStyle]
	}
    }
    return [rtfEnv get currentStyle]
}

eventHandler rtfConvert -global {
    START {
	rtf:write [subst [$rtfSpec get before ""]]
	rtfEnv save
	# %%% Document this:
	foreach param {cdataFilter sdataFilter currentStyle RE} {
	    if {[$rtfSpec has $param]} {
		rtfEnv set $param [$rtfSpec get $param]
	    }
	}
	switch [$rtfSpec get rtf unknown] {
	    #IMPLIED	{ }
	    none	{ }
	    para 	{ rtf:startPara [subst [$rtfSpec get paraStyle]] }
	    phrase 	{ rtf:startPhrase [subst [$rtfSpec get charStyle]] }
	    section	{ rtf:startSection [subst [$rtfSpec get sectStyle]] }
	    linespecific {
		rtf:startPara [subst [$rtfSpec get paraStyle]]
		rtfEnv set RE "\\line\n"
	    }
	    special	{ }
	    unknown	{ rtf:warnUnmapped [q gi] }
	    default	{ 
		rtf:warnUnmapped "[q gi] rtf=[$rtfSpec get rtf]"
	    }
	}
	$rtfSpec do startAction
	rtf:write [subst [$rtfSpec get prefix ""]]
    }
    END {
	rtf:write [subst [$rtfSpec get suffix ""]]
	$rtfSpec do endAction
	switch [$rtfSpec get rtf unknown] {
	    para 	{ rtf:endPara }
	    phrase 	{ rtf:endPhrase }
	    special	{ }
	    section	{ rtf:endSection }
	    linespecific { rtf:endPara }
	    default	{ }
	}
	rtfEnv restore
	rtf:write [subst [$rtfSpec get after ""]]
    }
    CDATA	{ rtf:text [[subst [rtfEnv get cdataFilter]] [content]] }
    RE  	{ if $rtf_state(inpara) { rtf:write [rtfEnv get RE] }}
    SDATA	{ rtf:write [[subst [rtfEnv get sdataFilter]] [content]] }
    DATAENT	{ $rtfSpec do content }
}

