/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * File:	costq.h
 * Author:	Joe English
 * Created:	1 Mar 1995
 * Requires:	esis.h
 * Description:	Definitions for CoST query procedures
 *
 * 1996/01/16 12:39:52
 * 1.5
 * 
 */


#ifndef COSTQ_H
#define COSTQ_H 1

typedef enum 
{
    CQ_FAIL = 0,
    CQ_SUCCEED = 1
} CQStatus;

/* 
 * Continuation routines:
 * If 'data' is non-NULL, the query is returning a value.
 * If 'nd' is non-NULL, the query has reached the end.
 * If both are NULL, the query has failed.
 * NB: 'data' != 0 implies 'nd' != 0.
 */
typedef CQStatus (*CQContinuation)(ESISNode nd,const char *data,void *closure);

typedef void **CQQuery;	/* opaque; see costq.c for interpretation */
extern CQQuery cq_buildquery(char *args[], int nargs);
extern void cq_destroyquery(CQQuery q);

extern CQStatus cq_doquery(ESISNode start, CQQuery q,
	CQContinuation cc, void *closure);
extern int cq_testquery(ESISNode start, CQQuery q);

#endif
