/* 
 * tkStubImg.c --
 *
 *	Stub object that will be statically linked into extensions that wish
 *	to access Tk.
 *
 * Copyright (c) 1999 Jan Nijtmans.
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tkStubImg.c,v 1.0 2000/01/03 01:31:06 nijtmans Exp $
 */

#include "tcl.h"


/*
 *----------------------------------------------------------------------
 *
 * Tk_InitImageArgs --
 *
 *	Checks if Tk supports the Tcl_Obj based image API or the
 *	older string based one. If necessary does the conversion.
 *
 * Results:
 *	Modifies argvPtr to point to string in stead of objects.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef Tk_InitImageArgs
#undef Tk_InitImageArgs
#endif

void
Tk_InitImageArgs(interp, argc, argvPtr)
    Tcl_Interp *interp;
    int argc;
    char ***argvPtr;
{
    static useNewImage = -1;
    static char **argv = NULL;

    if (argv) {
	tclStubsPtr->tcl_Free((char *) argv);
	argv = NULL;
    }
    if (!argc) {
	return;
    }

    if (useNewImage < 0) {
	Tcl_CmdInfo cmdInfo;
	if (!tclStubsPtr->tcl_GetCommandInfo(interp,"image", &cmdInfo)) {
	    tclStubsPtr->tcl_Panic("cannot find the \"image\" command");
	}
	if (cmdInfo.isNativeObjectProc == 1) {
	    useNewImage = 1; /* Tk uses the new image interface */
	}
    }
    if (useNewImage) {
	int i;
	argv = (char **) tclStubsPtr->tcl_Alloc(argc * sizeof(char *));
	for (i = 0; i < argc; i++) {
	    argv[i] = tclStubsPtr->tcl_GetString((Tcl_Obj *)(*argvPtr)[i]);
	}
	*argvPtr = (char **) argv;
    }
}
