load /home/msp/prog/tcl_gtk/src/tcl_gtk.so Tcl_Gtk

proc mmucl::display {str} {
    variable Mmucl

    gtk::text insert $Mmucl(gtk,text) $str
}

proc mmucl::interface_init {} {
    variable Mmucl

    set w [gtk::window new toplevel]
    gtk::window title $w "Mmucl Gtk"
    
    set tbl [gtk::table new -rows 2 -columns 2]
    
    set text [gtk::text new]
    set Mmucl(gtk,text) $text
    
    set entry [gtk::entry new]
    
    set vadj [lindex [gtk::text adjustments $text] 1]
    set sc [gtk::vscrollbar new $vadj]
    
    gtk::table attach $tbl $text -left 0 -right 1 -top 0 -bottom 1 -expand xy \
            -fill xy
    gtk::table attach $tbl $entry -left 0 -right 1 -top 1 -bottom 2 -expand x \
            -fill x
    gtk::table attach $tbl $sc -left 1 -right 2 -top 0 -bottom 2 -expand y \
            -fill y
    
    gtk::container add $w $tbl
    gtk::widget show $text $tbl $sc $entry $w

    gtk::signal connect $entry activate -proc mmucl::meta_parse

    rename interface_init ""
    return
}

proc mmucl::meta_parse {e} {
    meta_parse [gtk::entry text $e]
    gtk::entry text $e ""

    return
}
