proc mmucl::stdin_parse {} {
    meta_parse [gets stdin]

    if {[eof stdin]} {
        MCexit
    }

    return
}

proc mmucl::display {str} {
    puts -nonewline $str
    flush stdout

    return
}

# mostly a stub
proc mmucl::MCcline {args} {
    variable Mmucl

    set syntax {
	delete {{? first 0} {? last end}}
	get {{? first 0} {? last end}} 
	insert {{+ first} {+ str}}
	history {}
    }

    switch -exact [check cline $syntax $args 1] {
        delete {
	} get {
	} insert {
	} history {
	    return $Mmucl(history)
	}
    }
    
    return
}

# just a stub
proc mmucl::MCkey {args} {
    variable key

    set syntax {
	 set      {{+ key} {? script}}
	 names    {{? pattern *}}
	 print    {{? pattern *}}
	 delete   {{- exact} {+ pattern}}
     }
     
     switch [check key $syntax $args 1] {
	 set {
	     if {[info exists arg(script)]} {
		 set key($arg(key)) $arg(script)
	     } elseif {![info exist key($arg(key))]} {
		 error "no such key"
	     } else {
		 return $key($arg(key))
	     }
	 } names {
	     return [array names key $arg(pattern)]
	 } delete {
	     if {[info exists arg(-exact)]} {
		 unset key($arg(pattern))
	     } else {
		 foreach k [array names key $arg(pattern)] {
		     unset key($k)
		 }
	     }
	 } print {
	     foreach k [array names key $arg(pattern)] {
		 MCecho "$k bound to {$key($key)}"
	     }
	 }
     }
    
    return
}

proc mmucl::interface_init {} {
    variable Mmucl

    fileevent stdin readable mmucl::stdin_parse
    
    rename interface_init ""
    return
}