namespace eval tkconf {
    array set type {
	"X Resource"  tkres
	"Tk Option"   tkopt
	"Tk Text Tag" tag
	"App Defined" app
    }
}

proc tkconf::add {type id args} {
    variable tkconf

    set tkconf($type,$id) $args
    return
}

proc tkconf::init {} {
    variable tkconf

    foreach {id vallist} [array get tkconf tkres,*] {
	option add [lindex $vallist 0] [lindex $vallist 1]
    }
    
    return
}

proc tkconf::apply {{id ""}} {
    variable tkconf

    if {![string equal $id ""]} {
	set list [list $id $tkconf($id)]
    } else {
	set list [array get tkconf]
    }

    foreach {id vallist} $list {
	foreach {name val op1 op2} $vallist break
	
	switch -exact [lindex [split $id ,] 0] {
	    tkopt {
		if {[winfo exists $op1]} {
		    $op1 configure -$name $val
		}
	    } tag {
		if {[winfo exists $op1]} {
		    $op1 tag configure $name -$op2 $val
		}
	    } tkres {
		option add $name $val
	    }
	}
    }
    
    return
}

proc tkconf::save {file} {
    variable tkconf

    set fd [open $file w+]
    
    foreach {id vallist} [array get tkconf] {
	puts $fd "tkconf::add [split $id ,] $vallist"
    }

    flush $fd
    close $fd
    return
}

proc tkconf::dialog {} {
    variable tkconf
    variable type

    set w .tkconf

    if {[winfo exists $w]} {
        raise $w
        return
    }

    toplevel $w
    wm title $w "Tk Config"

    frame $w.type
    label $w.type.l -text Type
    listbox $w.type.list -yscroll [list $w.type.yscroll set] \
	    -exportselection 0
    scrollbar $w.type.yscroll -command [list $w.type.list yview]

    grid $w.type.l -row 0 -column 0
    grid $w.type.list -row 1 -column 0
    grid $w.type.yscroll -row 1 -column 1 -sticky ns

    foreach el [array names type] {
	$w.type.list insert end $el
    }

    frame $w.opt
    label $w.opt.l -text Option
    listbox $w.opt.list -yscroll [list $w.opt.yscroll set] \
	    -exportselection 0
    scrollbar $w.opt.yscroll -command [list $w.opt.list yview]
    #scrollbar $w.opt.xscroll -orient horizontal \
	    -command [list $w.opt.list xview]

    grid $w.opt.l -row 0 -column 0
    grid $w.opt.list -row 1 -column 0
    grid $w.opt.yscroll -row 1 -column 1 -sticky ns
    #grid $w.opt.xscroll -row 2 -column 0 -sticky ew
    
    frame $w.edit
    label $w.edit.l -text Value
    button $w.edit.apply -text Apply -command [list tkconf::_dialog_apply $w]
    button $w.edit.close -text Close -command [list destroy $w]
    entry $w.edit.entry

    pack $w.edit.l -side top
    pack $w.edit.entry
    pack $w.edit.apply
    pack $w.edit.close -side bottom
    
    pack $w.type $w.opt $w.edit -side left -expand 1 -fill both

    bind $w.edit.entry <Key-Return> [list tkconf::_dialog_apply $w]
    bind $w.opt.list <ButtonRelease-1> [list tkconf::_dialog_sel $w]
    bind $w.type.list <ButtonRelease-1> [list tkconf::_dialog_show $w]

    return $w
}

proc tkconf::_dialog_sel {w} {
    variable tkconf
    variable type

    set t [$w.type.list curselection]

    if {[string equal $t ""]} {
	return
    }

    set t $type([$w.type.list get $t])
    set i [$w.opt.list curselection]

    if {![string equal $i ""]} {
        set i [$w.opt.list get $i]

	$w.edit.entry delete 0 end
	$w.edit.entry insert 0 [lindex $tkconf($t,$i) 1]
    }

    return
}

proc tkconf::_dialog_show {w} {
    variable tkconf
    variable type

    set i [$w.type.list curselection]

    if {![string equal $i ""]} {
	set i [$w.type.list get $i]	
	set i $type($i)

	$w.opt.list delete 0 end
	foreach id [lsort [array names tkconf $i,*]] {
	    $w.opt.list insert end [lindex [split $id ,] 1]
	}
    }

    return
}

proc tkconf::_dialog_apply {w} {
    variable tkconf
    variable type

    set t [$w.type.list curselection]

    if {[string equal $t ""]} {
	return
    }

    set t $type([$w.type.list get $t])
    set i [$w.opt.list curselection]

    if {![string equal $i ""]} {
        set i [$w.opt.list get $i]
	
	set tkconf($t,$i) [lreplace $tkconf($t,$i) 1 1 [$w.edit.entry get]]
	
	apply $t,$i
    }
    
    return
}
