
proc _init {} {
    global argv config env
    
    package require Tcl 8.2

    foreach opt $argv {
	switch -glob -- $opt {
	    -h* - --help {
		puts "Usage: mmucl \[INTERFACE\] OPTION..."
		puts ""
		puts "Interfaces:"
		puts "tk      - GUI  (requires Tk)"
		puts "xterm   - GUI  (requires Tk)"
		puts "console - text (requires ANSI terminal)"
		puts "text    - text (ANSI terminal not required)"
		puts ""
		puts "INTERFACE defaults to tk."
		puts ""
		puts "Options:"
		puts "-h --help          print this message and exit"
		puts "-v --version       print the version and exit"
		puts "-e --exec SCRIPT   start mmucl and eval SCRIPT"
		puts ""
		puts "Report bugs to mpatton@jhu.edu."
		
		exit 0
	    } -v* - --version {
		puts "Mmucl $config(version)"
		exit 0
	    }
	}
    }
    
    set interfaces [list tk xterm console text gtk]
    set interface [string tolower [lindex $argv 0]]
    
    if {[string match -* $interface] || ![string length $interface]} {
	set interface tk
    } else {
	set argv [lreplace $argv 0 0]
    }

    if {[lsearch -exact $interfaces $interface] == -1} {
	puts stderr "bad interface: $interface"
	exit 1
    }

    if {![info exists config(lib_dir)]} {
	set config(lib_dir) [pwd]
    }

    if {[info exists env(HOME)]} {
	set config(rc_dir) [file join $env(HOME) .mmucl]
    } else {
	set config(rc_dir) [file join [pwd] .mmucl]
    }

    set config(interface) $interface
    source [file join $config(lib_dir) lib mmucl.tcl]
    source [file join $config(lib_dir) interface $interface].tcl

    mmucl::interface_init
    mmucl::init

    rename _init ""
    return
}

_init
vwait forever