#  Returns the fully qualified name of the most specific version of a
#  proc corresponding to the class of a specified object.

proc mostSpecific {obj aProc} {
    foreach class [$obj info heritage] {
        if {[lsearch [class $class info proc] $aProc] >= 0} {
            display_text "\"${class}::$aProc\" is the most specialized form for \"$obj\""
            return ${class}::$aProc
        }
    }
    
    error "Unable to find any proc \"$aProc\" in the heritage for \"$obj\""
}

