# -----------------------------------------------------------------------------
# efftcl_extra.tcl --
#
#       A package of extra procedures to add to the efftcl package, which
#       accompanies the following book:
#
# ----------------------------------------------------------------------
#  Effective Tcl/Tk Programming
#    Mark Harrison, DSC Communications Corp.
#    Michael McLennan, Bell Labs Innovations for Lucent Technologies
#    Addison-Wesley Professional Computing Series
# ======================================================================
#  Copyright (c) 1996-1997  Lucent Technologies Inc. and Mark Harrison
# ======================================================================
# -----------------------------------------------------------------------------
# Copyright 2001 Paul Welton
#       Permission to use, copy, modify, and distribute this software and its
#       documentation for any purpose and without fee is hereby granted,
#       provided that this copyright notice appears in all copies.  No
#       representations are made about the suitability of this software for any
#       purpose.  It is provided "as is" without express or implied warranty.
# -----------------------------------------------------------------------------
# Revision:   1.0   : Initial Release
# -----------------------------------------------------------------------------

package require Efftcl

package provide Efftcl_extra 1.0

#  As Efftcl does not use namespaces, these are not used here for consistency.

# -----------------------------------------------------------------------------
# colordial_get_hsb --
#
#       The base colordial exports its state in RBG format, and provides no
#       means to reload the widget with a previous state.  As the translation
#       from RGB back to HSB is non-trivial and may result in loss of
#       precision, the following routine allows the state to be extracted in
#       HSB format.
#
# Arguments:
#       Window of the colordial widget.
#
# Results:
#       A list of the current HSB values represented by the specified widget.

proc colordial_get_hsb {win} {
    global cdInfo

    set h $cdInfo($win-hue)
    set s $cdInfo($win-saturation)
    set v $cdInfo($win-brightness)

    return [list $h $s $v]
}

# -----------------------------------------------------------------------------
# colordial_set_hsb --
#
#       Companion procedure to "colordial_get_hsb", which allows the state to
#       be reloaded in HSB format, and the graphical representation to be
#       refreshed to reflect that state.
#
# Arguments:
#       Window of the colordial widget and HSB values as discrete arguments.
#
# Results:
#       No return value.

proc colordial_set_hsb {win h s b} {
    global cdInfo

    set cdInfo($win-hue)        $h
    set cdInfo($win-saturation) $s
    set cdInfo($win-brightness) $b

    colordial_refresh $win
    return
}

# ------------------------------------------------------------------------------
# END OF PACKAGE "Efftcl_extra"
# ------------------------------------------------------------------------------



