# -----------------------------------------------------------------------------
# testProcs.tcl --
#
#       Test procedures for the TSIPP Workbench.
# -----------------------------------------------------------------------------
# Copyright 2001 Paul Welton
#       Permission to use, copy, modify, and distribute this software and its
#       documentation for any purpose and without fee is hereby granted,
#       provided that this copyright notice appears in all copies.  No
#       representations are made about the suitability of this software for any
#       purpose.  It is provided "as is" without express or implied warranty.
# -----------------------------------------------------------------------------
# Revision:   1.0   : Initial Release
# -----------------------------------------------------------------------------

#  Redefine the file dialogs to use filenames supplied by the test procedure
#  in the global variable ::G_filename.
if {[info commands tk_getOpenFile_original] == ""} {
    uplevel #0 rename tk_getOpenFile tk_getOpenFile_original
    uplevel #0 [list proc tk_getOpenFile {args} {
        return $::G_filename
    }]
    debugPrint "Replaced tk_getOpenFile"
}

if {[info commands tk_getSaveFile_original] == ""} {
    uplevel #0 rename tk_getSaveFile tk_getSaveFile_original
    uplevel #0 [list proc tk_getSaveFile {args} {
        return $::G_filename
    }]
    debugPrint "Replaced tk_getSaveFile"
}

# -----------------------------------------------------------------------------
# loadSaveTest --
#
#       This procedure loads, renders and saves each source file in the
#       current working directory, and then compares the saved file with
#       the previous version.  On completion of the test, a summary of how
#       many saved files matched the original is generated.
#
# Arguments:
#       None.
#
# Results:
#       No return value.

proc loadSaveTest {} {

    set nTest     0
    set nFailures 0

    foreach filename [glob *.tcl] {
        regsub {\.tcl$} $filename {_test.tcl} ::G_filename
        exec cp $filename $::G_filename

        debugPrint "Loading and Saving $::G_filename ..."
        .g_win.fileControl.e.load   invoke
        debugPrint " ... loaded $::G_filename"
        update
        .g_win.renderControl.e.render invoke
        debugPrint " ... rendered $::G_filename"
        update
        .g_win.fileControl.e.saveAs invoke
        debugPrint " ... saved $::G_filename"

        set FAILED [catch [list exec diff $::G_filename ${::G_filename}% > /dev/null] msg]
        if {$FAILED} {
            debugPrint "Test for $filename failed - $msg"
        }
        incr nTest
        incr nFailures $FAILED
        
        #exec mv $filename     ${filename}-1
        exec mv $::G_filename ${filename}-test
        #exec rm $::G_filename
    }

    debugPrint "In $nTest tests, there were $nFailures failures."
}

# -----------------------------------------------------------------------------
# END OF FILE "testProcs.tcl"
# -----------------------------------------------------------------------------
