###############################################################################
###############################################################################
##                          Ayuda.tcl
###############################################################################
###############################################################################
## Includes the procedures needed for the commands in the 'help' menu
###############################################################################
###############################################################################
## (c) 1999-2000 Andrs Garca Garca. andresgarci@retemail.es
## You may distribute the contents of this file under the terms of the GPL
## license
###############################################################################
###############################################################################

namespace eval Ayuda {

###############################################################################
# ScrollText
#    Scrolls the text windows up or down a third of its height
#
# Parameters
#    text: full path of the text widget
#    how:  either 'up' or 'down'
###############################################################################
proc ScrollText {text how} {

    set height [$text cget -height]
    set scroll [expr round ($height/2.5)]
    if {$how=="up"} {
        set scroll [expr $scroll * -1]
    }

    $text yview scroll $scroll units

    return
}

###############################################################################
# DefineWindow
#    Creates a window to show the content of a file text.
#
# Paremeters:
#    titulo: title for the window.
#    fichero: file to show.
#    log: '1' if we are going to show the error log, defaults to '0'
###############################################################################
proc DefineWindow {titulo fichero {log 0} } {
    global labelButtons labelTitles labelMessages supportedLang options

    if [catch {open $fichero r} handle] {
        tk_messageBox -title $labelTitles(error) -icon error \
            -message [concat $labelMessages(notFound) \n $fichero]
        return
    }

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set ventana [toplevel .ventana]
    wm title $ventana $titulo
    wm resizable $ventana 0 0
    wm geometry $ventana +[expr $coord(x)+100]+[expr $coord(y)+50]

    set marcoExt [frame $ventana.marcoext]
    set marcoNad [frame $marcoExt.nada -height 10]
    set marcoTex [frame $marcoExt.marcotex -bd 2 -relief sunken]
    set botones  [frame $ventana.botones]

    set texto [text $marcoTex.texto -wrap none -bg white \
            -yscrollcommand [list $marcoExt.yscroll set] \
            -xscrollcommand [list $marcoExt.xscroll set] ]

    set barray [scrollbar $marcoExt.yscroll -orient vertical \
            -command [list $texto yview] ]
    set barrax [scrollbar $marcoExt.xscroll -orient horizontal \
            -command [list $texto xview] ]

    set aceptar [button $botones.aceptar -textvariable labelButtons(ok)   \
            -width 8 -command "destroy $ventana"]
    set clear   [button $botones.clear   -textvariable labelButtons(clear)\
            -width 8 -command "::Herramientas::EraseErrorLog
                      destroy $ventana " ]

    grid $texto -sticky news
    grid $marcoNad -sticky news
    grid $marcoTex $barray -sticky news
    if {$log==1} {
        grid $barrax -sticky news
    }
    grid $marcoExt -ipadx 10 ; #-ipady 5
    grid $botones -sticky ew
    if {$log==0} {
        grid $aceptar -pady 5 -padx 2
    } else {
        grid $clear $aceptar -pady 5 -padx 2
        fconfigure $handle -encoding $supportedLang($options(lang))
    }
    for {} {![eof $handle]} {} {
        set linea [gets $handle]
        $texto insert insert $linea\n
    }
    close $handle
    $texto configure -state disabled -setgrid 1

    bind $ventana <KeyPress-Prior> "::Ayuda::ScrollText $texto up"
    bind $ventana <KeyPress-Next>  "::Ayuda::ScrollText $texto down"
    bind $ventana <Key-Up>   "$texto yview scroll -1 units"
    bind $ventana <Key-Down> "$texto yview scroll  1 units"
    bind $ventana <Escape>   "$aceptar invoke"

    focus $aceptar
    grab $ventana
    tkwait window $ventana

    return
}

###############################################################################
# Manual
#   Shows Getleft manual.
###############################################################################
proc Manual {} {
    global dirGetleft labelTitles

    DefineWindow $labelTitles(manual) [file join "$dirGetleft(doc)" Readme.txt]

    return
}

###############################################################################
# Changes
#   Shows the 'Changes' log
###############################################################################
proc Changes {} {
    global dirGetleft labelTitles

    DefineWindow $labelTitles(changes) \
            [file join "$dirGetleft(doc)" Changes.txt]

    return
}

###############################################################################
# Licence
#   Shows the GPL licence.
###############################################################################
proc Licence {} {
    global dirGetleft labelTitles

    DefineWindow  $labelTitles(license) \
            [file join "$dirGetleft(doc)" license.txt]

    return
}

###############################################################################
# About
#    Shows some info about the program.
###############################################################################
proc About {} {
    global dirGetleft
    global labelButtons labelTitles

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set ven [toplevel .acercade]
    wm title $ven $labelTitles(about)
    wm resizable $ven 0 0
    wm geometry $ven +[expr $coord(x)+180]+[expr $coord(y)+50]

    set interno    [frame $ven.interno -bd 2 -relief sunken]
    set internoLft [frame $interno.left]
    set internoCnt [frame $interno.center]
    set internoRgt [frame $interno.right]

    set tclLogo [image create photo -file "$dirGetleft(images)/pwrdLogo150.gif"]
    set tclIma  [label $internoLft.tcl -image $tclLogo]

    set text    [image create photo -file "$dirGetleft(images)/about.gif"]
    set textIma [label $internoCnt.texto -image $text]

    set curl    [image create photo -file "$dirGetleft(images)/curl.gif"]
    set curlIma [label $internoRgt.curl  -image $curl]

    set aceptar [button $ven.aceptar -textvariable labelButtons(ok) \
            -command "destroy $ven"]

    pack $interno
    pack $internoLft $internoCnt $internoRgt -side left
    pack $tclIma
    pack $textIma
    pack $curlIma
    pack $ven.aceptar -pady 2

    bind $ven     <Escape>   "$aceptar invoke"

    focus $aceptar
    grab $ven

    return
}
}