#
proc zircon {} {
#
#	ZIRCON - an X11 interface to the Internet Relay Chat
#
#	Written by Lindsay (Lindsay F. Marshall)
#
#	Copyright (c) 1993, 1994, 1995, 1996
#
#	See the file COPYRIGHT for details
#
set lib [file join $zircon(lib) lib]
set auto_path [linsert $auto_path 0 $lib]
package require -exact interp [info tclversion]
package require $tcl_platform(platform)
package require zircon
package require Debug
#
proc zUnknown {args} {
    switch -glob [set cmd [lindex $args 0]] irc* {
	set net [lindex $args 1]
	if {[$net startup]} {$net fast}
	if {![auto_load $cmd]} { ircNUM $net $cmd $args } { return [uplevel $args] }
    } default {
	return [uplevel sys_unknown $args]
    }
}
#
rename unknown sys_unknown
rename zUnknown unknown
#
Initialise
#
# save some space!!! it will reload if necessary.
#
rename Initialise {}
rename InitGlobals {}
rename InitLook {}
rename InitImages {}
#
if {[set l [llength [set nets [Net :: list]]]] == 1} {
    $defaultNet show
    if {[$defaultNet nocontrol]} {
	wm withdraw [MainControl]
	wm withdraw [MainInfo]
    } {
	exposeFrame [MainControl] $defaultNet
	exposeFrame [MainInfo] [$defaultNet info]
	hideFrame [MainControl] $defaultNet
	hideFrame [MainInfo] [$defaultNet info]
    }
} {
    addToConf $defaultNet
    if {$l == 2} {
	set net [lindex $nets 1]
	if {[$net nocontrol]} {
	    wm withdraw [MainControl]
	    wm withdraw [MainInfo]
	} {
	    exposeFrame [MainControl] $net
	    exposeFrame [MainInfo] [$net info]
	}
    }
}
unset l
#
if {!$zircon(C)} {
    foreach x $znetList {
	switch nil [set hst [$x hostid]] {} default {
	    set s [$x servers]
	    set v [lsearch $s $hst]
	    listdel s $v
	    while {![$x startIRC $hst]} {
		switch {} $s {
		    [$x control] enableOpen
		    break
		}
		$x configure -hostid [set hst [lindex $s 0]]
		set s [lrange $s 1 end]
		update
	    }
	}
    }
    unset s x v
}
}
