#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/Object.tcl,v $
# $Date: 1998/03/03 09:21:37 $
# $Revision: 1.18.1.13 $
#
# ----------------------------------------------------------------------
#   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1995 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================
#
package provide zircon 1.18
#
proc objName {class} {
    global OType
    set n [newName $class]
    set OType($n) $class
    return $n
}
#
proc newName {thing} {
    global zircon
    return [string tolower $thing][incr zircon(nameCount)]
}
#
proc class {name vars args} {
    global $name Private.$name Configure.$name
    set $name {}
    foreach {x y z} $vars {
	lappend $name $x $y
	set Configure.${name}($x) $z
    }
    switch {} $args {} default {set Private.$name [lindex $args 0]}
}
#
proc initObj {name args} {
    foreach x $args {
	uplevel #0 "array set $name \[set $x\]"
	catch {uplevel #0 "array set $name \[set Private.$x\]"}
    }
}
#
proc makeObj {types pars} {
    set mt [lindex $types end]
    set this [objName $mt]
    eval initObj $this $types
    uplevel #0 set ${this}(name) $this
    set mt [string tolower $mt]
    switch {} [info proc ${mt}_call] {
	proc $this {op args} "objCall $mt $this \$op \$args"
    } default {
        proc $this {op args}  "${mt}_call $this \$op \$args"
    }
    eval $this configure $pars
    return $this
}
#
proc makeNObj {name net types pars} {
    set mt [lindex $types end]
    set this [objName $mt]
    eval initObj $this $types
    upvar #0 $this odata
    switch {} $name { array set odata [list name $this net $net] } default {
	array set odata [list name $name net $net]
    }
    set mt [string tolower $mt]
    $net register ${mt}s $this
    switch {} [info proc ${mt}_call] {
	proc $this {op args} "objCall $mt $this \$op \$args"
    } default {
        proc $this {op args}  "${mt}_call $this \$op \$args"
    }
    eval $this configure $pars
    return $this
}
#
proc objCall {kind this op pars} {
    upvar #0 $this odata
    if {[info exists odata($op)]} {return $odata($op)}
    return [eval ${kind}_$op $this $pars]
}
#
proc confObj {this pars} {
    upvar #0 $this odata
    foreach {x y} $pars { set odata([string range $x 1 end]) $y}
}
