#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/Sound.tcl,v $
# $Date: 1998/02/09 16:56:51 $
# $Revision: 1.18.1.9 $
#
package provide zircon 1.18
#
proc handleSound {net usr fl} {
    global zircon
    switch {} [$net wavplayer] {} default {
	set dirs [split [$net wavpath] :]
	lappend dirs [file join $zircon(prefdir) sounds] \
	  [file join $zircon(lib) sounds]
	switch {} [file extension $fl] {append fl .wav}
	foreach x $dirs {
	    if {[file exists [file join $x $fl]]} {
		set fl "[file join $x $fl]"
		if {[regsub -all %s [$net wavplayer] $fl cmd] == 0} {
		    append cmd " [list $fl]"
		}
		if {[catch {eval exec $cmd &} msg]} {
		    $net inform "Error executing wav player - \"$msg\""
		}
		return
	    }
	}
    }
}
#
proc doSendSound {net nk fl} {
    switch {} $fl return
    $net CTCP SOUND $nk "$fl <$fl>"
    handleSound $net [$net nickname] $fl
}
#
proc addSoundMenu {net menu chid} {
    switch {} [$net wavplayer] return
    global zircon
    $menu add cascade -label [trans sound] -menu $menu.sound
    menu $menu.sound -postcommand "buildSMenu $net $menu.sound $chid"
    catch {$menu.sound configure  -tearoffcommand "retitle {Sounds for [$chid name]}"}
}
#
proc buildSMenu {net menu chid} {
    global zircon
    $menu delete 0 end
    set ptn {*.[wW][aA][vV]}
    set wavs {}
    set dirs [split [$net wavpath] :]
    lappend dirs [file join $zircon(prefdir) sounds] \
      [file join $zircon(lib) sounds]
    foreach x $dirs {
	switch {} [set wvs [glob -nocomplain [file join $x $ptn]]] {} default {
	    foreach y $wvs { lappend wavs [file tail $y] }
	}
    }
    switch {} $wavs {
	foreach y [glob -nocomplain $ptn] { lappend wavs [file tail $y] }
    }
    $menu add command -label {Other file} -command "sendSound $net {[$chid name]}"
    $menu add separator
    foreach x [lsort $wavs] {
	$menu add command -label [file tail [file rootname $x]] \
	  -command "doSendSound $net {[$chid name]} {$x}"
    }
}
