// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.30.2
// source: workload.proto

package workload

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	SpiffeWorkloadAPI_FetchX509SVID_FullMethodName    = "/SpiffeWorkloadAPI/FetchX509SVID"
	SpiffeWorkloadAPI_FetchX509Bundles_FullMethodName = "/SpiffeWorkloadAPI/FetchX509Bundles"
	SpiffeWorkloadAPI_FetchJWTSVID_FullMethodName     = "/SpiffeWorkloadAPI/FetchJWTSVID"
	SpiffeWorkloadAPI_FetchJWTBundles_FullMethodName  = "/SpiffeWorkloadAPI/FetchJWTBundles"
	SpiffeWorkloadAPI_ValidateJWTSVID_FullMethodName  = "/SpiffeWorkloadAPI/ValidateJWTSVID"
)

// SpiffeWorkloadAPIClient is the client API for SpiffeWorkloadAPI service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SpiffeWorkloadAPIClient interface {
	// Fetch X.509-SVIDs for all SPIFFE identities the workload is entitled to,
	// as well as related information like trust bundles and CRLs. As this
	// information changes, subsequent messages will be streamed from the
	// server.
	FetchX509SVID(ctx context.Context, in *X509SVIDRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[X509SVIDResponse], error)
	// Fetch trust bundles and CRLs. Useful for clients that only need to
	// validate SVIDs without obtaining an SVID for themself. As this
	// information changes, subsequent messages will be streamed from the
	// server.
	FetchX509Bundles(ctx context.Context, in *X509BundlesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[X509BundlesResponse], error)
	// Fetch JWT-SVIDs for all SPIFFE identities the workload is entitled to,
	// for the requested audience. If an optional SPIFFE ID is requested, only
	// the JWT-SVID for that SPIFFE ID is returned.
	FetchJWTSVID(ctx context.Context, in *JWTSVIDRequest, opts ...grpc.CallOption) (*JWTSVIDResponse, error)
	// Fetches the JWT bundles, formatted as JWKS documents, keyed by the
	// SPIFFE ID of the trust domain. As this information changes, subsequent
	// messages will be streamed from the server.
	FetchJWTBundles(ctx context.Context, in *JWTBundlesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[JWTBundlesResponse], error)
	// Validates a JWT-SVID against the requested audience. Returns the SPIFFE
	// ID of the JWT-SVID and JWT claims.
	ValidateJWTSVID(ctx context.Context, in *ValidateJWTSVIDRequest, opts ...grpc.CallOption) (*ValidateJWTSVIDResponse, error)
}

type spiffeWorkloadAPIClient struct {
	cc grpc.ClientConnInterface
}

func NewSpiffeWorkloadAPIClient(cc grpc.ClientConnInterface) SpiffeWorkloadAPIClient {
	return &spiffeWorkloadAPIClient{cc}
}

func (c *spiffeWorkloadAPIClient) FetchX509SVID(ctx context.Context, in *X509SVIDRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[X509SVIDResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &SpiffeWorkloadAPI_ServiceDesc.Streams[0], SpiffeWorkloadAPI_FetchX509SVID_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[X509SVIDRequest, X509SVIDResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type SpiffeWorkloadAPI_FetchX509SVIDClient = grpc.ServerStreamingClient[X509SVIDResponse]

func (c *spiffeWorkloadAPIClient) FetchX509Bundles(ctx context.Context, in *X509BundlesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[X509BundlesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &SpiffeWorkloadAPI_ServiceDesc.Streams[1], SpiffeWorkloadAPI_FetchX509Bundles_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[X509BundlesRequest, X509BundlesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type SpiffeWorkloadAPI_FetchX509BundlesClient = grpc.ServerStreamingClient[X509BundlesResponse]

func (c *spiffeWorkloadAPIClient) FetchJWTSVID(ctx context.Context, in *JWTSVIDRequest, opts ...grpc.CallOption) (*JWTSVIDResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(JWTSVIDResponse)
	err := c.cc.Invoke(ctx, SpiffeWorkloadAPI_FetchJWTSVID_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spiffeWorkloadAPIClient) FetchJWTBundles(ctx context.Context, in *JWTBundlesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[JWTBundlesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &SpiffeWorkloadAPI_ServiceDesc.Streams[2], SpiffeWorkloadAPI_FetchJWTBundles_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[JWTBundlesRequest, JWTBundlesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type SpiffeWorkloadAPI_FetchJWTBundlesClient = grpc.ServerStreamingClient[JWTBundlesResponse]

func (c *spiffeWorkloadAPIClient) ValidateJWTSVID(ctx context.Context, in *ValidateJWTSVIDRequest, opts ...grpc.CallOption) (*ValidateJWTSVIDResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ValidateJWTSVIDResponse)
	err := c.cc.Invoke(ctx, SpiffeWorkloadAPI_ValidateJWTSVID_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SpiffeWorkloadAPIServer is the server API for SpiffeWorkloadAPI service.
// All implementations must embed UnimplementedSpiffeWorkloadAPIServer
// for forward compatibility.
type SpiffeWorkloadAPIServer interface {
	// Fetch X.509-SVIDs for all SPIFFE identities the workload is entitled to,
	// as well as related information like trust bundles and CRLs. As this
	// information changes, subsequent messages will be streamed from the
	// server.
	FetchX509SVID(*X509SVIDRequest, grpc.ServerStreamingServer[X509SVIDResponse]) error
	// Fetch trust bundles and CRLs. Useful for clients that only need to
	// validate SVIDs without obtaining an SVID for themself. As this
	// information changes, subsequent messages will be streamed from the
	// server.
	FetchX509Bundles(*X509BundlesRequest, grpc.ServerStreamingServer[X509BundlesResponse]) error
	// Fetch JWT-SVIDs for all SPIFFE identities the workload is entitled to,
	// for the requested audience. If an optional SPIFFE ID is requested, only
	// the JWT-SVID for that SPIFFE ID is returned.
	FetchJWTSVID(context.Context, *JWTSVIDRequest) (*JWTSVIDResponse, error)
	// Fetches the JWT bundles, formatted as JWKS documents, keyed by the
	// SPIFFE ID of the trust domain. As this information changes, subsequent
	// messages will be streamed from the server.
	FetchJWTBundles(*JWTBundlesRequest, grpc.ServerStreamingServer[JWTBundlesResponse]) error
	// Validates a JWT-SVID against the requested audience. Returns the SPIFFE
	// ID of the JWT-SVID and JWT claims.
	ValidateJWTSVID(context.Context, *ValidateJWTSVIDRequest) (*ValidateJWTSVIDResponse, error)
	mustEmbedUnimplementedSpiffeWorkloadAPIServer()
}

// UnimplementedSpiffeWorkloadAPIServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedSpiffeWorkloadAPIServer struct{}

func (UnimplementedSpiffeWorkloadAPIServer) FetchX509SVID(*X509SVIDRequest, grpc.ServerStreamingServer[X509SVIDResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FetchX509SVID not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) FetchX509Bundles(*X509BundlesRequest, grpc.ServerStreamingServer[X509BundlesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FetchX509Bundles not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) FetchJWTSVID(context.Context, *JWTSVIDRequest) (*JWTSVIDResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchJWTSVID not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) FetchJWTBundles(*JWTBundlesRequest, grpc.ServerStreamingServer[JWTBundlesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FetchJWTBundles not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) ValidateJWTSVID(context.Context, *ValidateJWTSVIDRequest) (*ValidateJWTSVIDResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateJWTSVID not implemented")
}
func (UnimplementedSpiffeWorkloadAPIServer) mustEmbedUnimplementedSpiffeWorkloadAPIServer() {}
func (UnimplementedSpiffeWorkloadAPIServer) testEmbeddedByValue()                           {}

// UnsafeSpiffeWorkloadAPIServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SpiffeWorkloadAPIServer will
// result in compilation errors.
type UnsafeSpiffeWorkloadAPIServer interface {
	mustEmbedUnimplementedSpiffeWorkloadAPIServer()
}

func RegisterSpiffeWorkloadAPIServer(s grpc.ServiceRegistrar, srv SpiffeWorkloadAPIServer) {
	// If the following call pancis, it indicates UnimplementedSpiffeWorkloadAPIServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&SpiffeWorkloadAPI_ServiceDesc, srv)
}

func _SpiffeWorkloadAPI_FetchX509SVID_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(X509SVIDRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpiffeWorkloadAPIServer).FetchX509SVID(m, &grpc.GenericServerStream[X509SVIDRequest, X509SVIDResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type SpiffeWorkloadAPI_FetchX509SVIDServer = grpc.ServerStreamingServer[X509SVIDResponse]

func _SpiffeWorkloadAPI_FetchX509Bundles_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(X509BundlesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpiffeWorkloadAPIServer).FetchX509Bundles(m, &grpc.GenericServerStream[X509BundlesRequest, X509BundlesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type SpiffeWorkloadAPI_FetchX509BundlesServer = grpc.ServerStreamingServer[X509BundlesResponse]

func _SpiffeWorkloadAPI_FetchJWTSVID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JWTSVIDRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpiffeWorkloadAPIServer).FetchJWTSVID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SpiffeWorkloadAPI_FetchJWTSVID_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpiffeWorkloadAPIServer).FetchJWTSVID(ctx, req.(*JWTSVIDRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpiffeWorkloadAPI_FetchJWTBundles_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(JWTBundlesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SpiffeWorkloadAPIServer).FetchJWTBundles(m, &grpc.GenericServerStream[JWTBundlesRequest, JWTBundlesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type SpiffeWorkloadAPI_FetchJWTBundlesServer = grpc.ServerStreamingServer[JWTBundlesResponse]

func _SpiffeWorkloadAPI_ValidateJWTSVID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateJWTSVIDRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpiffeWorkloadAPIServer).ValidateJWTSVID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SpiffeWorkloadAPI_ValidateJWTSVID_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpiffeWorkloadAPIServer).ValidateJWTSVID(ctx, req.(*ValidateJWTSVIDRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SpiffeWorkloadAPI_ServiceDesc is the grpc.ServiceDesc for SpiffeWorkloadAPI service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SpiffeWorkloadAPI_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "SpiffeWorkloadAPI",
	HandlerType: (*SpiffeWorkloadAPIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchJWTSVID",
			Handler:    _SpiffeWorkloadAPI_FetchJWTSVID_Handler,
		},
		{
			MethodName: "ValidateJWTSVID",
			Handler:    _SpiffeWorkloadAPI_ValidateJWTSVID_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "FetchX509SVID",
			Handler:       _SpiffeWorkloadAPI_FetchX509SVID_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FetchX509Bundles",
			Handler:       _SpiffeWorkloadAPI_FetchX509Bundles_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FetchJWTBundles",
			Handler:       _SpiffeWorkloadAPI_FetchJWTBundles_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "workload.proto",
}
