//===-- LoongArch_DWARF_Registers.h -----------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLDB_SOURCE_UTILITY_LOONGARCH_DWARF_REGISTERS_H
#define LLDB_SOURCE_UTILITY_LOONGARCH_DWARF_REGISTERS_H

#include "lldb/lldb-private.h"

namespace loongarch_dwarf {

enum {
  dwarf_gpr_r0 = 0,
  dwarf_gpr_r1,
  dwarf_gpr_r2,
  dwarf_gpr_r3,
  dwarf_gpr_r4,
  dwarf_gpr_r5,
  dwarf_gpr_r6,
  dwarf_gpr_r7,
  dwarf_gpr_r8,
  dwarf_gpr_r9,
  dwarf_gpr_r10,
  dwarf_gpr_r11,
  dwarf_gpr_r12,
  dwarf_gpr_r13,
  dwarf_gpr_r14,
  dwarf_gpr_r15,
  dwarf_gpr_r16,
  dwarf_gpr_r17,
  dwarf_gpr_r18,
  dwarf_gpr_r19,
  dwarf_gpr_r20,
  dwarf_gpr_r21,
  dwarf_gpr_r22,
  dwarf_gpr_r23,
  dwarf_gpr_r24,
  dwarf_gpr_r25,
  dwarf_gpr_r26,
  dwarf_gpr_r27,
  dwarf_gpr_r28,
  dwarf_gpr_r29,
  dwarf_gpr_r30,
  dwarf_gpr_r31 = 31,

  dwarf_fpr_f0 = 32,
  dwarf_fpr_f1,
  dwarf_fpr_f2,
  dwarf_fpr_f3,
  dwarf_fpr_f4,
  dwarf_fpr_f5,
  dwarf_fpr_f6,
  dwarf_fpr_f7,
  dwarf_fpr_f8,
  dwarf_fpr_f9,
  dwarf_fpr_f10,
  dwarf_fpr_f11,
  dwarf_fpr_f12,
  dwarf_fpr_f13,
  dwarf_fpr_f14,
  dwarf_fpr_f15,
  dwarf_fpr_f16,
  dwarf_fpr_f17,
  dwarf_fpr_f18,
  dwarf_fpr_f19,
  dwarf_fpr_f20,
  dwarf_fpr_f21,
  dwarf_fpr_f22,
  dwarf_fpr_f23,
  dwarf_fpr_f24,
  dwarf_fpr_f25,
  dwarf_fpr_f26,
  dwarf_fpr_f27,
  dwarf_fpr_f28,
  dwarf_fpr_f29,
  dwarf_fpr_f30,
  dwarf_fpr_f31 = 63,

  dwarf_fpr_fcc0,
  dwarf_fpr_fcc1,
  dwarf_fpr_fcc2,
  dwarf_fpr_fcc3,
  dwarf_fpr_fcc4,
  dwarf_fpr_fcc5,
  dwarf_fpr_fcc6,
  dwarf_fpr_fcc7,
  dwarf_fpr_fcsr,

  dwarf_lsx_vr0,
  dwarf_lsx_vr1,
  dwarf_lsx_vr2,
  dwarf_lsx_vr3,
  dwarf_lsx_vr4,
  dwarf_lsx_vr5,
  dwarf_lsx_vr6,
  dwarf_lsx_vr7,
  dwarf_lsx_vr8,
  dwarf_lsx_vr9,
  dwarf_lsx_vr10,
  dwarf_lsx_vr11,
  dwarf_lsx_vr12,
  dwarf_lsx_vr13,
  dwarf_lsx_vr14,
  dwarf_lsx_vr15,
  dwarf_lsx_vr16,
  dwarf_lsx_vr17,
  dwarf_lsx_vr18,
  dwarf_lsx_vr19,
  dwarf_lsx_vr20,
  dwarf_lsx_vr21,
  dwarf_lsx_vr22,
  dwarf_lsx_vr23,
  dwarf_lsx_vr24,
  dwarf_lsx_vr25,
  dwarf_lsx_vr26,
  dwarf_lsx_vr27,
  dwarf_lsx_vr28,
  dwarf_lsx_vr29,
  dwarf_lsx_vr30,
  dwarf_lsx_vr31,

  dwarf_lasx_xr0,
  dwarf_lasx_xr1,
  dwarf_lasx_xr2,
  dwarf_lasx_xr3,
  dwarf_lasx_xr4,
  dwarf_lasx_xr5,
  dwarf_lasx_xr6,
  dwarf_lasx_xr7,
  dwarf_lasx_xr8,
  dwarf_lasx_xr9,
  dwarf_lasx_xr10,
  dwarf_lasx_xr11,
  dwarf_lasx_xr12,
  dwarf_lasx_xr13,
  dwarf_lasx_xr14,
  dwarf_lasx_xr15,
  dwarf_lasx_xr16,
  dwarf_lasx_xr17,
  dwarf_lasx_xr18,
  dwarf_lasx_xr19,
  dwarf_lasx_xr20,
  dwarf_lasx_xr21,
  dwarf_lasx_xr22,
  dwarf_lasx_xr23,
  dwarf_lasx_xr24,
  dwarf_lasx_xr25,
  dwarf_lasx_xr26,
  dwarf_lasx_xr27,
  dwarf_lasx_xr28,
  dwarf_lasx_xr29,
  dwarf_lasx_xr30,
  dwarf_lasx_xr31,

  // register name alias
  dwarf_gpr_zero = dwarf_gpr_r0,
  dwarf_gpr_ra = dwarf_gpr_r1,
  dwarf_gpr_tp = dwarf_gpr_r2,
  dwarf_gpr_sp = dwarf_gpr_r3,
  dwarf_gpr_a0 = dwarf_gpr_r4,
  dwarf_gpr_a1 = dwarf_gpr_r5,
  dwarf_gpr_a2 = dwarf_gpr_r6,
  dwarf_gpr_a3 = dwarf_gpr_r7,
  dwarf_gpr_a4 = dwarf_gpr_r8,
  dwarf_gpr_a5 = dwarf_gpr_r9,
  dwarf_gpr_a6 = dwarf_gpr_r10,
  dwarf_gpr_a7 = dwarf_gpr_r11,
  dwarf_gpr_t0 = dwarf_gpr_r12,
  dwarf_gpr_t1 = dwarf_gpr_r13,
  dwarf_gpr_t2 = dwarf_gpr_r14,
  dwarf_gpr_t3 = dwarf_gpr_r15,
  dwarf_gpr_t4 = dwarf_gpr_r16,
  dwarf_gpr_t5 = dwarf_gpr_r17,
  dwarf_gpr_t6 = dwarf_gpr_r18,
  dwarf_gpr_t7 = dwarf_gpr_r19,
  dwarf_gpr_t8 = dwarf_gpr_r20,
  dwarf_gpr_fp = dwarf_gpr_r22,
  dwarf_gpr_s0 = dwarf_gpr_r23,
  dwarf_gpr_s1 = dwarf_gpr_r24,
  dwarf_gpr_s2 = dwarf_gpr_r25,
  dwarf_gpr_s3 = dwarf_gpr_r26,
  dwarf_gpr_s4 = dwarf_gpr_r27,
  dwarf_gpr_s5 = dwarf_gpr_r28,
  dwarf_gpr_s6 = dwarf_gpr_r29,
  dwarf_gpr_s7 = dwarf_gpr_r30,
  dwarf_gpr_s8 = dwarf_gpr_r31,

  dwarf_fpr_fa0 = dwarf_fpr_f0,
  dwarf_fpr_fa1 = dwarf_fpr_f1,
  dwarf_fpr_fa2 = dwarf_fpr_f2,
  dwarf_fpr_fa3 = dwarf_fpr_f3,
  dwarf_fpr_fa4 = dwarf_fpr_f4,
  dwarf_fpr_fa5 = dwarf_fpr_f5,
  dwarf_fpr_fa6 = dwarf_fpr_f6,
  dwarf_fpr_fa7 = dwarf_fpr_f7,
  dwarf_fpr_ft0 = dwarf_fpr_f8,
  dwarf_fpr_ft1 = dwarf_fpr_f9,
  dwarf_fpr_ft2 = dwarf_fpr_f10,
  dwarf_fpr_ft3 = dwarf_fpr_f11,
  dwarf_fpr_ft4 = dwarf_fpr_f12,
  dwarf_fpr_ft5 = dwarf_fpr_f13,
  dwarf_fpr_ft6 = dwarf_fpr_f14,
  dwarf_fpr_ft7 = dwarf_fpr_f15,
  dwarf_fpr_ft8 = dwarf_fpr_f16,
  dwarf_fpr_ft9 = dwarf_fpr_f17,
  dwarf_fpr_ft10 = dwarf_fpr_f18,
  dwarf_fpr_ft11 = dwarf_fpr_f19,
  dwarf_fpr_ft12 = dwarf_fpr_f20,
  dwarf_fpr_ft13 = dwarf_fpr_f21,
  dwarf_fpr_ft14 = dwarf_fpr_f22,
  dwarf_fpr_ft15 = dwarf_fpr_f23,
  dwarf_fpr_fs0 = dwarf_fpr_f24,
  dwarf_fpr_fs1 = dwarf_fpr_f25,
  dwarf_fpr_fs2 = dwarf_fpr_f26,
  dwarf_fpr_fs3 = dwarf_fpr_f27,
  dwarf_fpr_fs4 = dwarf_fpr_f28,
  dwarf_fpr_fs5 = dwarf_fpr_f29,
  dwarf_fpr_fs6 = dwarf_fpr_f30,
  dwarf_fpr_fs7 = dwarf_fpr_f31,

  // mock pc regnum
  dwarf_gpr_pc = 57005,

  // fake registers are only used to define `RegisterInfo`
  dwarf_gpr_orig_a0,
  dwarf_gpr_badv,
  dwarf_gpr_reserved0,
  dwarf_gpr_reserved1,
  dwarf_gpr_reserved2,
  dwarf_gpr_reserved3,
  dwarf_gpr_reserved4,
  dwarf_gpr_reserved5,
  dwarf_gpr_reserved6,
  dwarf_gpr_reserved7,
  dwarf_gpr_reserved8,
  dwarf_gpr_reserved9,
};

} // namespace loongarch_dwarf

#endif // LLDB_SOURCE_UTILITY_LOONGARCH_DWARF_REGISTERS_H
