# Platforms

## Supported Platforms

SDL3 has been known to work on the following platforms at some point:

- [Android](README-android.md)
- [Emscripten](README-emscripten.md) (Web browsers)
- [FreeBSD](README-bsd.md)
- [Haiku OS](README-haiku.md)
- [iOS](README-ios.md)
- [Linux](README-linux.md)
- [macOS](README-macos.md) (10.14 and later)
- [NetBSD](README-bsd.md)
- [Nintendo Switch](README-switch.md) (Separate NDA-only fork)
- [Nintendo 3DS](README-n3ds.md) (Homebrew)
- [Nokia N-Gage](README-ngage.md)
- [OpenBSD](README-bsd.md)
- [PlayStation 2](README-ps2.md) (Homebrew)
- [PlayStation 4](README-ps4.md) (Separate NDA-only fork)
- [PlayStation 5](README-ps5.md) (Separate NDA-only fork)
- [PlayStation Portable](README-psp.md) (Homebrew)
- [PlayStation Vita](README-vita.md) (Homebrew)
- [RISC OS](README-riscos.md)
- [SteamOS](README-steamos.md)
- [tvOS](README-ios.md)
- [visionOS](README-ios.md)
- [Windows](README-windows.md) (XP and later)
- [Windows GDK](README-gdk.md)
- [Xbox](README-gdk.md)

Note that the SDL maintainers do not test on all these platforms; if a less-common system breaks, [please let us know](https://github.com/libsdl-org/SDL/issues/new) and send patches if you can.

If you'd like to port SDL to a new platform, feel free to get in touch! [A guide to porting SDL2](https://discourse.libsdl.org/t/port-sdl-2-0-to-bios/25453/2) was written a while ago, and most of it still applies to SDL3.

## Unsupported Platforms

If your favorite system is listed below, we aren't working on it. However, if you send reasonable patches and are willing to support the port in the long term, we are happy to take a look!

All of these still work with [SDL2](/SDL2), which is an incompatible API, but an option if you need to support these platforms still.

- QNX
- Google Stadia
- NaCL
- OS/2
- WinPhone
- WinRT/UWP
