from typing import Any, ClassVar, Dict, List, Optional, Tuple

from . import stock_objects

from typing import overload
import mrpt.pymrpt.mrpt.containers
import mrpt.pymrpt.mrpt.img
import mrpt.pymrpt.mrpt.maps
import mrpt.pymrpt.mrpt.math
import mrpt.pymrpt.mrpt.obs
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization
import mrpt.pymrpt.mrpt.system
FILL: TOpenGLFontStyle
NICE: TOpenGLFontStyle
OUTLINE: TOpenGLFontStyle
VOXEL_SET_FREESPACE: predefined_voxel_sets_t
VOXEL_SET_OCCUPIED: predefined_voxel_sets_t

class Buffer:
    class Type:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        ElementIndex: ClassVar[Buffer.Type] = ...
        PixelPack: ClassVar[Buffer.Type] = ...
        PixelUnpack: ClassVar[Buffer.Type] = ...
        Vertex: ClassVar[Buffer.Type] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        def __setstate__(self, state: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class Usage:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        DynamicCopy: ClassVar[Buffer.Usage] = ...
        DynamicDraw: ClassVar[Buffer.Usage] = ...
        DynamicRead: ClassVar[Buffer.Usage] = ...
        StaticCopy: ClassVar[Buffer.Usage] = ...
        StaticDraw: ClassVar[Buffer.Usage] = ...
        StaticRead: ClassVar[Buffer.Usage] = ...
        StreamCopy: ClassVar[Buffer.Usage] = ...
        StreamDraw: ClassVar[Buffer.Usage] = ...
        StreamRead: ClassVar[Buffer.Usage] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        def __setstate__(self, state: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    @overload
    def __init__(self, type) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    def allocate(self, data: capsule, byteCount: int) -> None: ...
    def assign(self) -> Buffer: ...
    @overload
    def bind(self) -> None: ...
    @overload
    def bind() -> void: ...
    @overload
    def bufferId(self) -> int: ...
    @overload
    def bufferId() -> unsignedint: ...
    @overload
    def createOnce(self) -> None: ...
    @overload
    def createOnce() -> void: ...
    @overload
    def destroy(self) -> None: ...
    @overload
    def destroy() -> void: ...
    @overload
    def initialized(self) -> bool: ...
    @overload
    def initialized() -> bool: ...
    @overload
    def setUsage(self, u: Buffer.Usage) -> None: ...
    @overload
    def setUsage(constenummrpt) -> void: ...
    def type(self) -> Buffer.Type: ...
    @overload
    def unbind(self) -> None: ...
    @overload
    def unbind() -> void: ...
    def usage(self) -> Buffer.Usage: ...

class CAngularObservationMesh(CRenderizableShaderTriangles, CRenderizableShaderWireFrame):
    class TDoubleRange:
        @overload
        def __init__(self, a: float, b: float, c: float) -> None: ...
        @overload
        def __init__(self, a: float, b: float, c: int) -> None: ...
        @overload
        def __init__(self, a: float, b: int, c: bool) -> None: ...
        @overload
        def __init__(self, arg0: CAngularObservationMesh.TDoubleRange) -> None: ...
        def CreateFromAmount(self, *args, **kwargs) -> Any: ...
        def CreateFromAperture(self, *args, **kwargs) -> Any: ...
        def CreateFromIncrement(self, *args, **kwargs) -> Any: ...
        @overload
        def amount(self) -> int: ...
        @overload
        def amount() -> size_t: ...
        @overload
        def aperture(self) -> float: ...
        @overload
        def aperture() -> double: ...
        @overload
        def finalValue(self) -> float: ...
        @overload
        def finalValue() -> double: ...
        @overload
        def increment(self) -> float: ...
        @overload
        def increment() -> double: ...
        @overload
        def initialValue(self) -> float: ...
        @overload
        def initialValue() -> double: ...
        @overload
        def negToPos(self) -> bool: ...
        @overload
        def negToPos() -> bool: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CAngularObservationMesh) -> None: ...
    @overload
    def __init__(self, arg0: CAngularObservationMesh) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CAngularObservationMesh: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def enableTransparency(self) -> None: ...
    @overload
    def enableTransparency(self, enabled: bool) -> None: ...
    @overload
    def enableTransparency(bool) -> void: ...
    def freeOpenGLResources(self) -> None: ...
    @overload
    def generatePointCloud(self, out_map: mrpt.pymrpt.mrpt.maps.CPointsMap) -> None: ...
    @overload
    def generatePointCloud(classmrpt) -> void: ...
    @overload
    def generateSetOfTriangles(self, res: CSetOfTriangles) -> None: ...
    @overload
    def generateSetOfTriangles(std) -> Any: ...
    @overload
    def generateSetOfTriangles(classstd) -> void: ...
    def getPitchBounds(self, initial: float, final: float) -> None: ...
    @overload
    def getTracedRays(self, res: CSetOfLines) -> None: ...
    @overload
    def getTracedRays(classstd) -> void: ...
    @overload
    def getUntracedRays(self, res: CSetOfLines, dist: float) -> None: ...
    @overload
    def getUntracedRays(classstd, double) -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isTransparencyEnabled(self) -> bool: ...
    @overload
    def isTransparencyEnabled() -> bool: ...
    @overload
    def isWireframe(self) -> bool: ...
    @overload
    def isWireframe() -> bool: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    def setPitchBounds(self, initial: float, final: float) -> None: ...
    @overload
    def setWireframe(self) -> None: ...
    @overload
    def setWireframe(self, enabled: bool) -> None: ...
    @overload
    def setWireframe(bool) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CArrow(CRenderizableShaderTriangles):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float, arg7: float) -> None: ...
    @overload
    def __init__(self, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float, headRatio: float, smallRadius: float, largeRadius: float) -> None: ...
    @overload
    def __init__(self, arg0, arg1) -> None: ...
    @overload
    def __init__(self, arg0, arg1, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0, arg1, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, from, to, headRatio: float, smallRadius: float, largeRadius: float) -> None: ...
    @overload
    def __init__(self, arg0: CArrow) -> None: ...
    @overload
    def __init__(self, arg0: CArrow) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CArrow: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getSlicesCount(self) -> int: ...
    @overload
    def getSlicesCount() -> uint32_t: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    def onUpdateBuffers_Triangles(self) -> None: ...
    def setArrowEnds(self, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float) -> None: ...
    @overload
    def setHeadRatio(self, rat: float) -> None: ...
    @overload
    def setHeadRatio(float) -> void: ...
    @overload
    def setLargeRadius(self, rat: float) -> None: ...
    @overload
    def setLargeRadius(float) -> void: ...
    @overload
    def setSlicesCount(self, slices: int) -> None: ...
    @overload
    def setSlicesCount(uint32_t) -> void: ...
    @overload
    def setSmallRadius(self, rat: float) -> None: ...
    @overload
    def setSmallRadius(float) -> void: ...

class CAssimpModel(CRenderizableShaderTriangles, CRenderizableShaderWireFrame, CRenderizableShaderPoints):
    class LoadFlags:
        class flags_t:
            __doc__: ClassVar[str] = ...  # read-only
            __members__: ClassVar[dict] = ...  # read-only
            FlipUVs: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
            IgnoreMaterialColor: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
            RealTimeFast: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
            RealTimeMaxQuality: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
            RealTimeQuality: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
            Verbose: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
            __entries: ClassVar[dict] = ...
            def __init__(self, value: int) -> None: ...
            def __and__(self, other: object) -> object: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __getstate__(self) -> int: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> int: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> object: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: object) -> object: ...
            def __rand__(self, other: object) -> object: ...
            def __ror__(self, other: object) -> object: ...
            def __rxor__(self, other: object) -> object: ...
            def __setstate__(self, state: int) -> None: ...
            def __xor__(self, other: object) -> object: ...
            @property
            def name(self) -> str: ...
            @property
            def value(self) -> int: ...
        FlipUVs: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
        IgnoreMaterialColor: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
        RealTimeFast: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
        RealTimeMaxQuality: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
        RealTimeQuality: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
        Verbose: ClassVar[CAssimpModel.LoadFlags.flags_t] = ...
        def __init__(self) -> None: ...

    class TInfoPerTexture:
        id_idx: int
        img_alpha: Optional[mrpt.pymrpt.mrpt.img.CImage]
        img_rgb: mrpt.pymrpt.mrpt.img.CImage
        def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CAssimpModel) -> None: ...
    @overload
    def __init__(self, arg0: CAssimpModel) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CAssimpModel: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isCompositeObject(self) -> bool: ...
    @overload
    def isCompositeObject() -> bool: ...
    @overload
    def loadScene(self, file_name: str) -> None: ...
    @overload
    def loadScene(self, file_name: str, flags: int) -> None: ...
    @overload
    def loadScene(conststd, constint) -> void: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def onUpdateBuffers_all(self) -> None: ...
    @overload
    def onUpdateBuffers_all() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def split_triangles_rendering_bbox(self, bbox_size: float) -> None: ...
    @overload
    def split_triangles_rendering_bbox(constfloat) -> void: ...
    @overload
    def split_triangles_rendering_bbox(self) -> float: ...
    @overload
    def split_triangles_rendering_bbox() -> float: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CAxis(CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float, arg7: float) -> None: ...
    @overload
    def __init__(self, xmin: float, ymin: float, zmin: float, xmax: float, ymax: float, zmax: float, frecuency: float, lineWidth: float, marks: bool) -> None: ...
    @overload
    def __init__(self, arg0: CAxis) -> None: ...
    @overload
    def __init__(self, arg0: CAxis) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CAxis: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def enableTickMarks(self) -> None: ...
    @overload
    def enableTickMarks(self, v: bool) -> None: ...
    @overload
    def enableTickMarks(bool) -> void: ...
    @overload
    def enableTickMarks(self, show_x: bool, show_y: bool, show_z: bool) -> None: ...
    @overload
    def getFrequency(self) -> float: ...
    @overload
    def getFrequency() -> float: ...
    def getTextLabelOrientation(self, axis: int, yaw_deg: float, pitch_deg: float, roll_deg: float) -> None: ...
    @overload
    def getTextScale(self) -> float: ...
    @overload
    def getTextScale() -> float: ...
    @overload
    def getTickMarksLength(self, len: float) -> float: ...
    @overload
    def getTickMarksLength(float) -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isCompositeObject(self) -> bool: ...
    @overload
    def isCompositeObject() -> bool: ...
    def onUpdateBuffers_Wireframe(self) -> None: ...
    def setAxisLimits(self, xmin: float, ymin: float, zmin: float, xmax: float, ymax: float, zmax: float) -> None: ...
    @overload
    def setFrequency(self, f: float) -> None: ...
    @overload
    def setFrequency(float) -> void: ...
    def setTextLabelOrientation(self, axis: int, yaw_deg: float, pitch_deg: float, roll_deg: float) -> None: ...
    @overload
    def setTextScale(self, f: float) -> None: ...
    @overload
    def setTextScale(float) -> void: ...
    @overload
    def setTickMarksLength(self, len: float) -> None: ...
    @overload
    def setTickMarksLength(float) -> void: ...

class CBox(CRenderizableShaderTriangles, CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0, arg1) -> None: ...
    @overload
    def __init__(self, arg0, arg1, arg2: bool) -> None: ...
    @overload
    def __init__(self, corner1, corner2, is_wireframe: bool, lineWidth: float) -> None: ...
    @overload
    def __init__(self, arg0: CBox) -> None: ...
    @overload
    def __init__(self, arg0: CBox) -> None: ...
    def Create(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CBox: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def enableBoxBorder(self) -> None: ...
    @overload
    def enableBoxBorder(self, drawBorder: bool) -> None: ...
    @overload
    def enableBoxBorder(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getBoxBorderColor(self) -> mrpt.pymrpt.mrpt.img.TColor: ...
    def getBoxCorners(self, corner1, corner2) -> None: ...
    @overload
    def getLineWidth(self) -> float: ...
    @overload
    def getLineWidth() -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isBoxBorderEnabled(self) -> bool: ...
    @overload
    def isBoxBorderEnabled() -> bool: ...
    @overload
    def isWireframe(self) -> bool: ...
    @overload
    def isWireframe() -> bool: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setBoxBorderColor(self, c: mrpt.pymrpt.mrpt.img.TColor) -> None: ...
    @overload
    def setBoxBorderColor(conststructmrpt) -> void: ...
    def setBoxCorners(self, corner1, corner2) -> None: ...
    @overload
    def setLineWidth(self, width: float) -> None: ...
    @overload
    def setLineWidth(float) -> void: ...
    @overload
    def setWireframe(self) -> None: ...
    @overload
    def setWireframe(self, is_wireframe: bool) -> None: ...
    @overload
    def setWireframe(bool) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CCamera(CRenderizable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CCamera) -> None: ...
    @overload
    def __init__(self, arg0: CCamera) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CCamera: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def getAzimuthDegrees(self) -> float: ...
    @overload
    def getAzimuthDegrees() -> float: ...
    @overload
    def getElevationDegrees(self) -> float: ...
    @overload
    def getElevationDegrees() -> float: ...
    def getPointingAt(self, *args, **kwargs) -> Any: ...
    @overload
    def getPointingAtX(self) -> float: ...
    @overload
    def getPointingAtX() -> float: ...
    @overload
    def getPointingAtY(self) -> float: ...
    @overload
    def getPointingAtY() -> float: ...
    @overload
    def getPointingAtZ(self) -> float: ...
    @overload
    def getPointingAtZ() -> float: ...
    @overload
    def getProjectiveFOVdeg(self) -> float: ...
    @overload
    def getProjectiveFOVdeg() -> float: ...
    @overload
    def getRollDegrees(self) -> float: ...
    @overload
    def getRollDegrees() -> float: ...
    @overload
    def getZoomDistance(self) -> float: ...
    @overload
    def getZoomDistance() -> float: ...
    @overload
    def hasPinholeModel(self) -> bool: ...
    @overload
    def hasPinholeModel() -> bool: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def is6DOFMode(self) -> bool: ...
    @overload
    def is6DOFMode() -> bool: ...
    @overload
    def isNoProjection(self) -> bool: ...
    @overload
    def isNoProjection() -> bool: ...
    @overload
    def isOrthogonal(self) -> bool: ...
    @overload
    def isOrthogonal() -> bool: ...
    @overload
    def isProjective(self) -> bool: ...
    @overload
    def isProjective() -> bool: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def set6DOFMode(self, v: bool) -> None: ...
    @overload
    def set6DOFMode(bool) -> void: ...
    @overload
    def setAzimuthDegrees(self, ang: float) -> None: ...
    @overload
    def setAzimuthDegrees(float) -> void: ...
    @overload
    def setElevationDegrees(self, ang: float) -> None: ...
    @overload
    def setElevationDegrees(float) -> void: ...
    @overload
    def setNoProjection(self) -> None: ...
    @overload
    def setNoProjection() -> void: ...
    @overload
    def setOrthogonal(self) -> None: ...
    @overload
    def setOrthogonal(self, v: bool) -> None: ...
    @overload
    def setOrthogonal(bool) -> void: ...
    def setPointingAt(self, x: float, y: float, z: float) -> None: ...
    @overload
    def setProjectiveFOVdeg(self, ang: float) -> None: ...
    @overload
    def setProjectiveFOVdeg(float) -> void: ...
    @overload
    def setProjectiveFromPinhole(self, camIntrinsics: mrpt.pymrpt.mrpt.img.TCamera) -> None: ...
    @overload
    def setProjectiveFromPinhole(constclassmrpt) -> void: ...
    @overload
    def setProjectiveModel(self) -> None: ...
    @overload
    def setProjectiveModel(self, v: bool) -> None: ...
    @overload
    def setProjectiveModel(bool) -> void: ...
    @overload
    def setRollDegrees(self, ang: float) -> None: ...
    @overload
    def setRollDegrees(float) -> void: ...
    @overload
    def setZoomDistance(self, z: float) -> None: ...
    @overload
    def setZoomDistance(float) -> void: ...
    @overload
    def toYAMLMap(self, propertiesMap: mrpt.pymrpt.mrpt.containers.yaml) -> None: ...
    @overload
    def toYAMLMap(classmrpt) -> void: ...

class CColorBar(CRenderizableShaderTriangles, CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TColormap) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TColormap, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TColormap, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TColormap, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TColormap, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TColormap, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TColormap, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TColormap, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float, arg7: str) -> None: ...
    @overload
    def __init__(self, colormap: mrpt.pymrpt.mrpt.img.TColormap, width: float, height: float, min_col: float, max_col: float, min_value: float, max_value: float, label_format: str, label_font_size: float) -> None: ...
    @overload
    def __init__(self, arg0: CColorBar) -> None: ...
    @overload
    def __init__(self, arg0: CColorBar) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CColorBar: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def onUpdateBuffers_all(self) -> None: ...
    @overload
    def onUpdateBuffers_all() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    def setColorAndValueLimits(self, col_min: float, col_max: float, value_min: float, value_max: float) -> None: ...
    @overload
    def setColormap(self, colormap: mrpt.pymrpt.mrpt.img.TColormap) -> None: ...
    @overload
    def setColormap(constenummrpt) -> void: ...

class CCylinder(CRenderizableShaderTriangles):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, baseRadius: float, topRadius: float, height: float, slices: int) -> None: ...
    @overload
    def __init__(self, arg0: CCylinder) -> None: ...
    @overload
    def __init__(self, arg0: CCylinder) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CCylinder: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getBottomRadius(self) -> float: ...
    @overload
    def getBottomRadius() -> float: ...
    @overload
    def getHeight(self) -> float: ...
    @overload
    def getHeight() -> float: ...
    @overload
    def getSlicesCount(self) -> int: ...
    @overload
    def getSlicesCount() -> uint32_t: ...
    @overload
    def getTopRadius(self) -> float: ...
    @overload
    def getTopRadius() -> float: ...
    @overload
    def hasBottomBase(self) -> bool: ...
    @overload
    def hasBottomBase() -> bool: ...
    @overload
    def hasTopBase(self) -> bool: ...
    @overload
    def hasTopBase() -> bool: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def setHasBases(self) -> None: ...
    @overload
    def setHasBases(self, top: bool) -> None: ...
    @overload
    def setHasBases(self, top: bool, bottom: bool) -> None: ...
    @overload
    def setHeight(self, height: float) -> None: ...
    @overload
    def setHeight(float) -> void: ...
    def setRadii(self, bottom: float, top: float) -> None: ...
    @overload
    def setRadius(self, radius: float) -> None: ...
    @overload
    def setRadius(float) -> void: ...
    @overload
    def setSlicesCount(self, slices: int) -> None: ...
    @overload
    def setSlicesCount(uint32_t) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CDisk(CRenderizableShaderTriangles):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, rOut: float, rIn: float, slices: int) -> None: ...
    @overload
    def __init__(self, arg0: CDisk) -> None: ...
    @overload
    def __init__(self, arg0: CDisk) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CDisk: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getInRadius(self) -> float: ...
    @overload
    def getInRadius() -> float: ...
    @overload
    def getOutRadius(self) -> float: ...
    @overload
    def getOutRadius() -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def setDiskRadius(self, outRadius: float) -> None: ...
    @overload
    def setDiskRadius(self, outRadius: float, inRadius: float) -> None: ...
    @overload
    def setSlicesCount(self, N: int) -> None: ...
    @overload
    def setSlicesCount(uint32_t) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CEllipsoid2D(CGeneralizedEllipsoidTemplate_2_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoid2D) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoid2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CEllipsoid2D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def set2DsegmentsCount(self, N: int) -> None: ...
    @overload
    def set2DsegmentsCount(unsignedint) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CEllipsoid3D(CGeneralizedEllipsoidTemplate_3_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoid3D) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoid3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CEllipsoid3D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def set3DsegmentsCount(self, N: int) -> None: ...
    @overload
    def set3DsegmentsCount(unsignedint) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CEllipsoidInverseDepth2D(CGeneralizedEllipsoidTemplate_2_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoidInverseDepth2D) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoidInverseDepth2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CEllipsoidInverseDepth2D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getUnderflowMaxRange(self) -> float: ...
    @overload
    def getUnderflowMaxRange() -> double: ...
    @overload
    def setUnderflowMaxRange(self, maxRange: float) -> None: ...
    @overload
    def setUnderflowMaxRange(constdouble) -> void: ...

class CEllipsoidInverseDepth3D(CGeneralizedEllipsoidTemplate_3_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoidInverseDepth3D) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoidInverseDepth3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CEllipsoidInverseDepth3D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getUnderflowMaxRange(self) -> float: ...
    @overload
    def getUnderflowMaxRange() -> float: ...
    @overload
    def setUnderflowMaxRange(self, maxRange: float) -> None: ...
    @overload
    def setUnderflowMaxRange(constfloat) -> void: ...

class CEllipsoidRangeBearing2D(CGeneralizedEllipsoidTemplate_2_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoidRangeBearing2D) -> None: ...
    @overload
    def __init__(self, arg0: CEllipsoidRangeBearing2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CEllipsoidRangeBearing2D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CFBORender:
    class Parameters:
        bindOpenGLES_API: bool
        blueSize: int
        conformantOpenGLES2: bool
        contextDebug: bool
        contextMajorVersion: int
        contextMinorVersion: int
        create_EGL_context: bool
        depthSize: int
        deviceIndexToUse: int
        greenSize: int
        height: int
        raw_depth: bool
        redSize: int
        renderableOpenGLES2: bool
        width: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, Width: int, Height: int) -> None: ...
        @overload
        def __init__(self, arg0: CFBORender.Parameters) -> None: ...
        def assign(self) -> CFBORender.Parameters: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, arg0: CFBORender) -> None: ...
    def getCamera(self, scene: Scene) -> CCamera: ...
    def render_RGB(self, *args, **kwargs) -> Any: ...
    def render_RGBD(self, scene: Scene, outRGB: mrpt.pymrpt.mrpt.img.CImage, outDepth: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def render_depth(self, scene: Scene, outDepth: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def render_depth(constclassmrpt, classmrpt) -> void: ...
    def setCamera(self, scene: Scene, camera: CCamera) -> None: ...

class CFrustum(CRenderizableShaderTriangles, CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, near_distance: float, far_distance: float, horz_FOV_degrees: float, vert_FOV_degrees: float, lineWidth: float, draw_lines: bool, draw_planes: bool) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.img.TCamera) -> None: ...
    @overload
    def __init__(self, intrinsics: mrpt.pymrpt.mrpt.img.TCamera, focalDistScale: float) -> None: ...
    @overload
    def __init__(self, arg0: CFrustum) -> None: ...
    @overload
    def __init__(self, arg0: CFrustum) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CFrustum: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def getFarPlaneDistance(self) -> float: ...
    @overload
    def getFarPlaneDistance() -> float: ...
    @overload
    def getHorzFOV(self) -> float: ...
    @overload
    def getHorzFOV() -> float: ...
    @overload
    def getHorzFOVLeft(self) -> float: ...
    @overload
    def getHorzFOVLeft() -> float: ...
    @overload
    def getHorzFOVRight(self) -> float: ...
    @overload
    def getHorzFOVRight() -> float: ...
    @overload
    def getNearPlaneDistance(self) -> float: ...
    @overload
    def getNearPlaneDistance() -> float: ...
    def getPlaneColor(self) -> mrpt.pymrpt.mrpt.img.TColor: ...
    @overload
    def getVertFOV(self) -> float: ...
    @overload
    def getVertFOV() -> float: ...
    @overload
    def getVertFOVDown(self) -> float: ...
    @overload
    def getVertFOVDown() -> float: ...
    @overload
    def getVertFOVUp(self) -> float: ...
    @overload
    def getVertFOVUp() -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setHorzFOV(self, fov_horz_degrees: float) -> None: ...
    @overload
    def setHorzFOV(constfloat) -> void: ...
    def setHorzFOVAsymmetric(self, fov_horz_left_degrees: float, fov_horz_right_degrees: float) -> None: ...
    def setNearFarPlanes(self, near_distance: float, far_distance: float) -> None: ...
    @overload
    def setPlaneColor(self, c: mrpt.pymrpt.mrpt.img.TColor) -> None: ...
    @overload
    def setPlaneColor(conststructmrpt) -> void: ...
    @overload
    def setVertFOV(self, fov_vert_degrees: float) -> None: ...
    @overload
    def setVertFOV(constfloat) -> void: ...
    def setVertFOVAsymmetric(self, fov_vert_down_degrees: float, fov_vert_up_degrees: float) -> None: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CGeneralizedEllipsoidTemplate_2_t(CRenderizableShaderTriangles, CRenderizableShaderWireFrame):
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def assign(self) -> CGeneralizedEllipsoidTemplate_2_t: ...
    @overload
    def enableDrawSolid3D(self, v: bool) -> None: ...
    @overload
    def enableDrawSolid3D(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getCovMatrix(self) -> mrpt.pymrpt.mrpt.math.CMatrixFixed_double_2UL_2UL_t: ...
    @overload
    def getNumberOfSegments(self) -> int: ...
    @overload
    def getNumberOfSegments() -> uint32_t: ...
    @overload
    def getQuantiles(self) -> float: ...
    @overload
    def getQuantiles() -> float: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setNumberOfSegments(self, numSegments: int) -> None: ...
    @overload
    def setNumberOfSegments(constunsignedint) -> void: ...
    @overload
    def setQuantiles(self, q: float) -> None: ...
    @overload
    def setQuantiles(float) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CGeneralizedEllipsoidTemplate_3_t(CRenderizableShaderTriangles, CRenderizableShaderWireFrame):
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def assign(self) -> CGeneralizedEllipsoidTemplate_3_t: ...
    @overload
    def enableDrawSolid3D(self, v: bool) -> None: ...
    @overload
    def enableDrawSolid3D(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getCovMatrix(self) -> mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t: ...
    @overload
    def getNumberOfSegments(self) -> int: ...
    @overload
    def getNumberOfSegments() -> uint32_t: ...
    @overload
    def getQuantiles(self) -> float: ...
    @overload
    def getQuantiles() -> float: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    def setCovMatrix(self, new_cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t) -> None: ...
    def setCovMatrixAndMean(self, new_cov: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_3UL_t, new_mean: mrpt.pymrpt.mrpt.math.CMatrixFixed_double_3UL_1UL_t) -> None: ...
    @overload
    def setNumberOfSegments(self, numSegments: int) -> None: ...
    @overload
    def setNumberOfSegments(constunsignedint) -> void: ...
    @overload
    def setQuantiles(self, q: float) -> None: ...
    @overload
    def setQuantiles(float) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CGridPlaneXY(CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, yMin: float, yMax: float, z: float, frequency: float, lineWidth: float, antiAliasing: bool) -> None: ...
    @overload
    def __init__(self, arg0: CGridPlaneXY) -> None: ...
    @overload
    def __init__(self, arg0: CGridPlaneXY) -> None: ...
    def Create(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CGridPlaneXY: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getGridFrequency(self) -> float: ...
    @overload
    def getGridFrequency() -> float: ...
    def getPlaneLimits(self, xmin: float, xmax: float, ymin: float, ymax: float) -> None: ...
    @overload
    def getPlaneZcoord(self) -> float: ...
    @overload
    def getPlaneZcoord() -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def setGridFrequency(self, freq: float) -> None: ...
    @overload
    def setGridFrequency(float) -> void: ...
    def setPlaneLimits(self, xmin: float, xmax: float, ymin: float, ymax: float) -> None: ...
    @overload
    def setPlaneZcoord(self, z: float) -> None: ...
    @overload
    def setPlaneZcoord(float) -> void: ...

class CGridPlaneXZ(CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float) -> None: ...
    @overload
    def __init__(self, xMin: float, xMax: float, zMin: float, zMax: float, y: float, frequency: float, lineWidth: float, antiAliasing: bool) -> None: ...
    @overload
    def __init__(self, arg0: CGridPlaneXZ) -> None: ...
    @overload
    def __init__(self, arg0: CGridPlaneXZ) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CGridPlaneXZ: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getGridFrequency(self) -> float: ...
    @overload
    def getGridFrequency() -> float: ...
    def getPlaneLimits(self, xmin: float, xmax: float, zmin: float, zmax: float) -> None: ...
    @overload
    def getPlaneYcoord(self) -> float: ...
    @overload
    def getPlaneYcoord() -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def setGridFrequency(self, freq: float) -> None: ...
    @overload
    def setGridFrequency(float) -> void: ...
    def setPlaneLimits(self, xmin: float, xmax: float, zmin: float, zmax: float) -> None: ...
    @overload
    def setPlaneYcoord(self, y: float) -> None: ...
    @overload
    def setPlaneYcoord(float) -> void: ...

class CMesh(CRenderizableShaderTexturedTriangles, CRenderizableShaderWireFrame):
    class TTriangleVertexIndices:
        def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: bool) -> None: ...
    @overload
    def __init__(self, arg0: bool, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: bool, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: bool, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, enableTransparency: bool, xMin: float, xMax: float, yMin: float, yMax: float) -> None: ...
    @overload
    def __init__(self, arg0: CMesh) -> None: ...
    @overload
    def __init__(self, arg0: CMesh) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def adjustGridToImageAR(self) -> None: ...
    @overload
    def adjustGridToImageAR() -> void: ...
    def assign(self) -> CMesh: ...
    @overload
    def assignImage(self, img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def assignImage(constclassmrpt) -> void: ...
    def assignImageAndZ(self, img: mrpt.pymrpt.mrpt.img.CImage, in_Z: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def enableColorFromZ(self, v: bool) -> None: ...
    @overload
    def enableColorFromZ(self, v: bool, colorMap: mrpt.pymrpt.mrpt.img.TColormap) -> None: ...
    @overload
    def enableColorFromZ(bool, enummrpt) -> void: ...
    @overload
    def enableTransparency(self, v: bool) -> None: ...
    @overload
    def enableTransparency(bool) -> void: ...
    @overload
    def enableWireFrame(self, v: bool) -> None: ...
    @overload
    def enableWireFrame(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getGridLimits(self, xMin: float, xMax: float, yMin: float, yMax: float) -> None: ...
    @overload
    def getMask(self, out: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def getMask(classmrpt) -> void: ...
    def getMeshTextureExtension(self, textureSize_x: float, textureSize_y: float) -> None: ...
    def getXBounds(self, min: float, max: float) -> None: ...
    def getYBounds(self, min: float, max: float) -> None: ...
    @overload
    def getZ(self, out: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def getZ(classmrpt) -> void: ...
    @overload
    def getxMax(self) -> float: ...
    @overload
    def getxMax() -> float: ...
    @overload
    def getxMin(self) -> float: ...
    @overload
    def getxMin() -> float: ...
    @overload
    def getyMax(self) -> float: ...
    @overload
    def getyMax() -> float: ...
    @overload
    def getyMin(self) -> float: ...
    @overload
    def getyMin() -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_TexturedTriangles(self) -> None: ...
    @overload
    def onUpdateBuffers_TexturedTriangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setMask(self, in_mask: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def setMask(constclassmrpt) -> void: ...
    def setMeshTextureExtension(self, textureSize_x: float, textureSize_y: float) -> None: ...
    def setXBounds(self, min: float, max: float) -> None: ...
    def setYBounds(self, min: float, max: float) -> None: ...
    @overload
    def setZ(self, in_Z: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def setZ(constclassmrpt) -> void: ...
    @overload
    def setxMax(self, nxm: float) -> None: ...
    @overload
    def setxMax(constfloat) -> void: ...
    @overload
    def setxMin(self, nxm: float) -> None: ...
    @overload
    def setxMin(constfloat) -> void: ...
    @overload
    def setyMax(self, nym: float) -> None: ...
    @overload
    def setyMax(constfloat) -> void: ...
    @overload
    def setyMin(self, nym: float) -> None: ...
    @overload
    def setyMin(constfloat) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CMesh3D(CRenderizableShaderTriangles, CRenderizableShaderWireFrame, CRenderizableShaderPoints):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CMesh3D) -> None: ...
    @overload
    def __init__(self, arg0: CMesh3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMesh3D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def enableFaceNormals(self, v: bool) -> None: ...
    @overload
    def enableFaceNormals(bool) -> void: ...
    @overload
    def enableShowEdges(self, v: bool) -> None: ...
    @overload
    def enableShowEdges(bool) -> void: ...
    @overload
    def enableShowFaces(self, v: bool) -> None: ...
    @overload
    def enableShowFaces(bool) -> void: ...
    @overload
    def enableShowVertices(self, v: bool) -> None: ...
    @overload
    def enableShowVertices(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    def loadMesh(self, *args, **kwargs) -> Any: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setEdgeColor(self, r: float, g: float, b: float) -> None: ...
    @overload
    def setEdgeColor(self, r: float, g: float, b: float, a: float) -> None: ...
    @overload
    def setFaceColor(self, r: float, g: float, b: float) -> None: ...
    @overload
    def setFaceColor(self, r: float, g: float, b: float, a: float) -> None: ...
    @overload
    def setVertColor(self, r: float, g: float, b: float) -> None: ...
    @overload
    def setVertColor(self, r: float, g: float, b: float, a: float) -> None: ...

class CMeshFast(CRenderizableShaderPoints):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: bool) -> None: ...
    @overload
    def __init__(self, arg0: bool, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: bool, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: bool, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, enableTransparency: bool, xMin_p: float, xMax_p: float, yMin_p: float, yMax_p: float) -> None: ...
    @overload
    def __init__(self, arg0: CMeshFast) -> None: ...
    @overload
    def __init__(self, arg0: CMeshFast) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def adjustGridToImageAR(self) -> None: ...
    @overload
    def adjustGridToImageAR() -> void: ...
    def assign(self) -> CMeshFast: ...
    @overload
    def assignImage(self, img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def assignImage(constclassmrpt) -> void: ...
    def assignImageAndZ(self, img: mrpt.pymrpt.mrpt.img.CImage, in_Z: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def enableColorFromZ(self, v: bool) -> None: ...
    @overload
    def enableColorFromZ(self, v: bool, colorMap: mrpt.pymrpt.mrpt.img.TColormap) -> None: ...
    @overload
    def enableColorFromZ(bool, enummrpt) -> void: ...
    @overload
    def enableTransparency(self, v: bool) -> None: ...
    @overload
    def enableTransparency(bool) -> void: ...
    def getGridLimits(self, xmin: float, xmax: float, ymin: float, ymax: float) -> None: ...
    def getXBounds(self, min: float, max: float) -> None: ...
    @overload
    def getXMax(self) -> float: ...
    @overload
    def getXMax() -> float: ...
    @overload
    def getXMin(self) -> float: ...
    @overload
    def getXMin() -> float: ...
    def getYBounds(self, min: float, max: float) -> None: ...
    @overload
    def getYMax(self) -> float: ...
    @overload
    def getYMax() -> float: ...
    @overload
    def getYMin(self) -> float: ...
    @overload
    def getYMin() -> float: ...
    @overload
    def getZ(self, out: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def getZ(classmrpt) -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    def onUpdateBuffers_Points(self) -> None: ...
    def setGridLimits(self, xmin: float, xmax: float, ymin: float, ymax: float) -> None: ...
    def setXBounds(self, min: float, max: float) -> None: ...
    @overload
    def setXMax(self, nxm: float) -> None: ...
    @overload
    def setXMax(float) -> void: ...
    @overload
    def setXMin(self, nxm: float) -> None: ...
    @overload
    def setXMin(float) -> void: ...
    def setYBounds(self, min: float, max: float) -> None: ...
    @overload
    def setYMax(self, nym: float) -> None: ...
    @overload
    def setYMax(float) -> void: ...
    @overload
    def setYMin(self, nym: float) -> None: ...
    @overload
    def setYMin(float) -> void: ...
    @overload
    def setZ(self, in_Z: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def setZ(constclassmrpt) -> void: ...

class COctoMapVoxels(CRenderizableShaderTriangles, CRenderizableShaderWireFrame, CRenderizableShaderPoints):
    class TGridCube:
        max: Any
        min: Any
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, min_, max_) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapVoxels.TGridCube) -> None: ...
        def assign(self) -> COctoMapVoxels.TGridCube: ...

    class TInfoPerVoxelSet:
        visible: bool
        voxels: List[COctoMapVoxels.TVoxel]
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapVoxels.TInfoPerVoxelSet) -> None: ...
        def assign(self) -> COctoMapVoxels.TInfoPerVoxelSet: ...

    class TVoxel:
        color: mrpt.pymrpt.mrpt.img.TColor
        coords: Any
        side_length: float
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, coords_, side_length_: float, color_: mrpt.pymrpt.mrpt.img.TColor) -> None: ...
        @overload
        def __init__(self, arg0: COctoMapVoxels.TVoxel) -> None: ...
        def assign(self) -> COctoMapVoxels.TVoxel: ...

    class visualization_mode_t:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        COLOR_FROM_HEIGHT: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
        COLOR_FROM_OCCUPANCY: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
        COLOR_FROM_RGB_DATA: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
        FIXED: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
        MIXED: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
        TRANSPARENCY_FROM_OCCUPANCY: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
        TRANS_AND_COLOR_FROM_OCCUPANCY: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __and__(self, other: object) -> object: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> object: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: object) -> object: ...
        def __rand__(self, other: object) -> object: ...
        def __ror__(self, other: object) -> object: ...
        def __rxor__(self, other: object) -> object: ...
        def __setstate__(self, state: int) -> None: ...
        def __xor__(self, other: object) -> object: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    COLOR_FROM_HEIGHT: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
    COLOR_FROM_OCCUPANCY: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
    COLOR_FROM_RGB_DATA: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
    FIXED: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
    MIXED: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
    TRANSPARENCY_FROM_OCCUPANCY: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
    TRANS_AND_COLOR_FROM_OCCUPANCY: ClassVar[COctoMapVoxels.visualization_mode_t] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: COctoMapVoxels) -> None: ...
    @overload
    def __init__(self, arg0: COctoMapVoxels) -> None: ...
    def Create(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def areGridLinesVisible(self) -> bool: ...
    @overload
    def areGridLinesVisible() -> bool: ...
    @overload
    def areLightsEnabled(self) -> bool: ...
    @overload
    def areLightsEnabled() -> bool: ...
    @overload
    def areVoxelsShownAsPoints(self) -> bool: ...
    @overload
    def areVoxelsShownAsPoints() -> bool: ...
    @overload
    def areVoxelsVisible(self, voxel_set: int) -> bool: ...
    @overload
    def areVoxelsVisible(unsignedint) -> bool: ...
    def assign(self) -> COctoMapVoxels: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def colorMap(self) -> mrpt.pymrpt.mrpt.img.TColormap: ...
    @overload
    def colorMap(self, cm: mrpt.pymrpt.mrpt.img.TColormap) -> None: ...
    @overload
    def colorMap(constenummrpt) -> void: ...
    @overload
    def enableCubeTransparency(self, enable: bool) -> None: ...
    @overload
    def enableCubeTransparency(bool) -> void: ...
    @overload
    def enableLights(self, enable: bool) -> None: ...
    @overload
    def enableLights(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getGridCube(self, *args, **kwargs) -> Any: ...
    @overload
    def getGridCubeCount(self) -> int: ...
    @overload
    def getGridCubeCount() -> size_t: ...
    def getGridCubeRef(self, *args, **kwargs) -> Any: ...
    def getGridLinesColor(self) -> mrpt.pymrpt.mrpt.img.TColor: ...
    @overload
    def getGridLinesWidth(self) -> float: ...
    @overload
    def getGridLinesWidth() -> float: ...
    def getVisualizationMode(self) -> COctoMapVoxels.visualization_mode_t: ...
    def getVoxel(self, *args, **kwargs) -> Any: ...
    @overload
    def getVoxelAsPointsSize(self) -> float: ...
    @overload
    def getVoxelAsPointsSize() -> float: ...
    @overload
    def getVoxelCount(self, set_index: int) -> int: ...
    @overload
    def getVoxelCount(size_t) -> size_t: ...
    def getVoxelRef(self, *args, **kwargs) -> Any: ...
    @overload
    def getVoxelSetCount(self) -> int: ...
    @overload
    def getVoxelSetCount() -> size_t: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isCubeTransparencyEnabled(self) -> bool: ...
    @overload
    def isCubeTransparencyEnabled() -> bool: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def push_back_GridCube(self, c) -> None: ...
    @overload
    def push_back_GridCube(conststructmrpt) -> void: ...
    @overload
    def push_back_Voxel(self, set_index: int, v) -> None: ...
    @overload
    def push_back_Voxel(size_t, conststructmrpt) -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def reserveGridCubes(self, nCubes: int) -> None: ...
    @overload
    def reserveGridCubes(size_t) -> void: ...
    def reserveVoxels(self, set_index: int, nVoxels: int) -> None: ...
    @overload
    def resizeGridCubes(self, nCubes: int) -> None: ...
    @overload
    def resizeGridCubes(size_t) -> void: ...
    @overload
    def resizeVoxelSets(self, nVoxelSets: int) -> None: ...
    @overload
    def resizeVoxelSets(size_t) -> void: ...
    def resizeVoxels(self, set_index: int, nVoxels: int) -> None: ...
    def setBoundingBox(self, bb_min, bb_max) -> None: ...
    @overload
    def setGridLinesColor(self, color: mrpt.pymrpt.mrpt.img.TColor) -> None: ...
    @overload
    def setGridLinesColor(conststructmrpt) -> void: ...
    @overload
    def setGridLinesWidth(self, w: float) -> None: ...
    @overload
    def setGridLinesWidth(float) -> void: ...
    @overload
    def setVisualizationMode(self, mode: COctoMapVoxels.visualization_mode_t) -> None: ...
    @overload
    def setVisualizationMode(enummrpt) -> void: ...
    @overload
    def setVoxelAsPointsSize(self, pointSize: float) -> None: ...
    @overload
    def setVoxelAsPointsSize(float) -> void: ...
    @overload
    def showGridLines(self, show: bool) -> None: ...
    @overload
    def showGridLines(bool) -> void: ...
    @overload
    def showVoxels(self, voxel_set: int, show: bool) -> None: ...
    @overload
    def showVoxels(unsignedint, bool) -> void: ...
    @overload
    def showVoxelsAsPoints(self, enable: bool) -> None: ...
    @overload
    def showVoxelsAsPoints(constbool) -> void: ...
    @overload
    def sort_voxels_by_z(self) -> None: ...
    @overload
    def sort_voxels_by_z() -> void: ...

class CPlanarLaserScan(CRenderizableShaderPoints, CRenderizableShaderTriangles, CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPlanarLaserScan) -> None: ...
    @overload
    def __init__(self, arg0: CPlanarLaserScan) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPlanarLaserScan: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def enableLine(self) -> None: ...
    @overload
    def enableLine(self, enable: bool) -> None: ...
    @overload
    def enableLine(bool) -> void: ...
    @overload
    def enablePoints(self) -> None: ...
    @overload
    def enablePoints(self, enable: bool) -> None: ...
    @overload
    def enablePoints(bool) -> void: ...
    @overload
    def enableSurface(self) -> None: ...
    @overload
    def enableSurface(self, enable: bool) -> None: ...
    @overload
    def enableSurface(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getLocalRepresentativePoint(self, *args, **kwargs) -> Any: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setLineColor(self, R: float, G: float, B: float) -> None: ...
    @overload
    def setLineColor(self, R: float, G: float, B: float, A: float) -> None: ...
    @overload
    def setPointsColor(self, R: float, G: float, B: float) -> None: ...
    @overload
    def setPointsColor(self, R: float, G: float, B: float, A: float) -> None: ...
    @overload
    def setScan(self, scan: mrpt.pymrpt.mrpt.obs.CObservation2DRangeScan) -> None: ...
    @overload
    def setScan(constclassmrpt) -> void: ...
    @overload
    def setSurfaceColor(self, R: float, G: float, B: float) -> None: ...
    @overload
    def setSurfaceColor(self, R: float, G: float, B: float, A: float) -> None: ...

class CPointCloud(CRenderizableShaderPoints, PLY_Importer, PLY_Exporter):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPointCloud) -> None: ...
    @overload
    def __init__(self, arg0: CPointCloud) -> None: ...
    def Create(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def disablePointSmooth(self) -> None: ...
    @overload
    def disablePointSmooth() -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def enableColorFromX(self) -> None: ...
    @overload
    def enableColorFromX(self, v: bool) -> None: ...
    @overload
    def enableColorFromY(self) -> None: ...
    @overload
    def enableColorFromY(self, v: bool) -> None: ...
    @overload
    def enableColorFromY(bool) -> void: ...
    @overload
    def enableColorFromZ(self) -> None: ...
    @overload
    def enableColorFromZ(self, v: bool) -> None: ...
    @overload
    def enableColorFromZ(bool) -> void: ...
    @overload
    def enablePointSmooth(self) -> None: ...
    @overload
    def enablePointSmooth(self, enable: bool) -> None: ...
    @overload
    def enablePointSmooth(bool) -> void: ...
    @overload
    def getActuallyRendered(self) -> int: ...
    @overload
    def getActuallyRendered() -> size_t: ...
    def getPoint3Df(self, *args, **kwargs) -> Any: ...
    @overload
    def insertPoint(self, x: float, y: float, z: float) -> None: ...
    @overload
    def insertPoint(self, p) -> None: ...
    @overload
    def insertPoint(conststructmrpt) -> void: ...
    @overload
    def insertPoint(self, p) -> None: ...
    @overload
    def insertPoint(conststructmrpt) -> void: ...
    @overload
    def isPointSmoothEnabled(self) -> bool: ...
    @overload
    def isPointSmoothEnabled() -> bool: ...
    @overload
    def loadFromPointsMap(self, themap: mrpt.pymrpt.mrpt.maps.CPointsMap) -> None: ...
    @overload
    def loadFromPointsMap(constclassmrpt) -> void: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def reserve(self, N: int) -> None: ...
    @overload
    def reserve(size_t) -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def setGradientColors(self, colorMin: mrpt.pymrpt.mrpt.img.TColorf, colorMax: mrpt.pymrpt.mrpt.img.TColorf) -> None: ...
    def setPoint(self, i: int, x: float, y: float, z: float) -> None: ...
    def setPoint_fast(self, i: int, x: float, y: float, z: float) -> None: ...
    def size(self) -> int: ...
    @overload
    def size_unprotected(self) -> int: ...
    @overload
    def size_unprotected() -> size_t: ...
    @overload
    def toYAMLMap(self, propertiesMap: mrpt.pymrpt.mrpt.containers.yaml) -> None: ...
    @overload
    def toYAMLMap(classmrpt) -> void: ...
    def __getitem__(self, index) -> Any: ...

class CPointCloudColoured(CRenderizableShaderPoints, PLY_Importer, PLY_Exporter):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPointCloudColoured) -> None: ...
    @overload
    def __init__(self, arg0: CPointCloudColoured) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def getActuallyRendered(self) -> int: ...
    @overload
    def getActuallyRendered() -> size_t: ...
    def getPoint3Df(self, *args, **kwargs) -> Any: ...
    def getPointColor(self, index: int) -> mrpt.pymrpt.mrpt.img.TColor: ...
    @overload
    def getPointColor_fast(self, index: int, R: float, G: float, B: float) -> None: ...
    @overload
    def getPointColor_fast(self, index: int, r: int, g: int, b: int) -> None: ...
    @overload
    def insertPoint(self, p: mrpt.pymrpt.mrpt.math.TPointXYZfRGBAu8) -> None: ...
    @overload
    def insertPoint(conststructmrpt) -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def markAllPointsAsNew(self) -> None: ...
    @overload
    def markAllPointsAsNew() -> void: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def push_back(self, x: float, y: float, z: float, R: float, G: float, B: float) -> None: ...
    @overload
    def push_back(self, x: float, y: float, z: float, R: float, G: float, B: float, A: float) -> None: ...
    @overload
    def recolorizeByCoordinate(self, coord_min: float, coord_max: float) -> None: ...
    @overload
    def recolorizeByCoordinate(self, coord_min: float, coord_max: float, coord_index: int) -> None: ...
    @overload
    def recolorizeByCoordinate(self, coord_min: float, coord_max: float, coord_index: int, color_map: mrpt.pymrpt.mrpt.img.TColormap) -> None: ...
    @overload
    def reserve(self, N: int) -> None: ...
    @overload
    def reserve(size_t) -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def setPoint(self, i: int, p: mrpt.pymrpt.mrpt.math.TPointXYZfRGBAu8) -> None: ...
    @overload
    def setPoint(size_t, conststructmrpt) -> void: ...
    @overload
    def setPointColor_fast(self, index: int, R: float, G: float, B: float) -> None: ...
    @overload
    def setPointColor_fast(self, index: int, R: float, G: float, B: float, A: float) -> None: ...
    @overload
    def setPointColor_u8_fast(self, index: int, r: int, g: int, b: int) -> None: ...
    @overload
    def setPointColor_u8_fast(self, index: int, r: int, g: int, b: int, a: int) -> None: ...
    @overload
    def setPoint_fast(self, i: int, p: mrpt.pymrpt.mrpt.math.TPointXYZfRGBAu8) -> None: ...
    @overload
    def setPoint_fast(size_t, conststructmrpt) -> void: ...
    @overload
    def setPoint_fast(self, i: int, x: float, y: float, z: float) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    @overload
    def size_unprotected(self) -> int: ...
    @overload
    def size_unprotected() -> size_t: ...
    @overload
    def toYAMLMap(self, propertiesMap: mrpt.pymrpt.mrpt.containers.yaml) -> None: ...
    @overload
    def toYAMLMap(classmrpt) -> void: ...

class CPolyhedron(CRenderizableShaderWireFrame, CRenderizableShaderTriangles):
    class TPolyhedronEdge:
        __hash__: ClassVar[None] = ...
        v1: int
        v2: int
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPolyhedron.TPolyhedronEdge) -> None: ...
        def assign(self) -> CPolyhedron.TPolyhedronEdge: ...
        def __eq__(self, e: CPolyhedron.TPolyhedronEdge) -> bool: ...

    class TPolyhedronFace:
        normal: Any
        vertices: List[int]
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CPolyhedron.TPolyhedronFace) -> None: ...
        def assign(self) -> CPolyhedron.TPolyhedronFace: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPolyhedron) -> None: ...
    @overload
    def __init__(self, arg0: CPolyhedron) -> None: ...
    def CreateArchimedeanRegularAntiprism(self, *args, **kwargs) -> Any: ...
    def CreateArchimedeanRegularPrism(self, *args, **kwargs) -> Any: ...
    def CreateCatalanDoublePyramid(self, *args, **kwargs) -> Any: ...
    def CreateCatalanTrapezohedron(self, *args, **kwargs) -> Any: ...
    def CreateCubicPrism(self, *args, **kwargs) -> Any: ...
    def CreateCuboctahedron(self, *args, **kwargs) -> Any: ...
    def CreateCupola(self, *args, **kwargs) -> Any: ...
    def CreateDeltoidalHexecontahedron(self, *args, **kwargs) -> Any: ...
    def CreateDeltoidalIcositetrahedron(self, *args, **kwargs) -> Any: ...
    def CreateDodecahedron(self, *args, **kwargs) -> Any: ...
    def CreateEmpty(self, *args, **kwargs) -> Any: ...
    def CreateHexahedron(self, *args, **kwargs) -> Any: ...
    def CreateIcosahedron(self, *args, **kwargs) -> Any: ...
    def CreateIcosidodecahedron(self, *args, **kwargs) -> Any: ...
    def CreateJohnsonSolidWithConstantBase(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def CreateOctahedron(self, *args, **kwargs) -> Any: ...
    def CreateParallelepiped(self, *args, **kwargs) -> Any: ...
    def CreatePentagonalRotunda(self, *args, **kwargs) -> Any: ...
    def CreatePentakisDodecahedron(self, *args, **kwargs) -> Any: ...
    def CreateRandomPolyhedron(self, *args, **kwargs) -> Any: ...
    def CreateRegularAntiprism(self, *args, **kwargs) -> Any: ...
    def CreateRegularBifrustum(self, *args, **kwargs) -> Any: ...
    def CreateRegularDoublePyramid(self, *args, **kwargs) -> Any: ...
    def CreateRegularFrustum(self, *args, **kwargs) -> Any: ...
    def CreateRegularPrism(self, *args, **kwargs) -> Any: ...
    def CreateRegularPyramid(self, *args, **kwargs) -> Any: ...
    def CreateRegularTruncatedPyramid(self, *args, **kwargs) -> Any: ...
    def CreateRhombicDodecahedron(self, *args, **kwargs) -> Any: ...
    def CreateRhombicTriacontahedron(self, *args, **kwargs) -> Any: ...
    def CreateRhombicosidodecahedron(self, *args, **kwargs) -> Any: ...
    def CreateRhombicuboctahedron(self, *args, **kwargs) -> Any: ...
    def CreateTetrahedron(self, *args, **kwargs) -> Any: ...
    def CreateTetrakisHexahedron(self, *args, **kwargs) -> Any: ...
    def CreateTrapezohedron(self, *args, **kwargs) -> Any: ...
    def CreateTriakisIcosahedron(self, *args, **kwargs) -> Any: ...
    def CreateTriakisOctahedron(self, *args, **kwargs) -> Any: ...
    def CreateTriakisTetrahedron(self, *args, **kwargs) -> Any: ...
    def CreateTruncatedDodecahedron(self, *args, **kwargs) -> Any: ...
    def CreateTruncatedHexahedron(self, *args, **kwargs) -> Any: ...
    def CreateTruncatedIcosahedron(self, *args, **kwargs) -> Any: ...
    def CreateTruncatedOctahedron(self, *args, **kwargs) -> Any: ...
    def CreateTruncatedTetrahedron(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CPolyhedron: ...
    @overload
    def augment(self, height: float) -> CPolyhedron: ...
    @overload
    def augment(self, height: float, numVertices: int) -> CPolyhedron: ...
    @overload
    def augment(double) -> Any: ...
    @overload
    def augment(self) -> CPolyhedron: ...
    @overload
    def augment(self, direction: bool) -> CPolyhedron: ...
    @overload
    def augment(double) -> Any: ...
    @overload
    def augment(self, numVertices: int) -> CPolyhedron: ...
    @overload
    def augment(self, numVertices: int, direction: bool) -> CPolyhedron: ...
    @overload
    def augment(double) -> Any: ...
    def cantellate(self, factor: float) -> CPolyhedron: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def getCenter(self, center) -> None: ...
    @overload
    def getCenter(structmrpt) -> void: ...
    def getDual(self) -> CPolyhedron: ...
    @overload
    def getNumberOfEdges(self) -> int: ...
    @overload
    def getNumberOfEdges() -> uint32_t: ...
    @overload
    def getNumberOfFaces(self) -> int: ...
    @overload
    def getNumberOfFaces() -> uint32_t: ...
    @overload
    def getNumberOfVertices(self) -> int: ...
    @overload
    def getNumberOfVertices() -> uint32_t: ...
    @overload
    def getVolume(self) -> float: ...
    @overload
    def getVolume() -> double: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isClosed(self) -> bool: ...
    @overload
    def isClosed() -> bool: ...
    @overload
    def isWireframe(self) -> bool: ...
    @overload
    def isWireframe() -> bool: ...
    @overload
    def makeConvexPolygons(self) -> None: ...
    @overload
    def makeConvexPolygons() -> void: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    def rotate(self, angle: float) -> CPolyhedron: ...
    def scale(self, factor: float) -> CPolyhedron: ...
    @overload
    def setWireframe(self) -> None: ...
    @overload
    def setWireframe(self, enabled: bool) -> None: ...
    @overload
    def setWireframe(bool) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...
    def truncate(self, factor: float) -> CPolyhedron: ...
    @overload
    def updatePolygons(self) -> None: ...
    @overload
    def updatePolygons() -> void: ...

class CRenderizable(mrpt.pymrpt.mrpt.serialization.CSerializable):
    class RenderContext:
        activeCullFace: Optional[TCullFace]
        activeLights: Optional[TLightParameters]
        activeTextureUnit: Optional[int]
        shader_id: int
        def __init__(self) -> None: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRenderizable: ...
    @overload
    def castShadows(self) -> bool: ...
    @overload
    def castShadows() -> bool: ...
    @overload
    def castShadows(self) -> None: ...
    @overload
    def castShadows(self, doCast: bool) -> None: ...
    @overload
    def castShadows(bool) -> void: ...
    @overload
    def cullElegible(self) -> bool: ...
    @overload
    def cullElegible() -> bool: ...
    @overload
    def enableShowName(self) -> None: ...
    @overload
    def enableShowName(self, showName: bool) -> None: ...
    @overload
    def enableShowName(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getBoundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_double_t: ...
    @overload
    def getBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_double_t: ...
    @overload
    def getBoundingBoxLocal() -> Any: ...
    def getBoundingBoxLocalf(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    def getCPose(self) -> mrpt.pymrpt.mrpt.poses.CPose3D: ...
    def getColor(self) -> mrpt.pymrpt.mrpt.img.TColorf: ...
    def getColor_u8(self) -> mrpt.pymrpt.mrpt.img.TColor: ...
    def getLocalRepresentativePoint(self, *args, **kwargs) -> Any: ...
    def getName(self) -> str: ...
    def getPose(self) -> mrpt.pymrpt.mrpt.math.TPose3D: ...
    @overload
    def getScaleX(self) -> float: ...
    @overload
    def getScaleX() -> float: ...
    @overload
    def getScaleY(self) -> float: ...
    @overload
    def getScaleY() -> float: ...
    @overload
    def getScaleZ(self) -> float: ...
    @overload
    def getScaleZ() -> float: ...
    @overload
    def hasToUpdateBuffers(self) -> bool: ...
    @overload
    def hasToUpdateBuffers() -> bool: ...
    @overload
    def initializeTextures(self) -> None: ...
    @overload
    def initializeTextures() -> void: ...
    @overload
    def isCompositeObject(self) -> bool: ...
    @overload
    def isCompositeObject() -> bool: ...
    @overload
    def isShowNameEnabled(self) -> bool: ...
    @overload
    def isShowNameEnabled() -> bool: ...
    @overload
    def isVisible(self) -> bool: ...
    @overload
    def isVisible() -> bool: ...
    def labelObject(self, *args, **kwargs) -> Any: ...
    @overload
    def materialShininess(self) -> float: ...
    @overload
    def materialShininess() -> float: ...
    @overload
    def materialShininess(self, shininess: float) -> None: ...
    @overload
    def materialShininess(float) -> void: ...
    @overload
    def notifyBBoxChange(self) -> None: ...
    @overload
    def notifyBBoxChange() -> void: ...
    @overload
    def notifyChange(self) -> None: ...
    @overload
    def notifyChange() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setColor(self, c: mrpt.pymrpt.mrpt.img.TColorf) -> CRenderizable: ...
    @overload
    def setColor(self, R: float, G: float, B: float) -> CRenderizable: ...
    @overload
    def setColor(self, R: float, G: float, B: float, A: float) -> CRenderizable: ...
    def setColorA(self, a: float) -> CRenderizable: ...
    def setColorA_u8(self, a: int) -> CRenderizable: ...
    @overload
    def setColor_u8(self, c: mrpt.pymrpt.mrpt.img.TColor) -> CRenderizable: ...
    @overload
    def setColor_u8(self, R: int, G: int, B: int) -> CRenderizable: ...
    @overload
    def setColor_u8(self, R: int, G: int, B: int, A: int) -> CRenderizable: ...
    @overload
    def setLocalRepresentativePoint(self, p) -> None: ...
    @overload
    def setLocalRepresentativePoint(conststructmrpt) -> void: ...
    @overload
    def setLocation(self, x: float, y: float, z: float) -> CRenderizable: ...
    @overload
    def setLocation(self, p) -> CRenderizable: ...
    @overload
    def setName(self, n: str) -> None: ...
    @overload
    def setName(conststd) -> void: ...
    @overload
    def setPose(self, o: mrpt.pymrpt.mrpt.poses.CPose3D) -> CRenderizable: ...
    @overload
    def setPose(self, o: mrpt.pymrpt.mrpt.poses.CPose2D) -> CRenderizable: ...
    @overload
    def setPose(self, o: mrpt.pymrpt.mrpt.math.TPose3D) -> CRenderizable: ...
    @overload
    def setPose(self, o: mrpt.pymrpt.mrpt.math.TPose2D) -> CRenderizable: ...
    @overload
    def setPose(self, o) -> CRenderizable: ...
    @overload
    def setPose(self, o) -> CRenderizable: ...
    @overload
    def setScale(self, s: float) -> CRenderizable: ...
    @overload
    def setScale(self, sx: float, sy: float, sz: float) -> CRenderizable: ...
    @overload
    def setVisibility(self) -> None: ...
    @overload
    def setVisibility(self, visible: bool) -> None: ...
    @overload
    def setVisibility(bool) -> void: ...
    @overload
    def toYAMLMap(self, propertiesMap: mrpt.pymrpt.mrpt.containers.yaml) -> None: ...
    @overload
    def toYAMLMap(classmrpt) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...
    @overload
    def updateBuffers(self) -> None: ...
    @overload
    def updateBuffers() -> void: ...

class CRenderizableShaderPoints(CRenderizable):
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRenderizableShaderPoints: ...
    @overload
    def enableVariablePointSize(self) -> None: ...
    @overload
    def enableVariablePointSize(self, enable: bool) -> None: ...
    @overload
    def enableVariablePointSize(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def getPointSize(self) -> float: ...
    @overload
    def getPointSize() -> float: ...
    @overload
    def getVariablePointSize_DepthScale(self) -> float: ...
    @overload
    def getVariablePointSize_DepthScale() -> float: ...
    @overload
    def getVariablePointSize_k(self) -> float: ...
    @overload
    def getVariablePointSize_k() -> float: ...
    @overload
    def isEnabledVariablePointSize(self) -> bool: ...
    @overload
    def isEnabledVariablePointSize() -> bool: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setPointSize(self, p: float) -> None: ...
    @overload
    def setPointSize(float) -> void: ...
    @overload
    def setVariablePointSize_DepthScale(self, v: float) -> None: ...
    @overload
    def setVariablePointSize_DepthScale(float) -> void: ...
    @overload
    def setVariablePointSize_k(self, v: float) -> None: ...
    @overload
    def setVariablePointSize_k(float) -> void: ...

class CRenderizableShaderText(CRenderizable):
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRenderizableShaderText: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def onUpdateBuffers_Text(self) -> None: ...
    @overload
    def onUpdateBuffers_Text() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...

class CRenderizableShaderTexturedTriangles(CRenderizable):
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRenderizableShaderTexturedTriangles: ...
    @overload
    def assignImage(self, img: mrpt.pymrpt.mrpt.img.CImage, imgAlpha: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def assignImage(self, img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def assignImage(constclassmrpt) -> void: ...
    @overload
    def cullFaces(self, cf: TCullFace) -> None: ...
    @overload
    def cullFaces(constenummrpt) -> void: ...
    @overload
    def cullFaces(self) -> TCullFace: ...
    @overload
    def enableLight(self) -> None: ...
    @overload
    def enableLight(self, enable: bool) -> None: ...
    @overload
    def enableLight(bool) -> void: ...
    @overload
    def enableTextureLinearInterpolation(self, enable: bool) -> None: ...
    @overload
    def enableTextureLinearInterpolation(bool) -> void: ...
    @overload
    def enableTextureMipMap(self, enable: bool) -> None: ...
    @overload
    def enableTextureMipMap(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getTextureAlphaImage(self) -> mrpt.pymrpt.mrpt.img.CImage: ...
    def getTextureImage(self) -> mrpt.pymrpt.mrpt.img.CImage: ...
    @overload
    def initializeTextures(self) -> None: ...
    @overload
    def initializeTextures() -> void: ...
    @overload
    def isLightEnabled(self) -> bool: ...
    @overload
    def isLightEnabled() -> bool: ...
    @overload
    def onUpdateBuffers_TexturedTriangles(self) -> None: ...
    @overload
    def onUpdateBuffers_TexturedTriangles() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def textureImageHasBeenAssigned(self) -> bool: ...
    @overload
    def textureImageHasBeenAssigned() -> bool: ...
    @overload
    def textureLinearInterpolation(self) -> bool: ...
    @overload
    def textureLinearInterpolation() -> bool: ...
    @overload
    def textureMipMap(self) -> bool: ...
    @overload
    def textureMipMap() -> bool: ...

class CRenderizableShaderTriangles(CRenderizable):
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRenderizableShaderTriangles: ...
    @overload
    def cullFaces(self, cf: TCullFace) -> None: ...
    @overload
    def cullFaces(TCullFace) -> Any: ...
    @overload
    def cullFaces(constenummrpt) -> void: ...
    @overload
    def cullFaces(self) -> TCullFace: ...
    @overload
    def enableLight(self) -> None: ...
    @overload
    def enableLight(self, enable: bool) -> None: ...
    @overload
    def enableLight(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def isLightEnabled(self) -> bool: ...
    @overload
    def isLightEnabled() -> bool: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...

class CRenderizableShaderWireFrame(CRenderizable):
    def __init__(self, *args, **kwargs) -> None: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CRenderizableShaderWireFrame: ...
    @overload
    def enableAntiAliasing(self) -> None: ...
    @overload
    def enableAntiAliasing(self, enable: bool) -> None: ...
    @overload
    def enableAntiAliasing(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def getLineWidth(self) -> float: ...
    @overload
    def getLineWidth() -> float: ...
    @overload
    def isAntiAliasingEnabled(self) -> bool: ...
    @overload
    def isAntiAliasingEnabled() -> bool: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setLineWidth(self, w: float) -> None: ...
    @overload
    def setLineWidth(float) -> void: ...

class CSetOfLines(CRenderizableShaderWireFrame, CRenderizableShaderPoints):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CSetOfLines) -> None: ...
    @overload
    def __init__(self, arg0: CSetOfLines) -> None: ...
    def Create(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def appendLine(self, p0, p1) -> None: ...
    @overload
    def appendLine(self, sgm: mrpt.pymrpt.mrpt.math.TSegment3D) -> None: ...
    @overload
    def appendLine(conststructmrpt) -> void: ...
    @overload
    def appendLine(self, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float) -> None: ...
    def appendLineStrip(self, x: float, y: float, z: float) -> None: ...
    def assign(self) -> CSetOfLines: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def enableAntiAliasing(self) -> None: ...
    @overload
    def enableAntiAliasing(self, enable: bool) -> None: ...
    @overload
    def enableAntiAliasing(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getLineByIndex(self, index: int, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float) -> None: ...
    @overload
    def getLineCount(self) -> int: ...
    @overload
    def getLineCount() -> size_t: ...
    @overload
    def getVerticesPointSize(self) -> float: ...
    @overload
    def getVerticesPointSize() -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isAntiAliasingEnabled(self) -> bool: ...
    @overload
    def isAntiAliasingEnabled() -> bool: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def reserve(self, r: int) -> None: ...
    @overload
    def reserve(size_t) -> void: ...
    @overload
    def resize(self, nLines: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def setLineByIndex(self, index: int, segm: mrpt.pymrpt.mrpt.math.TSegment3D) -> None: ...
    @overload
    def setLineByIndex(size_t, conststructmrpt) -> void: ...
    @overload
    def setLineByIndex(self, index: int, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float) -> None: ...
    @overload
    def setVerticesPointSize(self, size_points: float) -> None: ...
    @overload
    def setVerticesPointSize(constfloat) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class CSetOfObjects(CRenderizable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CSetOfObjects) -> None: ...
    @overload
    def __init__(self, arg0: CSetOfObjects) -> None: ...
    def Create(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asYAML(self) -> mrpt.pymrpt.mrpt.containers.yaml: ...
    def assign(self) -> CSetOfObjects: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def contains(self, obj: CRenderizable) -> bool: ...
    @overload
    def contains(constclassstd) -> bool: ...
    @overload
    def dumpListOfObjects(self, lst: List[str]) -> None: ...
    @overload
    def dumpListOfObjects(classstd) -> void: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getByName(self, str: str) -> CRenderizable: ...
    @overload
    def initializeTextures(self) -> None: ...
    @overload
    def initializeTextures() -> void: ...
    @overload
    def insert(self, newObject: CRenderizable) -> None: ...
    @overload
    def insert(constclassstd) -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isCompositeObject(self) -> bool: ...
    @overload
    def isCompositeObject() -> bool: ...
    def posePDF2opengl(self, *args, **kwargs) -> Any: ...
    @overload
    def removeObject(self, obj: CRenderizable) -> None: ...
    @overload
    def removeObject(constclassstd) -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    def setColorA_u8(self, a: int) -> CRenderizable: ...
    def setColor_u8(self, c: mrpt.pymrpt.mrpt.img.TColor) -> CRenderizable: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CSetOfTexturedTriangles(CRenderizableShaderTexturedTriangles):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CSetOfTexturedTriangles) -> None: ...
    @overload
    def __init__(self, arg0: CSetOfTexturedTriangles) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CSetOfTexturedTriangles: ...
    @overload
    def clearTriangles(self) -> None: ...
    @overload
    def clearTriangles() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getTriangle(self, idx: int) -> TTriangle: ...
    @overload
    def getTriangle(self, idx: int, t: TTriangle) -> None: ...
    @overload
    def getTriangle(size_t, structmrpt) -> void: ...
    @overload
    def getTrianglesCount(self) -> int: ...
    @overload
    def getTrianglesCount() -> size_t: ...
    @overload
    def insertTriangle(self, t: TTriangle) -> None: ...
    @overload
    def insertTriangle(conststructmrpt) -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_TexturedTriangles(self) -> None: ...
    @overload
    def onUpdateBuffers_TexturedTriangles() -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CSetOfTriangles(CRenderizableShaderTriangles):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CSetOfTriangles) -> None: ...
    @overload
    def __init__(self, arg0: CSetOfTriangles) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CSetOfTriangles: ...
    @overload
    def clearTriangles(self) -> None: ...
    @overload
    def clearTriangles() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getTriangle(self, idx: int, t: TTriangle) -> None: ...
    @overload
    def getTriangle(size_t, structmrpt) -> void: ...
    @overload
    def getTrianglesCount(self) -> int: ...
    @overload
    def getTrianglesCount() -> size_t: ...
    @overload
    def insertTriangle(self, t: TTriangle) -> None: ...
    @overload
    def insertTriangle(conststructmrpt) -> void: ...
    @overload
    def insertTriangles(self, p: CSetOfTriangles) -> None: ...
    @overload
    def insertTriangles(constclassstd) -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def reserve(self, t: int) -> None: ...
    @overload
    def reserve(size_t) -> void: ...
    def setColorA_u8(self, a: int) -> CRenderizable: ...
    def setColor_u8(self, c: mrpt.pymrpt.mrpt.img.TColor) -> CRenderizable: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...
    @overload
    def updatePolygons(self) -> None: ...
    @overload
    def updatePolygons() -> void: ...

class CSimpleLine(CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float) -> None: ...
    @overload
    def __init__(self, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float, lineWidth: float, antiAliasing: bool) -> None: ...
    @overload
    def __init__(self, arg0: CSimpleLine) -> None: ...
    @overload
    def __init__(self, arg0: CSimpleLine) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CSimpleLine: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getLineCoords(self, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float) -> None: ...
    def getLineEnd(self, *args, **kwargs) -> Any: ...
    def getLineStart(self, *args, **kwargs) -> Any: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def setLineCoords(self, p0, p1) -> None: ...
    @overload
    def setLineCoords(self, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float) -> None: ...

class CSkyBox(CRenderizable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CSkyBox) -> None: ...
    @overload
    def __init__(self, arg0: CSkyBox) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CSkyBox: ...
    @overload
    def assignImage(self, face: CUBE_TEXTURE_FACE, img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def assignImage(constenummrpt, constclassmrpt) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def cullElegible(self) -> bool: ...
    @overload
    def cullElegible() -> bool: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def initializeTextures(self) -> None: ...
    @overload
    def initializeTextures() -> void: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...

class CSphere(CGeneralizedEllipsoidTemplate_3_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, radius: float, nDivs: int) -> None: ...
    @overload
    def __init__(self, arg0: CSphere) -> None: ...
    @overload
    def __init__(self, arg0: CSphere) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CSphere: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getRadius(self) -> float: ...
    @overload
    def getRadius() -> float: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    @overload
    def setNumberDivs(self, N: int) -> None: ...
    @overload
    def setNumberDivs(int) -> void: ...
    @overload
    def setRadius(self, r: float) -> None: ...
    @overload
    def setRadius(float) -> void: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CText(CRenderizableShaderText):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, str: str) -> None: ...
    @overload
    def __init__(self, arg0: CText) -> None: ...
    @overload
    def __init__(self, arg0: CText) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CText: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def computeTextExtension(self) -> Tuple[float,float]: ...
    def getFont(self) -> str: ...
    def getString(self) -> str: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def setFont(self, s: str, height: int) -> None: ...
    @overload
    def setFont(conststd, int) -> void: ...
    @overload
    def setString(self, s: str) -> None: ...
    @overload
    def setString(conststd) -> void: ...
    @overload
    def toYAMLMap(self, propertiesMap: mrpt.pymrpt.mrpt.containers.yaml) -> None: ...
    @overload
    def toYAMLMap(classmrpt) -> void: ...

class CText3D(CRenderizableShaderText):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: str) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: str, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: str, arg2: float, arg3: TOpenGLFontStyle) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: str, arg2: float, arg3: TOpenGLFontStyle, arg4: float) -> None: ...
    @overload
    def __init__(self, str: str, fontName: str, scale: float, text_style: TOpenGLFontStyle, text_spacing: float, text_kerning: float) -> None: ...
    @overload
    def __init__(self, arg0: CText3D) -> None: ...
    @overload
    def __init__(self, arg0: CText3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CText3D: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def getFont(self) -> str: ...
    def getString(self) -> str: ...
    def getTextStyle(self) -> TOpenGLFontStyle: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def setFont(self, font: str) -> None: ...
    @overload
    def setFont(conststd) -> void: ...
    @overload
    def setString(self, s: str) -> None: ...
    @overload
    def setString(conststd) -> void: ...
    @overload
    def setTextKerning(self, text_kerning: float) -> None: ...
    @overload
    def setTextKerning(constdouble) -> void: ...
    @overload
    def setTextKerning(self) -> float: ...
    @overload
    def setTextKerning() -> double: ...
    @overload
    def setTextSpacing(self, text_spacing: float) -> None: ...
    @overload
    def setTextSpacing(constdouble) -> void: ...
    @overload
    def setTextSpacing(self) -> float: ...
    @overload
    def setTextSpacing() -> double: ...
    @overload
    def setTextStyle(self, text_style: TOpenGLFontStyle) -> None: ...
    @overload
    def setTextStyle(constenummrpt) -> void: ...
    @overload
    def toYAMLMap(self, propertiesMap: mrpt.pymrpt.mrpt.containers.yaml) -> None: ...
    @overload
    def toYAMLMap(classmrpt) -> void: ...

class CTextMessageCapable:
    class DataPerText(T2DTextData):
        gl_text: CText
        gl_text_outdated: bool
        gl_text_shadow: CText
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CTextMessageCapable.DataPerText) -> None: ...
        def assign(self) -> CTextMessageCapable.DataPerText: ...

    class TListTextMessages:
        messages: Dict[int,CTextMessageCapable.DataPerText]
        mtx: Any
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: CTextMessageCapable.TListTextMessages) -> None: ...
        def assign(self) -> CTextMessageCapable.TListTextMessages: ...
        @overload
        def regenerateGLobjects(self) -> None: ...
        @overload
        def regenerateGLobjects() -> void: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CTextMessageCapable) -> None: ...
    @overload
    def addTextMessage(self, x_frac: float, y_frac: float, text: str) -> None: ...
    @overload
    def addTextMessage(self, x_frac: float, y_frac: float, text: str, unique_index: int) -> None: ...
    @overload
    def addTextMessage(self, x_frac: float, y_frac: float, text: str, unique_index: int, fontParams: TFontParams) -> None: ...
    def assign(self) -> CTextMessageCapable: ...
    @overload
    def clearTextMessages(self) -> None: ...
    @overload
    def clearTextMessages() -> void: ...
    def getTextMessages(self, *args, **kwargs) -> Any: ...
    @overload
    def updateTextMessage(self, unique_index: int, text: str) -> bool: ...
    @overload
    def updateTextMessage(size_t, conststd) -> bool: ...

class CTexturedPlane(CRenderizableShaderTexturedTriangles, CRenderizableShaderTriangles):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, x_min: float, x_max: float, y_min: float, y_max: float) -> None: ...
    @overload
    def __init__(self, arg0: CTexturedPlane) -> None: ...
    @overload
    def __init__(self, arg0: CTexturedPlane) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CTexturedPlane: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def cullFaces(self, cf: TCullFace) -> None: ...
    @overload
    def cullFaces(constenummrpt) -> void: ...
    @overload
    def cullFaces(self) -> TCullFace: ...
    @overload
    def enableLighting(self) -> None: ...
    @overload
    def enableLighting(self, enable: bool) -> None: ...
    @overload
    def enableLighting(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getPlaneCorners(self, xMin: float, xMax: float, yMin: float, yMax: float) -> None: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def onUpdateBuffers_TexturedTriangles(self) -> None: ...
    @overload
    def onUpdateBuffers_TexturedTriangles() -> void: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    def setPlaneCorners(self, xMin: float, xMax: float, yMin: float, yMax: float) -> None: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...

class CUBE_TEXTURE_FACE:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    BACK: ClassVar[CUBE_TEXTURE_FACE] = ...
    BOTTOM: ClassVar[CUBE_TEXTURE_FACE] = ...
    FRONT: ClassVar[CUBE_TEXTURE_FACE] = ...
    LEFT: ClassVar[CUBE_TEXTURE_FACE] = ...
    RIGHT: ClassVar[CUBE_TEXTURE_FACE] = ...
    TOP: ClassVar[CUBE_TEXTURE_FACE] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class CVectorField2D(CRenderizableShaderPoints, CRenderizableShaderTriangles, CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, arg1: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, arg1: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, arg1: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, arg2: float, arg3: float) -> None: ...
    @overload
    def __init__(self, arg0: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, arg1: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, arg2: float, arg3: float, arg4: float) -> None: ...
    @overload
    def __init__(self, Matrix_x: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_y: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, xmin: float, xmax: float, ymin: float, ymax: float) -> None: ...
    @overload
    def __init__(self, arg0: CVectorField2D) -> None: ...
    @overload
    def __init__(self, arg0: CVectorField2D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def adjustVectorFieldToGrid(self) -> None: ...
    @overload
    def adjustVectorFieldToGrid() -> void: ...
    def assign(self) -> CVectorField2D: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> size_t: ...
    @overload
    def enableAntiAliasing(self) -> None: ...
    @overload
    def enableAntiAliasing(self, enable: bool) -> None: ...
    @overload
    def enableAntiAliasing(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    def getGridLimits(self, xmin: float, xmax: float, ymin: float, ymax: float) -> None: ...
    def getPointColor(self) -> mrpt.pymrpt.mrpt.img.TColorf: ...
    def getVectorField(self, Matrix_x: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_y: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    def getVectorFieldColor(self) -> mrpt.pymrpt.mrpt.img.TColorf: ...
    def getVectorField_x(self) -> mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t: ...
    def getVectorField_y(self) -> mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isAntiAliasingEnabled(self) -> bool: ...
    @overload
    def isAntiAliasingEnabled() -> bool: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def onUpdateBuffers_Triangles(self) -> None: ...
    @overload
    def onUpdateBuffers_Triangles() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    def resize(self, rows: int, cols: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> size_t: ...
    def setGridCenterAndCellSize(self, center_x: float, center_y: float, cellsize_x: float, cellsize_y: float) -> None: ...
    def setGridLimits(self, xmin: float, xmax: float, ymin: float, ymax: float) -> None: ...
    @overload
    def setPointColor(self, R: float, G: float, B: float) -> None: ...
    @overload
    def setPointColor(self, R: float, G: float, B: float, A: float) -> None: ...
    def setVectorField(self, Matrix_x: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_y: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def setVectorFieldColor(self, R: float, G: float, B: float) -> None: ...
    @overload
    def setVectorFieldColor(self, R: float, G: float, B: float, A: float) -> None: ...

class CVectorField3D(CRenderizableShaderPoints, CRenderizableShaderWireFrame):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x_vf_ini: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, y_vf_ini: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, z_vf_ini: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, x_p_ini: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, y_p_ini: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, z_p_ini: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def __init__(self, arg0: CVectorField3D) -> None: ...
    @overload
    def __init__(self, arg0: CVectorField3D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CVectorField3D: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> size_t: ...
    @overload
    def enableColorFromModule(self) -> None: ...
    @overload
    def enableColorFromModule(self, enable: bool) -> None: ...
    @overload
    def enableColorFromModule(bool) -> void: ...
    @overload
    def enableShowPoints(self) -> None: ...
    @overload
    def enableShowPoints(self, enable: bool) -> None: ...
    @overload
    def enableShowPoints(bool) -> void: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def getMaxSpeedForColor(self) -> float: ...
    @overload
    def getMaxSpeedForColor() -> float: ...
    def getPointColor(self) -> mrpt.pymrpt.mrpt.img.TColorf: ...
    def getPointCoordinates(self, Coord_x: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Coord_y: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Coord_z: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    def getVectorField(self, Matrix_x: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_y: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_z: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def getVectorFieldColor(self, Cmin: mrpt.pymrpt.mrpt.img.TColorf, Cmax: mrpt.pymrpt.mrpt.img.TColorf) -> None: ...
    @overload
    def getVectorFieldColor(self) -> mrpt.pymrpt.mrpt.img.TColorf: ...
    def getVectorField_x(self) -> mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t: ...
    def getVectorField_y(self) -> mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t: ...
    def getVectorField_z(self) -> mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t: ...
    def internalBoundingBoxLocal(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_float_t: ...
    @overload
    def isAntiAliasingEnabled(self) -> bool: ...
    @overload
    def isAntiAliasingEnabled() -> bool: ...
    @overload
    def isColorFromModuleEnabled(self) -> bool: ...
    @overload
    def isColorFromModuleEnabled() -> bool: ...
    @overload
    def onUpdateBuffers_Points(self) -> None: ...
    @overload
    def onUpdateBuffers_Points() -> void: ...
    @overload
    def onUpdateBuffers_Wireframe(self) -> None: ...
    @overload
    def onUpdateBuffers_Wireframe() -> void: ...
    @overload
    def renderUpdateBuffers(self) -> None: ...
    @overload
    def renderUpdateBuffers() -> void: ...
    def resize(self, rows: int, cols: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> size_t: ...
    @overload
    def setMaxSpeedForColor(self, s: float) -> None: ...
    @overload
    def setMaxSpeedForColor(constfloat) -> void: ...
    @overload
    def setMotionFieldColormap(self, Rmin: float, Gmin: float, Bmin: float, Rmax: float, Gmax: float, Bmax: float) -> None: ...
    @overload
    def setMotionFieldColormap(self, Rmin: float, Gmin: float, Bmin: float, Rmax: float, Gmax: float, Bmax: float, Amin: float) -> None: ...
    @overload
    def setMotionFieldColormap(self, Rmin: float, Gmin: float, Bmin: float, Rmax: float, Gmax: float, Bmax: float, Amin: float, Amax: float) -> None: ...
    @overload
    def setPointColor(self, R: float, G: float, B: float) -> None: ...
    @overload
    def setPointColor(self, R: float, G: float, B: float, A: float) -> None: ...
    def setPointCoordinates(self, Matrix_x: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_y: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_z: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    def setVectorField(self, Matrix_x: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_y: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t, Matrix_z: mrpt.pymrpt.mrpt.math.CMatrixDynamic_float_t) -> None: ...
    @overload
    def setVectorFieldColor(self, R: float, G: float, B: float) -> None: ...
    @overload
    def setVectorFieldColor(self, R: float, G: float, B: float, A: float) -> None: ...

class DefaultShaderID:
    def __init__(self) -> None: ...

class FrameBuffer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: FrameBuffer) -> None: ...
    def Bind(self, *args, **kwargs) -> Any: ...
    def CurrentBinding(self, *args, **kwargs) -> Any: ...
    def Unbind(self, *args, **kwargs) -> Any: ...
    def assign(self) -> FrameBuffer: ...
    def bind(self) -> FrameBufferBinding: ...
    @overload
    def blit(self) -> None: ...
    @overload
    def blit() -> void: ...
    @overload
    def create(self, width: int, height: int) -> None: ...
    @overload
    def create(self, width: int, height: int, nSamples: int) -> None: ...
    def createDepthMap(self, width: int, height: int) -> None: ...
    @overload
    def depthMapTextureId(self) -> int: ...
    @overload
    def depthMapTextureId() -> unsignedint: ...
    @overload
    def destroy(self) -> None: ...
    @overload
    def destroy() -> void: ...
    @overload
    def height(self) -> int: ...
    @overload
    def height() -> unsignedint: ...
    @overload
    def initialized(self) -> bool: ...
    @overload
    def initialized() -> bool: ...
    @overload
    def numSamples(self) -> int: ...
    @overload
    def numSamples() -> int: ...
    @overload
    def unbind(self) -> None: ...
    @overload
    def unbind() -> void: ...
    @overload
    def width(self) -> int: ...
    @overload
    def width() -> unsignedint: ...

class FrameBufferBinding:
    drawFbId: int
    readFbId: int
    def __init__(self) -> None: ...

class PLY_Exporter:
    @overload
    def __init__(self, arg0: PLY_Exporter) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> PLY_Exporter: ...
    def getSavePLYErrorString(self) -> str: ...
    @overload
    def saveToPlyFile(self, filename: str) -> bool: ...
    @overload
    def saveToPlyFile(self, filename: str, save_in_binary: bool) -> bool: ...
    @overload
    def saveToPlyFile(self, filename: str, save_in_binary: bool, file_comments: List[str]) -> bool: ...
    @overload
    def saveToPlyFile(self, filename: str, save_in_binary: bool, file_comments: List[str], file_obj_info: List[str]) -> bool: ...

class PLY_Importer:
    @overload
    def __init__(self, arg0: PLY_Importer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> PLY_Importer: ...
    def getLoadPLYErrorString(self) -> str: ...
    @overload
    def loadFromPlyFile(self, filename: str) -> bool: ...
    @overload
    def loadFromPlyFile(self, filename: str, file_comments: List[str]) -> bool: ...
    @overload
    def loadFromPlyFile(self, filename: str, file_comments: List[str], file_obj_info: List[str]) -> bool: ...

class PointCloudAdapter_mrpt_maps_CColouredPointsMap_t:
    def __init__(self, obj: mrpt.pymrpt.mrpt.maps.CColouredPointsMap) -> None: ...
    def getPointRGBf(self, idx: int, r: float, g: float, b: float) -> None: ...
    def getPointRGBu8(self, idx: int, r: int, g: int, b: int) -> None: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(constunsignedlong) -> void: ...
    def setDimensions(self, height: int, width: int) -> None: ...
    @overload
    def setInvalidPoint(self, idx: int) -> None: ...
    @overload
    def setInvalidPoint(size_t) -> void: ...
    def setPointRGBf(self, idx: int, r: float, g: float, b: float) -> None: ...
    def setPointRGBu8(self, idx: int, r: int, g: int, b: int) -> None: ...
    def setPointXYZ(self, idx: int, x: float, y: float, z: float) -> None: ...
    def setPointXYZ_RGBAf(self, idx: int, x: float, y: float, z: float, r: float, g: float, b: float, a: float) -> None: ...
    def setPointXYZ_RGBu8(self, idx: int, x: float, y: float, z: float, r: int, g: int, b: int) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class PointCloudAdapter_mrpt_maps_CPointsMapXYZI_t:
    def __init__(self, obj: mrpt.pymrpt.mrpt.maps.CPointsMapXYZI) -> None: ...
    def getPointRGBf(self, idx: int, r: float, g: float, b: float) -> None: ...
    def getPointRGBu8(self, idx: int, r: int, g: int, b: int) -> None: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def setDimensions(self) -> None: ...
    def setPointRGBf(self, idx: int, r: float, g: float, b: float) -> None: ...
    def setPointRGBu8(self, idx: int, r: int, g: int, b: int) -> None: ...
    def setPointXYZ(self, idx: int, x: float, y: float, z: float) -> None: ...
    def setPointXYZ_RGBAf(self, idx: int, x: float, y: float, z: float, r: float, g: float, b: float, a: float) -> None: ...
    def setPointXYZ_RGBu8(self, idx: int, x: float, y: float, z: float, r: int, g: int, b: int) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class PointCloudAdapter_mrpt_maps_CPointsMap_t:
    def __init__(self, obj: mrpt.pymrpt.mrpt.maps.CPointsMap) -> None: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def setDimensions(self, height: int, width: int) -> None: ...
    @overload
    def setInvalidPoint(self, idx: int) -> None: ...
    @overload
    def setInvalidPoint(size_t) -> void: ...
    def setPointXYZ(self, idx: int, x: float, y: float, z: float) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class PointCloudAdapter_mrpt_maps_CSimplePointsMap_t:
    def __init__(self, obj: mrpt.pymrpt.mrpt.maps.CSimplePointsMap) -> None: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def setDimensions(self, height: int, width: int) -> None: ...
    @overload
    def setInvalidPoint(self, idx: int) -> None: ...
    @overload
    def setInvalidPoint(size_t) -> void: ...
    def setPointXYZ(self, idx: int, x: float, y: float, z: float) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class PointCloudAdapter_mrpt_maps_CWeightedPointsMap_t:
    def __init__(self, obj: mrpt.pymrpt.mrpt.maps.CWeightedPointsMap) -> None: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def setDimensions(self, height: int, width: int) -> None: ...
    def setPointXYZ(self, idx: int, x: float, y: float, z: float) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class PointCloudAdapter_mrpt_obs_CObservation3DRangeScan_t:
    def __init__(self, obj: mrpt.pymrpt.mrpt.obs.CObservation3DRangeScan) -> None: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def setDimensions(self, height: int, width: int) -> None: ...
    @overload
    def setInvalidPoint(self, idx: int) -> None: ...
    @overload
    def setInvalidPoint(size_t) -> void: ...
    def setPointXYZ(self, idx: int, x: float, y: float, z: float) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class PointCloudAdapter_mrpt_opengl_CPointCloudColoured_t:
    @overload
    def __init__(self, obj: CPointCloudColoured) -> None: ...
    @overload
    def __init__(self, arg0: PointCloudAdapter_mrpt_opengl_CPointCloudColoured_t) -> None: ...
    def getPointRGBf(self, idx: int, r: float, g: float, b: float) -> None: ...
    def getPointRGBu8(self, idx: int, r: int, g: int, b: int) -> None: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def setDimensions(self, height: int, width: int) -> None: ...
    @overload
    def setInvalidPoint(self, idx: int) -> None: ...
    @overload
    def setInvalidPoint(size_t) -> void: ...
    def setPointRGBf(self, idx: int, r: float, g: float, b: float) -> None: ...
    def setPointRGBu8(self, idx: int, r: int, g: int, b: int) -> None: ...
    def setPointXYZ(self, idx: int, x: float, y: float, z: float) -> None: ...
    def setPointXYZ_RGBAf(self, idx: int, x: float, y: float, z: float, Rf: float, Gf: float, Bf: float, Af: float) -> None: ...
    @overload
    def setPointXYZ_RGBu8(self, idx: int, x: float, y: float, z: float, r: int, g: int, b: int) -> None: ...
    @overload
    def setPointXYZ_RGBu8(self, idx: int, x: float, y: float, z: float, r: int, g: int, b: int, a: int) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class PointCloudAdapter_mrpt_opengl_CPointCloud_t:
    @overload
    def __init__(self, obj: CPointCloud) -> None: ...
    @overload
    def __init__(self, arg0: PointCloudAdapter_mrpt_opengl_CPointCloud_t) -> None: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    def setDimensions(self, height: int, width: int) -> None: ...
    @overload
    def setInvalidPoint(self, idx: int) -> None: ...
    @overload
    def setInvalidPoint(size_t) -> void: ...
    def setPointXYZ(self, idx: int, x: float, y: float, z: float) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...

class RenderQueueElement:
    renderState: TRenderMatrices
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, obj, state: TRenderMatrices) -> None: ...

class RenderQueueStats:
    numObjRendered: int
    numObjTotal: int
    def __init__(self) -> None: ...

class Scene(mrpt.pymrpt.mrpt.serialization.CSerializable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Scene) -> None: ...
    @overload
    def __init__(self, arg0: Scene) -> None: ...
    def Create(self, *args, **kwargs) -> Any: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def asYAML(self) -> mrpt.pymrpt.mrpt.containers.yaml: ...
    def assign(self, obj: Scene) -> Scene: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear(self, createMainViewport: bool) -> None: ...
    @overload
    def clear(bool) -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    def createViewport(self, viewportName: str) -> Viewport: ...
    @overload
    def dumpListOfObjects(self, lst: List[str]) -> None: ...
    @overload
    def dumpListOfObjects(classstd) -> void: ...
    @overload
    def enableFollowCamera(self, enabled: bool) -> None: ...
    @overload
    def enableFollowCamera(bool) -> void: ...
    @overload
    def followCamera(self) -> bool: ...
    @overload
    def followCamera() -> bool: ...
    @overload
    def freeOpenGLResources(self) -> None: ...
    @overload
    def freeOpenGLResources() -> void: ...
    @overload
    def getBoundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_double_t: ...
    @overload
    def getBoundingBox(self, vpn: str) -> mrpt.pymrpt.mrpt.math.TBoundingBox_double_t: ...
    @overload
    def getByName(self, str: str) -> CRenderizable: ...
    @overload
    def getByName(self, str: str, viewportName: str) -> CRenderizable: ...
    @overload
    def getViewport(self) -> Viewport: ...
    @overload
    def getViewport(self, viewportName: str) -> Viewport: ...
    @overload
    def initializeTextures(self) -> None: ...
    @overload
    def initializeTextures() -> void: ...
    def insert(self, *args, **kwargs) -> Any: ...
    @overload
    def loadFromFile(self, fil: str) -> bool: ...
    @overload
    def loadFromFile(conststd) -> bool: ...
    @overload
    def removeObject(self, obj: CRenderizable) -> None: ...
    @overload
    def removeObject(self, obj: CRenderizable, viewportName: str) -> None: ...
    @overload
    def removeObject(constclassstd, conststd) -> void: ...
    @overload
    def render(self) -> None: ...
    @overload
    def render() -> void: ...
    @overload
    def saveToFile(self, fil: str) -> bool: ...
    @overload
    def saveToFile(conststd) -> bool: ...
    def traceRay(self, o: mrpt.pymrpt.mrpt.poses.CPose3D, dist: float) -> bool: ...
    @overload
    def unloadShaders(self) -> None: ...
    @overload
    def unloadShaders() -> void: ...
    @overload
    def viewportsCount(self) -> int: ...
    @overload
    def viewportsCount() -> size_t: ...

class T2DTextData(TFontParams):
    text: str
    x: float
    y: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: T2DTextData) -> None: ...
    def assign(self) -> T2DTextData: ...

class TCullFace:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    BACK: ClassVar[TCullFace] = ...
    FRONT: ClassVar[TCullFace] = ...
    NONE: ClassVar[TCullFace] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TFontParams:
    color: mrpt.pymrpt.mrpt.img.TColorf
    draw_shadow: bool
    shadow_color: mrpt.pymrpt.mrpt.img.TColorf
    vfont_kerning: float
    vfont_name: str
    vfont_scale: float
    vfont_spacing: float
    vfont_style: TOpenGLFontStyle
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TFontParams) -> None: ...
    def assign(self) -> TFontParams: ...

class TLightParameters:
    ambient: float
    color: mrpt.pymrpt.mrpt.img.TColorf
    diffuse: float
    direction: Any
    eyeDistance2lightShadowExtension: float
    minimum_shadow_map_extension_ratio: float
    shadow_bias: float
    shadow_bias_cam2frag: float
    shadow_bias_normal: float
    specular: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TLightParameters) -> None: ...
    def assign(self) -> TLightParameters: ...
    @overload
    def readFromStream(self, in: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def readFromStream(classmrpt) -> void: ...
    @overload
    def writeToStream(self, out: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def writeToStream(classmrpt) -> void: ...

class TOpenGLFontStyle:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    FILL: ClassVar[TOpenGLFontStyle] = ...
    NICE: ClassVar[TOpenGLFontStyle] = ...
    OUTLINE: ClassVar[TOpenGLFontStyle] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TRenderMatrices:
    FOV: float
    azimuth: float
    elev: float
    eye: Any
    eyeDistance: float
    initialized: bool
    is1stShadowMapPass: bool
    is_projective: bool
    light_p: Any
    light_pmv: Any
    light_pv: Any
    light_v: Any
    m_matrix: Any
    mv_matrix: Any
    p_matrix: Any
    pinhole_model: Optional[mrpt.pymrpt.mrpt.img.TCamera]
    pmv_matrix: Any
    pointing: Any
    roll: float
    up: Any
    v_matrix: Any
    v_matrix_no_translation: Any
    viewport_height: int
    viewport_width: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TRenderMatrices) -> None: ...
    def LookAt(self, *args, **kwargs) -> Any: ...
    def OrthoProjectionMatrix(self, *args, **kwargs) -> Any: ...
    def assign(self) -> TRenderMatrices: ...
    def computeLightProjectionMatrix(self, zmin: float, zmax: float, lp) -> None: ...
    def computeNoProjectionMatrix(self, znear: float, zfar: float) -> None: ...
    def computeOrthoProjectionMatrix(self, *args, **kwargs) -> Any: ...
    def computeProjectionMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def computeViewMatrix(self) -> None: ...
    @overload
    def computeViewMatrix() -> void: ...
    @overload
    def getLastClipZFar(self) -> float: ...
    @overload
    def getLastClipZFar() -> float: ...
    @overload
    def getLastClipZNear(self) -> float: ...
    @overload
    def getLastClipZNear() -> float: ...
    @overload
    def getLastLightClipZFar(self) -> float: ...
    @overload
    def getLastLightClipZFar() -> float: ...
    @overload
    def getLastLightClipZNear(self) -> float: ...
    @overload
    def getLastLightClipZNear() -> float: ...
    @overload
    def matricesSetIdentity(self) -> None: ...
    @overload
    def matricesSetIdentity() -> void: ...
    def projectPoint(self, x: float, y: float, z: float, proj_u: float, proj_v: float, proj_z_depth: float) -> None: ...
    def projectPointPixels(self, x: float, y: float, z: float, proj_u_px: float, proj_v_px: float, proj_depth: float) -> None: ...
    @overload
    def saveToYaml(self, c: mrpt.pymrpt.mrpt.containers.yaml) -> None: ...
    @overload
    def saveToYaml(classmrpt) -> void: ...

class TTriangle:
    class Vertex:
        normal: Any
        uv: Any
        xyzrgba: mrpt.pymrpt.mrpt.math.TPointXYZfRGBAu8
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: TTriangle.Vertex) -> None: ...
        def assign(self) -> TTriangle.Vertex: ...
        @overload
        def setColor(self, c: mrpt.pymrpt.mrpt.img.TColor) -> None: ...
        @overload
        def setColor(conststructmrpt) -> void: ...
    vertices: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, p: mrpt.pymrpt.mrpt.math.TPolygon3D) -> None: ...
    @overload
    def __init__(self, p1, p2, p3) -> None: ...
    @overload
    def __init__(self, p1, p2, p3, n1, n2, n3) -> None: ...
    @overload
    def __init__(self, arg0: TTriangle) -> None: ...
    def a(self, i: int) -> int: ...
    def assign(self) -> TTriangle: ...
    def b(self, i: int) -> int: ...
    @overload
    def computeNormals(self) -> None: ...
    @overload
    def computeNormals() -> void: ...
    def g(self, i: int) -> int: ...
    def r(self, i: int) -> int: ...
    @overload
    def readFrom(self, i: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def readFrom(classmrpt) -> void: ...
    @overload
    def setColor(self, c: mrpt.pymrpt.mrpt.img.TColor) -> None: ...
    @overload
    def setColor(conststructmrpt) -> void: ...
    @overload
    def setColor(self, c: mrpt.pymrpt.mrpt.img.TColorf) -> None: ...
    @overload
    def setColor(conststructmrpt) -> void: ...
    def u(self, i: int) -> float: ...
    def v(self, i: int) -> float: ...
    def vertex(self, *args, **kwargs) -> Any: ...
    @overload
    def writeTo(self, o: mrpt.pymrpt.mrpt.serialization.CArchive) -> None: ...
    @overload
    def writeTo(classmrpt) -> void: ...
    def x(self, i: int) -> float: ...
    def y(self, i: int) -> float: ...
    def z(self, i: int) -> float: ...

class Texture:
    class Options:
        autoScale16to8bitConversion: bool
        enableTransparency: bool
        generateMipMaps: bool
        magnifyLinearFilter: bool
        wrappingModeS: Texture.Wrapping
        wrappingModeT: Texture.Wrapping
        def __init__(self) -> None: ...

    class Wrapping:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        ClampToEdge: ClassVar[Texture.Wrapping] = ...
        ClapToBorder: ClassVar[Texture.Wrapping] = ...
        MirroredRepeat: ClassVar[Texture.Wrapping] = ...
        Repeat: ClassVar[Texture.Wrapping] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        def __setstate__(self, state: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Texture) -> None: ...
    def assign(self) -> Texture: ...
    @overload
    def assignCubeImages(self, imgs: List[mrpt.pymrpt.mrpt.img.CImage[6]]) -> None: ...
    @overload
    def assignCubeImages(self, imgs: List[mrpt.pymrpt.mrpt.img.CImage[6]], textureUnit: int) -> None: ...
    @overload
    def assignImage2D(self, rgb: mrpt.pymrpt.mrpt.img.CImage, o) -> None: ...
    @overload
    def assignImage2D(self, rgb: mrpt.pymrpt.mrpt.img.CImage, o, textureUnit: int) -> None: ...
    @overload
    def assignImage2D(constclassmrpt, conststructmrpt, int) -> void: ...
    @overload
    def assignImage2D(self, rgb: mrpt.pymrpt.mrpt.img.CImage, alpha: mrpt.pymrpt.mrpt.img.CImage, o) -> None: ...
    @overload
    def assignImage2D(self, rgb: mrpt.pymrpt.mrpt.img.CImage, alpha: mrpt.pymrpt.mrpt.img.CImage, o, textureUnit: int) -> None: ...
    @overload
    def bindAsCubeTexture(self) -> None: ...
    @overload
    def bindAsCubeTexture() -> void: ...
    @overload
    def bindAsTexture2D(self) -> None: ...
    @overload
    def bindAsTexture2D() -> void: ...
    @overload
    def initialized(self) -> bool: ...
    @overload
    def initialized() -> bool: ...
    @overload
    def textureNameID(self) -> int: ...
    @overload
    def textureNameID() -> unsignedint: ...
    @overload
    def textureUnit(self) -> int: ...
    @overload
    def textureUnit() -> int: ...
    @overload
    def unloadTexture(self) -> None: ...
    @overload
    def unloadTexture() -> void: ...

class VertexArrayObject:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VertexArrayObject) -> None: ...
    def assign(self) -> VertexArrayObject: ...
    @overload
    def bind(self) -> None: ...
    @overload
    def bind() -> void: ...
    @overload
    def bufferId(self) -> int: ...
    @overload
    def bufferId() -> unsignedint: ...
    @overload
    def createOnce(self) -> None: ...
    @overload
    def createOnce() -> void: ...
    @overload
    def destroy(self) -> None: ...
    @overload
    def destroy() -> void: ...
    @overload
    def isCreated(self) -> bool: ...
    @overload
    def isCreated() -> bool: ...
    @overload
    def release(self) -> None: ...
    @overload
    def release() -> void: ...

class Viewport(mrpt.pymrpt.mrpt.serialization.CSerializable, mrpt.pymrpt.mrpt.system.CObservable, CTextMessageCapable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0) -> None: ...
    @overload
    def __init__(self, parent, name: str) -> None: ...
    @overload
    def __init__(self, arg0: Viewport) -> None: ...
    @overload
    def __init__(self, arg0: Viewport) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> Viewport: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def enablePolygonNicest(self) -> None: ...
    @overload
    def enablePolygonNicest(self, enable: bool) -> None: ...
    @overload
    def enablePolygonNicest(bool) -> void: ...
    @overload
    def enableShadowCasting(self) -> None: ...
    @overload
    def enableShadowCasting(self, enabled: bool) -> None: ...
    @overload
    def enableShadowCasting(self, enabled: bool, SHADOW_MAP_SIZE_X: int) -> None: ...
    @overload
    def enableShadowCasting(self, enabled: bool, SHADOW_MAP_SIZE_X: int, SHADOW_MAP_SIZE_Y: int) -> None: ...
    @overload
    def get3DRayForPixelCoord(self, x_coord: float, y_coord: float, out_ray) -> None: ...
    @overload
    def get3DRayForPixelCoord(self, x_coord: float, y_coord: float, out_ray, out_cameraPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    def getBorderColor(self) -> mrpt.pymrpt.mrpt.img.TColor: ...
    @overload
    def getBorderSize(self) -> int: ...
    @overload
    def getBorderSize() -> unsignedint: ...
    def getBoundingBox(self) -> mrpt.pymrpt.mrpt.math.TBoundingBox_double_t: ...
    def getByName(self, str: str) -> CRenderizable: ...
    def getCamera(self) -> CCamera: ...
    @overload
    def getCurrentCameraPose(self, out_cameraPose: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def getCurrentCameraPose(classmrpt) -> void: ...
    @overload
    def getCurrentCameraPose(self) -> mrpt.pymrpt.mrpt.poses.CPose3D: ...
    def getCustomBackgroundColor(self) -> mrpt.pymrpt.mrpt.img.TColorf: ...
    def getLightShadowClipDistances(self, clip_min: float, clip_max: float) -> None: ...
    def getName(self) -> str: ...
    def getRenderMatrices(self) -> TRenderMatrices: ...
    def getViewportClipDistances(self, clip_min: float, clip_max: float) -> None: ...
    def getViewportPosition(self, *args, **kwargs) -> Any: ...
    @overload
    def getViewportVisibility(self) -> bool: ...
    @overload
    def getViewportVisibility() -> bool: ...
    def insert(self, *args, **kwargs) -> Any: ...
    @overload
    def isImageViewMode(self) -> bool: ...
    @overload
    def isImageViewMode() -> bool: ...
    @overload
    def isPolygonNicestEnabled(self) -> bool: ...
    @overload
    def isPolygonNicestEnabled() -> bool: ...
    @overload
    def isShadowCastingEnabled(self) -> bool: ...
    @overload
    def isShadowCastingEnabled() -> bool: ...
    @overload
    def isTransparent(self) -> bool: ...
    @overload
    def isTransparent() -> bool: ...
    def lightParameters(self) -> TLightParameters: ...
    @overload
    def loadDefaultShaders(self) -> None: ...
    @overload
    def loadDefaultShaders() -> void: ...
    @overload
    def removeObject(self, obj: CRenderizable) -> None: ...
    @overload
    def removeObject(constclassstd) -> void: ...
    @overload
    def render(self, render_width: int, render_height: int) -> None: ...
    @overload
    def render(self, render_width: int, render_height: int, render_offset_x: int) -> None: ...
    @overload
    def render(self, render_width: int, render_height: int, render_offset_x: int, render_offset_y: int) -> None: ...
    @overload
    def render(self, render_width: int, render_height: int, render_offset_x: int, render_offset_y: int, forceThisCamera: CCamera) -> None: ...
    @overload
    def resetCloneView(self) -> None: ...
    @overload
    def resetCloneView() -> void: ...
    @overload
    def setBorderColor(self, c: mrpt.pymrpt.mrpt.img.TColor) -> None: ...
    @overload
    def setBorderColor(conststructmrpt) -> void: ...
    @overload
    def setBorderSize(self, lineWidth: int) -> None: ...
    @overload
    def setBorderSize(unsignedint) -> void: ...
    @overload
    def setCloneCamera(self, enable: bool) -> None: ...
    @overload
    def setCloneCamera(bool) -> void: ...
    @overload
    def setCloneView(self, clonedViewport: str) -> None: ...
    @overload
    def setCloneView(conststd) -> void: ...
    @overload
    def setClonedCameraFrom(self, viewPortName: str) -> None: ...
    @overload
    def setClonedCameraFrom(conststd) -> void: ...
    @overload
    def setCurrentCameraFromPose(self, p: mrpt.pymrpt.mrpt.poses.CPose3D) -> None: ...
    @overload
    def setCurrentCameraFromPose(classmrpt) -> void: ...
    @overload
    def setCustomBackgroundColor(self, color: mrpt.pymrpt.mrpt.img.TColorf) -> None: ...
    @overload
    def setCustomBackgroundColor(conststructmrpt) -> void: ...
    @overload
    def setImageView(self, img: mrpt.pymrpt.mrpt.img.CImage) -> None: ...
    @overload
    def setImageView(self, img: mrpt.pymrpt.mrpt.img.CImage, transparentBackground: bool) -> None: ...
    @overload
    def setImageView(constclassmrpt, bool) -> void: ...
    def setLightShadowClipDistances(self, clip_min: float, clip_max: float) -> None: ...
    @overload
    def setNormalMode(self) -> None: ...
    @overload
    def setNormalMode() -> void: ...
    @overload
    def setTransparent(self, trans: bool) -> None: ...
    @overload
    def setTransparent(bool) -> void: ...
    def setViewportClipDistances(self, clip_min: float, clip_max: float) -> None: ...
    def setViewportPosition(self, *args, **kwargs) -> Any: ...
    @overload
    def setViewportVisibility(self, visible: bool) -> None: ...
    @overload
    def setViewportVisibility(bool) -> void: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> size_t: ...
    @overload
    def updateMatricesFromCamera(self, myCamera: CCamera) -> None: ...
    @overload
    def updateMatricesFromCamera(constclassmrpt) -> void: ...

class Visualizable:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Visualizable) -> None: ...
    def assign(self) -> Visualizable: ...
    def getVisualization(self, *args, **kwargs) -> Any: ...
    @overload
    def getVisualizationInto(self, o) -> None: ...
    @overload
    def getVisualizationInto(classmrpt) -> void: ...

class mrptEventGLPostRender(mrpt.pymrpt.mrpt.system.mrptEvent):
    def __init__(self, obj: Viewport) -> None: ...

class mrptEventGLPreRender(mrpt.pymrpt.mrpt.system.mrptEvent):
    def __init__(self, obj: Viewport) -> None: ...

class predefined_voxel_sets_t:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    VOXEL_SET_FREESPACE: ClassVar[predefined_voxel_sets_t] = ...
    VOXEL_SET_OCCUPIED: ClassVar[predefined_voxel_sets_t] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class texture_name_unit_t:
    name: int
    unit: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Name: int) -> None: ...
    @overload
    def __init__(self, Name: int, Unit: int) -> None: ...
    @overload
    def __init__(self, arg0: texture_name_unit_t) -> None: ...
    def assign(self) -> texture_name_unit_t: ...

def depthAndVisibleInView(obj, objState: TRenderMatrices, skipCullChecks: bool) -> Tuple[float,bool,bool]: ...
@overload
def getNewTextureNumber() -> int: ...
@overload
def getNewTextureNumber() -> unsignedint: ...
def releaseTextureName(t: int) -> None: ...
