# 2023-04-04 Triage Log

A large improvement in const evaluation (particularly for large types) in
[#109670](https://github.com/rust-lang/rust/pull/109670) and a large
improvement to many-paged rustdoc workloads in
[#109876](https://github.com/rust-lang/rust/pull/109876) by removing quadratic
behavior. Regressions are comparatively limited this week.

Triage done by **@simulacrum**.
Revision range: [cbc064b341be231403d181402a786cce7f1c73f1..7c96e40da81165beef4f273f44e96eeef5a1bd30](https://perf.rust-lang.org/?start=cbc064b341be231403d181402a786cce7f1c73f1&end=7c96e40da81165beef4f273f44e96eeef5a1bd30&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.3%  | [0.4%, 8.4%]    | 18    |
| Regressions ❌ <br /> (secondary)  | 1.6%  | [0.3%, 10.7%]   | 26    |
| Improvements ✅ <br /> (primary)   | -2.5% | [-77.6%, -0.3%] | 63    |
| Improvements ✅ <br /> (secondary) | -4.0% | [-27.9%, -0.3%] | 52    |
| All ❌✅ (primary)                 | -1.4% | [-77.6%, 8.4%]  | 81    |


1 Regressions, 4 Improvements, 3 Mixed; 2 of them in rollups
54 artifact comparisons made in total

#### Regressions

Insert alignment checks for pointer dereferences when debug assertions are enabled [#98112](https://github.com/rust-lang/rust/pull/98112) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ec7bb8da11f3e5cc73be397b78d2aea4157df300&end=22a7a19f9333bc1fcba97ce444a3515cb5fb33e6&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.4%, 0.5%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.4%, 0.5%] | 3     |

#### Improvements

Rollup of 6 pull requests [#109714](https://github.com/rust-lang/rust/pull/109714) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=acd27bb5572553a4dc9a2d6f21d9a3a68ff8a233&end=40cd0310db7f67867b305c28fb87b5b660e77df1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.3%] | 5     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.7%, -0.3%] | 5     |


Make init mask lazy for fully initialized/uninitialized const allocations [#109670](https://github.com/rust-lang/rust/pull/109670) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cf32b9de1e8f66526c36ad2927458558d2e81093&end=86792086646b61342c9417b78b8a535392f1045f&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -     | -               | 0     |
| Improvements ✅ <br /> (secondary) | -5.1% | [-27.7%, -1.4%] | 17    |
| All ❌✅ (primary)                 | -     | -               | 0     |


Update `ty::VariantDef` to use `IndexVec<FieldIdx, FieldDef>` [#109762](https://github.com/rust-lang/rust/pull/109762) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=276029deae08ad5b62f7d1ef2ea1acb7f5f529d8&end=eb3e9c1f45981b47160543cfd882ca00e69bbfab&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.5%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.5% | [-0.6%, -0.5%] | 3     |


rustdoc: make intra-doc link pass non-quadratic for repeated links [#109876](https://github.com/rust-lang/rust/pull/109876) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cf7ada217c8ac63367b184afd9fffaff30f6ed44&end=eb48e9771a924080a2a7a87b403278e61f3061ea&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -      | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -      | -               | 0     |
| Improvements ✅ <br /> (primary)   | -11.8% | [-77.7%, -0.6%] | 8     |
| Improvements ✅ <br /> (secondary) | -3.6%  | [-3.6%, -3.6%]  | 1     |
| All ❌✅ (primary)                 | -11.8% | [-77.7%, -0.6%] | 8     |


#### Mixed

Add a builtin `FnPtr` trait that is implemented for all function pointers [#108080](https://github.com/rust-lang/rust/pull/108080) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=60660371efe59dfc99644e9d709a1b71e25ae2ac&end=bf57e8ada6dc62369d1cee7ab055fb4074bd2d10&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.2%  | [1.1%, 5.5%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.3%, 1.1%]   | 5     |
| Improvements ✅ <br /> (primary)   | -1.8% | [-7.3%, -0.3%] | 17    |
| Improvements ✅ <br /> (secondary) | -4.0% | [-7.5%, -0.4%] | 27    |
| All ❌✅ (primary)                 | 0.1%  | [-7.3%, 5.5%]  | 27    |


Rollup of 8 pull requests [#109692](https://github.com/rust-lang/rust/pull/109692) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bf57e8ada6dc62369d1cee7ab055fb4074bd2d10&end=478cbb42b730ba4739351b72ce2aa928e78e2f81&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.2%, 9.2%]   | 31    |
| Regressions ❌ <br /> (secondary)  | 1.7%  | [0.2%, 10.9%]  | 25    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.6%, -0.5%] | 5     |
| All ❌✅ (primary)                 | 0.9%  | [0.2%, 9.2%]   | 31    |


numeric vars can only be unified with numerical types in deep reject [#109750](https://github.com/rust-lang/rust/pull/109750) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c1d3610ac1ddd1cd605479274047fd0a3f37d220&end=276029deae08ad5b62f7d1ef2ea1acb7f5f529d8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 8     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.8%, -0.2%] | 44    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.5%, -0.2%] | 3     |
| All ❌✅ (primary)                 | -0.6% | [-1.8%, 0.6%]  | 47    |
