/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.editor.EditorBeanGroup;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanField;
import ancestris.modules.releve.model.BeanGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class EditorConfigGroupDialog {
    private static final ArrayList<EditorConfigListener> editorConfigListeners = new ArrayList(1);

    public static void showEditorConfigGroupDialog(AbstractRecord.RecordType recordType, BeanGroup group, MouseEvent evt) {
        JPopupMenu popup = new JPopupMenu();
        for (BeanField field : group.getFields()) {
            if (!field.isUsed()) continue;
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(field.getLabel(), field.isVisible());
            menuItem.addActionListener(new FieldActionListener(recordType, field));
            popup.add(menuItem);
        }
        popup.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    public static void addEditorConfigListener(EditorConfigListener listener) {
        editorConfigListeners.add(listener);
    }

    public static void removeEditorConfigListener(EditorConfigListener listener) {
        editorConfigListeners.remove(listener);
    }

    public static void fireEditorConfigListener(final AbstractRecord.RecordType recordType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (EditorConfigListener listener : editorConfigListeners) {
                    listener.onEditorConfigChanged(recordType);
                }
            }
        });
    }

    static class FieldActionListener
    implements ActionListener {
        private final AbstractRecord.RecordType recordType;
        private final BeanField field;

        FieldActionListener(AbstractRecord.RecordType recordType, BeanField field) {
            this.recordType = recordType;
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)evt.getSource();
            this.field.setVisible(menuItem.isSelected());
            EditorBeanGroup.savePreferences();
            EditorConfigGroupDialog.fireEditorConfigListener(this.recordType);
        }
    }

    protected static interface EditorConfigListener {
        public void onEditorConfigChanged(AbstractRecord.RecordType var1);
    }
}

