/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Property;

public class PropertyInteger
extends Property {
    private String value = "0";

    public PropertyInteger(String tag) {
        super(tag);
    }

    public PropertyInteger(String tag, String value) {
        super(tag);
        this.value = this.makeNumericValue(value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        String old = this.value;
        this.value = this.makeNumericValue(value);
        this.propagatePropertyChanged(this, old);
    }

    @Override
    public boolean isValid() {
        return this.makeNumericValue(this.value).equals(this.value);
    }

    private String makeNumericValue(String value) {
        return value.replaceAll("[^0-9]", "");
    }
}

