/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorsWidget
extends JPanel {
    private ChangeSupport changes = new ChangeSupport(this);
    private JColorChooser chooser = new JColorChooser();
    private Model model = new Model();

    public ColorsWidget() {
        super(new BorderLayout());
        this.chooser.setPreviewPanel(new JPanel());
        final JList<Object> list = new JList<Object>(this.model);
        list.setSelectionMode(0);
        list.setCellRenderer(new Renderer());
        this.add((Component)new JScrollPane(list), "Center");
        this.add((Component)this.chooser, "South");
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = list.getSelectedIndex();
                if (i >= 0) {
                    ColorsWidget.this.changes.mute();
                    try {
                        ColorsWidget.this.chooser.setColor(ColorsWidget.this.model.getItemAt((int)i).color);
                    }
                    finally {
                        ColorsWidget.this.changes.unmute();
                    }
                }
            }
        });
        this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int i = list.getSelectedIndex();
                if (i >= 0) {
                    ColorsWidget.this.model.setColor(i, ColorsWidget.this.chooser.getColor());
                    ColorsWidget.this.changes.fireChangeEvent();
                }
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.changes.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changes.removeChangeListener(listener);
    }

    public void removeAllColors() {
        this.model.clear();
    }

    public Color getColor(String key) {
        return this.model.getItem((String)key).color;
    }

    public Map<String, Color> getColors() {
        return this.model.colors();
    }

    public void addColor(String key, String name, Color color) {
        this.model.add(new Item(key, name, color));
    }

    private class Model
    extends AbstractListModel {
        private List<Item> items = new ArrayList<Item>();

        private Model() {
        }

        Map<String, Color> colors() {
            HashMap<String, Color> result = new HashMap<String, Color>();
            for (Item item : this.items) {
                result.put(item.key, item.color);
            }
            return result;
        }

        void clear() {
            int size = this.items.size();
            for (int i = size - 1; i >= 0; --i) {
                this.items.remove(i);
            }
            this.fireIntervalRemoved(this, 0, size);
        }

        void add(Item item) {
            this.items.add(item);
            this.fireIntervalAdded(this, this.items.size() - 1, this.items.size());
        }

        void setColor(int index, Color set) {
            this.getItemAt((int)index).color = set;
            this.fireContentsChanged(this, index, index);
        }

        Item getItem(String key) {
            for (Item item : this.items) {
                if (!item.key.equals(key)) continue;
                return item;
            }
            throw new IllegalArgumentException("key for unknown color");
        }

        Item getItemAt(int index) {
            return this.items.get(index);
        }

        @Override
        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }
    }

    private class Renderer
    extends DefaultListCellRenderer
    implements Icon {
        private int dim = 8;
        private Color color;

        private Renderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(2);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Item item = (Item)value;
            super.getListCellRendererComponent((JList<?>)list, item.name, index, isSelected, cellHasFocus);
            this.setIcon(this);
            this.color = item.color;
            return this;
        }

        @Override
        public int getIconHeight() {
            return this.dim;
        }

        @Override
        public int getIconWidth() {
            return this.dim;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, this.dim, this.dim);
            g.setColor(this.getForeground());
            g.drawRect(x, y, this.dim, this.dim);
        }
    }

    private class Item {
        String key;
        String name;
        Color color;

        Item(String k, String n, Color c) {
            this.key = k;
            this.name = n;
            this.color = c;
        }
    }
}

