// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

.intel_syntax noprefix
#include <AsmOffsets.inc>         // generated by the build from AsmOffsets.cpp
#include <unixasmmacros.inc>

// trick to avoid PLT relocation at runtime which corrupts registers
#define REL_C_FUNC(name) C_FUNC(name)@gotpcrel

// Cache miss case, call the runtime to resolve the target and update the cache.
// Use universal transition helper to allow an exception to flow out of resolution
LEAF_ENTRY RhpInterfaceDispatchSlow, _TEXT
        // r11 contains indirection cell address already, so it will naturally be passed to RhpCidResolve
        // the universal transition thunk as an argument to RhpCidResolve
        mov r10, [rip + REL_C_FUNC(RhpCidResolve)]
        jmp qword ptr [rip + REL_C_FUNC(RhpUniversalTransition_DebugStepTailCall)]

LEAF_END RhpInterfaceDispatchSlow, _TEXT
