/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmspecglob.h
 * \date 19/07/2025
 * \author Olivier Langella
 * \brief compute specglob alignment on scan's PSM
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "../psmfilescanprocessandcopy.h"
#include <QJsonObject>
#include "pappsomspp/export-import-config.h"

namespace pappso::cbor::psm
{

class PsmSpecGlobScan;
/**
 * @todo write docs
 */
class PMSPP_LIB_DECL PsmSpecGlob : public PsmFileScanProcessAndCopy
{
  friend PsmSpecGlobScan;

  public:
  /**
   * Default constructor
   */
  PsmSpecGlob(std::size_t buffer_scan_size,
              CborStreamWriter *cbor_output_p,
              const QJsonObject &parameters);

  /**
   * Destructor
   */
  virtual ~PsmSpecGlob();


  void filterMassSpectrum(pappso::MassSpectrum &mass_spectrum) const;

  protected:
  pappso::cbor::psm::CborScanMapBase *newCborScanMap() override;

  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;

  virtual void processBufferScanDone(pappso::UiMonitorInterface &monitor) override;

  protected:
  QJsonObject m_specglobParameters;
  pappso::PrecisionPtr m_fragmentTolerance;
  double m_minimumMz;
  std::size_t m_nMostIntense;
  bool m_deisotope                 = true;
  bool m_isProteinMatcherResult    = false;
  std::size_t m_countScanProcessed = 0;
};

} // namespace pappso::cbor::psm
