# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AdditionalCacheNodeProperties(_model_base.Model):
    """Model representing cache node for connected cache resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar cache_node_properties_details_issues_list: issues list to return the issues as part of
     the additional cache node properties.
    :vartype cache_node_properties_details_issues_list: list[str]
    :ivar aggregated_status_details: Cache node resource aggregated status details.
    :vartype aggregated_status_details: str
    :ivar aggregated_status_text: Cache node resource aggregated status text.
    :vartype aggregated_status_text: str
    :ivar aggregated_status_code: Cache node resource aggregated status code.
    :vartype aggregated_status_code: int
    :ivar product_version: Cache node resource Mcc product version.
    :vartype product_version: str
    :ivar is_provisioned: Cache node resource flag indicating if cache node has been physically
     installed or provisioned on their physical lab.
    :vartype is_provisioned: bool
    :ivar cache_node_state_detailed_text: Cache node resource detailed state text.
    :vartype cache_node_state_detailed_text: str
    :ivar cache_node_state_short_text: Cache node resource short state text.
    :vartype cache_node_state_short_text: str
    :ivar cache_node_state: Cache node resource state as integer.
    :vartype cache_node_state: int
    :ivar drive_configuration: Cache node resource drive configurations.
    :vartype drive_configuration:
     list[~azure.mgmt.connectedcache.models.CacheNodeDriveConfiguration]
    :ivar bgp_configuration: Cache node resource Bgp configuration.
    :vartype bgp_configuration: ~azure.mgmt.connectedcache.models.BgpConfiguration
    :ivar proxy_url_configuration: proxyUrl configuration of the cache node.
    :vartype proxy_url_configuration: ~azure.mgmt.connectedcache.models.ProxyUrlConfiguration
    :ivar proxy_url: Cache node resource Mcc proxy Url.
    :vartype proxy_url: str
    :ivar is_proxy_required: Cache node resource requires a proxy. Known values are: "None" and
     "Required".
    :vartype is_proxy_required: str or ~azure.mgmt.connectedcache.models.ProxyRequired
    :ivar os_type: Operating system of the cache node. Known values are: "Windows", "Linux", and
     "Eflow".
    :vartype os_type: str or ~azure.mgmt.connectedcache.models.OsType
    :ivar update_cycle_type: Update Cycle Type. Known values are: "Preview", "Slow", and "Fast".
    :vartype update_cycle_type: str or ~azure.mgmt.connectedcache.models.CycleType
    :ivar auto_update_version: Auto update or fast update version.
    :vartype auto_update_version: str
    :ivar update_info_details: Update related information details.
    :vartype update_info_details: str
    :ivar update_requested_date_time: customer requested date time for mcc install of update cycle.
    :vartype update_requested_date_time: ~datetime.datetime
    :ivar auto_update_next_available_version: Auto update version that is the Next available
     version to update on mcc cache node.
    :vartype auto_update_next_available_version: str
    :ivar auto_update_next_available_date_time: Auto update last applied date time of mcc install.
    :vartype auto_update_next_available_date_time: ~datetime.datetime
    :ivar auto_update_applied_version: Auto update version that is the applied to update on mcc
     cache node.
    :vartype auto_update_applied_version: str
    :ivar auto_update_last_applied_details: Auto Update status details from the backend after
     applying the new version details.
    :vartype auto_update_last_applied_details: str
    :ivar auto_update_last_applied_state: Last applied auto update state for mcc install of auto
     update cycle.
    :vartype auto_update_last_applied_state: str
    :ivar auto_update_last_applied_date_time: Auto update last applied date time of mcc install.
    :vartype auto_update_last_applied_date_time: ~datetime.datetime
    :ivar auto_update_last_triggered_date_time: Auto update last triggered date time of mcc
     install.
    :vartype auto_update_last_triggered_date_time: ~datetime.datetime
    :ivar optional_property1: Optional property #1 of Mcc response object.
    :vartype optional_property1: str
    :ivar optional_property2: Optional property #2 of Mcc response object.
    :vartype optional_property2: str
    :ivar optional_property3: Optional property #3 of Mcc response object.
    :vartype optional_property3: str
    :ivar optional_property4: Optional property #4 of Mcc response object.
    :vartype optional_property4: str
    :ivar optional_property5: Optional property #5 of Mcc response object.
    :vartype optional_property5: str
    """

    cache_node_properties_details_issues_list: Optional[List[str]] = rest_field(
        name="cacheNodePropertiesDetailsIssuesList"
    )
    """issues list to return the issues as part of the additional cache node properties."""
    aggregated_status_details: Optional[str] = rest_field(name="aggregatedStatusDetails", visibility=["read"])
    """Cache node resource aggregated status details."""
    aggregated_status_text: Optional[str] = rest_field(name="aggregatedStatusText", visibility=["read"])
    """Cache node resource aggregated status text."""
    aggregated_status_code: Optional[int] = rest_field(name="aggregatedStatusCode", visibility=["read"])
    """Cache node resource aggregated status code."""
    product_version: Optional[str] = rest_field(name="productVersion", visibility=["read"])
    """Cache node resource Mcc product version."""
    is_provisioned: Optional[bool] = rest_field(name="isProvisioned", visibility=["read"])
    """Cache node resource flag indicating if cache node has been physically installed or provisioned
     on their physical lab."""
    cache_node_state_detailed_text: Optional[str] = rest_field(name="cacheNodeStateDetailedText", visibility=["read"])
    """Cache node resource detailed state text."""
    cache_node_state_short_text: Optional[str] = rest_field(name="cacheNodeStateShortText", visibility=["read"])
    """Cache node resource short state text."""
    cache_node_state: Optional[int] = rest_field(name="cacheNodeState", visibility=["read"])
    """Cache node resource state as integer."""
    drive_configuration: Optional[List["_models.CacheNodeDriveConfiguration"]] = rest_field(name="driveConfiguration")
    """Cache node resource drive configurations."""
    bgp_configuration: Optional["_models.BgpConfiguration"] = rest_field(name="bgpConfiguration")
    """Cache node resource Bgp configuration."""
    proxy_url_configuration: Optional["_models.ProxyUrlConfiguration"] = rest_field(name="proxyUrlConfiguration")
    """proxyUrl configuration of the cache node."""
    proxy_url: Optional[str] = rest_field(name="proxyUrl")
    """Cache node resource Mcc proxy Url."""
    is_proxy_required: Optional[Union[str, "_models.ProxyRequired"]] = rest_field(name="isProxyRequired")
    """Cache node resource requires a proxy. Known values are: \"None\" and \"Required\"."""
    os_type: Optional[Union[str, "_models.OsType"]] = rest_field(name="osType")
    """Operating system of the cache node. Known values are: \"Windows\", \"Linux\", and \"Eflow\"."""
    update_cycle_type: Optional[Union[str, "_models.CycleType"]] = rest_field(name="updateCycleType")
    """Update Cycle Type. Known values are: \"Preview\", \"Slow\", and \"Fast\"."""
    auto_update_version: Optional[str] = rest_field(name="autoUpdateVersion")
    """Auto update or fast update version."""
    update_info_details: Optional[str] = rest_field(name="updateInfoDetails")
    """Update related information details."""
    update_requested_date_time: Optional[datetime.datetime] = rest_field(
        name="updateRequestedDateTime", format="rfc3339"
    )
    """customer requested date time for mcc install of update cycle."""
    auto_update_next_available_version: Optional[str] = rest_field(
        name="autoUpdateNextAvailableVersion", visibility=["read"]
    )
    """Auto update version that is the Next available version to update on mcc cache node."""
    auto_update_next_available_date_time: Optional[datetime.datetime] = rest_field(
        name="autoUpdateNextAvailableDateTime", visibility=["read"], format="rfc3339"
    )
    """Auto update last applied date time of mcc install."""
    auto_update_applied_version: Optional[str] = rest_field(name="autoUpdateAppliedVersion", visibility=["read"])
    """Auto update version that is the applied to update on mcc cache node."""
    auto_update_last_applied_details: Optional[str] = rest_field(
        name="autoUpdateLastAppliedDetails", visibility=["read"]
    )
    """Auto Update status details from the backend after applying the new version details."""
    auto_update_last_applied_state: Optional[str] = rest_field(name="autoUpdateLastAppliedState", visibility=["read"])
    """Last applied auto update state for mcc install of auto update cycle."""
    auto_update_last_applied_date_time: Optional[datetime.datetime] = rest_field(
        name="autoUpdateLastAppliedDateTime", visibility=["read"], format="rfc3339"
    )
    """Auto update last applied date time of mcc install."""
    auto_update_last_triggered_date_time: Optional[datetime.datetime] = rest_field(
        name="autoUpdateLastTriggeredDateTime", visibility=["read"], format="rfc3339"
    )
    """Auto update last triggered date time of mcc install."""
    optional_property1: Optional[str] = rest_field(name="optionalProperty1")
    """Optional property #1 of Mcc response object."""
    optional_property2: Optional[str] = rest_field(name="optionalProperty2")
    """Optional property #2 of Mcc response object."""
    optional_property3: Optional[str] = rest_field(name="optionalProperty3")
    """Optional property #3 of Mcc response object."""
    optional_property4: Optional[str] = rest_field(name="optionalProperty4")
    """Optional property #4 of Mcc response object."""
    optional_property5: Optional[str] = rest_field(name="optionalProperty5")
    """Optional property #5 of Mcc response object."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        cache_node_properties_details_issues_list: Optional[List[str]] = None,
        drive_configuration: Optional[List["_models.CacheNodeDriveConfiguration"]] = None,
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        proxy_url_configuration: Optional["_models.ProxyUrlConfiguration"] = None,
        proxy_url: Optional[str] = None,
        is_proxy_required: Optional[Union[str, "_models.ProxyRequired"]] = None,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
        update_cycle_type: Optional[Union[str, "_models.CycleType"]] = None,
        auto_update_version: Optional[str] = None,
        update_info_details: Optional[str] = None,
        update_requested_date_time: Optional[datetime.datetime] = None,
        optional_property1: Optional[str] = None,
        optional_property2: Optional[str] = None,
        optional_property3: Optional[str] = None,
        optional_property4: Optional[str] = None,
        optional_property5: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdditionalCustomerProperties(_model_base.Model):
    """Model representing customer for connected cache resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar peering_db_last_update_time: Customer resource last PeeringDB update timestamp.
    :vartype peering_db_last_update_time: ~datetime.datetime
    :ivar customer_properties_overview_cache_efficiency: Customer resource cache efficiency.
    :vartype customer_properties_overview_cache_efficiency: float
    :ivar customer_properties_overview_average_egress_mbps: Customer resource average egress in
     Mbps.
    :vartype customer_properties_overview_average_egress_mbps: float
    :ivar customer_properties_overview_average_miss_mbps: Customer resource average cache miss
     throughput in Mbps.
    :vartype customer_properties_overview_average_miss_mbps: float
    :ivar customer_properties_overview_egress_mbps_max: Customer resource maximum egress in Mbps.
    :vartype customer_properties_overview_egress_mbps_max: float
    :ivar customer_properties_overview_egress_mbps_max_date_time: Customer resource peak egress
     timestamp.
    :vartype customer_properties_overview_egress_mbps_max_date_time: ~datetime.datetime
    :ivar customer_properties_overview_miss_mbps_max: Customer resource maximum cache miss
     throughput in Mbps.
    :vartype customer_properties_overview_miss_mbps_max: float
    :ivar customer_properties_overview_miss_mbps_max_date_time: Customer resource peak cache miss
     throughput timestamp.
    :vartype customer_properties_overview_miss_mbps_max_date_time: ~datetime.datetime
    :ivar customer_properties_overview_cache_nodes_healthy_count: Customer resource total healthy
     cache nodes.
    :vartype customer_properties_overview_cache_nodes_healthy_count: int
    :ivar customer_properties_overview_cache_nodes_unhealthy_count: Customer resource total
     unhealthy cache nodes.
    :vartype customer_properties_overview_cache_nodes_unhealthy_count: int
    :ivar signup_status: Customer resource signup status as boolean.
    :vartype signup_status: bool
    :ivar signup_status_code: Customer resource signup status as integer code.
    :vartype signup_status_code: int
    :ivar signup_status_text: Customer resource signup status as string text.
    :vartype signup_status_text: str
    :ivar signup_phase_status_code: Customer resource signup phase status code as integer.
    :vartype signup_phase_status_code: int
    :ivar signup_phase_status_text: Customer resource signup phase status as string text.
    :vartype signup_phase_status_text: str
    :ivar peering_db_last_update_date: Customer resource last PeeringDB update timestamp.
    :vartype peering_db_last_update_date: ~datetime.datetime
    :ivar customer_org_name: Customer resource owner organization name.
    :vartype customer_org_name: str
    :ivar customer_email: Customer resource contact email.
    :vartype customer_email: str
    :ivar customer_transit_asn: Customer resource transit Asn (autonomous system number).
    :vartype customer_transit_asn: str
    :ivar customer_transit_state: Customer resource transit state. Known values are: "NoTransit",
     "CombinedTransit", and "TransitOnly".
    :vartype customer_transit_state: str or ~azure.mgmt.connectedcache.models.CustomerTransitState
    :ivar customer_asn: Customer resource Asn (autonomous system number).
    :vartype customer_asn: str
    :ivar customer_asn_estimated_egress_peek_gbps: Customer resource estimated Asn peering peak in
     Gbps.
    :vartype customer_asn_estimated_egress_peek_gbps: float
    :ivar customer_entitlement_sku_id: Customer resource entitlement Sku Id.
    :vartype customer_entitlement_sku_id: str
    :ivar customer_entitlement_sku_guid: Customer resource entitlement Sku Guid.
    :vartype customer_entitlement_sku_guid: str
    :ivar customer_entitlement_sku_name: Customer resource entitlement Sku name.
    :vartype customer_entitlement_sku_name: str
    :ivar customer_entitlement_expiration: Customer resource entitlement expiration date string.
    :vartype customer_entitlement_expiration: ~datetime.datetime
    :ivar optional_property1: Optional property #1 of Mcc response object.
    :vartype optional_property1: str
    :ivar optional_property2: Optional property #2 of Mcc response object.
    :vartype optional_property2: str
    :ivar optional_property3: Optional property #3 of Mcc response object.
    :vartype optional_property3: str
    :ivar optional_property4: Optional property #4 of Mcc response object.
    :vartype optional_property4: str
    :ivar optional_property5: Optional property #5 of Mcc response object.
    :vartype optional_property5: str
    """

    peering_db_last_update_time: Optional[datetime.datetime] = rest_field(
        name="peeringDbLastUpdateTime", visibility=["read"], format="rfc3339"
    )
    """Customer resource last PeeringDB update timestamp."""
    customer_properties_overview_cache_efficiency: Optional[float] = rest_field(
        name="customerPropertiesOverviewCacheEfficiency", visibility=["read"]
    )
    """Customer resource cache efficiency."""
    customer_properties_overview_average_egress_mbps: Optional[float] = rest_field(
        name="customerPropertiesOverviewAverageEgressMbps", visibility=["read"]
    )
    """Customer resource average egress in Mbps."""
    customer_properties_overview_average_miss_mbps: Optional[float] = rest_field(
        name="customerPropertiesOverviewAverageMissMbps", visibility=["read"]
    )
    """Customer resource average cache miss throughput in Mbps."""
    customer_properties_overview_egress_mbps_max: Optional[float] = rest_field(
        name="customerPropertiesOverviewEgressMbpsMax", visibility=["read"]
    )
    """Customer resource maximum egress in Mbps."""
    customer_properties_overview_egress_mbps_max_date_time: Optional[datetime.datetime] = rest_field(
        name="customerPropertiesOverviewEgressMbpsMaxDateTime", visibility=["read"], format="rfc3339"
    )
    """Customer resource peak egress timestamp."""
    customer_properties_overview_miss_mbps_max: Optional[float] = rest_field(
        name="customerPropertiesOverviewMissMbpsMax", visibility=["read"]
    )
    """Customer resource maximum cache miss throughput in Mbps."""
    customer_properties_overview_miss_mbps_max_date_time: Optional[datetime.datetime] = rest_field(
        name="customerPropertiesOverviewMissMbpsMaxDateTime", visibility=["read"], format="rfc3339"
    )
    """Customer resource peak cache miss throughput timestamp."""
    customer_properties_overview_cache_nodes_healthy_count: Optional[int] = rest_field(
        name="customerPropertiesOverviewCacheNodesHealthyCount", visibility=["read"]
    )
    """Customer resource total healthy cache nodes."""
    customer_properties_overview_cache_nodes_unhealthy_count: Optional[int] = rest_field(
        name="customerPropertiesOverviewCacheNodesUnhealthyCount", visibility=["read"]
    )
    """Customer resource total unhealthy cache nodes."""
    signup_status: Optional[bool] = rest_field(name="signupStatus", visibility=["read"])
    """Customer resource signup status as boolean."""
    signup_status_code: Optional[int] = rest_field(name="signupStatusCode", visibility=["read"])
    """Customer resource signup status as integer code."""
    signup_status_text: Optional[str] = rest_field(name="signupStatusText", visibility=["read"])
    """Customer resource signup status as string text."""
    signup_phase_status_code: Optional[int] = rest_field(name="signupPhaseStatusCode", visibility=["read"])
    """Customer resource signup phase status code as integer."""
    signup_phase_status_text: Optional[str] = rest_field(name="signupPhaseStatusText", visibility=["read"])
    """Customer resource signup phase status as string text."""
    peering_db_last_update_date: Optional[datetime.datetime] = rest_field(
        name="peeringDbLastUpdateDate", visibility=["read"], format="rfc3339"
    )
    """Customer resource last PeeringDB update timestamp."""
    customer_org_name: Optional[str] = rest_field(name="customerOrgName", visibility=["read"])
    """Customer resource owner organization name."""
    customer_email: Optional[str] = rest_field(name="customerEmail")
    """Customer resource contact email."""
    customer_transit_asn: Optional[str] = rest_field(name="customerTransitAsn")
    """Customer resource transit Asn (autonomous system number)."""
    customer_transit_state: Optional[Union[str, "_models.CustomerTransitState"]] = rest_field(
        name="customerTransitState"
    )
    """Customer resource transit state. Known values are: \"NoTransit\", \"CombinedTransit\", and
     \"TransitOnly\"."""
    customer_asn: Optional[str] = rest_field(name="customerAsn")
    """Customer resource Asn (autonomous system number)."""
    customer_asn_estimated_egress_peek_gbps: Optional[float] = rest_field(
        name="customerAsnEstimatedEgressPeekGbps", visibility=["read"]
    )
    """Customer resource estimated Asn peering peak in Gbps."""
    customer_entitlement_sku_id: Optional[str] = rest_field(name="customerEntitlementSkuId")
    """Customer resource entitlement Sku Id."""
    customer_entitlement_sku_guid: Optional[str] = rest_field(name="customerEntitlementSkuGuid")
    """Customer resource entitlement Sku Guid."""
    customer_entitlement_sku_name: Optional[str] = rest_field(name="customerEntitlementSkuName")
    """Customer resource entitlement Sku name."""
    customer_entitlement_expiration: Optional[datetime.datetime] = rest_field(
        name="customerEntitlementExpiration", format="rfc3339"
    )
    """Customer resource entitlement expiration date string."""
    optional_property1: Optional[str] = rest_field(name="optionalProperty1")
    """Optional property #1 of Mcc response object."""
    optional_property2: Optional[str] = rest_field(name="optionalProperty2")
    """Optional property #2 of Mcc response object."""
    optional_property3: Optional[str] = rest_field(name="optionalProperty3")
    """Optional property #3 of Mcc response object."""
    optional_property4: Optional[str] = rest_field(name="optionalProperty4")
    """Optional property #4 of Mcc response object."""
    optional_property5: Optional[str] = rest_field(name="optionalProperty5")
    """Optional property #5 of Mcc response object."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        customer_email: Optional[str] = None,
        customer_transit_asn: Optional[str] = None,
        customer_transit_state: Optional[Union[str, "_models.CustomerTransitState"]] = None,
        customer_asn: Optional[str] = None,
        customer_entitlement_sku_id: Optional[str] = None,
        customer_entitlement_sku_guid: Optional[str] = None,
        customer_entitlement_sku_name: Optional[str] = None,
        customer_entitlement_expiration: Optional[datetime.datetime] = None,
        optional_property1: Optional[str] = None,
        optional_property2: Optional[str] = None,
        optional_property3: Optional[str] = None,
        optional_property4: Optional[str] = None,
        optional_property5: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BgpCidrsConfiguration(_model_base.Model):
    """Mcc cache node Bgp Cidr details.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar bgp_cidrs: Mcc cache node Bgp Cidr details.
    :vartype bgp_cidrs: list[str]
    """

    bgp_cidrs: Optional[List[str]] = rest_field(name="bgpCidrs", visibility=["read"])
    """Mcc cache node Bgp Cidr details."""


class BgpConfiguration(_model_base.Model):
    """Bgp configuration of cache node.

    :ivar asn_to_ip_address_mapping: Asn to ip address mapping.
    :vartype asn_to_ip_address_mapping: str
    """

    asn_to_ip_address_mapping: Optional[str] = rest_field(name="asnToIpAddressMapping")
    """Asn to ip address mapping."""

    @overload
    def __init__(
        self,
        *,
        asn_to_ip_address_mapping: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeDriveConfiguration(_model_base.Model):
    """Drive configuration for cache node.

    :ivar physical_path: physical path location of the folder used for caching content.
    :vartype physical_path: str
    :ivar size_in_gb: physical size of the drive used for caching content.
    :vartype size_in_gb: int
    :ivar cache_number: corresponding nginx cache number. Valid cache numbers are 1 - 20.
    :vartype cache_number: int
    :ivar nginx_mapping: full binding for corresponding nginx cache drive.
    :vartype nginx_mapping: str
    """

    physical_path: Optional[str] = rest_field(name="physicalPath")
    """physical path location of the folder used for caching content."""
    size_in_gb: Optional[int] = rest_field(name="sizeInGb")
    """physical size of the drive used for caching content."""
    cache_number: Optional[int] = rest_field(name="cacheNumber")
    """corresponding nginx cache number. Valid cache numbers are 1 - 20."""
    nginx_mapping: Optional[str] = rest_field(name="nginxMapping")
    """full binding for corresponding nginx cache drive."""

    @overload
    def __init__(
        self,
        *,
        physical_path: Optional[str] = None,
        size_in_gb: Optional[int] = None,
        cache_number: Optional[int] = None,
        nginx_mapping: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeEntity(_model_base.Model):
    """Model representing Cache Node for ConnectedCache resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar fully_qualified_resource_id: Cache node resource Azure fully qualified resource Id.
    :vartype fully_qualified_resource_id: str
    :ivar customer_id: Cache node resource customer resource GUID Id.
    :vartype customer_id: str
    :ivar customer_name: Cache node resource customer resource name.
    :vartype customer_name: str
    :ivar ip_address: Cache node resource Ip address.
    :vartype ip_address: str
    :ivar customer_index: Cache node resource customer index as string.
    :vartype customer_index: str
    :ivar cache_node_id: Cache node resource identifier of the cache node.
    :vartype cache_node_id: str
    :ivar cache_node_name: Cache node resource name.
    :vartype cache_node_name: str
    :ivar customer_asn: Cache node resource customer resource Asn (autonomous system number).
    :vartype customer_asn: int
    :ivar is_enabled: Cache node resource flag for indicating if cache node is enabled.
    :vartype is_enabled: bool
    :ivar max_allowable_egress_in_mbps: Cache node resource maximum allowed egress in Mbps.
    :vartype max_allowable_egress_in_mbps: int
    :ivar max_allowable_probability: Cache node resource maximum allowed probability of egress.
    :vartype max_allowable_probability: float
    :ivar x_cid: Cache node resource Azure XCid.
    :vartype x_cid: str
    :ivar is_enterprise_managed: Cache node resource flag for determining if managed by enterprise
     as boolean.
    :vartype is_enterprise_managed: bool
    :ivar create_async_operation_id: Cache node resource create async operation Id.
    :vartype create_async_operation_id: str
    :ivar delete_async_operation_id: Cache node resource deletion async operation Id.
    :vartype delete_async_operation_id: str
    :ivar client_tenant_id: Cache node resource customer resource client tenant Id of subscription.
    :vartype client_tenant_id: str
    :ivar category: Cache node resource category.
    :vartype category: str
    :ivar release_version: Cache node resource release version.
    :vartype release_version: int
    :ivar last_sync_with_azure_timestamp: Cache node resource last sync timestamp.
    :vartype last_sync_with_azure_timestamp: ~datetime.datetime
    :ivar last_updated_timestamp: Cache node resource last backend updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar synch_with_azure_attempts_count: Cache node resource attempts to sync with Azure.
    :vartype synch_with_azure_attempts_count: int
    :ivar container_configurations: Cache node resource container configuration details.
    :vartype container_configurations: str
    :ivar cidr_csv: Cache node resource comma separated values of Cidrs.
    :vartype cidr_csv: list[str]
    :ivar cidr_csv_last_update_time: Cache node resource last Cidr Csv update timestamp.
    :vartype cidr_csv_last_update_time: ~datetime.datetime
    :ivar bgp_cidr_csv_last_update_time: Cache node resource last Bgp Cidr Csv update timestamp.
    :vartype bgp_cidr_csv_last_update_time: ~datetime.datetime
    :ivar bgp_last_reported_time: Cache node resource last Bgp report timestamp.
    :vartype bgp_last_reported_time: ~datetime.datetime
    :ivar bgp_review_state_text: Cache node resource Bgp review state string text in detail.
    :vartype bgp_review_state_text: str
    :ivar bgp_review_state: Cache node resource Bgp review state string text. Known values are:
     "NotConfigured", "InReview", "Approved", and "AttentionRequired".
    :vartype bgp_review_state: str or ~azure.mgmt.connectedcache.models.BgpReviewStateEnum
    :ivar bgp_review_feedback: Cache node resource Bgp review feedback text.
    :vartype bgp_review_feedback: str
    :ivar bgp_number_of_times_updated: Cache node resource Bgp update count.
    :vartype bgp_number_of_times_updated: int
    :ivar bgp_number_of_records: Cache node resource Bgp record count.
    :vartype bgp_number_of_records: int
    :ivar bgp_cidr_blocks_count: Cache node resource Bgp block count.
    :vartype bgp_cidr_blocks_count: int
    :ivar bgp_address_space: Cache node resource total addressable space defined by Bgp and Cidr
     Csv blocks.
    :vartype bgp_address_space: int
    :ivar should_migrate: Cache node resource flag for determining if customer will be migrated.
    :vartype should_migrate: bool
    :ivar bgp_file_bytes_truncated: Cache node resource bytes truncated from Bgp output file.
    :vartype bgp_file_bytes_truncated: int
    :ivar cidr_selection_type: Cache node resource current Cidr range precedence selection type.
    :vartype cidr_selection_type: int
    :ivar is_frozen: Cache node resource flag for indicating the cache node resource is frozen (not
     selectable, not editable in UI).
    :vartype is_frozen: bool
    :ivar review_state: Cache node resource review process state as integer.
    :vartype review_state: int
    :ivar review_state_text: Cache node resource review state text.
    :vartype review_state_text: str
    :ivar review_feedback: Cache node resource review feedback text.
    :vartype review_feedback: str
    :ivar configuration_state: Cache node resource configuration state. Known values are:
     "Configured" and "NotConfigured_Ip".
    :vartype configuration_state: str or ~azure.mgmt.connectedcache.models.ConfigurationState
    :ivar configuration_state_text: Cache node resource configuration state text.
    :vartype configuration_state_text: str
    :ivar address_space: Cache node resource total addressable space defined by the Cidr Csv block.
    :vartype address_space: int
    :ivar worker_connections: Cache node resource Mcc container deployment worker connection count.
    :vartype worker_connections: int
    :ivar worker_connections_last_updated_date_time: Cache node resource last updated Mcc container
     deployment worker connection count timestamp.
    :vartype worker_connections_last_updated_date_time: ~datetime.datetime
    :ivar container_resync_trigger: Cache node resource Mcc container configuration details re-sync
     trigger.
    :vartype container_resync_trigger: int
    :ivar image_uri: Cache node resource Mcc Container Id Uri.
    :vartype image_uri: str
    :ivar fully_qualified_domain_name: FQDN(fully qualified domain name) value of the mcc cache
     node.
    :vartype fully_qualified_domain_name: str
    :ivar auto_update_ring_type: Auto Update Ring Type which is slow or fast etc. Known values are:
     "Preview", "Slow", and "Fast".
    :vartype auto_update_ring_type: str or ~azure.mgmt.connectedcache.models.AutoUpdateRingType
    :ivar auto_update_requested_week: Customer requested week of month for mcc install of auto
     update cycle.
    :vartype auto_update_requested_week: int
    :ivar auto_update_requested_day: Customer requested day of week for mcc install of auto update
     cycle.
    :vartype auto_update_requested_day: int
    :ivar auto_update_requested_time: Customer requested time of the day for mcc install of auto
     update cycle, should be hh:mm.
    :vartype auto_update_requested_time: str
    """

    fully_qualified_resource_id: Optional[str] = rest_field(name="fullyQualifiedResourceId")
    """Cache node resource Azure fully qualified resource Id."""
    customer_id: Optional[str] = rest_field(name="customerId", visibility=["read"])
    """Cache node resource customer resource GUID Id."""
    customer_name: Optional[str] = rest_field(name="customerName")
    """Cache node resource customer resource name."""
    ip_address: Optional[str] = rest_field(name="ipAddress")
    """Cache node resource Ip address."""
    customer_index: Optional[str] = rest_field(name="customerIndex")
    """Cache node resource customer index as string."""
    cache_node_id: Optional[str] = rest_field(name="cacheNodeId")
    """Cache node resource identifier of the cache node."""
    cache_node_name: Optional[str] = rest_field(name="cacheNodeName")
    """Cache node resource name."""
    customer_asn: Optional[int] = rest_field(name="customerAsn")
    """Cache node resource customer resource Asn (autonomous system number)."""
    is_enabled: Optional[bool] = rest_field(name="isEnabled")
    """Cache node resource flag for indicating if cache node is enabled."""
    max_allowable_egress_in_mbps: Optional[int] = rest_field(name="maxAllowableEgressInMbps")
    """Cache node resource maximum allowed egress in Mbps."""
    max_allowable_probability: Optional[float] = rest_field(name="maxAllowableProbability", visibility=["read"])
    """Cache node resource maximum allowed probability of egress."""
    x_cid: Optional[str] = rest_field(name="xCid", visibility=["read"])
    """Cache node resource Azure XCid."""
    is_enterprise_managed: Optional[bool] = rest_field(name="isEnterpriseManaged")
    """Cache node resource flag for determining if managed by enterprise as boolean."""
    create_async_operation_id: Optional[str] = rest_field(name="createAsyncOperationId", visibility=["read"])
    """Cache node resource create async operation Id."""
    delete_async_operation_id: Optional[str] = rest_field(name="deleteAsyncOperationId", visibility=["read"])
    """Cache node resource deletion async operation Id."""
    client_tenant_id: Optional[str] = rest_field(name="clientTenantId", visibility=["read"])
    """Cache node resource customer resource client tenant Id of subscription."""
    category: Optional[str] = rest_field(visibility=["read"])
    """Cache node resource category."""
    release_version: Optional[int] = rest_field(name="releaseVersion", visibility=["read"])
    """Cache node resource release version."""
    last_sync_with_azure_timestamp: Optional[datetime.datetime] = rest_field(
        name="lastSyncWithAzureTimestamp", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last sync timestamp."""
    last_updated_timestamp: Optional[datetime.datetime] = rest_field(
        name="lastUpdatedTimestamp", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last backend updated timestamp."""
    synch_with_azure_attempts_count: Optional[int] = rest_field(name="synchWithAzureAttemptsCount", visibility=["read"])
    """Cache node resource attempts to sync with Azure."""
    container_configurations: Optional[str] = rest_field(name="containerConfigurations", visibility=["read"])
    """Cache node resource container configuration details."""
    cidr_csv: Optional[List[str]] = rest_field(name="cidrCsv")
    """Cache node resource comma separated values of Cidrs."""
    cidr_csv_last_update_time: Optional[datetime.datetime] = rest_field(
        name="cidrCsvLastUpdateTime", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last Cidr Csv update timestamp."""
    bgp_cidr_csv_last_update_time: Optional[datetime.datetime] = rest_field(
        name="bgpCidrCsvLastUpdateTime", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last Bgp Cidr Csv update timestamp."""
    bgp_last_reported_time: Optional[datetime.datetime] = rest_field(
        name="bgpLastReportedTime", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last Bgp report timestamp."""
    bgp_review_state_text: Optional[str] = rest_field(name="bgpReviewStateText", visibility=["read"])
    """Cache node resource Bgp review state string text in detail."""
    bgp_review_state: Optional[Union[str, "_models.BgpReviewStateEnum"]] = rest_field(
        name="bgpReviewState", visibility=["read"]
    )
    """Cache node resource Bgp review state string text. Known values are: \"NotConfigured\",
     \"InReview\", \"Approved\", and \"AttentionRequired\"."""
    bgp_review_feedback: Optional[str] = rest_field(name="bgpReviewFeedback", visibility=["read"])
    """Cache node resource Bgp review feedback text."""
    bgp_number_of_times_updated: Optional[int] = rest_field(name="bgpNumberOfTimesUpdated", visibility=["read"])
    """Cache node resource Bgp update count."""
    bgp_number_of_records: Optional[int] = rest_field(name="bgpNumberOfRecords", visibility=["read"])
    """Cache node resource Bgp record count."""
    bgp_cidr_blocks_count: Optional[int] = rest_field(name="bgpCidrBlocksCount", visibility=["read"])
    """Cache node resource Bgp block count."""
    bgp_address_space: Optional[int] = rest_field(name="bgpAddressSpace", visibility=["read"])
    """Cache node resource total addressable space defined by Bgp and Cidr Csv blocks."""
    should_migrate: Optional[bool] = rest_field(name="shouldMigrate")
    """Cache node resource flag for determining if customer will be migrated."""
    bgp_file_bytes_truncated: Optional[int] = rest_field(name="bgpFileBytesTruncated", visibility=["read"])
    """Cache node resource bytes truncated from Bgp output file."""
    cidr_selection_type: Optional[int] = rest_field(name="cidrSelectionType")
    """Cache node resource current Cidr range precedence selection type."""
    is_frozen: Optional[bool] = rest_field(name="isFrozen", visibility=["read"])
    """Cache node resource flag for indicating the cache node resource is frozen (not selectable, not
     editable in UI)."""
    review_state: Optional[int] = rest_field(name="reviewState", visibility=["read"])
    """Cache node resource review process state as integer."""
    review_state_text: Optional[str] = rest_field(name="reviewStateText", visibility=["read"])
    """Cache node resource review state text."""
    review_feedback: Optional[str] = rest_field(name="reviewFeedback", visibility=["read"])
    """Cache node resource review feedback text."""
    configuration_state: Optional[Union[str, "_models.ConfigurationState"]] = rest_field(
        name="configurationState", visibility=["read"]
    )
    """Cache node resource configuration state. Known values are: \"Configured\" and
     \"NotConfigured_Ip\"."""
    configuration_state_text: Optional[str] = rest_field(name="configurationStateText", visibility=["read"])
    """Cache node resource configuration state text."""
    address_space: Optional[int] = rest_field(name="addressSpace", visibility=["read"])
    """Cache node resource total addressable space defined by the Cidr Csv block."""
    worker_connections: Optional[int] = rest_field(name="workerConnections", visibility=["read"])
    """Cache node resource Mcc container deployment worker connection count."""
    worker_connections_last_updated_date_time: Optional[datetime.datetime] = rest_field(
        name="workerConnectionsLastUpdatedDateTime", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last updated Mcc container deployment worker connection count timestamp."""
    container_resync_trigger: Optional[int] = rest_field(name="containerResyncTrigger", visibility=["read"])
    """Cache node resource Mcc container configuration details re-sync trigger."""
    image_uri: Optional[str] = rest_field(name="imageUri", visibility=["read"])
    """Cache node resource Mcc Container Id Uri."""
    fully_qualified_domain_name: Optional[str] = rest_field(name="fullyQualifiedDomainName")
    """FQDN(fully qualified domain name) value of the mcc cache node."""
    auto_update_ring_type: Optional[Union[str, "_models.AutoUpdateRingType"]] = rest_field(name="autoUpdateRingType")
    """Auto Update Ring Type which is slow or fast etc. Known values are: \"Preview\", \"Slow\", and
     \"Fast\"."""
    auto_update_requested_week: Optional[int] = rest_field(name="autoUpdateRequestedWeek")
    """Customer requested week of month for mcc install of auto update cycle."""
    auto_update_requested_day: Optional[int] = rest_field(name="autoUpdateRequestedDay")
    """Customer requested day of week for mcc install of auto update cycle."""
    auto_update_requested_time: Optional[str] = rest_field(name="autoUpdateRequestedTime")
    """Customer requested time of the day for mcc install of auto update cycle, should be hh:mm."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        fully_qualified_resource_id: Optional[str] = None,
        customer_name: Optional[str] = None,
        ip_address: Optional[str] = None,
        customer_index: Optional[str] = None,
        cache_node_id: Optional[str] = None,
        cache_node_name: Optional[str] = None,
        customer_asn: Optional[int] = None,
        is_enabled: Optional[bool] = None,
        max_allowable_egress_in_mbps: Optional[int] = None,
        is_enterprise_managed: Optional[bool] = None,
        cidr_csv: Optional[List[str]] = None,
        should_migrate: Optional[bool] = None,
        cidr_selection_type: Optional[int] = None,
        fully_qualified_domain_name: Optional[str] = None,
        auto_update_ring_type: Optional[Union[str, "_models.AutoUpdateRingType"]] = None,
        auto_update_requested_week: Optional[int] = None,
        auto_update_requested_day: Optional[int] = None,
        auto_update_requested_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeInstallProperties(_model_base.Model):
    """Mcc cache node resource install script properties.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar customer_id: Mcc customer resource Id.
    :vartype customer_id: str
    :ivar cache_node_id: Mcc cache node resource Id.
    :vartype cache_node_id: str
    :ivar primary_account_key: Mcc primary account key. Internal to Mcc.
    :vartype primary_account_key: str
    :ivar secondary_account_key: Mcc secondary account key. Internal to Mcc.
    :vartype secondary_account_key: str
    :ivar registration_key: Mcc Iot Central temporary device registration key, used once.
    :vartype registration_key: str
    """

    customer_id: Optional[str] = rest_field(name="customerId")
    """Mcc customer resource Id."""
    cache_node_id: Optional[str] = rest_field(name="cacheNodeId")
    """Mcc cache node resource Id."""
    primary_account_key: Optional[str] = rest_field(name="primaryAccountKey", visibility=["read"])
    """Mcc primary account key. Internal to Mcc."""
    secondary_account_key: Optional[str] = rest_field(name="secondaryAccountKey", visibility=["read"])
    """Mcc secondary account key. Internal to Mcc."""
    registration_key: Optional[str] = rest_field(name="registrationKey", visibility=["read"])
    """Mcc Iot Central temporary device registration key, used once."""

    @overload
    def __init__(
        self,
        *,
        customer_id: Optional[str] = None,
        cache_node_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeOldResponse(_model_base.Model):
    """Model representing Cache Node for ConnectedCache resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioned state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Unknown", "Accepted", "Upgrading", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.connectedcache.models.ProvisioningState
    :ivar status_code: statusCode used to get code details of Mcc response object.
    :vartype status_code: str
    :ivar status_text: statusText used to get status details in string format of Mcc response
     object.
    :vartype status_text: str
    :ivar status_details: statusDetails used to get inner details of Mcc response object.
    :vartype status_details: str
    :ivar status: status of the HTTP error code.
    :vartype status: str
    :ivar error: The error details.
    :vartype error: ~azure.mgmt.connectedcache.models.ErrorDetail
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioned state of the resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Unknown\", \"Accepted\", \"Upgrading\", and \"Deleting\"."""
    status_code: Optional[str] = rest_field(name="statusCode")
    """statusCode used to get code details of Mcc response object."""
    status_text: Optional[str] = rest_field(name="statusText")
    """statusText used to get status details in string format of Mcc response object."""
    status_details: Optional[str] = rest_field(name="statusDetails")
    """statusDetails used to get inner details of Mcc response object."""
    status: Optional[str] = rest_field(visibility=["read"])
    """status of the HTTP error code."""
    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error details."""

    @overload
    def __init__(
        self,
        *,
        status_code: Optional[str] = None,
        status_text: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field()
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodePreviewResource(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CacheNodeOldResponse
    """

    properties: Optional["_models.CacheNodeOldResponse"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CacheNodeOldResponse"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeProperty(_model_base.Model):
    """Model representing an Mcc cache node connectedCache resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioned state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Unknown", "Accepted", "Upgrading", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.connectedcache.models.ProvisioningState
    :ivar cache_node: Mcc cache node resource (cache node entity).
    :vartype cache_node: ~azure.mgmt.connectedcache.models.CacheNodeEntity
    :ivar additional_cache_node_properties: Mcc cache node resource additional properties.
    :vartype additional_cache_node_properties:
     ~azure.mgmt.connectedcache.models.AdditionalCacheNodeProperties
    :ivar status_code: Mcc response status code.
    :vartype status_code: str
    :ivar status_text: Mcc response status text as string for retrieving status details.
    :vartype status_text: str
    :ivar status_details: Mcc response status details for retrieving response inner details.
    :vartype status_details: str
    :ivar status: HTTP error status code.
    :vartype status: str
    :ivar error: Mcc response error details.
    :vartype error: ~azure.mgmt.connectedcache.models.ErrorDetail
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioned state of the resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Unknown\", \"Accepted\", \"Upgrading\", and \"Deleting\"."""
    cache_node: Optional["_models.CacheNodeEntity"] = rest_field(name="cacheNode")
    """Mcc cache node resource (cache node entity)."""
    additional_cache_node_properties: Optional["_models.AdditionalCacheNodeProperties"] = rest_field(
        name="additionalCacheNodeProperties"
    )
    """Mcc cache node resource additional properties."""
    status_code: Optional[str] = rest_field(name="statusCode")
    """Mcc response status code."""
    status_text: Optional[str] = rest_field(name="statusText")
    """Mcc response status text as string for retrieving status details."""
    status_details: Optional[str] = rest_field(name="statusDetails")
    """Mcc response status details for retrieving response inner details."""
    status: Optional[str] = rest_field(visibility=["read"])
    """HTTP error status code."""
    error: Optional["_models.ErrorDetail"] = rest_field()
    """Mcc response error details."""

    @overload
    def __init__(
        self,
        *,
        cache_node: Optional["_models.CacheNodeEntity"] = None,
        additional_cache_node_properties: Optional["_models.AdditionalCacheNodeProperties"] = None,
        status_code: Optional[str] = None,
        status_text: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectedCachePatchResource(_model_base.Model):
    """Mcc PATCH operation properties.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "update"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomerEntity(_model_base.Model):
    """Model representing Customer resource for ConnectedCache resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar fully_qualified_resource_id: Customer resource Azure fully qualified resource Id.
    :vartype fully_qualified_resource_id: str
    :ivar customer_id: Customer resource Guid Id.
    :vartype customer_id: str
    :ivar customer_name: Customer resource name.
    :vartype customer_name: str
    :ivar contact_email: Customer resource contact email.
    :vartype contact_email: str
    :ivar contact_phone: Customer resource contact phone.
    :vartype contact_phone: str
    :ivar contact_name: Customer resource contact full name.
    :vartype contact_name: str
    :ivar is_entitled: Customer resource entitlement flag as boolean.
    :vartype is_entitled: bool
    :ivar release_version: Customer resource Mcc release version.
    :vartype release_version: int
    :ivar create_async_operation_id: Customer resource create async operation Id.
    :vartype create_async_operation_id: str
    :ivar delete_async_operation_id: Customer resource deletion async operation Id.
    :vartype delete_async_operation_id: str
    :ivar client_tenant_id: Customer resource client tenant Id of subscription.
    :vartype client_tenant_id: str
    :ivar synch_with_azure_attempts_count: Customer resource sync attempts.
    :vartype synch_with_azure_attempts_count: int
    :ivar last_sync_with_azure_timestamp: Customer resource last Azure sync timestamp.
    :vartype last_sync_with_azure_timestamp: ~datetime.datetime
    :ivar is_enterprise_managed: Customer resource flag for enterprise management as boolean.
    :vartype is_enterprise_managed: bool
    :ivar should_migrate: Customer resource flag for migration.
    :vartype should_migrate: bool
    :ivar resend_signup_code: Customer resource flag for resending signup code as boolean.
    :vartype resend_signup_code: bool
    :ivar verify_signup_code: Customer resource flag for requiring verification of signup code as
     boolean.
    :vartype verify_signup_code: bool
    :ivar verify_signup_phrase: Customer resource phrase for verifying signup.
    :vartype verify_signup_phrase: str
    """

    fully_qualified_resource_id: Optional[str] = rest_field(name="fullyQualifiedResourceId")
    """Customer resource Azure fully qualified resource Id."""
    customer_id: Optional[str] = rest_field(name="customerId", visibility=["read"])
    """Customer resource Guid Id."""
    customer_name: Optional[str] = rest_field(name="customerName")
    """Customer resource name."""
    contact_email: Optional[str] = rest_field(name="contactEmail")
    """Customer resource contact email."""
    contact_phone: Optional[str] = rest_field(name="contactPhone")
    """Customer resource contact phone."""
    contact_name: Optional[str] = rest_field(name="contactName")
    """Customer resource contact full name."""
    is_entitled: Optional[bool] = rest_field(name="isEntitled")
    """Customer resource entitlement flag as boolean."""
    release_version: Optional[int] = rest_field(name="releaseVersion")
    """Customer resource Mcc release version."""
    create_async_operation_id: Optional[str] = rest_field(name="createAsyncOperationId", visibility=["read"])
    """Customer resource create async operation Id."""
    delete_async_operation_id: Optional[str] = rest_field(name="deleteAsyncOperationId", visibility=["read"])
    """Customer resource deletion async operation Id."""
    client_tenant_id: Optional[str] = rest_field(name="clientTenantId")
    """Customer resource client tenant Id of subscription."""
    synch_with_azure_attempts_count: Optional[int] = rest_field(name="synchWithAzureAttemptsCount", visibility=["read"])
    """Customer resource sync attempts."""
    last_sync_with_azure_timestamp: Optional[datetime.datetime] = rest_field(
        name="lastSyncWithAzureTimestamp", visibility=["read"], format="rfc3339"
    )
    """Customer resource last Azure sync timestamp."""
    is_enterprise_managed: Optional[bool] = rest_field(name="isEnterpriseManaged")
    """Customer resource flag for enterprise management as boolean."""
    should_migrate: Optional[bool] = rest_field(name="shouldMigrate")
    """Customer resource flag for migration."""
    resend_signup_code: Optional[bool] = rest_field(name="resendSignupCode")
    """Customer resource flag for resending signup code as boolean."""
    verify_signup_code: Optional[bool] = rest_field(name="verifySignupCode")
    """Customer resource flag for requiring verification of signup code as boolean."""
    verify_signup_phrase: Optional[str] = rest_field(name="verifySignupPhrase", visibility=["create", "update"])
    """Customer resource phrase for verifying signup."""

    @overload
    def __init__(
        self,
        *,
        fully_qualified_resource_id: Optional[str] = None,
        customer_name: Optional[str] = None,
        contact_email: Optional[str] = None,
        contact_phone: Optional[str] = None,
        contact_name: Optional[str] = None,
        is_entitled: Optional[bool] = None,
        release_version: Optional[int] = None,
        client_tenant_id: Optional[str] = None,
        is_enterprise_managed: Optional[bool] = None,
        should_migrate: Optional[bool] = None,
        resend_signup_code: Optional[bool] = None,
        verify_signup_code: Optional[bool] = None,
        verify_signup_phrase: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomerProperty(_model_base.Model):
    """Model representing customer for connectedCache resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioned state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Unknown", "Accepted", "Upgrading", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.connectedcache.models.ProvisioningState
    :ivar customer: Mcc customer resource (customer entity).
    :vartype customer: ~azure.mgmt.connectedcache.models.CustomerEntity
    :ivar additional_customer_properties: Mcc customer resource additional properties.
    :vartype additional_customer_properties:
     ~azure.mgmt.connectedcache.models.AdditionalCustomerProperties
    :ivar status_code: Mcc response status code.
    :vartype status_code: str
    :ivar status_text: Mcc response status text as string for retrieving status details.
    :vartype status_text: str
    :ivar status_details: Mcc response status details for retrieving response inner details.
    :vartype status_details: str
    :ivar status: HTTP error status code.
    :vartype status: str
    :ivar error: Mcc response error details.
    :vartype error: ~azure.mgmt.connectedcache.models.ErrorDetail
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioned state of the resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Unknown\", \"Accepted\", \"Upgrading\", and \"Deleting\"."""
    customer: Optional["_models.CustomerEntity"] = rest_field()
    """Mcc customer resource (customer entity)."""
    additional_customer_properties: Optional["_models.AdditionalCustomerProperties"] = rest_field(
        name="additionalCustomerProperties"
    )
    """Mcc customer resource additional properties."""
    status_code: Optional[str] = rest_field(name="statusCode", visibility=["read"])
    """Mcc response status code."""
    status_text: Optional[str] = rest_field(name="statusText", visibility=["read"])
    """Mcc response status text as string for retrieving status details."""
    status_details: Optional[str] = rest_field(name="statusDetails", visibility=["read"])
    """Mcc response status details for retrieving response inner details."""
    status: Optional[str] = rest_field(visibility=["read"])
    """HTTP error status code."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read"])
    """Mcc response error details."""

    @overload
    def __init__(
        self,
        *,
        customer: Optional["_models.CustomerEntity"] = None,
        additional_customer_properties: Optional["_models.AdditionalCustomerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnterpriseMccCacheNodeResource(TrackedResource):
    """Represents the high level Nodes needed to provision cache node resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CacheNodeProperty
    """

    properties: Optional["_models.CacheNodeProperty"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CacheNodeProperty"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnterpriseMccCustomerResource(TrackedResource):
    """Represents the high level Nodes needed to provision customer resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CustomerProperty
    """

    properties: Optional["_models.CustomerProperty"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CustomerProperty"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnterprisePreviewResource(TrackedResource):
    """ConnectedCache Resource. Represents the high level Nodes needed to provision CacheNode and
    customer resources used in private preview.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CacheNodeOldResponse
    """

    properties: Optional["_models.CacheNodeOldResponse"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CacheNodeOldResponse"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.connectedcache.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.connectedcache.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.connectedcache.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IspCacheNodeResource(TrackedResource):
    """Represents the high level Nodes needed to provision cache node resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CacheNodeProperty
    """

    properties: Optional["_models.CacheNodeProperty"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CacheNodeProperty"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IspCustomerResource(TrackedResource):
    """Represents the high level Nodes needed to provision isp customer resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CustomerProperty
    """

    properties: Optional["_models.CustomerProperty"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CustomerProperty"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeBgpCidrDetails(TrackedResource):
    """Represents all Cidr details of the Bgp request for a specific cache node resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Mcc cache node resource Bgp Cidr properties.
    :vartype properties: ~azure.mgmt.connectedcache.models.BgpCidrsConfiguration
    """

    properties: Optional["_models.BgpCidrsConfiguration"] = rest_field()
    """Mcc cache node resource Bgp Cidr properties."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.BgpCidrsConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeInstallDetails(TrackedResource):
    """Mcc cache node resource all install details.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Mcc cache node resource install script details.
    :vartype properties: ~azure.mgmt.connectedcache.models.CacheNodeInstallProperties
    """

    properties: Optional["_models.CacheNodeInstallProperties"] = rest_field()
    """Mcc cache node resource install script details."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CacheNodeInstallProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.connectedcache.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.connectedcache.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.connectedcache.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class ProxyUrlConfiguration(_model_base.Model):
    """ProxyUrl configuration of cache node.

    :ivar proxy_url: Host Proxy Address configuration along with port number. This can be a proxy
     or ip address. ex: xx.xx.xx.xxxx:80 or host name http://exampleproxy.com:80.
    :vartype proxy_url: str
    """

    proxy_url: Optional[str] = rest_field(name="proxyUrl")
    """Host Proxy Address configuration along with port number. This can be a proxy or ip address. ex:
     xx.xx.xx.xxxx:80 or host name http://exampleproxy.com:80."""

    @overload
    def __init__(
        self,
        *,
        proxy_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.connectedcache.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.connectedcache.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
