# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class BillingFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The billing frequency."""

    MONTH = "Month"
    QUARTER = "Quarter"
    YEAR = "Year"


class BudgetOperatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operator to use for comparison."""

    IN = "In"


class CategoryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The category of the budget, whether the budget tracks cost or usage."""

    COST = "Cost"


class ChargeSummaryKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the kind of charge summary."""

    LEGACY = "legacy"
    MODERN = "modern"


class CultureCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Language in which the recipient will receive the notification."""

    EN_US = "en-us"
    JA_JP = "ja-jp"
    ZH_CN = "zh-cn"
    DE_DE = "de-de"
    ES_ES = "es-es"
    FR_FR = "fr-fr"
    IT_IT = "it-it"
    KO_KR = "ko-kr"
    PT_BR = "pt-br"
    RU_RU = "ru-ru"
    ZH_TW = "zh-tw"
    CS_CZ = "cs-cz"
    PL_PL = "pl-pl"
    TR_TR = "tr-tr"
    DA_DK = "da-dk"
    EN_GB = "en-gb"
    HU_HU = "hu-hu"
    NB_NO = "nb-no"
    NL_NL = "nl-nl"
    PT_PT = "pt-pt"
    SV_SE = "sv-se"


class Datagrain(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Datagrain."""

    #: Daily grain of data
    DAILY_GRAIN = "daily"
    #: Monthly grain of data
    MONTHLY_GRAIN = "monthly"


class EventType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifies the type of the event."""

    SETTLED_CHARGES = "SettledCharges"
    PENDING_CHARGES = "PendingCharges"
    PENDING_ADJUSTMENTS = "PendingAdjustments"
    PENDING_NEW_CREDIT = "PendingNewCredit"
    PENDING_EXPIRED_CREDIT = "PendingExpiredCredit"
    UN_KNOWN = "UnKnown"
    NEW_CREDIT = "NewCredit"
    CREDIT_EXPIRED = "CreditExpired"


class LookBackPeriod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LookBackPeriod."""

    #: Use 7 days of data for recommendations
    LAST07_DAYS = "Last7Days"
    #: Use 30 days of data for recommendations
    LAST30_DAYS = "Last30Days"
    #: Use 60 days of data for recommendations
    LAST60_DAYS = "Last60Days"


class LotSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The source of the lot."""

    PURCHASED_CREDIT = "PurchasedCredit"
    PROMOTIONAL_CREDIT = "PromotionalCredit"
    CONSUMPTION_COMMITMENT = "ConsumptionCommitment"


class Metrictype(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metrictype."""

    #: Actual cost data.
    ACTUAL_COST_METRIC_TYPE = "actualcost"
    #: Amortized cost data.
    AMORTIZED_COST_METRIC_TYPE = "amortizedcost"
    #: Usage data.
    USAGE_METRIC_TYPE = "usage"


class OperatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The comparison operator."""

    #: Alert will be triggered if the evaluated cost is the same as threshold value. Note: It’s not
    #: recommended to use this OperatorType as there’s low chance of cost being exactly the same as
    #: threshold value, leading to missing of your alert. This OperatorType will be deprecated in
    #: future.
    EQUAL_TO = "EqualTo"
    #: Alert will be triggered if the evaluated cost is greater than the threshold value. Note: This
    #: is the recommended OperatorType while configuring Budget Alert.
    GREATER_THAN = "GreaterThan"
    #: Alert will be triggered if the evaluated cost is greater than or equal to the threshold value.
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"


class PricingModelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifier that indicates how the meter is priced."""

    ON_DEMAND = "On Demand"
    RESERVATION = "Reservation"
    SPOT = "Spot"


class ReservationRecommendationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the kind of reservation recommendation."""

    LEGACY = "legacy"
    MODERN = "modern"


class Scope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scope."""

    SINGLE = "Single"
    SHARED = "Shared"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the lot."""

    NONE = "None"
    ACTIVE = "Active"
    INACTIVE = "Inactive"
    EXPIRED = "Expired"
    COMPLETE = "Complete"
    CANCELED = "Canceled"


class Term(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Term."""

    #: 1 year reservation term
    P1_Y = "P1Y"
    #: 3 year reservation term
    P3_Y = "P3Y"


class ThresholdType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of threshold."""

    #: Actual costs budget alerts notify when the actual accrued cost exceeds the allocated budget .
    ACTUAL = "Actual"
    #: Forecasted costs budget alerts provide advanced notification that your spending trends are
    #: likely to exceed your allocated budget, as it relies on forecasted cost predictions.
    FORECASTED = "Forecasted"


class TimeGrainType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The time covered by a budget. Tracking of the amount will be reset based on the time grain.
    BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers.
    """

    MONTHLY = "Monthly"
    QUARTERLY = "Quarterly"
    ANNUALLY = "Annually"
    BILLING_MONTH = "BillingMonth"
    BILLING_QUARTER = "BillingQuarter"
    BILLING_ANNUAL = "BillingAnnual"


class UsageDetailsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the kind of usage details."""

    LEGACY = "legacy"
    MODERN = "modern"
