---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractères, e dans l'o, o-e collés, 
              o-e entrelacé, e dans l'a, a-e entrelacé, a-e collés
---

# Comment obtenir un e dans l'o ?

L’[o-e entrelacé](wpfr:Œ) s'obtient avec la commande :

- `\oe` pour la version en minuscule ;
- `\OE` pour la version en majuscule.

Cette commande doit être suivie d'une espace (qui ne sera pas affichée, 
en application des règles usuelles de LaTeX) ou être accompagnée d'accolades afin d'isoler la commande. 
Voici un exemple d'utilisation de ces commandes avec quelques variantes sur ce point :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

\begin{document}
Tout comme sa s\oe ur, \OE dipe disait souvent : qui vole un \oe{}uf 
vole un b{\oe}uf !
\end{document}
```

De façon similaire, il existe aussi des commandes `\ae` et `\AE` pour obtenir 
le [a-e entrelacé](wpfr:Æ) ("æ" et "Æ").

Ceci dit, avec le [codage d'entrée UTF-8](/3_composition/langues/latex_et_l_utf8) 
(depuis 2018, supposé par défaut), il suffit de saisir ces o-e et a-e entrelacés (`œ`, `Œ`, `æ`, `Æ`) 
directement dans le fichier source :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page

\begin{document}
Tout comme sa sœur, Œdipe disait souvent : qui vole un œuf vole un bœuf 
(et cætera) !
\end{document}
```