// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/visionai/v1/warehouse.proto

package visionaipb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Different types for a facet bucket.
type FacetBucketType int32

const (
	// Unspecified type.
	FacetBucketType_FACET_BUCKET_TYPE_UNSPECIFIED FacetBucketType = 0
	// Value type.
	FacetBucketType_FACET_BUCKET_TYPE_VALUE FacetBucketType = 1
	// Datetime type.
	FacetBucketType_FACET_BUCKET_TYPE_DATETIME FacetBucketType = 2
	// Fixed Range type.
	FacetBucketType_FACET_BUCKET_TYPE_FIXED_RANGE FacetBucketType = 3
	// Custom Range type.
	FacetBucketType_FACET_BUCKET_TYPE_CUSTOM_RANGE FacetBucketType = 4
)

// Enum value maps for FacetBucketType.
var (
	FacetBucketType_name = map[int32]string{
		0: "FACET_BUCKET_TYPE_UNSPECIFIED",
		1: "FACET_BUCKET_TYPE_VALUE",
		2: "FACET_BUCKET_TYPE_DATETIME",
		3: "FACET_BUCKET_TYPE_FIXED_RANGE",
		4: "FACET_BUCKET_TYPE_CUSTOM_RANGE",
	}
	FacetBucketType_value = map[string]int32{
		"FACET_BUCKET_TYPE_UNSPECIFIED":  0,
		"FACET_BUCKET_TYPE_VALUE":        1,
		"FACET_BUCKET_TYPE_DATETIME":     2,
		"FACET_BUCKET_TYPE_FIXED_RANGE":  3,
		"FACET_BUCKET_TYPE_CUSTOM_RANGE": 4,
	}
)

func (x FacetBucketType) Enum() *FacetBucketType {
	p := new(FacetBucketType)
	*p = x
	return p
}

func (x FacetBucketType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FacetBucketType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[0].Descriptor()
}

func (FacetBucketType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[0]
}

func (x FacetBucketType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FacetBucketType.Descriptor instead.
func (FacetBucketType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{0}
}

// The state of the search capability.
type AnalyzeAssetMetadata_AnalysisStatus_State int32

const (
	// The default process state should never happen.
	AnalyzeAssetMetadata_AnalysisStatus_STATE_UNSPECIFIED AnalyzeAssetMetadata_AnalysisStatus_State = 0
	// The feature is in progress.
	AnalyzeAssetMetadata_AnalysisStatus_IN_PROGRESS AnalyzeAssetMetadata_AnalysisStatus_State = 1
	// The process is successfully done.
	AnalyzeAssetMetadata_AnalysisStatus_SUCCEEDED AnalyzeAssetMetadata_AnalysisStatus_State = 2
	// The process failed.
	AnalyzeAssetMetadata_AnalysisStatus_FAILED AnalyzeAssetMetadata_AnalysisStatus_State = 3
)

// Enum value maps for AnalyzeAssetMetadata_AnalysisStatus_State.
var (
	AnalyzeAssetMetadata_AnalysisStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "SUCCEEDED",
		3: "FAILED",
	}
	AnalyzeAssetMetadata_AnalysisStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":       1,
		"SUCCEEDED":         2,
		"FAILED":            3,
	}
)

func (x AnalyzeAssetMetadata_AnalysisStatus_State) Enum() *AnalyzeAssetMetadata_AnalysisStatus_State {
	p := new(AnalyzeAssetMetadata_AnalysisStatus_State)
	*p = x
	return p
}

func (x AnalyzeAssetMetadata_AnalysisStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnalyzeAssetMetadata_AnalysisStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[1].Descriptor()
}

func (AnalyzeAssetMetadata_AnalysisStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[1]
}

func (x AnalyzeAssetMetadata_AnalysisStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnalyzeAssetMetadata_AnalysisStatus_State.Descriptor instead.
func (AnalyzeAssetMetadata_AnalysisStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{14, 0, 0}
}

// State enum for this asset's indexing.
type IndexingStatus_State int32

const (
	// The default process state should never happen.
	IndexingStatus_STATE_UNSPECIFIED IndexingStatus_State = 0
	// The indexing is in progress.
	IndexingStatus_IN_PROGRESS IndexingStatus_State = 1
	// The process is successfully done.
	IndexingStatus_SUCCEEDED IndexingStatus_State = 2
	// The process failed.
	IndexingStatus_FAILED IndexingStatus_State = 3
)

// Enum value maps for IndexingStatus_State.
var (
	IndexingStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "SUCCEEDED",
		3: "FAILED",
	}
	IndexingStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":       1,
		"SUCCEEDED":         2,
		"FAILED":            3,
	}
)

func (x IndexingStatus_State) Enum() *IndexingStatus_State {
	p := new(IndexingStatus_State)
	*p = x
	return p
}

func (x IndexingStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexingStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[2].Descriptor()
}

func (IndexingStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[2]
}

func (x IndexingStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndexingStatus_State.Descriptor instead.
func (IndexingStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{16, 0}
}

// Capability to perform different search on assets.
type SearchCapability_Type int32

const (
	// Unspecified search capability, should never be used.
	SearchCapability_TYPE_UNSPECIFIED SearchCapability_Type = 0
	// Embedding search.
	SearchCapability_EMBEDDING_SEARCH SearchCapability_Type = 1
)

// Enum value maps for SearchCapability_Type.
var (
	SearchCapability_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "EMBEDDING_SEARCH",
	}
	SearchCapability_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"EMBEDDING_SEARCH": 1,
	}
)

func (x SearchCapability_Type) Enum() *SearchCapability_Type {
	p := new(SearchCapability_Type)
	*p = x
	return p
}

func (x SearchCapability_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchCapability_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[3].Descriptor()
}

func (SearchCapability_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[3]
}

func (x SearchCapability_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchCapability_Type.Descriptor instead.
func (SearchCapability_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{28, 0}
}

// CollectionItem types.
type CollectionItem_Type int32

const (
	// The default type of item should never happen.
	CollectionItem_TYPE_UNSPECIFIED CollectionItem_Type = 0
	// Asset type item.
	CollectionItem_ASSET CollectionItem_Type = 1
)

// Enum value maps for CollectionItem_Type.
var (
	CollectionItem_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ASSET",
	}
	CollectionItem_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ASSET":            1,
	}
)

func (x CollectionItem_Type) Enum() *CollectionItem_Type {
	p := new(CollectionItem_Type)
	*p = x
	return p
}

func (x CollectionItem_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CollectionItem_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[4].Descriptor()
}

func (CollectionItem_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[4]
}

func (x CollectionItem_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CollectionItem_Type.Descriptor instead.
func (CollectionItem_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{45, 0}
}

// Enum representing the different states through which an Index might cycle
// during its lifetime.
type Index_State int32

const (
	// The default value. Should not be used.
	Index_STATE_UNSPECIFIED Index_State = 0
	// State CREATING.
	Index_CREATING Index_State = 1
	// State CREATED.
	Index_CREATED Index_State = 2
	// State UPDATING.
	Index_UPDATING Index_State = 3
)

// Enum value maps for Index_State.
var (
	Index_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "CREATED",
		3: "UPDATING",
	}
	Index_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"CREATED":           2,
		"UPDATING":          3,
	}
)

func (x Index_State) Enum() *Index_State {
	p := new(Index_State)
	*p = x
	return p
}

func (x Index_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Index_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[5].Descriptor()
}

func (Index_State) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[5]
}

func (x Index_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Index_State.Descriptor instead.
func (Index_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{55, 0}
}

// Type of the asset inside the corpus.
type Corpus_Type int32

const (
	// The default type, not supposed to be used. If this default type is used,
	// the corpus will be created as STREAM_VIDEO corpus.
	Corpus_TYPE_UNSPECIFIED Corpus_Type = 0
	// Asset is a live streaming video.
	Corpus_STREAM_VIDEO Corpus_Type = 1
	// Asset is an image.
	Corpus_IMAGE Corpus_Type = 2
	// Asset is a batch video.
	Corpus_VIDEO_ON_DEMAND Corpus_Type = 3
)

// Enum value maps for Corpus_Type.
var (
	Corpus_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "STREAM_VIDEO",
		2: "IMAGE",
		3: "VIDEO_ON_DEMAND",
	}
	Corpus_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"STREAM_VIDEO":     1,
		"IMAGE":            2,
		"VIDEO_ON_DEMAND":  3,
	}
)

func (x Corpus_Type) Enum() *Corpus_Type {
	p := new(Corpus_Type)
	*p = x
	return p
}

func (x Corpus_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Corpus_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[6].Descriptor()
}

func (Corpus_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[6]
}

func (x Corpus_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Corpus_Type.Descriptor instead.
func (Corpus_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{57, 0}
}

// Data type of the annotation.
type DataSchemaDetails_DataType int32

const (
	// Unspecified type.
	DataSchemaDetails_DATA_TYPE_UNSPECIFIED DataSchemaDetails_DataType = 0
	// Integer type.
	// Allowed search strategies:
	//   - DataSchema.SearchStrategy.NO_SEARCH,
	//   - DataSchema.SearchStrategy.EXACT_SEARCH.
	//     Supports query by IntRangeArray.
	DataSchemaDetails_INTEGER DataSchemaDetails_DataType = 1
	// Float type.
	// Allowed search strategies:
	//   - DataSchema.SearchStrategy.NO_SEARCH,
	//   - DataSchema.SearchStrategy.EXACT_SEARCH.
	//     Supports query by FloatRangeArray.
	DataSchemaDetails_FLOAT DataSchemaDetails_DataType = 2
	// String type.
	// Allowed search strategies:
	// - DataSchema.SearchStrategy.NO_SEARCH,
	// - DataSchema.SearchStrategy.EXACT_SEARCH,
	// - DataSchema.SearchStrategy.SMART_SEARCH.
	DataSchemaDetails_STRING DataSchemaDetails_DataType = 3
	// Supported formats:
	// %Y-%m-%dT%H:%M:%E*S%E*z (absl::RFC3339_full)
	// %Y-%m-%dT%H:%M:%E*S
	// %Y-%m-%dT%H:%M%E*z
	// %Y-%m-%dT%H:%M
	// %Y-%m-%dT%H%E*z
	// %Y-%m-%dT%H
	// %Y-%m-%d%E*z
	// %Y-%m-%d
	// %Y-%m
	// %Y
	// Allowed search strategies:
	//   - DataSchema.SearchStrategy.NO_SEARCH,
	//   - DataSchema.SearchStrategy.EXACT_SEARCH.
	//     Supports query by DateTimeRangeArray.
	DataSchemaDetails_DATETIME DataSchemaDetails_DataType = 5
	// Geo coordinate type.
	// Allowed search strategies:
	//   - DataSchema.SearchStrategy.NO_SEARCH,
	//   - DataSchema.SearchStrategy.EXACT_SEARCH.
	//     Supports query by GeoLocationArray.
	DataSchemaDetails_GEO_COORDINATE DataSchemaDetails_DataType = 7
	// Type to pass any proto as available in annotations.proto. Only use
	// internally.
	// Available proto types and its corresponding search behavior:
	//   - ImageObjectDetectionPredictionResult, allows SMART_SEARCH on
	//     display_names and NO_SEARCH.
	//   - ClassificationPredictionResult, allows SMART_SEARCH on display_names
	//     and NO_SEARCH.
	//   - ImageSegmentationPredictionResult, allows NO_SEARCH.
	//   - VideoActionRecognitionPredictionResult, allows SMART_SEARCH on
	//     display_name and NO_SEARCH.
	//   - VideoObjectTrackingPredictionResult, allows SMART_SEARCH on
	//     display_name and NO_SEARCH.
	//   - VideoClassificationPredictionResult, allows SMART_SEARCH on
	//     display_name and NO_SEARCH.
	//   - OccupancyCountingPredictionResult, allows EXACT_SEARCH on
	//     stats.full_frame_count.count and NO_SEARCH.
	//   - ObjectDetectionPredictionResult, allows SMART_SEARCH on
	//     identified_boxes.entity.label_string and NO_SEARCH.
	DataSchemaDetails_PROTO_ANY DataSchemaDetails_DataType = 8
	// Boolean type.
	// Allowed search strategies:
	// - DataSchema.SearchStrategy.NO_SEARCH,
	// - DataSchema.SearchStrategy.EXACT_SEARCH.
	DataSchemaDetails_BOOLEAN DataSchemaDetails_DataType = 9
	// List type.
	//   - Each element in the list must be of the exact same data schema;
	//     otherwise, they are invalid arguments.
	//   - List level cannot set search strategy. Leaf node level can do.
	//   - Elements cannot be another list (no list of list).
	//   - Elements can be CUSTOMIZED_STRUCT, and max number of layers is 10.
	DataSchemaDetails_LIST DataSchemaDetails_DataType = 10
	// Struct type.
	// - SearchStrategy:
	//   - Data Schema that's CUSTOMIZED_STRUCT cannot set search strategy.
	//   - Leaf-node elements allow setting search strategy based on element's
	//     SearchStrategy restriction.
	//
	// - Nested layer restrictions:
	//   - Data Schema that's CUSTOMIZED_STRUCT allows its fields to be of
	//     CUSTOMIZED_STRUCT as well, but the overall layers restriction is 10.
	DataSchemaDetails_CUSTOMIZED_STRUCT DataSchemaDetails_DataType = 6
)

// Enum value maps for DataSchemaDetails_DataType.
var (
	DataSchemaDetails_DataType_name = map[int32]string{
		0:  "DATA_TYPE_UNSPECIFIED",
		1:  "INTEGER",
		2:  "FLOAT",
		3:  "STRING",
		5:  "DATETIME",
		7:  "GEO_COORDINATE",
		8:  "PROTO_ANY",
		9:  "BOOLEAN",
		10: "LIST",
		6:  "CUSTOMIZED_STRUCT",
	}
	DataSchemaDetails_DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"INTEGER":               1,
		"FLOAT":                 2,
		"STRING":                3,
		"DATETIME":              5,
		"GEO_COORDINATE":        7,
		"PROTO_ANY":             8,
		"BOOLEAN":               9,
		"LIST":                  10,
		"CUSTOMIZED_STRUCT":     6,
	}
)

func (x DataSchemaDetails_DataType) Enum() *DataSchemaDetails_DataType {
	p := new(DataSchemaDetails_DataType)
	*p = x
	return p
}

func (x DataSchemaDetails_DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSchemaDetails_DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[7].Descriptor()
}

func (DataSchemaDetails_DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[7]
}

func (x DataSchemaDetails_DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSchemaDetails_DataType.Descriptor instead.
func (DataSchemaDetails_DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68, 0}
}

// The granularity of annotations under this DataSchema.
type DataSchemaDetails_Granularity int32

const (
	// Unspecified granularity.
	DataSchemaDetails_GRANULARITY_UNSPECIFIED DataSchemaDetails_Granularity = 0
	// Asset-level granularity (annotations must not contain partition info).
	DataSchemaDetails_GRANULARITY_ASSET_LEVEL DataSchemaDetails_Granularity = 1
	// Partition-level granularity (annotations must contain partition info).
	DataSchemaDetails_GRANULARITY_PARTITION_LEVEL DataSchemaDetails_Granularity = 2
)

// Enum value maps for DataSchemaDetails_Granularity.
var (
	DataSchemaDetails_Granularity_name = map[int32]string{
		0: "GRANULARITY_UNSPECIFIED",
		1: "GRANULARITY_ASSET_LEVEL",
		2: "GRANULARITY_PARTITION_LEVEL",
	}
	DataSchemaDetails_Granularity_value = map[string]int32{
		"GRANULARITY_UNSPECIFIED":     0,
		"GRANULARITY_ASSET_LEVEL":     1,
		"GRANULARITY_PARTITION_LEVEL": 2,
	}
)

func (x DataSchemaDetails_Granularity) Enum() *DataSchemaDetails_Granularity {
	p := new(DataSchemaDetails_Granularity)
	*p = x
	return p
}

func (x DataSchemaDetails_Granularity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSchemaDetails_Granularity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[8].Descriptor()
}

func (DataSchemaDetails_Granularity) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[8]
}

func (x DataSchemaDetails_Granularity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSchemaDetails_Granularity.Descriptor instead.
func (DataSchemaDetails_Granularity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68, 1}
}

// The types of search strategies to be applied on the annotation key.
type DataSchemaDetails_SearchStrategy_SearchStrategyType int32

const (
	// Annotatation values of the `key` above will not be searchable.
	DataSchemaDetails_SearchStrategy_NO_SEARCH DataSchemaDetails_SearchStrategy_SearchStrategyType = 0
	// When searching with `key`, the value must be exactly as the annotation
	// value that has been ingested.
	DataSchemaDetails_SearchStrategy_EXACT_SEARCH DataSchemaDetails_SearchStrategy_SearchStrategyType = 1
	// When searching with `key`, Warehouse will perform broad search based on
	// semantic of the annotation value.
	DataSchemaDetails_SearchStrategy_SMART_SEARCH DataSchemaDetails_SearchStrategy_SearchStrategyType = 2
)

// Enum value maps for DataSchemaDetails_SearchStrategy_SearchStrategyType.
var (
	DataSchemaDetails_SearchStrategy_SearchStrategyType_name = map[int32]string{
		0: "NO_SEARCH",
		1: "EXACT_SEARCH",
		2: "SMART_SEARCH",
	}
	DataSchemaDetails_SearchStrategy_SearchStrategyType_value = map[string]int32{
		"NO_SEARCH":    0,
		"EXACT_SEARCH": 1,
		"SMART_SEARCH": 2,
	}
)

func (x DataSchemaDetails_SearchStrategy_SearchStrategyType) Enum() *DataSchemaDetails_SearchStrategy_SearchStrategyType {
	p := new(DataSchemaDetails_SearchStrategy_SearchStrategyType)
	*p = x
	return p
}

func (x DataSchemaDetails_SearchStrategy_SearchStrategyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSchemaDetails_SearchStrategy_SearchStrategyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[9].Descriptor()
}

func (DataSchemaDetails_SearchStrategy_SearchStrategyType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[9]
}

func (x DataSchemaDetails_SearchStrategy_SearchStrategyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSchemaDetails_SearchStrategy_SearchStrategyType.Descriptor instead.
func (DataSchemaDetails_SearchStrategy_SearchStrategyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68, 3, 0}
}

// IndexEndpoint stage.
type IndexEndpoint_State int32

const (
	// The default value. Should not be used.
	IndexEndpoint_STATE_UNSPECIFIED IndexEndpoint_State = 0
	// State CREATING.
	IndexEndpoint_CREATING IndexEndpoint_State = 1
	// State CREATED.
	IndexEndpoint_CREATED IndexEndpoint_State = 2
	// State UPDATING.
	IndexEndpoint_UPDATING IndexEndpoint_State = 3
	// State FAILED.
	IndexEndpoint_FAILED IndexEndpoint_State = 4
)

// Enum value maps for IndexEndpoint_State.
var (
	IndexEndpoint_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "CREATED",
		3: "UPDATING",
		4: "FAILED",
	}
	IndexEndpoint_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"CREATED":           2,
		"UPDATING":          3,
		"FAILED":            4,
	}
)

func (x IndexEndpoint_State) Enum() *IndexEndpoint_State {
	p := new(IndexEndpoint_State)
	*p = x
	return p
}

func (x IndexEndpoint_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexEndpoint_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[10].Descriptor()
}

func (IndexEndpoint_State) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[10]
}

func (x IndexEndpoint_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndexEndpoint_State.Descriptor instead.
func (IndexEndpoint_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{96, 0}
}

// Granularity enum for the datetime bucket.
type FacetProperty_DateTimeBucketSpec_Granularity int32

const (
	// Unspecified granularity.
	FacetProperty_DateTimeBucketSpec_GRANULARITY_UNSPECIFIED FacetProperty_DateTimeBucketSpec_Granularity = 0
	// Granularity is year.
	FacetProperty_DateTimeBucketSpec_YEAR FacetProperty_DateTimeBucketSpec_Granularity = 1
	// Granularity is month.
	FacetProperty_DateTimeBucketSpec_MONTH FacetProperty_DateTimeBucketSpec_Granularity = 2
	// Granularity is day.
	FacetProperty_DateTimeBucketSpec_DAY FacetProperty_DateTimeBucketSpec_Granularity = 3
)

// Enum value maps for FacetProperty_DateTimeBucketSpec_Granularity.
var (
	FacetProperty_DateTimeBucketSpec_Granularity_name = map[int32]string{
		0: "GRANULARITY_UNSPECIFIED",
		1: "YEAR",
		2: "MONTH",
		3: "DAY",
	}
	FacetProperty_DateTimeBucketSpec_Granularity_value = map[string]int32{
		"GRANULARITY_UNSPECIFIED": 0,
		"YEAR":                    1,
		"MONTH":                   2,
		"DAY":                     3,
	}
)

func (x FacetProperty_DateTimeBucketSpec_Granularity) Enum() *FacetProperty_DateTimeBucketSpec_Granularity {
	p := new(FacetProperty_DateTimeBucketSpec_Granularity)
	*p = x
	return p
}

func (x FacetProperty_DateTimeBucketSpec_Granularity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FacetProperty_DateTimeBucketSpec_Granularity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[11].Descriptor()
}

func (FacetProperty_DateTimeBucketSpec_Granularity) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[11]
}

func (x FacetProperty_DateTimeBucketSpec_Granularity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FacetProperty_DateTimeBucketSpec_Granularity.Descriptor instead.
func (FacetProperty_DateTimeBucketSpec_Granularity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{113, 2, 0}
}

// Container format of the video.
type IngestAssetRequest_Config_VideoType_ContainerFormat int32

const (
	// The default type, not supposed to be used.
	IngestAssetRequest_Config_VideoType_CONTAINER_FORMAT_UNSPECIFIED IngestAssetRequest_Config_VideoType_ContainerFormat = 0
	// Mp4 container format.
	IngestAssetRequest_Config_VideoType_CONTAINER_FORMAT_MP4 IngestAssetRequest_Config_VideoType_ContainerFormat = 1
)

// Enum value maps for IngestAssetRequest_Config_VideoType_ContainerFormat.
var (
	IngestAssetRequest_Config_VideoType_ContainerFormat_name = map[int32]string{
		0: "CONTAINER_FORMAT_UNSPECIFIED",
		1: "CONTAINER_FORMAT_MP4",
	}
	IngestAssetRequest_Config_VideoType_ContainerFormat_value = map[string]int32{
		"CONTAINER_FORMAT_UNSPECIFIED": 0,
		"CONTAINER_FORMAT_MP4":         1,
	}
)

func (x IngestAssetRequest_Config_VideoType_ContainerFormat) Enum() *IngestAssetRequest_Config_VideoType_ContainerFormat {
	p := new(IngestAssetRequest_Config_VideoType_ContainerFormat)
	*p = x
	return p
}

func (x IngestAssetRequest_Config_VideoType_ContainerFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestAssetRequest_Config_VideoType_ContainerFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[12].Descriptor()
}

func (IngestAssetRequest_Config_VideoType_ContainerFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[12]
}

func (x IngestAssetRequest_Config_VideoType_ContainerFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestAssetRequest_Config_VideoType_ContainerFormat.Descriptor instead.
func (IngestAssetRequest_Config_VideoType_ContainerFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{125, 0, 0, 0}
}

// When one result has multiple values with the same key, specify
// which value is used to sort. By default, AGGREGATE_METHOD_LARGEST
// is used when results are sorted in decreasing order,
// AGGREGATE_METHOD_SMALLEST is used when results are sorted in
// incresing order.
type SchemaKeySortingStrategy_Option_AggregateMethod int32

const (
	// The unspecified aggregate method will be overwritten as mentioned
	// above.
	SchemaKeySortingStrategy_Option_AGGREGATE_METHOD_UNSPECIFIED SchemaKeySortingStrategy_Option_AggregateMethod = 0
	// Take the (lexicographical or numerical) largest value to sort.
	SchemaKeySortingStrategy_Option_AGGREGATE_METHOD_LARGEST SchemaKeySortingStrategy_Option_AggregateMethod = 1
	// Take the (lexicographical or numerical) smallest value to sort.
	SchemaKeySortingStrategy_Option_AGGREGATE_METHOD_SMALLEST SchemaKeySortingStrategy_Option_AggregateMethod = 2
)

// Enum value maps for SchemaKeySortingStrategy_Option_AggregateMethod.
var (
	SchemaKeySortingStrategy_Option_AggregateMethod_name = map[int32]string{
		0: "AGGREGATE_METHOD_UNSPECIFIED",
		1: "AGGREGATE_METHOD_LARGEST",
		2: "AGGREGATE_METHOD_SMALLEST",
	}
	SchemaKeySortingStrategy_Option_AggregateMethod_value = map[string]int32{
		"AGGREGATE_METHOD_UNSPECIFIED": 0,
		"AGGREGATE_METHOD_LARGEST":     1,
		"AGGREGATE_METHOD_SMALLEST":    2,
	}
)

func (x SchemaKeySortingStrategy_Option_AggregateMethod) Enum() *SchemaKeySortingStrategy_Option_AggregateMethod {
	p := new(SchemaKeySortingStrategy_Option_AggregateMethod)
	*p = x
	return p
}

func (x SchemaKeySortingStrategy_Option_AggregateMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchemaKeySortingStrategy_Option_AggregateMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_warehouse_proto_enumTypes[13].Descriptor()
}

func (SchemaKeySortingStrategy_Option_AggregateMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_warehouse_proto_enumTypes[13]
}

func (x SchemaKeySortingStrategy_Option_AggregateMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchemaKeySortingStrategy_Option_AggregateMethod.Descriptor instead.
func (SchemaKeySortingStrategy_Option_AggregateMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{134, 0, 0}
}

// Request message for CreateAssetRequest.
type CreateAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this asset will be created.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The asset to create.
	Asset *Asset `protobuf:"bytes,2,opt,name=asset,proto3" json:"asset,omitempty"`
	// Optional. The ID to use for the asset, which will become the final
	// component of the asset's resource name if user choose to specify.
	// Otherwise, asset id will be generated by system.
	//
	// This value should be up to 63 characters, and valid characters
	// are /[a-z][0-9]-/. The first character must be a letter, the last could be
	// a letter or a number.
	AssetId *string `protobuf:"bytes,3,opt,name=asset_id,json=assetId,proto3,oneof" json:"asset_id,omitempty"`
}

func (x *CreateAssetRequest) Reset() {
	*x = CreateAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAssetRequest) ProtoMessage() {}

func (x *CreateAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAssetRequest.ProtoReflect.Descriptor instead.
func (*CreateAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{0}
}

func (x *CreateAssetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAssetRequest) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *CreateAssetRequest) GetAssetId() string {
	if x != nil && x.AssetId != nil {
		return *x.AssetId
	}
	return ""
}

// Request message for GetAsset.
type GetAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the asset to retrieve.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAssetRequest) Reset() {
	*x = GetAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAssetRequest) ProtoMessage() {}

func (x *GetAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAssetRequest.ProtoReflect.Descriptor instead.
func (*GetAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{1}
}

func (x *GetAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAssets.
type ListAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of assets.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of assets to return. The service may return fewer than
	// this value.
	// If unspecified, at most 50 assets will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAssets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAssets` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The filter applied to the returned list.
	// Only the following filterings are supported:
	// "assets_with_contents = true", which returns assets with contents uploaded;
	// "assets_with_contents = false", which returns assets without contents.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAssetsRequest) Reset() {
	*x = ListAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsRequest) ProtoMessage() {}

func (x *ListAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsRequest.ProtoReflect.Descriptor instead.
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{2}
}

func (x *ListAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ListAssets.
type ListAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The assets from the specified corpus.
	Assets []*Asset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAssetsResponse) Reset() {
	*x = ListAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse) ProtoMessage() {}

func (x *ListAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{3}
}

func (x *ListAssetsResponse) GetAssets() []*Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *ListAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for UpdateAsset.
type UpdateAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The asset to update.
	//
	// The asset's `name` field is used to identify the asset to be updated.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
	Asset *Asset `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAssetRequest) Reset() {
	*x = UpdateAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAssetRequest) ProtoMessage() {}

func (x *UpdateAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAssetRequest.ProtoReflect.Descriptor instead.
func (*UpdateAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAssetRequest) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *UpdateAssetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteAsset.
type DeleteAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the asset to delete.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAssetRequest) Reset() {
	*x = DeleteAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAssetRequest) ProtoMessage() {}

func (x *DeleteAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAssetRequest.ProtoReflect.Descriptor instead.
func (*DeleteAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The source of the asset.
type AssetSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceForm:
	//
	//	*AssetSource_AssetGcsSource_
	//	*AssetSource_AssetContentData_
	SourceForm isAssetSource_SourceForm `protobuf_oneof:"source_form"`
}

func (x *AssetSource) Reset() {
	*x = AssetSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetSource) ProtoMessage() {}

func (x *AssetSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetSource.ProtoReflect.Descriptor instead.
func (*AssetSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{6}
}

func (m *AssetSource) GetSourceForm() isAssetSource_SourceForm {
	if m != nil {
		return m.SourceForm
	}
	return nil
}

func (x *AssetSource) GetAssetGcsSource() *AssetSource_AssetGcsSource {
	if x, ok := x.GetSourceForm().(*AssetSource_AssetGcsSource_); ok {
		return x.AssetGcsSource
	}
	return nil
}

func (x *AssetSource) GetAssetContentData() *AssetSource_AssetContentData {
	if x, ok := x.GetSourceForm().(*AssetSource_AssetContentData_); ok {
		return x.AssetContentData
	}
	return nil
}

type isAssetSource_SourceForm interface {
	isAssetSource_SourceForm()
}

type AssetSource_AssetGcsSource_ struct {
	// The source of the asset is from Cloud Storage.
	AssetGcsSource *AssetSource_AssetGcsSource `protobuf:"bytes,1,opt,name=asset_gcs_source,json=assetGcsSource,proto3,oneof"`
}

type AssetSource_AssetContentData_ struct {
	// The source of the asset is from content bytes.
	AssetContentData *AssetSource_AssetContentData `protobuf:"bytes,2,opt,name=asset_content_data,json=assetContentData,proto3,oneof"`
}

func (*AssetSource_AssetGcsSource_) isAssetSource_SourceForm() {}

func (*AssetSource_AssetContentData_) isAssetSource_SourceForm() {}

// Request message for UploadAsset.
type UploadAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to upload.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The source of the asset.
	AssetSource *AssetSource `protobuf:"bytes,2,opt,name=asset_source,json=assetSource,proto3" json:"asset_source,omitempty"`
}

func (x *UploadAssetRequest) Reset() {
	*x = UploadAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadAssetRequest) ProtoMessage() {}

func (x *UploadAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadAssetRequest.ProtoReflect.Descriptor instead.
func (*UploadAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{7}
}

func (x *UploadAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UploadAssetRequest) GetAssetSource() *AssetSource {
	if x != nil {
		return x.AssetSource
	}
	return nil
}

// Response message for UploadAsset.
type UploadAssetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UploadAssetResponse) Reset() {
	*x = UploadAssetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadAssetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadAssetResponse) ProtoMessage() {}

func (x *UploadAssetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadAssetResponse.ProtoReflect.Descriptor instead.
func (*UploadAssetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{8}
}

// Metadata for UploadAsset.
type UploadAssetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start time of the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The update time of the operation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *UploadAssetMetadata) Reset() {
	*x = UploadAssetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadAssetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadAssetMetadata) ProtoMessage() {}

func (x *UploadAssetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadAssetMetadata.ProtoReflect.Descriptor instead.
func (*UploadAssetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{9}
}

func (x *UploadAssetMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *UploadAssetMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for GenerateRetrievalUrl API.
type GenerateRetrievalUrlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to request signed url for.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GenerateRetrievalUrlRequest) Reset() {
	*x = GenerateRetrievalUrlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateRetrievalUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateRetrievalUrlRequest) ProtoMessage() {}

func (x *GenerateRetrievalUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateRetrievalUrlRequest.ProtoReflect.Descriptor instead.
func (*GenerateRetrievalUrlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{10}
}

func (x *GenerateRetrievalUrlRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for GenerateRetrievalUrl API.
type GenerateRetrievalUrlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A signed url to download the content of the asset.
	SignedUri string `protobuf:"bytes,1,opt,name=signed_uri,json=signedUri,proto3" json:"signed_uri,omitempty"`
}

func (x *GenerateRetrievalUrlResponse) Reset() {
	*x = GenerateRetrievalUrlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateRetrievalUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateRetrievalUrlResponse) ProtoMessage() {}

func (x *GenerateRetrievalUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateRetrievalUrlResponse.ProtoReflect.Descriptor instead.
func (*GenerateRetrievalUrlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{11}
}

func (x *GenerateRetrievalUrlResponse) GetSignedUri() string {
	if x != nil {
		return x.SignedUri
	}
	return ""
}

// An asset is a resource in corpus. It represents a media object inside corpus,
// contains metadata and another resource annotation. Different feature could be
// applied to the asset to generate annotations. User could specified annotation
// related to the target asset.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the asset.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The duration for which all media assets, associated metadata, and search
	// documents can exist. If not set, then it will using the default ttl in the
	// parent corpus resource.
	Ttl *durationpb.Duration `protobuf:"bytes,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// Output only. The original cloud storage source uri that is associated with
	// this asset.
	AssetGcsSource *AssetSource_AssetGcsSource `protobuf:"bytes,4,opt,name=asset_gcs_source,json=assetGcsSource,proto3" json:"asset_gcs_source,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{12}
}

func (x *Asset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *Asset) GetAssetGcsSource() *AssetSource_AssetGcsSource {
	if x != nil {
		return x.AssetGcsSource
	}
	return nil
}

// Request message for AnalyzeAsset.
type AnalyzeAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to analyze.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AnalyzeAssetRequest) Reset() {
	*x = AnalyzeAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeAssetRequest) ProtoMessage() {}

func (x *AnalyzeAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeAssetRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{13}
}

func (x *AnalyzeAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata for AnalyzeAsset.
type AnalyzeAssetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of analysis on all search capabilities.
	AnalysisStatus []*AnalyzeAssetMetadata_AnalysisStatus `protobuf:"bytes,1,rep,name=analysis_status,json=analysisStatus,proto3" json:"analysis_status,omitempty"`
	// The start time of the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The update time of the operation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *AnalyzeAssetMetadata) Reset() {
	*x = AnalyzeAssetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeAssetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeAssetMetadata) ProtoMessage() {}

func (x *AnalyzeAssetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeAssetMetadata.ProtoReflect.Descriptor instead.
func (*AnalyzeAssetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{14}
}

func (x *AnalyzeAssetMetadata) GetAnalysisStatus() []*AnalyzeAssetMetadata_AnalysisStatus {
	if x != nil {
		return x.AnalysisStatus
	}
	return nil
}

func (x *AnalyzeAssetMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *AnalyzeAssetMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Response message for AnalyzeAsset.
type AnalyzeAssetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AnalyzeAssetResponse) Reset() {
	*x = AnalyzeAssetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeAssetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeAssetResponse) ProtoMessage() {}

func (x *AnalyzeAssetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeAssetResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeAssetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{15}
}

// The status of indexing for the asset.
type IndexingStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. State of this asset's indexing.
	State IndexingStatus_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.visionai.v1.IndexingStatus_State" json:"state,omitempty"`
	// Detailed message describing the state.
	StatusMessage string `protobuf:"bytes,3,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
}

func (x *IndexingStatus) Reset() {
	*x = IndexingStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexingStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexingStatus) ProtoMessage() {}

func (x *IndexingStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexingStatus.ProtoReflect.Descriptor instead.
func (*IndexingStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{16}
}

func (x *IndexingStatus) GetState() IndexingStatus_State {
	if x != nil {
		return x.State
	}
	return IndexingStatus_STATE_UNSPECIFIED
}

func (x *IndexingStatus) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

// Request message for IndexAsset.
type IndexAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to index.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The name of the index.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
	Index string `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *IndexAssetRequest) Reset() {
	*x = IndexAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexAssetRequest) ProtoMessage() {}

func (x *IndexAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexAssetRequest.ProtoReflect.Descriptor instead.
func (*IndexAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{17}
}

func (x *IndexAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IndexAssetRequest) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

// Metadata for IndexAsset.
type IndexAssetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of indexing this asset.
	Status *IndexingStatus `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	// The start time of the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The update time of the operation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *IndexAssetMetadata) Reset() {
	*x = IndexAssetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexAssetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexAssetMetadata) ProtoMessage() {}

func (x *IndexAssetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexAssetMetadata.ProtoReflect.Descriptor instead.
func (*IndexAssetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{18}
}

func (x *IndexAssetMetadata) GetStatus() *IndexingStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *IndexAssetMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *IndexAssetMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Response message for IndexAsset.
type IndexAssetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *IndexAssetResponse) Reset() {
	*x = IndexAssetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexAssetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexAssetResponse) ProtoMessage() {}

func (x *IndexAssetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexAssetResponse.ProtoReflect.Descriptor instead.
func (*IndexAssetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{19}
}

// Request message for RemoveIndexAsset.
type RemoveIndexAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to index.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The name of the index.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
	Index string `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *RemoveIndexAssetRequest) Reset() {
	*x = RemoveIndexAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveIndexAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveIndexAssetRequest) ProtoMessage() {}

func (x *RemoveIndexAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveIndexAssetRequest.ProtoReflect.Descriptor instead.
func (*RemoveIndexAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{20}
}

func (x *RemoveIndexAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RemoveIndexAssetRequest) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

// Metadata for RemoveIndexAsset.
type RemoveIndexAssetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of indexing this asset.
	IndexingStatus *IndexingStatus `protobuf:"bytes,1,opt,name=indexing_status,json=indexingStatus,proto3" json:"indexing_status,omitempty"`
	// The start time of the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The update time of the operation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *RemoveIndexAssetMetadata) Reset() {
	*x = RemoveIndexAssetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveIndexAssetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveIndexAssetMetadata) ProtoMessage() {}

func (x *RemoveIndexAssetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveIndexAssetMetadata.ProtoReflect.Descriptor instead.
func (*RemoveIndexAssetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{21}
}

func (x *RemoveIndexAssetMetadata) GetIndexingStatus() *IndexingStatus {
	if x != nil {
		return x.IndexingStatus
	}
	return nil
}

func (x *RemoveIndexAssetMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *RemoveIndexAssetMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Response message for RemoveIndexAsset.
type RemoveIndexAssetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveIndexAssetResponse) Reset() {
	*x = RemoveIndexAssetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveIndexAssetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveIndexAssetResponse) ProtoMessage() {}

func (x *RemoveIndexAssetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveIndexAssetResponse.ProtoReflect.Descriptor instead.
func (*RemoveIndexAssetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{22}
}

// An IndexedAsset is an asset that the index is built upon.
type IndexedAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The index that this indexed asset belongs to.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// Required. The resource name of the asset.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Asset string `protobuf:"bytes,2,opt,name=asset,proto3" json:"asset,omitempty"`
	// Output only. The create timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *IndexedAsset) Reset() {
	*x = IndexedAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexedAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexedAsset) ProtoMessage() {}

func (x *IndexedAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexedAsset.ProtoReflect.Descriptor instead.
func (*IndexedAsset) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{23}
}

func (x *IndexedAsset) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *IndexedAsset) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

func (x *IndexedAsset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *IndexedAsset) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for ViewIndexedAssets.
type ViewIndexedAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The index that owns this collection of assets.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// The maximum number of assets to return. The service may return fewer than
	// this value.
	// If unspecified, at most 50 assets will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ViewIndexedAssets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ViewIndexedAssets` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The filter applied to the returned list.
	// Only the following filterings are supported:
	// "asset_id = xxxx", which returns asset with specified id.
	// "asset_id = xxxx, yyyy, zzzz", which returns assets with specified ids.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ViewIndexedAssetsRequest) Reset() {
	*x = ViewIndexedAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ViewIndexedAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ViewIndexedAssetsRequest) ProtoMessage() {}

func (x *ViewIndexedAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ViewIndexedAssetsRequest.ProtoReflect.Descriptor instead.
func (*ViewIndexedAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{24}
}

func (x *ViewIndexedAssetsRequest) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *ViewIndexedAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ViewIndexedAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ViewIndexedAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ViewIndexedAssets.
type ViewIndexedAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The assets from the specified index.
	IndexedAssets []*IndexedAsset `protobuf:"bytes,1,rep,name=indexed_assets,json=indexedAssets,proto3" json:"indexed_assets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ViewIndexedAssetsResponse) Reset() {
	*x = ViewIndexedAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ViewIndexedAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ViewIndexedAssetsResponse) ProtoMessage() {}

func (x *ViewIndexedAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ViewIndexedAssetsResponse.ProtoReflect.Descriptor instead.
func (*ViewIndexedAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{25}
}

func (x *ViewIndexedAssetsResponse) GetIndexedAssets() []*IndexedAsset {
	if x != nil {
		return x.IndexedAssets
	}
	return nil
}

func (x *ViewIndexedAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message of CreateCorpus API.
type CreateCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Form: `projects/{project_number}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The corpus to be created.
	Corpus *Corpus `protobuf:"bytes,2,opt,name=corpus,proto3" json:"corpus,omitempty"`
}

func (x *CreateCorpusRequest) Reset() {
	*x = CreateCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCorpusRequest) ProtoMessage() {}

func (x *CreateCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCorpusRequest.ProtoReflect.Descriptor instead.
func (*CreateCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{26}
}

func (x *CreateCorpusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCorpusRequest) GetCorpus() *Corpus {
	if x != nil {
		return x.Corpus
	}
	return nil
}

// Metadata for CreateCorpus API.
type CreateCorpusMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The create time of the create corpus operation.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The update time of the create corpus operation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *CreateCorpusMetadata) Reset() {
	*x = CreateCorpusMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCorpusMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCorpusMetadata) ProtoMessage() {}

func (x *CreateCorpusMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCorpusMetadata.ProtoReflect.Descriptor instead.
func (*CreateCorpusMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{27}
}

func (x *CreateCorpusMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateCorpusMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The capability and metadata of search capability.
type SearchCapability struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search capability to enable.
	Type SearchCapability_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.visionai.v1.SearchCapability_Type" json:"type,omitempty"`
}

func (x *SearchCapability) Reset() {
	*x = SearchCapability{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCapability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCapability) ProtoMessage() {}

func (x *SearchCapability) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCapability.ProtoReflect.Descriptor instead.
func (*SearchCapability) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{28}
}

func (x *SearchCapability) GetType() SearchCapability_Type {
	if x != nil {
		return x.Type
	}
	return SearchCapability_TYPE_UNSPECIFIED
}

// Setting for search capability to enable.
type SearchCapabilitySetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata of search capability to enable.
	SearchCapabilities []*SearchCapability `protobuf:"bytes,1,rep,name=search_capabilities,json=searchCapabilities,proto3" json:"search_capabilities,omitempty"`
}

func (x *SearchCapabilitySetting) Reset() {
	*x = SearchCapabilitySetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCapabilitySetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCapabilitySetting) ProtoMessage() {}

func (x *SearchCapabilitySetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCapabilitySetting.ProtoReflect.Descriptor instead.
func (*SearchCapabilitySetting) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{29}
}

func (x *SearchCapabilitySetting) GetSearchCapabilities() []*SearchCapability {
	if x != nil {
		return x.SearchCapabilities
	}
	return nil
}

// Metadata message for CreateCollectionRequest
type CreateCollectionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
}

func (x *CreateCollectionMetadata) Reset() {
	*x = CreateCollectionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCollectionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCollectionMetadata) ProtoMessage() {}

func (x *CreateCollectionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCollectionMetadata.ProtoReflect.Descriptor instead.
func (*CreateCollectionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{30}
}

func (x *CreateCollectionMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

// Request message for CreateCollection.
type CreateCollectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this collection will be created.
	// Format: `projects/{project_number}/locations/{location}/corpora/{corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The collection resource to be created.
	Collection *Collection `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
	// Optional. The ID to use for the collection, which will become the final
	// component of the resource name if user choose to specify. Otherwise,
	// collection id will be generated by system.
	//
	// This value should be up to 55 characters, and valid characters
	// are /[a-z][0-9]-/. The first character must be a letter, the last could be
	// a letter or a number.
	CollectionId *string `protobuf:"bytes,3,opt,name=collection_id,json=collectionId,proto3,oneof" json:"collection_id,omitempty"`
}

func (x *CreateCollectionRequest) Reset() {
	*x = CreateCollectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCollectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCollectionRequest) ProtoMessage() {}

func (x *CreateCollectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCollectionRequest.ProtoReflect.Descriptor instead.
func (*CreateCollectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{31}
}

func (x *CreateCollectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCollectionRequest) GetCollection() *Collection {
	if x != nil {
		return x.Collection
	}
	return nil
}

func (x *CreateCollectionRequest) GetCollectionId() string {
	if x != nil && x.CollectionId != nil {
		return *x.CollectionId
	}
	return ""
}

// Metadata message for DeleteCollectionRequest
type DeleteCollectionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
}

func (x *DeleteCollectionMetadata) Reset() {
	*x = DeleteCollectionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCollectionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCollectionMetadata) ProtoMessage() {}

func (x *DeleteCollectionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCollectionMetadata.ProtoReflect.Descriptor instead.
func (*DeleteCollectionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{32}
}

func (x *DeleteCollectionMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

// Request message for DeleteCollectionRequest.
type DeleteCollectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the collection to delete. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCollectionRequest) Reset() {
	*x = DeleteCollectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCollectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCollectionRequest) ProtoMessage() {}

func (x *DeleteCollectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCollectionRequest.ProtoReflect.Descriptor instead.
func (*DeleteCollectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{33}
}

func (x *DeleteCollectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCollectionRequest.
type GetCollectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the collection to retrieve. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCollectionRequest) Reset() {
	*x = GetCollectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCollectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCollectionRequest) ProtoMessage() {}

func (x *GetCollectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCollectionRequest.ProtoReflect.Descriptor instead.
func (*GetCollectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{34}
}

func (x *GetCollectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateCollectionRequest.
type UpdateCollectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The collection to update.
	//
	// The collection's `name` field is used to identify the collection to be
	// updated. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
	Collection *Collection `protobuf:"bytes,1,opt,name=collection,proto3" json:"collection,omitempty"`
	// The list of fields to be updated.
	//   - Unset `update_mask` or set `update_mask` to be a single "*" only will
	//     update all updatable fields with the value provided in `collection`.
	//   - To update `display_name` value to empty string, set it in the
	//
	// `collection`
	//
	//	to empty string, and set `update_mask` with "display_name". Same applies
	//	to other updatable string fields in the `collection`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCollectionRequest) Reset() {
	*x = UpdateCollectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCollectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCollectionRequest) ProtoMessage() {}

func (x *UpdateCollectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCollectionRequest.ProtoReflect.Descriptor instead.
func (*UpdateCollectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{35}
}

func (x *UpdateCollectionRequest) GetCollection() *Collection {
	if x != nil {
		return x.Collection
	}
	return nil
}

func (x *UpdateCollectionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCollections.
type ListCollectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent corpus. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of collections to return. The service may return fewer
	// than this value. If unspecified, at most 50 collections will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCollectionsRequest` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCollectionsRequest`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCollectionsRequest) Reset() {
	*x = ListCollectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCollectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCollectionsRequest) ProtoMessage() {}

func (x *ListCollectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCollectionsRequest.ProtoReflect.Descriptor instead.
func (*ListCollectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{36}
}

func (x *ListCollectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCollectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCollectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCollections.
type ListCollectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The collections from the specified corpus.
	Collections []*Collection `protobuf:"bytes,1,rep,name=collections,proto3" json:"collections,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCollectionsResponse) Reset() {
	*x = ListCollectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCollectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCollectionsResponse) ProtoMessage() {}

func (x *ListCollectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCollectionsResponse.ProtoReflect.Descriptor instead.
func (*ListCollectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{37}
}

func (x *ListCollectionsResponse) GetCollections() []*Collection {
	if x != nil {
		return x.Collections
	}
	return nil
}

func (x *ListCollectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for AddCollectionItem.
type AddCollectionItemRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The item to be added.
	Item *CollectionItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *AddCollectionItemRequest) Reset() {
	*x = AddCollectionItemRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddCollectionItemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddCollectionItemRequest) ProtoMessage() {}

func (x *AddCollectionItemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddCollectionItemRequest.ProtoReflect.Descriptor instead.
func (*AddCollectionItemRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{38}
}

func (x *AddCollectionItemRequest) GetItem() *CollectionItem {
	if x != nil {
		return x.Item
	}
	return nil
}

// Response message for AddCollectionItem.
type AddCollectionItemResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The item that has already been added.
	Item *CollectionItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *AddCollectionItemResponse) Reset() {
	*x = AddCollectionItemResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddCollectionItemResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddCollectionItemResponse) ProtoMessage() {}

func (x *AddCollectionItemResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddCollectionItemResponse.ProtoReflect.Descriptor instead.
func (*AddCollectionItemResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{39}
}

func (x *AddCollectionItemResponse) GetItem() *CollectionItem {
	if x != nil {
		return x.Item
	}
	return nil
}

// Request message for RemoveCollectionItem.
type RemoveCollectionItemRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The item to be removed.
	Item *CollectionItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *RemoveCollectionItemRequest) Reset() {
	*x = RemoveCollectionItemRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveCollectionItemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveCollectionItemRequest) ProtoMessage() {}

func (x *RemoveCollectionItemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveCollectionItemRequest.ProtoReflect.Descriptor instead.
func (*RemoveCollectionItemRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{40}
}

func (x *RemoveCollectionItemRequest) GetItem() *CollectionItem {
	if x != nil {
		return x.Item
	}
	return nil
}

// Request message for RemoveCollectionItem.
type RemoveCollectionItemResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The item that has already been removed.
	Item *CollectionItem `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *RemoveCollectionItemResponse) Reset() {
	*x = RemoveCollectionItemResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveCollectionItemResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveCollectionItemResponse) ProtoMessage() {}

func (x *RemoveCollectionItemResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveCollectionItemResponse.ProtoReflect.Descriptor instead.
func (*RemoveCollectionItemResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{41}
}

func (x *RemoveCollectionItemResponse) GetItem() *CollectionItem {
	if x != nil {
		return x.Item
	}
	return nil
}

// Request message for ViewCollectionItems.
type ViewCollectionItemsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The collection to view. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
	Collection string `protobuf:"bytes,1,opt,name=collection,proto3" json:"collection,omitempty"`
	// The maximum number of collections to return. The service may return fewer
	// than this value. If unspecified, at most 50 collections will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ViewCollectionItemsRequest` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ViewCollectionItemsRequest` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ViewCollectionItemsRequest) Reset() {
	*x = ViewCollectionItemsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ViewCollectionItemsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ViewCollectionItemsRequest) ProtoMessage() {}

func (x *ViewCollectionItemsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ViewCollectionItemsRequest.ProtoReflect.Descriptor instead.
func (*ViewCollectionItemsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{42}
}

func (x *ViewCollectionItemsRequest) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

func (x *ViewCollectionItemsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ViewCollectionItemsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ViewCollectionItems.
type ViewCollectionItemsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The items from the specified collection.
	Items []*CollectionItem `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ViewCollectionItemsResponse) Reset() {
	*x = ViewCollectionItemsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ViewCollectionItemsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ViewCollectionItemsResponse) ProtoMessage() {}

func (x *ViewCollectionItemsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ViewCollectionItemsResponse.ProtoReflect.Descriptor instead.
func (*ViewCollectionItemsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{43}
}

func (x *ViewCollectionItemsResponse) GetItems() []*CollectionItem {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ViewCollectionItemsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A collection is a resource in a corpus. It serves as a container of
// references to original resources.
type Collection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the collection. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The collection name for displaying.
	// The name can be up to 256 characters long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description of the collection. Can be up to 25000 characters
	// long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Collection) Reset() {
	*x = Collection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Collection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Collection) ProtoMessage() {}

func (x *Collection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Collection.ProtoReflect.Descriptor instead.
func (*Collection) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{44}
}

func (x *Collection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Collection) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Collection) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// A CollectionItem is an item in a collection.
// Each item is a reference to the original resource in a collection.
type CollectionItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The collection name that this item belongs to. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/collections/{collection}`
	Collection string `protobuf:"bytes,1,opt,name=collection,proto3" json:"collection,omitempty"`
	// Required. The type of item.
	Type CollectionItem_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.visionai.v1.CollectionItem_Type" json:"type,omitempty"`
	// Required. The name of the CollectionItem. Its format depends on the `type`
	// above. For ASSET:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
	ItemResource string `protobuf:"bytes,3,opt,name=item_resource,json=itemResource,proto3" json:"item_resource,omitempty"`
}

func (x *CollectionItem) Reset() {
	*x = CollectionItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CollectionItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CollectionItem) ProtoMessage() {}

func (x *CollectionItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CollectionItem.ProtoReflect.Descriptor instead.
func (*CollectionItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{45}
}

func (x *CollectionItem) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

func (x *CollectionItem) GetType() CollectionItem_Type {
	if x != nil {
		return x.Type
	}
	return CollectionItem_TYPE_UNSPECIFIED
}

func (x *CollectionItem) GetItemResource() string {
	if x != nil {
		return x.ItemResource
	}
	return ""
}

// Message for creating an Index.
type CreateIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for the parent. The resource name of the Corpus under which
	// this index is created. Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID for the index. This will become the final resource name
	// for the index. If the user does not specify this value, it will be
	// generated by system.
	//
	// This value should be up to 63 characters, and valid characters
	// are /[a-z][0-9]-/. The first character must be a letter, the last could be
	// a letter or a number.
	IndexId string `protobuf:"bytes,2,opt,name=index_id,json=indexId,proto3" json:"index_id,omitempty"`
	// Required. The index being created.
	Index *Index `protobuf:"bytes,3,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *CreateIndexRequest) Reset() {
	*x = CreateIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIndexRequest) ProtoMessage() {}

func (x *CreateIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIndexRequest.ProtoReflect.Descriptor instead.
func (*CreateIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{46}
}

func (x *CreateIndexRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIndexRequest) GetIndexId() string {
	if x != nil {
		return x.IndexId
	}
	return ""
}

func (x *CreateIndexRequest) GetIndex() *Index {
	if x != nil {
		return x.Index
	}
	return nil
}

// Metadata message for CreateIndexRequest
type CreateIndexMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
}

func (x *CreateIndexMetadata) Reset() {
	*x = CreateIndexMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIndexMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIndexMetadata) ProtoMessage() {}

func (x *CreateIndexMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIndexMetadata.ProtoReflect.Descriptor instead.
func (*CreateIndexMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{47}
}

func (x *CreateIndexMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

// Request message for UpdateIndex.
type UpdateIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource being updated.
	Index *Index `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// Index resource by the update. The fields specified in the update_mask are
	// relative to the resource, not the full request. A field of the resource
	// will be overwritten if it is in the mask. Empty field mask is not allowed.
	// If the mask is "*", it triggers a full update of the index, and also a
	// whole rebuild of index data.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIndexRequest) Reset() {
	*x = UpdateIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIndexRequest) ProtoMessage() {}

func (x *UpdateIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIndexRequest.ProtoReflect.Descriptor instead.
func (*UpdateIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{48}
}

func (x *UpdateIndexRequest) GetIndex() *Index {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *UpdateIndexRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Metadata message for UpdateIndexRequest
type UpdateIndexMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
}

func (x *UpdateIndexMetadata) Reset() {
	*x = UpdateIndexMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIndexMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIndexMetadata) ProtoMessage() {}

func (x *UpdateIndexMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIndexMetadata.ProtoReflect.Descriptor instead.
func (*UpdateIndexMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{49}
}

func (x *UpdateIndexMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

// Request message for getting an Index.
type GetIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Index resource.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIndexRequest) Reset() {
	*x = GetIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIndexRequest) ProtoMessage() {}

func (x *GetIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIndexRequest.ProtoReflect.Descriptor instead.
func (*GetIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{50}
}

func (x *GetIndexRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for listing Indexes.
type ListIndexesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent corpus that owns this collection of indexes.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of indexes to return. The service may return fewer than
	// this value.
	// If unspecified, at most 50 indexes will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListIndexes` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListIndexes` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIndexesRequest) Reset() {
	*x = ListIndexesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesRequest) ProtoMessage() {}

func (x *ListIndexesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesRequest.ProtoReflect.Descriptor instead.
func (*ListIndexesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{51}
}

func (x *ListIndexesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIndexesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIndexesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListIndexes.
type ListIndexesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The indexes under the specified corpus.
	Indexes []*Index `protobuf:"bytes,1,rep,name=indexes,proto3" json:"indexes,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIndexesResponse) Reset() {
	*x = ListIndexesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesResponse) ProtoMessage() {}

func (x *ListIndexesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesResponse.ProtoReflect.Descriptor instead.
func (*ListIndexesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{52}
}

func (x *ListIndexesResponse) GetIndexes() []*Index {
	if x != nil {
		return x.Indexes
	}
	return nil
}

func (x *ListIndexesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteIndex.
type DeleteIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the index to delete.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/indexes/{index}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIndexRequest) Reset() {
	*x = DeleteIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIndexRequest) ProtoMessage() {}

func (x *DeleteIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIndexRequest.ProtoReflect.Descriptor instead.
func (*DeleteIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{53}
}

func (x *DeleteIndexRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata message for DeleteIndexRequest
type DeleteIndexMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteIndexMetadata) Reset() {
	*x = DeleteIndexMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIndexMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIndexMetadata) ProtoMessage() {}

func (x *DeleteIndexMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIndexMetadata.ProtoReflect.Descriptor instead.
func (*DeleteIndexMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{54}
}

// An Index is a resource in Corpus. It contains an indexed version of the
// assets and annotations. When deployed to an endpoint, it will allow users to
// search the Index.
type Index struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies how assets are selected for this index. Default to
	// entire_corpus if unspecified. Behavior in UpdateIndex: if update_mask
	// includes one of the asset_filter field paths, the index will be rebuilt
	// with latest assets, including their analyzed data and annotations.
	//
	// Types that are assignable to AssetFilter:
	//
	//	*Index_EntireCorpus
	AssetFilter isIndex_AssetFilter `protobuf_oneof:"asset_filter"`
	// Output only. Resource name of the Index resource.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/indexes/{index_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Optional user-specified display name of the index.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Optional description of the index.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. State of the index.
	State Index_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.visionai.v1.Index_State" json:"state,omitempty"`
	// Output only. The create timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. References to the deployed index instance.
	// Index of VIDEO_ON_DEMAND corpus can have at most one deployed index.
	// Index of IMAGE corpus can have multiple deployed indexes.
	DeployedIndexes []*DeployedIndexReference `protobuf:"bytes,8,rep,name=deployed_indexes,json=deployedIndexes,proto3" json:"deployed_indexes,omitempty"`
}

func (x *Index) Reset() {
	*x = Index{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Index) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Index) ProtoMessage() {}

func (x *Index) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Index.ProtoReflect.Descriptor instead.
func (*Index) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{55}
}

func (m *Index) GetAssetFilter() isIndex_AssetFilter {
	if m != nil {
		return m.AssetFilter
	}
	return nil
}

func (x *Index) GetEntireCorpus() bool {
	if x, ok := x.GetAssetFilter().(*Index_EntireCorpus); ok {
		return x.EntireCorpus
	}
	return false
}

func (x *Index) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Index) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Index) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Index) GetState() Index_State {
	if x != nil {
		return x.State
	}
	return Index_STATE_UNSPECIFIED
}

func (x *Index) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Index) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Index) GetDeployedIndexes() []*DeployedIndexReference {
	if x != nil {
		return x.DeployedIndexes
	}
	return nil
}

type isIndex_AssetFilter interface {
	isIndex_AssetFilter()
}

type Index_EntireCorpus struct {
	// Include all assets under the corpus.
	EntireCorpus bool `protobuf:"varint,9,opt,name=entire_corpus,json=entireCorpus,proto3,oneof"`
}

func (*Index_EntireCorpus) isIndex_AssetFilter() {}

// Points to a DeployedIndex.
type DeployedIndexReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. A resource name of the IndexEndpoint.
	IndexEndpoint string `protobuf:"bytes,1,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
}

func (x *DeployedIndexReference) Reset() {
	*x = DeployedIndexReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployedIndexReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedIndexReference) ProtoMessage() {}

func (x *DeployedIndexReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedIndexReference.ProtoReflect.Descriptor instead.
func (*DeployedIndexReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{56}
}

func (x *DeployedIndexReference) GetIndexEndpoint() string {
	if x != nil {
		return x.IndexEndpoint
	}
	return ""
}

// Corpus is a set of media contents for management.
// Within a corpus, media shares the same data schema. Search is also restricted
// within a single corpus.
type Corpus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the corpus.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The corpus name to shown in the UI. The name can be up to 32
	// characters long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description of the corpus. Can be up to 25000 characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The default TTL value for all assets under the corpus without a
	// asset level user-defined TTL. For STREAM_VIDEO type corpora, this is
	// required and the maximum allowed
	//
	//	default_ttl is 10 years.
	DefaultTtl *durationpb.Duration `protobuf:"bytes,5,opt,name=default_ttl,json=defaultTtl,proto3" json:"default_ttl,omitempty"`
	// Optional. Type of the asset inside corpus.
	Type Corpus_Type `protobuf:"varint,7,opt,name=type,proto3,enum=google.cloud.visionai.v1.Corpus_Type" json:"type,omitempty"`
	// Default search capability setting on corpus level.
	SearchCapabilitySetting *SearchCapabilitySetting `protobuf:"bytes,8,opt,name=search_capability_setting,json=searchCapabilitySetting,proto3" json:"search_capability_setting,omitempty"`
}

func (x *Corpus) Reset() {
	*x = Corpus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Corpus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Corpus) ProtoMessage() {}

func (x *Corpus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Corpus.ProtoReflect.Descriptor instead.
func (*Corpus) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{57}
}

func (x *Corpus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Corpus) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Corpus) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Corpus) GetDefaultTtl() *durationpb.Duration {
	if x != nil {
		return x.DefaultTtl
	}
	return nil
}

func (x *Corpus) GetType() Corpus_Type {
	if x != nil {
		return x.Type
	}
	return Corpus_TYPE_UNSPECIFIED
}

func (x *Corpus) GetSearchCapabilitySetting() *SearchCapabilitySetting {
	if x != nil {
		return x.SearchCapabilitySetting
	}
	return nil
}

// Request message for GetCorpus.
type GetCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the corpus to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCorpusRequest) Reset() {
	*x = GetCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCorpusRequest) ProtoMessage() {}

func (x *GetCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCorpusRequest.ProtoReflect.Descriptor instead.
func (*GetCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{58}
}

func (x *GetCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateCorpus.
type UpdateCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The corpus which replaces the resource on the server.
	Corpus *Corpus `protobuf:"bytes,1,opt,name=corpus,proto3" json:"corpus,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCorpusRequest) Reset() {
	*x = UpdateCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCorpusRequest) ProtoMessage() {}

func (x *UpdateCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCorpusRequest.ProtoReflect.Descriptor instead.
func (*UpdateCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{59}
}

func (x *UpdateCorpusRequest) GetCorpus() *Corpus {
	if x != nil {
		return x.Corpus
	}
	return nil
}

func (x *UpdateCorpusRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCorpora.
type ListCorporaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project from which to list corpora.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. API may return fewer results than requested.
	// If negative, INVALID_ARGUMENT error will be returned.
	// If unspecified or 0, API will pick a default size, which is 10.
	// If the requested page size is larger than the maximum size, API will pick
	// use the maximum size, which is 20.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return.
	// Typically obtained via
	// [ListCorporaResponse.next_page_token][google.cloud.visionai.v1.ListCorporaResponse.next_page_token]
	// of the previous
	// [Warehouse.ListCorpora][google.cloud.visionai.v1.Warehouse.ListCorpora]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The filter applied to the returned corpora list.
	// Only the following restrictions are supported:
	// `type=<Corpus.Type>`,
	// `type!=<Corpus.Type>`.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListCorporaRequest) Reset() {
	*x = ListCorporaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCorporaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCorporaRequest) ProtoMessage() {}

func (x *ListCorporaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCorporaRequest.ProtoReflect.Descriptor instead.
func (*ListCorporaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{60}
}

func (x *ListCorporaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCorporaRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCorporaRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCorporaRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ListCorpora.
type ListCorporaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The corpora in the project.
	Corpora []*Corpus `protobuf:"bytes,1,rep,name=corpora,proto3" json:"corpora,omitempty"`
	// A token to retrieve next page of results.
	// Pass to
	// [ListCorporaRequest.page_token][google.cloud.visionai.v1.ListCorporaRequest.page_token]
	// to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCorporaResponse) Reset() {
	*x = ListCorporaResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCorporaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCorporaResponse) ProtoMessage() {}

func (x *ListCorporaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCorporaResponse.ProtoReflect.Descriptor instead.
func (*ListCorporaResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{61}
}

func (x *ListCorporaResponse) GetCorpora() []*Corpus {
	if x != nil {
		return x.Corpora
	}
	return nil
}

func (x *ListCorporaResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteCorpus.
type DeleteCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the corpus to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCorpusRequest) Reset() {
	*x = DeleteCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCorpusRequest) ProtoMessage() {}

func (x *DeleteCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCorpusRequest.ProtoReflect.Descriptor instead.
func (*DeleteCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{62}
}

func (x *DeleteCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for AnalyzeCorpus.
type AnalyzeCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent corpus resource where the assets will be analyzed.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AnalyzeCorpusRequest) Reset() {
	*x = AnalyzeCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeCorpusRequest) ProtoMessage() {}

func (x *AnalyzeCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeCorpusRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{63}
}

func (x *AnalyzeCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The metadata message for AnalyzeCorpus LRO.
type AnalyzeCorpusMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata of the operation.
	Metadata *OperationMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *AnalyzeCorpusMetadata) Reset() {
	*x = AnalyzeCorpusMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeCorpusMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeCorpusMetadata) ProtoMessage() {}

func (x *AnalyzeCorpusMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeCorpusMetadata.ProtoReflect.Descriptor instead.
func (*AnalyzeCorpusMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{64}
}

func (x *AnalyzeCorpusMetadata) GetMetadata() *OperationMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// The response message for AnalyzeCorpus LRO.
type AnalyzeCorpusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AnalyzeCorpusResponse) Reset() {
	*x = AnalyzeCorpusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeCorpusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeCorpusResponse) ProtoMessage() {}

func (x *AnalyzeCorpusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeCorpusResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeCorpusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{65}
}

// Request message for CreateDataSchema.
type CreateDataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this data schema will be created.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The data schema to create.
	DataSchema *DataSchema `protobuf:"bytes,2,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
}

func (x *CreateDataSchemaRequest) Reset() {
	*x = CreateDataSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataSchemaRequest) ProtoMessage() {}

func (x *CreateDataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataSchemaRequest.ProtoReflect.Descriptor instead.
func (*CreateDataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{66}
}

func (x *CreateDataSchemaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataSchemaRequest) GetDataSchema() *DataSchema {
	if x != nil {
		return x.DataSchema
	}
	return nil
}

// Data schema indicates how the user specified annotation is interpreted in the
// system.
type DataSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the data schema in the form of:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}`
	// where {data_schema} part should be the same as the `key` field below.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The key of this data schema. This key should be matching the key
	// of user specified annotation and unique inside corpus. This value can be up
	// to 63 characters, and valid characters are /[a-z][0-9]-/. The first
	// character must be a letter, the last could be a letter or a number.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// The schema details mapping to the key.
	SchemaDetails *DataSchemaDetails `protobuf:"bytes,3,opt,name=schema_details,json=schemaDetails,proto3" json:"schema_details,omitempty"`
}

func (x *DataSchema) Reset() {
	*x = DataSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchema) ProtoMessage() {}

func (x *DataSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchema.ProtoReflect.Descriptor instead.
func (*DataSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{67}
}

func (x *DataSchema) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataSchema) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *DataSchema) GetSchemaDetails() *DataSchemaDetails {
	if x != nil {
		return x.SchemaDetails
	}
	return nil
}

// Data schema details indicates the data type and the data struct corresponding
// to the key of user specified annotation.
type DataSchemaDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the annotation.
	Type *DataSchemaDetails_DataType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.visionai.v1.DataSchemaDetails_DataType,oneof" json:"type,omitempty"`
	// Config for protobuf any type.
	ProtoAnyConfig *DataSchemaDetails_ProtoAnyConfig `protobuf:"bytes,6,opt,name=proto_any_config,json=protoAnyConfig,proto3" json:"proto_any_config,omitempty"`
	// Config for List data type.
	ListConfig *DataSchemaDetails_ListConfig `protobuf:"bytes,8,opt,name=list_config,json=listConfig,proto3" json:"list_config,omitempty"`
	// Config for CustomizedStruct data type.
	CustomizedStructConfig *DataSchemaDetails_CustomizedStructConfig `protobuf:"bytes,9,opt,name=customized_struct_config,json=customizedStructConfig,proto3" json:"customized_struct_config,omitempty"`
	// The granularity associated with this DataSchema.
	Granularity *DataSchemaDetails_Granularity `protobuf:"varint,5,opt,name=granularity,proto3,enum=google.cloud.visionai.v1.DataSchemaDetails_Granularity,oneof" json:"granularity,omitempty"`
	// The search strategy to be applied on the `key` above.
	SearchStrategy *DataSchemaDetails_SearchStrategy `protobuf:"bytes,7,opt,name=search_strategy,json=searchStrategy,proto3" json:"search_strategy,omitempty"`
}

func (x *DataSchemaDetails) Reset() {
	*x = DataSchemaDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails) ProtoMessage() {}

func (x *DataSchemaDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68}
}

func (x *DataSchemaDetails) GetType() DataSchemaDetails_DataType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return DataSchemaDetails_DATA_TYPE_UNSPECIFIED
}

func (x *DataSchemaDetails) GetProtoAnyConfig() *DataSchemaDetails_ProtoAnyConfig {
	if x != nil {
		return x.ProtoAnyConfig
	}
	return nil
}

func (x *DataSchemaDetails) GetListConfig() *DataSchemaDetails_ListConfig {
	if x != nil {
		return x.ListConfig
	}
	return nil
}

func (x *DataSchemaDetails) GetCustomizedStructConfig() *DataSchemaDetails_CustomizedStructConfig {
	if x != nil {
		return x.CustomizedStructConfig
	}
	return nil
}

func (x *DataSchemaDetails) GetGranularity() DataSchemaDetails_Granularity {
	if x != nil && x.Granularity != nil {
		return *x.Granularity
	}
	return DataSchemaDetails_GRANULARITY_UNSPECIFIED
}

func (x *DataSchemaDetails) GetSearchStrategy() *DataSchemaDetails_SearchStrategy {
	if x != nil {
		return x.SearchStrategy
	}
	return nil
}

// Request message for UpdateDataSchema.
type UpdateDataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The data schema's `name` field is used to identify the data
	// schema to be updated. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}`
	DataSchema *DataSchema `protobuf:"bytes,1,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataSchemaRequest) Reset() {
	*x = UpdateDataSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataSchemaRequest) ProtoMessage() {}

func (x *UpdateDataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataSchemaRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{69}
}

func (x *UpdateDataSchemaRequest) GetDataSchema() *DataSchema {
	if x != nil {
		return x.DataSchema
	}
	return nil
}

func (x *UpdateDataSchemaRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDataSchema.
type GetDataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the data schema to retrieve.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataSchemaRequest) Reset() {
	*x = GetDataSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataSchemaRequest) ProtoMessage() {}

func (x *GetDataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataSchemaRequest.ProtoReflect.Descriptor instead.
func (*GetDataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{70}
}

func (x *GetDataSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteDataSchema.
type DeleteDataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the data schema to delete.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataSchemaRequest) Reset() {
	*x = DeleteDataSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataSchemaRequest) ProtoMessage() {}

func (x *DeleteDataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataSchemaRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{71}
}

func (x *DeleteDataSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDataSchemas.
type ListDataSchemasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of data schemas.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of data schemas to return. The service may return fewer
	// than this value. If unspecified, at most 50 data schemas will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDataSchemas` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDataSchemas` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataSchemasRequest) Reset() {
	*x = ListDataSchemasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataSchemasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSchemasRequest) ProtoMessage() {}

func (x *ListDataSchemasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSchemasRequest.ProtoReflect.Descriptor instead.
func (*ListDataSchemasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{72}
}

func (x *ListDataSchemasRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataSchemasRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataSchemasRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDataSchemas.
type ListDataSchemasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data schemas from the specified corpus.
	DataSchemas []*DataSchema `protobuf:"bytes,1,rep,name=data_schemas,json=dataSchemas,proto3" json:"data_schemas,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataSchemasResponse) Reset() {
	*x = ListDataSchemasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataSchemasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSchemasResponse) ProtoMessage() {}

func (x *ListDataSchemasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSchemasResponse.ProtoReflect.Descriptor instead.
func (*ListDataSchemasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{73}
}

func (x *ListDataSchemasResponse) GetDataSchemas() []*DataSchema {
	if x != nil {
		return x.DataSchemas
	}
	return nil
}

func (x *ListDataSchemasResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateAnnotation.
type CreateAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this annotation will be created.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The annotation to create.
	Annotation *Annotation `protobuf:"bytes,2,opt,name=annotation,proto3" json:"annotation,omitempty"`
	// Optional. The ID to use for the annotation, which will become the final
	// component of the annotation's resource name if user choose to specify.
	// Otherwise, annotation id will be generated by system.
	//
	// This value should be up to 63 characters, and valid characters
	// are /[a-z][0-9]-/. The first character must be a letter, the last could be
	// a letter or a number.
	AnnotationId *string `protobuf:"bytes,3,opt,name=annotation_id,json=annotationId,proto3,oneof" json:"annotation_id,omitempty"`
}

func (x *CreateAnnotationRequest) Reset() {
	*x = CreateAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnnotationRequest) ProtoMessage() {}

func (x *CreateAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnnotationRequest.ProtoReflect.Descriptor instead.
func (*CreateAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{74}
}

func (x *CreateAnnotationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnnotationRequest) GetAnnotation() *Annotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

func (x *CreateAnnotationRequest) GetAnnotationId() string {
	if x != nil && x.AnnotationId != nil {
		return *x.AnnotationId
	}
	return ""
}

// An annotation is a resource in asset. It represents a key-value mapping of
// content in asset.
type Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the annotation.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided annotation.
	UserSpecifiedAnnotation *UserSpecifiedAnnotation `protobuf:"bytes,2,opt,name=user_specified_annotation,json=userSpecifiedAnnotation,proto3" json:"user_specified_annotation,omitempty"`
}

func (x *Annotation) Reset() {
	*x = Annotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotation) ProtoMessage() {}

func (x *Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Annotation.ProtoReflect.Descriptor instead.
func (*Annotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{75}
}

func (x *Annotation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Annotation) GetUserSpecifiedAnnotation() *UserSpecifiedAnnotation {
	if x != nil {
		return x.UserSpecifiedAnnotation
	}
	return nil
}

// Annotation provided by users.
type UserSpecifiedAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Key of the annotation. The key must be set with type by
	// CreateDataSchema.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value of the annotation. The value must be able to convert
	// to the type according to the data schema.
	Value *AnnotationValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Partition information in time and space for the sub-asset level annotation.
	Partition *Partition `protobuf:"bytes,3,opt,name=partition,proto3" json:"partition,omitempty"`
}

func (x *UserSpecifiedAnnotation) Reset() {
	*x = UserSpecifiedAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSpecifiedAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSpecifiedAnnotation) ProtoMessage() {}

func (x *UserSpecifiedAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSpecifiedAnnotation.ProtoReflect.Descriptor instead.
func (*UserSpecifiedAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{76}
}

func (x *UserSpecifiedAnnotation) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *UserSpecifiedAnnotation) GetValue() *AnnotationValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *UserSpecifiedAnnotation) GetPartition() *Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

// Location Coordinate Representation
type GeoCoordinate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Latitude Coordinate. Degrees [-90 .. 90]
	Latitude float64 `protobuf:"fixed64,1,opt,name=latitude,proto3" json:"latitude,omitempty"`
	// Longitude Coordinate. Degrees [-180 .. 180]
	Longitude float64 `protobuf:"fixed64,2,opt,name=longitude,proto3" json:"longitude,omitempty"`
}

func (x *GeoCoordinate) Reset() {
	*x = GeoCoordinate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GeoCoordinate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeoCoordinate) ProtoMessage() {}

func (x *GeoCoordinate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeoCoordinate.ProtoReflect.Descriptor instead.
func (*GeoCoordinate) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{77}
}

func (x *GeoCoordinate) GetLatitude() float64 {
	if x != nil {
		return x.Latitude
	}
	return 0
}

func (x *GeoCoordinate) GetLongitude() float64 {
	if x != nil {
		return x.Longitude
	}
	return 0
}

// Value of annotation, including all types available in data schema.
type AnnotationValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*AnnotationValue_IntValue
	//	*AnnotationValue_FloatValue
	//	*AnnotationValue_StrValue
	//	*AnnotationValue_DatetimeValue
	//	*AnnotationValue_GeoCoordinate
	//	*AnnotationValue_ProtoAnyValue
	//	*AnnotationValue_BoolValue
	//	*AnnotationValue_CustomizedStructDataValue
	//	*AnnotationValue_ListValue
	//	*AnnotationValue_CustomizedStructValue
	Value isAnnotationValue_Value `protobuf_oneof:"value"`
}

func (x *AnnotationValue) Reset() {
	*x = AnnotationValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationValue) ProtoMessage() {}

func (x *AnnotationValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationValue.ProtoReflect.Descriptor instead.
func (*AnnotationValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{78}
}

func (m *AnnotationValue) GetValue() isAnnotationValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *AnnotationValue) GetIntValue() int64 {
	if x, ok := x.GetValue().(*AnnotationValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *AnnotationValue) GetFloatValue() float32 {
	if x, ok := x.GetValue().(*AnnotationValue_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (x *AnnotationValue) GetStrValue() string {
	if x, ok := x.GetValue().(*AnnotationValue_StrValue); ok {
		return x.StrValue
	}
	return ""
}

func (x *AnnotationValue) GetDatetimeValue() string {
	if x, ok := x.GetValue().(*AnnotationValue_DatetimeValue); ok {
		return x.DatetimeValue
	}
	return ""
}

func (x *AnnotationValue) GetGeoCoordinate() *GeoCoordinate {
	if x, ok := x.GetValue().(*AnnotationValue_GeoCoordinate); ok {
		return x.GeoCoordinate
	}
	return nil
}

func (x *AnnotationValue) GetProtoAnyValue() *anypb.Any {
	if x, ok := x.GetValue().(*AnnotationValue_ProtoAnyValue); ok {
		return x.ProtoAnyValue
	}
	return nil
}

func (x *AnnotationValue) GetBoolValue() bool {
	if x, ok := x.GetValue().(*AnnotationValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *AnnotationValue) GetCustomizedStructDataValue() *structpb.Struct {
	if x, ok := x.GetValue().(*AnnotationValue_CustomizedStructDataValue); ok {
		return x.CustomizedStructDataValue
	}
	return nil
}

func (x *AnnotationValue) GetListValue() *AnnotationList {
	if x, ok := x.GetValue().(*AnnotationValue_ListValue); ok {
		return x.ListValue
	}
	return nil
}

func (x *AnnotationValue) GetCustomizedStructValue() *AnnotationCustomizedStruct {
	if x, ok := x.GetValue().(*AnnotationValue_CustomizedStructValue); ok {
		return x.CustomizedStructValue
	}
	return nil
}

type isAnnotationValue_Value interface {
	isAnnotationValue_Value()
}

type AnnotationValue_IntValue struct {
	// Value of int type annotation.
	IntValue int64 `protobuf:"varint,1,opt,name=int_value,json=intValue,proto3,oneof"`
}

type AnnotationValue_FloatValue struct {
	// Value of float type annotation.
	FloatValue float32 `protobuf:"fixed32,2,opt,name=float_value,json=floatValue,proto3,oneof"`
}

type AnnotationValue_StrValue struct {
	// Value of string type annotation.
	StrValue string `protobuf:"bytes,3,opt,name=str_value,json=strValue,proto3,oneof"`
}

type AnnotationValue_DatetimeValue struct {
	// Value of date time type annotation.
	DatetimeValue string `protobuf:"bytes,5,opt,name=datetime_value,json=datetimeValue,proto3,oneof"`
}

type AnnotationValue_GeoCoordinate struct {
	// Value of geo coordinate type annotation.
	GeoCoordinate *GeoCoordinate `protobuf:"bytes,7,opt,name=geo_coordinate,json=geoCoordinate,proto3,oneof"`
}

type AnnotationValue_ProtoAnyValue struct {
	// Value of any proto value.
	ProtoAnyValue *anypb.Any `protobuf:"bytes,8,opt,name=proto_any_value,json=protoAnyValue,proto3,oneof"`
}

type AnnotationValue_BoolValue struct {
	// Value of boolean type annotation.
	BoolValue bool `protobuf:"varint,9,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type AnnotationValue_CustomizedStructDataValue struct {
	// Value of customized struct annotation. This field does not have effects.
	// Use customized_struct_value instead for customized struct annotation.
	CustomizedStructDataValue *structpb.Struct `protobuf:"bytes,10,opt,name=customized_struct_data_value,json=customizedStructDataValue,proto3,oneof"`
}

type AnnotationValue_ListValue struct {
	// Value of list type annotation.
	ListValue *AnnotationList `protobuf:"bytes,11,opt,name=list_value,json=listValue,proto3,oneof"`
}

type AnnotationValue_CustomizedStructValue struct {
	// Value of custom struct type annotation.
	CustomizedStructValue *AnnotationCustomizedStruct `protobuf:"bytes,6,opt,name=customized_struct_value,json=customizedStructValue,proto3,oneof"`
}

func (*AnnotationValue_IntValue) isAnnotationValue_Value() {}

func (*AnnotationValue_FloatValue) isAnnotationValue_Value() {}

func (*AnnotationValue_StrValue) isAnnotationValue_Value() {}

func (*AnnotationValue_DatetimeValue) isAnnotationValue_Value() {}

func (*AnnotationValue_GeoCoordinate) isAnnotationValue_Value() {}

func (*AnnotationValue_ProtoAnyValue) isAnnotationValue_Value() {}

func (*AnnotationValue_BoolValue) isAnnotationValue_Value() {}

func (*AnnotationValue_CustomizedStructDataValue) isAnnotationValue_Value() {}

func (*AnnotationValue_ListValue) isAnnotationValue_Value() {}

func (*AnnotationValue_CustomizedStructValue) isAnnotationValue_Value() {}

// List representation in annotation.
type AnnotationList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The values of `LIST` data type annotation.
	Values []*AnnotationValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *AnnotationList) Reset() {
	*x = AnnotationList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationList) ProtoMessage() {}

func (x *AnnotationList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationList.ProtoReflect.Descriptor instead.
func (*AnnotationList) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{79}
}

func (x *AnnotationList) GetValues() []*AnnotationValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// Customized struct represnation in annotation.
type AnnotationCustomizedStruct struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A map from elements' keys to element's annotation value.
	Elements map[string]*AnnotationValue `protobuf:"bytes,2,rep,name=elements,proto3" json:"elements,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AnnotationCustomizedStruct) Reset() {
	*x = AnnotationCustomizedStruct{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationCustomizedStruct) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationCustomizedStruct) ProtoMessage() {}

func (x *AnnotationCustomizedStruct) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationCustomizedStruct.ProtoReflect.Descriptor instead.
func (*AnnotationCustomizedStruct) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{80}
}

func (x *AnnotationCustomizedStruct) GetElements() map[string]*AnnotationValue {
	if x != nil {
		return x.Elements
	}
	return nil
}

// Request message for GetAnnotation API.
type ListAnnotationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent, which owns this collection of annotations.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of annotations to return. The service may return fewer
	// than this value. If unspecified, at most 50 annotations will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAnnotations` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAnnotations` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The filter applied to the returned list.
	// We only support filtering for the following fields:
	// For corpus of STREAM_VIDEO type:
	// `partition.temporal_partition.start_time`,
	// `partition.temporal_partition.end_time`, and `key`.
	// For corpus of VIDEO_ON_DEMAND type,
	// `partition.relative_temporal_partition.start_offset`,
	// `partition.relative_temporal_partition.end_offset`, and `key`.
	// For corpus of IMAGE type, only `key` is supported.
	// Timestamps are specified in the RFC-3339 format, and only one restriction
	// may be applied per field, joined by conjunctions.
	// Format:
	// "partition.temporal_partition.start_time > "2012-04-21T11:30:00-04:00" AND
	// partition.temporal_partition.end_time < "2012-04-22T11:30:00-04:00" AND
	// key = "example_key""
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAnnotationsRequest) Reset() {
	*x = ListAnnotationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsRequest) ProtoMessage() {}

func (x *ListAnnotationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsRequest.ProtoReflect.Descriptor instead.
func (*ListAnnotationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{81}
}

func (x *ListAnnotationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnnotationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnnotationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAnnotationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Request message for ListAnnotations API.
type ListAnnotationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotations from the specified asset.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnnotationsResponse) Reset() {
	*x = ListAnnotationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsResponse) ProtoMessage() {}

func (x *ListAnnotationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsResponse.ProtoReflect.Descriptor instead.
func (*ListAnnotationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{82}
}

func (x *ListAnnotationsResponse) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ListAnnotationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetAnnotation API.
type GetAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the annotation to retrieve.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAnnotationRequest) Reset() {
	*x = GetAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnnotationRequest) ProtoMessage() {}

func (x *GetAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnnotationRequest.ProtoReflect.Descriptor instead.
func (*GetAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{83}
}

func (x *GetAnnotationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAnnotation API.
type UpdateAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The annotation to update.
	// The annotation's `name` field is used to identify the annotation to be
	// updated. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
	Annotation *Annotation `protobuf:"bytes,1,opt,name=annotation,proto3" json:"annotation,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAnnotationRequest) Reset() {
	*x = UpdateAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnnotationRequest) ProtoMessage() {}

func (x *UpdateAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnnotationRequest.ProtoReflect.Descriptor instead.
func (*UpdateAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{84}
}

func (x *UpdateAnnotationRequest) GetAnnotation() *Annotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

func (x *UpdateAnnotationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteAnnotation API.
type DeleteAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the annotation to delete.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAnnotationRequest) Reset() {
	*x = DeleteAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnnotationRequest) ProtoMessage() {}

func (x *DeleteAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnnotationRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{85}
}

func (x *DeleteAnnotationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for ImportAssets.
type ImportAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source.
	//
	// Types that are assignable to Source:
	//
	//	*ImportAssetsRequest_AssetsGcsUri
	Source isImportAssetsRequest_Source `protobuf_oneof:"source"`
	// Required. The parent corpus resource where the assets will be imported.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ImportAssetsRequest) Reset() {
	*x = ImportAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAssetsRequest) ProtoMessage() {}

func (x *ImportAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAssetsRequest.ProtoReflect.Descriptor instead.
func (*ImportAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{86}
}

func (m *ImportAssetsRequest) GetSource() isImportAssetsRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportAssetsRequest) GetAssetsGcsUri() string {
	if x, ok := x.GetSource().(*ImportAssetsRequest_AssetsGcsUri); ok {
		return x.AssetsGcsUri
	}
	return ""
}

func (x *ImportAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

type isImportAssetsRequest_Source interface {
	isImportAssetsRequest_Source()
}

type ImportAssetsRequest_AssetsGcsUri struct {
	// The file contains all assets information to be imported.
	// * The file is in JSONL format.
	// * Each line corresponding to one asset.
	// * Each line will be converted into InputImageAsset proto.
	AssetsGcsUri string `protobuf:"bytes,2,opt,name=assets_gcs_uri,json=assetsGcsUri,proto3,oneof"`
}

func (*ImportAssetsRequest_AssetsGcsUri) isImportAssetsRequest_Source() {}

// The metadata message for ImportAssets LRO.
type ImportAssetsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata of the operation.
	Metadata *OperationMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ImportAssetsMetadata) Reset() {
	*x = ImportAssetsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAssetsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAssetsMetadata) ProtoMessage() {}

func (x *ImportAssetsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAssetsMetadata.ProtoReflect.Descriptor instead.
func (*ImportAssetsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{87}
}

func (x *ImportAssetsMetadata) GetMetadata() *OperationMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// The response message for ImportAssets LRO.
type ImportAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportAssetsResponse) Reset() {
	*x = ImportAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAssetsResponse) ProtoMessage() {}

func (x *ImportAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAssetsResponse.ProtoReflect.Descriptor instead.
func (*ImportAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{88}
}

// Request message for CreateSearchConfig.
type CreateSearchConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this search configuration will be
	// created. Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The search config to create.
	SearchConfig *SearchConfig `protobuf:"bytes,2,opt,name=search_config,json=searchConfig,proto3" json:"search_config,omitempty"`
	// Required. ID to use for the new search config. Will become the final
	// component of the SearchConfig's resource name. This value should be up to
	// 63 characters, and valid characters are /[a-z][0-9]-_/. The first character
	// must be a letter, the last could be a letter or a number.
	SearchConfigId string `protobuf:"bytes,3,opt,name=search_config_id,json=searchConfigId,proto3" json:"search_config_id,omitempty"`
}

func (x *CreateSearchConfigRequest) Reset() {
	*x = CreateSearchConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSearchConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSearchConfigRequest) ProtoMessage() {}

func (x *CreateSearchConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSearchConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateSearchConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{89}
}

func (x *CreateSearchConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSearchConfigRequest) GetSearchConfig() *SearchConfig {
	if x != nil {
		return x.SearchConfig
	}
	return nil
}

func (x *CreateSearchConfigRequest) GetSearchConfigId() string {
	if x != nil {
		return x.SearchConfigId
	}
	return ""
}

// Request message for UpdateSearchConfig.
type UpdateSearchConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The search configuration to update.
	//
	// The search configuration's `name` field is used to identify the resource to
	// be updated. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
	SearchConfig *SearchConfig `protobuf:"bytes,1,opt,name=search_config,json=searchConfig,proto3" json:"search_config,omitempty"`
	// The list of fields to be updated. If left unset, all field paths will be
	// updated/overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSearchConfigRequest) Reset() {
	*x = UpdateSearchConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSearchConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSearchConfigRequest) ProtoMessage() {}

func (x *UpdateSearchConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSearchConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateSearchConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{90}
}

func (x *UpdateSearchConfigRequest) GetSearchConfig() *SearchConfig {
	if x != nil {
		return x.SearchConfig
	}
	return nil
}

func (x *UpdateSearchConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetSearchConfig.
type GetSearchConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the search configuration to retrieve.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSearchConfigRequest) Reset() {
	*x = GetSearchConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSearchConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSearchConfigRequest) ProtoMessage() {}

func (x *GetSearchConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSearchConfigRequest.ProtoReflect.Descriptor instead.
func (*GetSearchConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{91}
}

func (x *GetSearchConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteSearchConfig.
type DeleteSearchConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the search configuration to delete.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSearchConfigRequest) Reset() {
	*x = DeleteSearchConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSearchConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSearchConfigRequest) ProtoMessage() {}

func (x *DeleteSearchConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSearchConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteSearchConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{92}
}

func (x *DeleteSearchConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListSearchConfigs.
type ListSearchConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of search configurations.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of search configurations to return. The service may
	// return fewer than this value. If unspecified, a page size of 50 will be
	// used. The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSearchConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListSearchConfigs` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSearchConfigsRequest) Reset() {
	*x = ListSearchConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSearchConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSearchConfigsRequest) ProtoMessage() {}

func (x *ListSearchConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSearchConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListSearchConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{93}
}

func (x *ListSearchConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSearchConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSearchConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListSearchConfigs.
type ListSearchConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search configurations from the specified corpus.
	SearchConfigs []*SearchConfig `protobuf:"bytes,1,rep,name=search_configs,json=searchConfigs,proto3" json:"search_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSearchConfigsResponse) Reset() {
	*x = ListSearchConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSearchConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSearchConfigsResponse) ProtoMessage() {}

func (x *ListSearchConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSearchConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListSearchConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{94}
}

func (x *ListSearchConfigsResponse) GetSearchConfigs() []*SearchConfig {
	if x != nil {
		return x.SearchConfigs
	}
	return nil
}

func (x *ListSearchConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// SearchConfig stores different properties that will affect search
// behaviors and search results.
type SearchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the search configuration.
	// For CustomSearchCriteria, search_config would be the search
	// operator name. For Facets, search_config would be the facet
	// dimension name.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Establishes a FacetDimension and associated specifications.
	FacetProperty *FacetProperty `protobuf:"bytes,2,opt,name=facet_property,json=facetProperty,proto3" json:"facet_property,omitempty"`
	// Creates a mapping between a custom SearchCriteria and one or more UGA keys.
	SearchCriteriaProperty *SearchCriteriaProperty `protobuf:"bytes,3,opt,name=search_criteria_property,json=searchCriteriaProperty,proto3" json:"search_criteria_property,omitempty"`
}

func (x *SearchConfig) Reset() {
	*x = SearchConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchConfig) ProtoMessage() {}

func (x *SearchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchConfig.ProtoReflect.Descriptor instead.
func (*SearchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{95}
}

func (x *SearchConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchConfig) GetFacetProperty() *FacetProperty {
	if x != nil {
		return x.FacetProperty
	}
	return nil
}

func (x *SearchConfig) GetSearchCriteriaProperty() *SearchCriteriaProperty {
	if x != nil {
		return x.SearchCriteriaProperty
	}
	return nil
}

// Message representing IndexEndpoint resource. Indexes are deployed into it.
type IndexEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the IndexEndpoint.
	// Format:
	// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Display name of the IndexEndpoint. Can be up to 32 characters
	// long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description of the IndexEndpoint. Can be up to 25000 characters
	// long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The Index deployed in this IndexEndpoint.
	DeployedIndex *DeployedIndex `protobuf:"bytes,9,opt,name=deployed_index,json=deployedIndex,proto3" json:"deployed_index,omitempty"`
	// Output only. IndexEndpoint state.
	State IndexEndpoint_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.visionai.v1.IndexEndpoint_State" json:"state,omitempty"`
	// Optional. The labels applied to a resource must meet the following
	// requirements:
	//
	//   - Each resource can have multiple labels, up to a maximum of 64.
	//   - Each label must be a key-value pair.
	//   - Keys have a minimum length of 1 character and a maximum length of 63
	//     characters and cannot be empty. Values can be empty and have a maximum
	//     length of 63 characters.
	//   - Keys and values can contain only lowercase letters, numeric characters,
	//     underscores, and dashes. All characters must use UTF-8 encoding, and
	//     international characters are allowed.
	//   - The key portion of a label must be unique. However, you can use the same
	//     key with multiple resources.
	//   - Keys must start with a lowercase letter or international character.
	//
	// See [Google Cloud
	// Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Create timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *IndexEndpoint) Reset() {
	*x = IndexEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexEndpoint) ProtoMessage() {}

func (x *IndexEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexEndpoint.ProtoReflect.Descriptor instead.
func (*IndexEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{96}
}

func (x *IndexEndpoint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IndexEndpoint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *IndexEndpoint) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *IndexEndpoint) GetDeployedIndex() *DeployedIndex {
	if x != nil {
		return x.DeployedIndex
	}
	return nil
}

func (x *IndexEndpoint) GetState() IndexEndpoint_State {
	if x != nil {
		return x.State
	}
	return IndexEndpoint_STATE_UNSPECIFIED
}

func (x *IndexEndpoint) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *IndexEndpoint) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *IndexEndpoint) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for CreateIndexEndpoint.
type CreateIndexEndpointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The ID to use for the IndexEndpoint, which will become the final
	// component of the IndexEndpoint's resource name if the user specifies it.
	// Otherwise, IndexEndpoint id will be autogenerated.
	//
	// This value should be up to 63 characters, and valid characters
	// are a-z, 0-9 and dash (-). The first character must be a letter, the last
	// must be a letter or a number.
	IndexEndpointId string `protobuf:"bytes,2,opt,name=index_endpoint_id,json=indexEndpointId,proto3" json:"index_endpoint_id,omitempty"`
	// Required. The resource being created.
	IndexEndpoint *IndexEndpoint `protobuf:"bytes,3,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
}

func (x *CreateIndexEndpointRequest) Reset() {
	*x = CreateIndexEndpointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIndexEndpointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIndexEndpointRequest) ProtoMessage() {}

func (x *CreateIndexEndpointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIndexEndpointRequest.ProtoReflect.Descriptor instead.
func (*CreateIndexEndpointRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{97}
}

func (x *CreateIndexEndpointRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIndexEndpointRequest) GetIndexEndpointId() string {
	if x != nil {
		return x.IndexEndpointId
	}
	return ""
}

func (x *CreateIndexEndpointRequest) GetIndexEndpoint() *IndexEndpoint {
	if x != nil {
		return x.IndexEndpoint
	}
	return nil
}

// Metadata message for CreateIndexEndpoint.
type CreateIndexEndpointMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
}

func (x *CreateIndexEndpointMetadata) Reset() {
	*x = CreateIndexEndpointMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIndexEndpointMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIndexEndpointMetadata) ProtoMessage() {}

func (x *CreateIndexEndpointMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIndexEndpointMetadata.ProtoReflect.Descriptor instead.
func (*CreateIndexEndpointMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{98}
}

func (x *CreateIndexEndpointMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

// Request message for GetIndexEndpoint.
type GetIndexEndpointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the IndexEndpoint resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIndexEndpointRequest) Reset() {
	*x = GetIndexEndpointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIndexEndpointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIndexEndpointRequest) ProtoMessage() {}

func (x *GetIndexEndpointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIndexEndpointRequest.ProtoReflect.Descriptor instead.
func (*GetIndexEndpointRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{99}
}

func (x *GetIndexEndpointRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListIndexEndpoints.
type ListIndexEndpointsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. The service may return fewer than this value. If unspecified, a
	// page size of 50 will be used. The maximum value is 1000; values above 1000
	// will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter applied to the returned list.
	// We only support filtering for the `deployed_image_index.image_index` field.
	// However, to filter by a corpus instead of an image index, simply use
	// `deployed_image_index.corpus`, which will return all endpoints with
	// `deployed_image_index.image_index` inside of the given corpus.
	// A basic filter on image index would look like:
	//
	//	deployed_image_index.image_index =
	//	  "projects/123/locations/us-central1/corpora/my_corpus/imageIndexes/my_image_index"
	//
	// A basic filter on corpus would look like:
	//
	//	deployed_image_index.corpus =
	//	  "projects/123/locations/us-central1/corpora/my_corpus"
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListIndexEndpointsRequest) Reset() {
	*x = ListIndexEndpointsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexEndpointsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexEndpointsRequest) ProtoMessage() {}

func (x *ListIndexEndpointsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexEndpointsRequest.ProtoReflect.Descriptor instead.
func (*ListIndexEndpointsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{100}
}

func (x *ListIndexEndpointsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIndexEndpointsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIndexEndpointsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListIndexEndpointsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for ListIndexEndpoints.
type ListIndexEndpointsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of IndexEndpoints.
	IndexEndpoints []*IndexEndpoint `protobuf:"bytes,1,rep,name=index_endpoints,json=indexEndpoints,proto3" json:"index_endpoints,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIndexEndpointsResponse) Reset() {
	*x = ListIndexEndpointsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexEndpointsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexEndpointsResponse) ProtoMessage() {}

func (x *ListIndexEndpointsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexEndpointsResponse.ProtoReflect.Descriptor instead.
func (*ListIndexEndpointsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{101}
}

func (x *ListIndexEndpointsResponse) GetIndexEndpoints() []*IndexEndpoint {
	if x != nil {
		return x.IndexEndpoints
	}
	return nil
}

func (x *ListIndexEndpointsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for UpdateIndexEndpoint.
type UpdateIndexEndpointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource being updated.
	IndexEndpoint *IndexEndpoint `protobuf:"bytes,1,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// IndexEndpoint resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request.
	// A field of the resource will be overwritten if it is in the mask.
	// Empty field mask is not allowed.
	// If the mask is "*", then this is a full replacement of the resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIndexEndpointRequest) Reset() {
	*x = UpdateIndexEndpointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIndexEndpointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIndexEndpointRequest) ProtoMessage() {}

func (x *UpdateIndexEndpointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIndexEndpointRequest.ProtoReflect.Descriptor instead.
func (*UpdateIndexEndpointRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{102}
}

func (x *UpdateIndexEndpointRequest) GetIndexEndpoint() *IndexEndpoint {
	if x != nil {
		return x.IndexEndpoint
	}
	return nil
}

func (x *UpdateIndexEndpointRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Metadata message for UpdateIndexEndpoint.
type UpdateIndexEndpointMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
}

func (x *UpdateIndexEndpointMetadata) Reset() {
	*x = UpdateIndexEndpointMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIndexEndpointMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIndexEndpointMetadata) ProtoMessage() {}

func (x *UpdateIndexEndpointMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIndexEndpointMetadata.ProtoReflect.Descriptor instead.
func (*UpdateIndexEndpointMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{103}
}

func (x *UpdateIndexEndpointMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

// Request message for DeleteIndexEndpoint.
type DeleteIndexEndpointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIndexEndpointRequest) Reset() {
	*x = DeleteIndexEndpointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIndexEndpointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIndexEndpointRequest) ProtoMessage() {}

func (x *DeleteIndexEndpointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIndexEndpointRequest.ProtoReflect.Descriptor instead.
func (*DeleteIndexEndpointRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{104}
}

func (x *DeleteIndexEndpointRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata message for DeleteIndexEndpoint.
type DeleteIndexEndpointMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
}

func (x *DeleteIndexEndpointMetadata) Reset() {
	*x = DeleteIndexEndpointMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIndexEndpointMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIndexEndpointMetadata) ProtoMessage() {}

func (x *DeleteIndexEndpointMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIndexEndpointMetadata.ProtoReflect.Descriptor instead.
func (*DeleteIndexEndpointMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{105}
}

func (x *DeleteIndexEndpointMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

// Request message for DeployIndex.
type DeployIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. IndexEndpoint the index is deployed to.
	// Format:
	// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
	IndexEndpoint string `protobuf:"bytes,1,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
	// Required. Index to deploy.
	DeployedIndex *DeployedIndex `protobuf:"bytes,3,opt,name=deployed_index,json=deployedIndex,proto3" json:"deployed_index,omitempty"`
}

func (x *DeployIndexRequest) Reset() {
	*x = DeployIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIndexRequest) ProtoMessage() {}

func (x *DeployIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIndexRequest.ProtoReflect.Descriptor instead.
func (*DeployIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{106}
}

func (x *DeployIndexRequest) GetIndexEndpoint() string {
	if x != nil {
		return x.IndexEndpoint
	}
	return ""
}

func (x *DeployIndexRequest) GetDeployedIndex() *DeployedIndex {
	if x != nil {
		return x.DeployedIndex
	}
	return nil
}

// DeployIndex response once the operation is done.
type DeployIndexResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployIndexResponse) Reset() {
	*x = DeployIndexResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIndexResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIndexResponse) ProtoMessage() {}

func (x *DeployIndexResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIndexResponse.ProtoReflect.Descriptor instead.
func (*DeployIndexResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{107}
}

// Metadata message for DeployIndex.
type DeployIndexMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
	// Output only. The index being deployed.
	DeployedIndex string `protobuf:"bytes,2,opt,name=deployed_index,json=deployedIndex,proto3" json:"deployed_index,omitempty"`
}

func (x *DeployIndexMetadata) Reset() {
	*x = DeployIndexMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployIndexMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployIndexMetadata) ProtoMessage() {}

func (x *DeployIndexMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployIndexMetadata.ProtoReflect.Descriptor instead.
func (*DeployIndexMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{108}
}

func (x *DeployIndexMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

func (x *DeployIndexMetadata) GetDeployedIndex() string {
	if x != nil {
		return x.DeployedIndex
	}
	return ""
}

// Metadata message for UndeployIndex.
type UndeployIndexMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metadata of the long-running operation.
	OperationMetadata *OperationMetadata `protobuf:"bytes,1,opt,name=operation_metadata,json=operationMetadata,proto3" json:"operation_metadata,omitempty"`
	// Output only. The index being undeployed.
	DeployedIndex string `protobuf:"bytes,2,opt,name=deployed_index,json=deployedIndex,proto3" json:"deployed_index,omitempty"`
}

func (x *UndeployIndexMetadata) Reset() {
	*x = UndeployIndexMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIndexMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIndexMetadata) ProtoMessage() {}

func (x *UndeployIndexMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIndexMetadata.ProtoReflect.Descriptor instead.
func (*UndeployIndexMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{109}
}

func (x *UndeployIndexMetadata) GetOperationMetadata() *OperationMetadata {
	if x != nil {
		return x.OperationMetadata
	}
	return nil
}

func (x *UndeployIndexMetadata) GetDeployedIndex() string {
	if x != nil {
		return x.DeployedIndex
	}
	return ""
}

// Request message for UndeployIndexEndpoint.
type UndeployIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the IndexEndpoint resource on which the
	// undeployment will act. Format:
	// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
	IndexEndpoint string `protobuf:"bytes,1,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
}

func (x *UndeployIndexRequest) Reset() {
	*x = UndeployIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIndexRequest) ProtoMessage() {}

func (x *UndeployIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIndexRequest.ProtoReflect.Descriptor instead.
func (*UndeployIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{110}
}

func (x *UndeployIndexRequest) GetIndexEndpoint() string {
	if x != nil {
		return x.IndexEndpoint
	}
	return ""
}

// UndeployIndex response once the operation is done.
type UndeployIndexResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UndeployIndexResponse) Reset() {
	*x = UndeployIndexResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployIndexResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployIndexResponse) ProtoMessage() {}

func (x *UndeployIndexResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployIndexResponse.ProtoReflect.Descriptor instead.
func (*UndeployIndexResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{111}
}

// A deployment of an Index.
type DeployedIndex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the deployed Index.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/indexes/{index_id}`
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *DeployedIndex) Reset() {
	*x = DeployedIndex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployedIndex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedIndex) ProtoMessage() {}

func (x *DeployedIndex) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedIndex.ProtoReflect.Descriptor instead.
func (*DeployedIndex) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{112}
}

func (x *DeployedIndex) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

// Central configuration for a facet.
type FacetProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RangeFacetConfig:
	//
	//	*FacetProperty_FixedRangeBucketSpec_
	//	*FacetProperty_CustomRangeBucketSpec_
	//	*FacetProperty_DatetimeBucketSpec
	RangeFacetConfig isFacetProperty_RangeFacetConfig `protobuf_oneof:"range_facet_config"`
	// Name of the facets, which are the dimensions users want to use to refine
	// search results. `mapped_fields` will match UserSpecifiedDataSchema keys.
	//
	// For example, user can add a bunch of UGAs with the same key, such as
	// player:adam, player:bob, player:charles. When multiple mapped_fields are
	// specified, will merge their value together as final facet value. E.g.
	// home_team: a, home_team:b, away_team:a, away_team:c, when facet_field =
	// [home_team, away_team], facet_value will be [a, b, c].
	//
	// UNLESS this is a 1:1 facet dimension (mapped_fields.size() == 1) AND the
	// mapped_field equals the parent SearchConfig.name, the parent must
	// also contain a SearchCriteriaProperty that maps to the same fields.
	// mapped_fields must not be empty.
	MappedFields []string `protobuf:"bytes,1,rep,name=mapped_fields,json=mappedFields,proto3" json:"mapped_fields,omitempty"`
	// Display name of the facet. To be used by UI for facet rendering.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Maximum number of unique bucket to return for one facet. Bucket number can
	// be large for high-cardinality facet such as "player". We only return top-n
	// most related ones to user. If it's <= 0, the server will decide the
	// appropriate result_size.
	ResultSize int64 `protobuf:"varint,3,opt,name=result_size,json=resultSize,proto3" json:"result_size,omitempty"`
	// Facet bucket type e.g. value, range.
	BucketType FacetBucketType `protobuf:"varint,4,opt,name=bucket_type,json=bucketType,proto3,enum=google.cloud.visionai.v1.FacetBucketType" json:"bucket_type,omitempty"`
}

func (x *FacetProperty) Reset() {
	*x = FacetProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetProperty) ProtoMessage() {}

func (x *FacetProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetProperty.ProtoReflect.Descriptor instead.
func (*FacetProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{113}
}

func (m *FacetProperty) GetRangeFacetConfig() isFacetProperty_RangeFacetConfig {
	if m != nil {
		return m.RangeFacetConfig
	}
	return nil
}

func (x *FacetProperty) GetFixedRangeBucketSpec() *FacetProperty_FixedRangeBucketSpec {
	if x, ok := x.GetRangeFacetConfig().(*FacetProperty_FixedRangeBucketSpec_); ok {
		return x.FixedRangeBucketSpec
	}
	return nil
}

func (x *FacetProperty) GetCustomRangeBucketSpec() *FacetProperty_CustomRangeBucketSpec {
	if x, ok := x.GetRangeFacetConfig().(*FacetProperty_CustomRangeBucketSpec_); ok {
		return x.CustomRangeBucketSpec
	}
	return nil
}

func (x *FacetProperty) GetDatetimeBucketSpec() *FacetProperty_DateTimeBucketSpec {
	if x, ok := x.GetRangeFacetConfig().(*FacetProperty_DatetimeBucketSpec); ok {
		return x.DatetimeBucketSpec
	}
	return nil
}

func (x *FacetProperty) GetMappedFields() []string {
	if x != nil {
		return x.MappedFields
	}
	return nil
}

func (x *FacetProperty) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FacetProperty) GetResultSize() int64 {
	if x != nil {
		return x.ResultSize
	}
	return 0
}

func (x *FacetProperty) GetBucketType() FacetBucketType {
	if x != nil {
		return x.BucketType
	}
	return FacetBucketType_FACET_BUCKET_TYPE_UNSPECIFIED
}

type isFacetProperty_RangeFacetConfig interface {
	isFacetProperty_RangeFacetConfig()
}

type FacetProperty_FixedRangeBucketSpec_ struct {
	// Fixed range facet bucket config.
	FixedRangeBucketSpec *FacetProperty_FixedRangeBucketSpec `protobuf:"bytes,5,opt,name=fixed_range_bucket_spec,json=fixedRangeBucketSpec,proto3,oneof"`
}

type FacetProperty_CustomRangeBucketSpec_ struct {
	// Custom range facet bucket config.
	CustomRangeBucketSpec *FacetProperty_CustomRangeBucketSpec `protobuf:"bytes,6,opt,name=custom_range_bucket_spec,json=customRangeBucketSpec,proto3,oneof"`
}

type FacetProperty_DatetimeBucketSpec struct {
	// Datetime range facet bucket config.
	DatetimeBucketSpec *FacetProperty_DateTimeBucketSpec `protobuf:"bytes,7,opt,name=datetime_bucket_spec,json=datetimeBucketSpec,proto3,oneof"`
}

func (*FacetProperty_FixedRangeBucketSpec_) isFacetProperty_RangeFacetConfig() {}

func (*FacetProperty_CustomRangeBucketSpec_) isFacetProperty_RangeFacetConfig() {}

func (*FacetProperty_DatetimeBucketSpec) isFacetProperty_RangeFacetConfig() {}

// Search resource: SearchHypernym.
// For example,
// { hypernym: "vehicle"
//
//	hyponyms: ["sedan", "truck"] }
//
// This means in SMART_SEARCH mode, searching for "vehicle" will also return
// results with "sedan" or "truck" as annotations.
type SearchHypernym struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the SearchHypernym.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The hypernym.
	Hypernym string `protobuf:"bytes,2,opt,name=hypernym,proto3" json:"hypernym,omitempty"`
	// Optional. Hyponyms that the hypernym is mapped to.
	Hyponyms []string `protobuf:"bytes,3,rep,name=hyponyms,proto3" json:"hyponyms,omitempty"`
}

func (x *SearchHypernym) Reset() {
	*x = SearchHypernym{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchHypernym) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchHypernym) ProtoMessage() {}

func (x *SearchHypernym) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchHypernym.ProtoReflect.Descriptor instead.
func (*SearchHypernym) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{114}
}

func (x *SearchHypernym) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchHypernym) GetHypernym() string {
	if x != nil {
		return x.Hypernym
	}
	return ""
}

func (x *SearchHypernym) GetHyponyms() []string {
	if x != nil {
		return x.Hyponyms
	}
	return nil
}

// Request message for creating SearchHypernym.
type CreateSearchHypernymRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this SearchHypernym will be created.
	// Format: `projects/{project_number}/locations/{location}/corpora/{corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The SearchHypernym to create.
	SearchHypernym *SearchHypernym `protobuf:"bytes,2,opt,name=search_hypernym,json=searchHypernym,proto3" json:"search_hypernym,omitempty"`
	// Optional. The search hypernym id.
	// If omitted, a random UUID will be generated.
	SearchHypernymId *string `protobuf:"bytes,3,opt,name=search_hypernym_id,json=searchHypernymId,proto3,oneof" json:"search_hypernym_id,omitempty"`
}

func (x *CreateSearchHypernymRequest) Reset() {
	*x = CreateSearchHypernymRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSearchHypernymRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSearchHypernymRequest) ProtoMessage() {}

func (x *CreateSearchHypernymRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSearchHypernymRequest.ProtoReflect.Descriptor instead.
func (*CreateSearchHypernymRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{115}
}

func (x *CreateSearchHypernymRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSearchHypernymRequest) GetSearchHypernym() *SearchHypernym {
	if x != nil {
		return x.SearchHypernym
	}
	return nil
}

func (x *CreateSearchHypernymRequest) GetSearchHypernymId() string {
	if x != nil && x.SearchHypernymId != nil {
		return *x.SearchHypernymId
	}
	return ""
}

// Request message for updating SearchHypernym.
type UpdateSearchHypernymRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The SearchHypernym to update.
	// The search hypernym's `name` field is used to identify the search hypernym
	// to be updated. Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
	SearchHypernym *SearchHypernym `protobuf:"bytes,1,opt,name=search_hypernym,json=searchHypernym,proto3" json:"search_hypernym,omitempty"`
	// The list of fields to be updated. If left unset, all field paths will be
	// updated/overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSearchHypernymRequest) Reset() {
	*x = UpdateSearchHypernymRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSearchHypernymRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSearchHypernymRequest) ProtoMessage() {}

func (x *UpdateSearchHypernymRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSearchHypernymRequest.ProtoReflect.Descriptor instead.
func (*UpdateSearchHypernymRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{116}
}

func (x *UpdateSearchHypernymRequest) GetSearchHypernym() *SearchHypernym {
	if x != nil {
		return x.SearchHypernym
	}
	return nil
}

func (x *UpdateSearchHypernymRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for getting SearchHypernym.
type GetSearchHypernymRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SearchHypernym to retrieve.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSearchHypernymRequest) Reset() {
	*x = GetSearchHypernymRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSearchHypernymRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSearchHypernymRequest) ProtoMessage() {}

func (x *GetSearchHypernymRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSearchHypernymRequest.ProtoReflect.Descriptor instead.
func (*GetSearchHypernymRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{117}
}

func (x *GetSearchHypernymRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for deleting SearchHypernym.
type DeleteSearchHypernymRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the SearchHypernym to delete.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSearchHypernymRequest) Reset() {
	*x = DeleteSearchHypernymRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSearchHypernymRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSearchHypernymRequest) ProtoMessage() {}

func (x *DeleteSearchHypernymRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSearchHypernymRequest.ProtoReflect.Descriptor instead.
func (*DeleteSearchHypernymRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{118}
}

func (x *DeleteSearchHypernymRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for listing SearchHypernyms.
type ListSearchHypernymsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of SearchHypernyms.
	// Format:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of SearchHypernyms returned. The service may
	// return fewer than this value. If unspecified, a page size of 50 will be
	// used. The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `SearchHypernym` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `SearchHypernym` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSearchHypernymsRequest) Reset() {
	*x = ListSearchHypernymsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSearchHypernymsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSearchHypernymsRequest) ProtoMessage() {}

func (x *ListSearchHypernymsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSearchHypernymsRequest.ProtoReflect.Descriptor instead.
func (*ListSearchHypernymsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{119}
}

func (x *ListSearchHypernymsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSearchHypernymsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSearchHypernymsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing SearchHypernyms.
type ListSearchHypernymsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SearchHypernyms from the specified corpus.
	SearchHypernyms []*SearchHypernym `protobuf:"bytes,1,rep,name=search_hypernyms,json=searchHypernyms,proto3" json:"search_hypernyms,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSearchHypernymsResponse) Reset() {
	*x = ListSearchHypernymsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSearchHypernymsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSearchHypernymsResponse) ProtoMessage() {}

func (x *ListSearchHypernymsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSearchHypernymsResponse.ProtoReflect.Descriptor instead.
func (*ListSearchHypernymsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{120}
}

func (x *ListSearchHypernymsResponse) GetSearchHypernyms() []*SearchHypernym {
	if x != nil {
		return x.SearchHypernyms
	}
	return nil
}

func (x *ListSearchHypernymsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Central configuration for custom search criteria.
type SearchCriteriaProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each mapped_field corresponds to a UGA key. To understand how this property
	// works, take the following example. In the SearchConfig table, the
	// user adds this entry:
	//
	//	search_config {
	//	  name: "person"
	//	  search_criteria_property {
	//	    mapped_fields: "player"
	//	    mapped_fields: "coach"
	//	  }
	//	}
	//
	// Now, when a user issues a query like:
	//
	//	criteria {
	//	  field: "person"
	//	  text_array {
	//	    txt_values: "Tom Brady"
	//	    txt_values: "Bill Belichick"
	//	  }
	//	}
	//
	// MWH search will return search documents where (player=Tom Brady ||
	// coach=Tom Brady || player=Bill Belichick || coach=Bill Belichick).
	MappedFields []string `protobuf:"bytes,1,rep,name=mapped_fields,json=mappedFields,proto3" json:"mapped_fields,omitempty"`
}

func (x *SearchCriteriaProperty) Reset() {
	*x = SearchCriteriaProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCriteriaProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCriteriaProperty) ProtoMessage() {}

func (x *SearchCriteriaProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCriteriaProperty.ProtoReflect.Descriptor instead.
func (*SearchCriteriaProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{121}
}

func (x *SearchCriteriaProperty) GetMappedFields() []string {
	if x != nil {
		return x.MappedFields
	}
	return nil
}

// Definition of a single value with generic type.
type FacetValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*FacetValue_StringValue
	//	*FacetValue_IntegerValue
	//	*FacetValue_DatetimeValue
	Value isFacetValue_Value `protobuf_oneof:"value"`
}

func (x *FacetValue) Reset() {
	*x = FacetValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetValue) ProtoMessage() {}

func (x *FacetValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetValue.ProtoReflect.Descriptor instead.
func (*FacetValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{122}
}

func (m *FacetValue) GetValue() isFacetValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *FacetValue) GetStringValue() string {
	if x, ok := x.GetValue().(*FacetValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *FacetValue) GetIntegerValue() int64 {
	if x, ok := x.GetValue().(*FacetValue_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (x *FacetValue) GetDatetimeValue() *datetime.DateTime {
	if x, ok := x.GetValue().(*FacetValue_DatetimeValue); ok {
		return x.DatetimeValue
	}
	return nil
}

type isFacetValue_Value interface {
	isFacetValue_Value()
}

type FacetValue_StringValue struct {
	// String type value.
	StringValue string `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type FacetValue_IntegerValue struct {
	// Integer type value.
	IntegerValue int64 `protobuf:"varint,2,opt,name=integer_value,json=integerValue,proto3,oneof"`
}

type FacetValue_DatetimeValue struct {
	// Datetime type value.
	DatetimeValue *datetime.DateTime `protobuf:"bytes,3,opt,name=datetime_value,json=datetimeValue,proto3,oneof"`
}

func (*FacetValue_StringValue) isFacetValue_Value() {}

func (*FacetValue_IntegerValue) isFacetValue_Value() {}

func (*FacetValue_DatetimeValue) isFacetValue_Value() {}

// Holds the facet value, selections state, and metadata.
type FacetBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bucket associated with a facet. For example, bucket of facet “team”
	// can be "49ers", "patriots", etc; bucket of facet "player" can be "tom
	// brady", "drew brees", etc.
	//
	// Types that are assignable to BucketValue:
	//
	//	*FacetBucket_Value
	//	*FacetBucket_Range_
	BucketValue isFacetBucket_BucketValue `protobuf_oneof:"bucket_value"`
	// Whether one facet bucket is selected. This field represents user's facet
	// selection. It is set by frontend in SearchVideosRequest.
	Selected bool `protobuf:"varint,3,opt,name=selected,proto3" json:"selected,omitempty"`
}

func (x *FacetBucket) Reset() {
	*x = FacetBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetBucket) ProtoMessage() {}

func (x *FacetBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetBucket.ProtoReflect.Descriptor instead.
func (*FacetBucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{123}
}

func (m *FacetBucket) GetBucketValue() isFacetBucket_BucketValue {
	if m != nil {
		return m.BucketValue
	}
	return nil
}

func (x *FacetBucket) GetValue() *FacetValue {
	if x, ok := x.GetBucketValue().(*FacetBucket_Value); ok {
		return x.Value
	}
	return nil
}

func (x *FacetBucket) GetRange() *FacetBucket_Range {
	if x, ok := x.GetBucketValue().(*FacetBucket_Range_); ok {
		return x.Range
	}
	return nil
}

func (x *FacetBucket) GetSelected() bool {
	if x != nil {
		return x.Selected
	}
	return false
}

type isFacetBucket_BucketValue interface {
	isFacetBucket_BucketValue()
}

type FacetBucket_Value struct {
	// Singular value.
	Value *FacetValue `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

type FacetBucket_Range_ struct {
	// Range value.
	Range *FacetBucket_Range `protobuf:"bytes,4,opt,name=range,proto3,oneof"`
}

func (*FacetBucket_Value) isFacetBucket_BucketValue() {}

func (*FacetBucket_Range_) isFacetBucket_BucketValue() {}

// A group of facet buckets to be passed back and forth between backend &
// frontend.
type FacetGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique id of the facet group.
	FacetId string `protobuf:"bytes,1,opt,name=facet_id,json=facetId,proto3" json:"facet_id,omitempty"`
	// Display name of the facet. To be used by UI for facet rendering.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Buckets associated with the facet. E.g. for "Team" facet, the bucket
	// can be 49ers, patriots, etc.
	Buckets []*FacetBucket `protobuf:"bytes,3,rep,name=buckets,proto3" json:"buckets,omitempty"`
	// Facet bucket type.
	BucketType FacetBucketType `protobuf:"varint,4,opt,name=bucket_type,json=bucketType,proto3,enum=google.cloud.visionai.v1.FacetBucketType" json:"bucket_type,omitempty"`
	// If true, return query matched annotations for this facet group's selection.
	// This option is only applicable for facets based on partition level
	// annotations. It supports the following facet values:
	//   - INTEGER
	//   - STRING (DataSchema.SearchStrategy.EXACT_SEARCH only)
	FetchMatchedAnnotations bool `protobuf:"varint,5,opt,name=fetch_matched_annotations,json=fetchMatchedAnnotations,proto3" json:"fetch_matched_annotations,omitempty"`
}

func (x *FacetGroup) Reset() {
	*x = FacetGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetGroup) ProtoMessage() {}

func (x *FacetGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetGroup.ProtoReflect.Descriptor instead.
func (*FacetGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{124}
}

func (x *FacetGroup) GetFacetId() string {
	if x != nil {
		return x.FacetId
	}
	return ""
}

func (x *FacetGroup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FacetGroup) GetBuckets() []*FacetBucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

func (x *FacetGroup) GetBucketType() FacetBucketType {
	if x != nil {
		return x.BucketType
	}
	return FacetBucketType_FACET_BUCKET_TYPE_UNSPECIFIED
}

func (x *FacetGroup) GetFetchMatchedAnnotations() bool {
	if x != nil {
		return x.FetchMatchedAnnotations
	}
	return false
}

// Request message for IngestAsset API.
type IngestAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to StreamingRequest:
	//
	//	*IngestAssetRequest_Config_
	//	*IngestAssetRequest_TimeIndexedData_
	StreamingRequest isIngestAssetRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
}

func (x *IngestAssetRequest) Reset() {
	*x = IngestAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[125]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetRequest) ProtoMessage() {}

func (x *IngestAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[125]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetRequest.ProtoReflect.Descriptor instead.
func (*IngestAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{125}
}

func (m *IngestAssetRequest) GetStreamingRequest() isIngestAssetRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (x *IngestAssetRequest) GetConfig() *IngestAssetRequest_Config {
	if x, ok := x.GetStreamingRequest().(*IngestAssetRequest_Config_); ok {
		return x.Config
	}
	return nil
}

func (x *IngestAssetRequest) GetTimeIndexedData() *IngestAssetRequest_TimeIndexedData {
	if x, ok := x.GetStreamingRequest().(*IngestAssetRequest_TimeIndexedData_); ok {
		return x.TimeIndexedData
	}
	return nil
}

type isIngestAssetRequest_StreamingRequest interface {
	isIngestAssetRequest_StreamingRequest()
}

type IngestAssetRequest_Config_ struct {
	// Provides information for the data and the asset resource name that the
	// data belongs to. The first `IngestAssetRequest` message must only contain
	// a `Config` message.
	Config *IngestAssetRequest_Config `protobuf:"bytes,1,opt,name=config,proto3,oneof"`
}

type IngestAssetRequest_TimeIndexedData_ struct {
	// Data to be ingested.
	TimeIndexedData *IngestAssetRequest_TimeIndexedData `protobuf:"bytes,2,opt,name=time_indexed_data,json=timeIndexedData,proto3,oneof"`
}

func (*IngestAssetRequest_Config_) isIngestAssetRequest_StreamingRequest() {}

func (*IngestAssetRequest_TimeIndexedData_) isIngestAssetRequest_StreamingRequest() {}

// Response message for IngestAsset API.
type IngestAssetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time range of the data that has been successfully ingested.
	SuccessfullyIngestedPartition *Partition_TemporalPartition `protobuf:"bytes,1,opt,name=successfully_ingested_partition,json=successfullyIngestedPartition,proto3" json:"successfully_ingested_partition,omitempty"`
}

func (x *IngestAssetResponse) Reset() {
	*x = IngestAssetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[126]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetResponse) ProtoMessage() {}

func (x *IngestAssetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[126]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetResponse.ProtoReflect.Descriptor instead.
func (*IngestAssetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{126}
}

func (x *IngestAssetResponse) GetSuccessfullyIngestedPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.SuccessfullyIngestedPartition
	}
	return nil
}

// Request message for ClipAsset API.
type ClipAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to request clips for.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The time range to request clips for.
	TemporalPartition *Partition_TemporalPartition `protobuf:"bytes,2,opt,name=temporal_partition,json=temporalPartition,proto3" json:"temporal_partition,omitempty"`
}

func (x *ClipAssetRequest) Reset() {
	*x = ClipAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[127]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClipAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClipAssetRequest) ProtoMessage() {}

func (x *ClipAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[127]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClipAssetRequest.ProtoReflect.Descriptor instead.
func (*ClipAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{127}
}

func (x *ClipAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ClipAssetRequest) GetTemporalPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartition
	}
	return nil
}

// Response message for ClipAsset API.
type ClipAssetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of signed uris to download the video clips that cover the requested
	// time range ordered by time.
	TimeIndexedUris []*ClipAssetResponse_TimeIndexedUri `protobuf:"bytes,1,rep,name=time_indexed_uris,json=timeIndexedUris,proto3" json:"time_indexed_uris,omitempty"`
}

func (x *ClipAssetResponse) Reset() {
	*x = ClipAssetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[128]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClipAssetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClipAssetResponse) ProtoMessage() {}

func (x *ClipAssetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[128]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClipAssetResponse.ProtoReflect.Descriptor instead.
func (*ClipAssetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{128}
}

func (x *ClipAssetResponse) GetTimeIndexedUris() []*ClipAssetResponse_TimeIndexedUri {
	if x != nil {
		return x.TimeIndexedUris
	}
	return nil
}

// Request message for GenerateHlsUri API.
type GenerateHlsUriRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to request clips for.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The time range to request clips for. Will be ignored if `get_live_view` is
	// set to True. The total time range requested should be smaller than 24h.
	TemporalPartitions []*Partition_TemporalPartition `protobuf:"bytes,2,rep,name=temporal_partitions,json=temporalPartitions,proto3" json:"temporal_partitions,omitempty"`
	// Option to exclusively show a livestream of the asset with up to 3 minutes
	// of backlog data.
	LiveViewEnabled bool `protobuf:"varint,3,opt,name=live_view_enabled,json=liveViewEnabled,proto3" json:"live_view_enabled,omitempty"`
}

func (x *GenerateHlsUriRequest) Reset() {
	*x = GenerateHlsUriRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[129]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateHlsUriRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateHlsUriRequest) ProtoMessage() {}

func (x *GenerateHlsUriRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[129]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateHlsUriRequest.ProtoReflect.Descriptor instead.
func (*GenerateHlsUriRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{129}
}

func (x *GenerateHlsUriRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GenerateHlsUriRequest) GetTemporalPartitions() []*Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartitions
	}
	return nil
}

func (x *GenerateHlsUriRequest) GetLiveViewEnabled() bool {
	if x != nil {
		return x.LiveViewEnabled
	}
	return false
}

// Response message for GenerateHlsUri API.
type GenerateHlsUriResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A signed uri to download the HLS manifest corresponding to the requested
	// times.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// A list of temporal partitions of the content returned in the order they
	// appear in the stream.
	TemporalPartitions []*Partition_TemporalPartition `protobuf:"bytes,2,rep,name=temporal_partitions,json=temporalPartitions,proto3" json:"temporal_partitions,omitempty"`
}

func (x *GenerateHlsUriResponse) Reset() {
	*x = GenerateHlsUriResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[130]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateHlsUriResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateHlsUriResponse) ProtoMessage() {}

func (x *GenerateHlsUriResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[130]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateHlsUriResponse.ProtoReflect.Descriptor instead.
func (*GenerateHlsUriResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{130}
}

func (x *GenerateHlsUriResponse) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *GenerateHlsUriResponse) GetTemporalPartitions() []*Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartitions
	}
	return nil
}

// Request message for SearchAssets.
type SearchAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sorting specification. If this field is not specified, by default:
	// - STREAM_VIDEO: search results are sorted by the start time.
	//
	// Types that are assignable to SortSpec:
	//
	//	*SearchAssetsRequest_SchemaKeySortingStrategy
	SortSpec isSearchAssetsRequest_SortSpec `protobuf_oneof:"sort_spec"`
	// Required. The parent corpus to search.
	// Format: `projects/{project_id}/locations/{location_id}/corpora/{corpus_id}'
	Corpus string `protobuf:"bytes,1,opt,name=corpus,proto3" json:"corpus,omitempty"`
	// The number of results to be returned in this page. If it's 0, the server
	// will decide the appropriate page_size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The continuation token to fetch the next page. If empty, it means it is
	// fetching the first page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Time ranges that matching video content must fall within. If no ranges are
	// provided, there will be no time restriction. This field is treated just
	// like the criteria below, but defined separately for convenience as it is
	// used frequently. Note that if the end_time is in the future, it will be
	// clamped to the time the request was received.
	ContentTimeRanges *DateTimeRangeArray `protobuf:"bytes,5,opt,name=content_time_ranges,json=contentTimeRanges,proto3" json:"content_time_ranges,omitempty"`
	// Criteria applied to search results.
	Criteria []*Criteria `protobuf:"bytes,4,rep,name=criteria,proto3" json:"criteria,omitempty"`
	// Stores most recent facet selection state. Only facet groups with user's
	// selection will be presented here. Selection state is either selected or
	// unselected. Only selected facet buckets will be used as search criteria.
	FacetSelections []*FacetGroup `protobuf:"bytes,6,rep,name=facet_selections,json=facetSelections,proto3" json:"facet_selections,omitempty"`
	// A list of annotation keys to specify the annotations to be retrieved and
	// returned with each search result.
	// Annotation granularity must be GRANULARITY_ASSET_LEVEL and its search
	// strategy must not be NO_SEARCH.
	ResultAnnotationKeys []string `protobuf:"bytes,8,rep,name=result_annotation_keys,json=resultAnnotationKeys,proto3" json:"result_annotation_keys,omitempty"`
	// Global search query. Allows user to search assets without needing to
	// specify which field the value belongs to.
	SearchQuery string `protobuf:"bytes,10,opt,name=search_query,json=searchQuery,proto3" json:"search_query,omitempty"`
}

func (x *SearchAssetsRequest) Reset() {
	*x = SearchAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[131]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAssetsRequest) ProtoMessage() {}

func (x *SearchAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[131]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAssetsRequest.ProtoReflect.Descriptor instead.
func (*SearchAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{131}
}

func (m *SearchAssetsRequest) GetSortSpec() isSearchAssetsRequest_SortSpec {
	if m != nil {
		return m.SortSpec
	}
	return nil
}

func (x *SearchAssetsRequest) GetSchemaKeySortingStrategy() *SchemaKeySortingStrategy {
	if x, ok := x.GetSortSpec().(*SearchAssetsRequest_SchemaKeySortingStrategy); ok {
		return x.SchemaKeySortingStrategy
	}
	return nil
}

func (x *SearchAssetsRequest) GetCorpus() string {
	if x != nil {
		return x.Corpus
	}
	return ""
}

func (x *SearchAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAssetsRequest) GetContentTimeRanges() *DateTimeRangeArray {
	if x != nil {
		return x.ContentTimeRanges
	}
	return nil
}

func (x *SearchAssetsRequest) GetCriteria() []*Criteria {
	if x != nil {
		return x.Criteria
	}
	return nil
}

func (x *SearchAssetsRequest) GetFacetSelections() []*FacetGroup {
	if x != nil {
		return x.FacetSelections
	}
	return nil
}

func (x *SearchAssetsRequest) GetResultAnnotationKeys() []string {
	if x != nil {
		return x.ResultAnnotationKeys
	}
	return nil
}

func (x *SearchAssetsRequest) GetSearchQuery() string {
	if x != nil {
		return x.SearchQuery
	}
	return ""
}

type isSearchAssetsRequest_SortSpec interface {
	isSearchAssetsRequest_SortSpec()
}

type SearchAssetsRequest_SchemaKeySortingStrategy struct {
	// Sort by the value under the data schema key.
	SchemaKeySortingStrategy *SchemaKeySortingStrategy `protobuf:"bytes,9,opt,name=schema_key_sorting_strategy,json=schemaKeySortingStrategy,proto3,oneof"`
}

func (*SearchAssetsRequest_SchemaKeySortingStrategy) isSearchAssetsRequest_SortSpec() {}

// Request message for SearchIndexEndpoint.
type SearchIndexEndpointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The oneof global search query.
	//
	// Types that are assignable to Query:
	//
	//	*SearchIndexEndpointRequest_ImageQuery
	//	*SearchIndexEndpointRequest_TextQuery
	Query isSearchIndexEndpointRequest_Query `protobuf_oneof:"query"`
	// Required. The index endpoint to search.
	// Format:
	// `projects/{project_id}/locations/{location_id}/indexEndpoints/{index_endpoint_id}'
	IndexEndpoint string `protobuf:"bytes,1,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
	// Criteria applied to search results.
	Criteria []*Criteria `protobuf:"bytes,4,rep,name=criteria,proto3" json:"criteria,omitempty"`
	// Criteria to exclude from search results.
	// Note that `fetch_matched_annotations` will be ignored.
	ExclusionCriteria []*Criteria `protobuf:"bytes,7,rep,name=exclusion_criteria,json=exclusionCriteria,proto3" json:"exclusion_criteria,omitempty"`
	// Requested page size. API may return fewer results than requested.
	// If negative, INVALID_ARGUMENT error will be returned.
	// If unspecified or 0, API will pick a default size, which is 10.
	// If the requested page size is larger than the maximum size, API will pick
	// the maximum size, which is 100.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The continuation token to fetch the next page. If empty, it means it is
	// fetching the first page.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchIndexEndpointRequest) Reset() {
	*x = SearchIndexEndpointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[132]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchIndexEndpointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchIndexEndpointRequest) ProtoMessage() {}

func (x *SearchIndexEndpointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[132]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchIndexEndpointRequest.ProtoReflect.Descriptor instead.
func (*SearchIndexEndpointRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{132}
}

func (m *SearchIndexEndpointRequest) GetQuery() isSearchIndexEndpointRequest_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *SearchIndexEndpointRequest) GetImageQuery() *ImageQuery {
	if x, ok := x.GetQuery().(*SearchIndexEndpointRequest_ImageQuery); ok {
		return x.ImageQuery
	}
	return nil
}

func (x *SearchIndexEndpointRequest) GetTextQuery() string {
	if x, ok := x.GetQuery().(*SearchIndexEndpointRequest_TextQuery); ok {
		return x.TextQuery
	}
	return ""
}

func (x *SearchIndexEndpointRequest) GetIndexEndpoint() string {
	if x != nil {
		return x.IndexEndpoint
	}
	return ""
}

func (x *SearchIndexEndpointRequest) GetCriteria() []*Criteria {
	if x != nil {
		return x.Criteria
	}
	return nil
}

func (x *SearchIndexEndpointRequest) GetExclusionCriteria() []*Criteria {
	if x != nil {
		return x.ExclusionCriteria
	}
	return nil
}

func (x *SearchIndexEndpointRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchIndexEndpointRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type isSearchIndexEndpointRequest_Query interface {
	isSearchIndexEndpointRequest_Query()
}

type SearchIndexEndpointRequest_ImageQuery struct {
	// An image-only query.
	ImageQuery *ImageQuery `protobuf:"bytes,2,opt,name=image_query,json=imageQuery,proto3,oneof"`
}

type SearchIndexEndpointRequest_TextQuery struct {
	// A text-only query.
	TextQuery string `protobuf:"bytes,3,opt,name=text_query,json=textQuery,proto3,oneof"`
}

func (*SearchIndexEndpointRequest_ImageQuery) isSearchIndexEndpointRequest_Query() {}

func (*SearchIndexEndpointRequest_TextQuery) isSearchIndexEndpointRequest_Query() {}

// Image query for search endpoint request.
type ImageQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Image:
	//
	//	*ImageQuery_InputImage
	//	*ImageQuery_Asset
	Image isImageQuery_Image `protobuf_oneof:"image"`
}

func (x *ImageQuery) Reset() {
	*x = ImageQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[133]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageQuery) ProtoMessage() {}

func (x *ImageQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[133]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageQuery.ProtoReflect.Descriptor instead.
func (*ImageQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{133}
}

func (m *ImageQuery) GetImage() isImageQuery_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (x *ImageQuery) GetInputImage() []byte {
	if x, ok := x.GetImage().(*ImageQuery_InputImage); ok {
		return x.InputImage
	}
	return nil
}

func (x *ImageQuery) GetAsset() string {
	if x, ok := x.GetImage().(*ImageQuery_Asset); ok {
		return x.Asset
	}
	return ""
}

type isImageQuery_Image interface {
	isImageQuery_Image()
}

type ImageQuery_InputImage struct {
	// Input image in raw bytes.
	InputImage []byte `protobuf:"bytes,1,opt,name=input_image,json=inputImage,proto3,oneof"`
}

type ImageQuery_Asset struct {
	// Resource name of the asset. Only supported in IMAGE corpus type.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Asset string `protobuf:"bytes,2,opt,name=asset,proto3,oneof"`
}

func (*ImageQuery_InputImage) isImageQuery_Image() {}

func (*ImageQuery_Asset) isImageQuery_Image() {}

// A strategy to specify how to sort by data schema key.
type SchemaKeySortingStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Options in the front have high priority than those in the back.
	Options []*SchemaKeySortingStrategy_Option `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *SchemaKeySortingStrategy) Reset() {
	*x = SchemaKeySortingStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[134]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemaKeySortingStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaKeySortingStrategy) ProtoMessage() {}

func (x *SchemaKeySortingStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[134]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaKeySortingStrategy.ProtoReflect.Descriptor instead.
func (*SchemaKeySortingStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{134}
}

func (x *SchemaKeySortingStrategy) GetOptions() []*SchemaKeySortingStrategy_Option {
	if x != nil {
		return x.Options
	}
	return nil
}

// The metadata for DeleteAsset API that embeds in
// [metadata][google.longrunning.Operation.metadata] field.
type DeleteAssetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteAssetMetadata) Reset() {
	*x = DeleteAssetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[135]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAssetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAssetMetadata) ProtoMessage() {}

func (x *DeleteAssetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[135]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAssetMetadata.ProtoReflect.Descriptor instead.
func (*DeleteAssetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{135}
}

// Stores the criteria-annotation matching results for each search result item.
type AnnotationMatchingResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The criteria used for matching. It can be an input search criteria or a
	// criteria converted from a facet selection.
	Criteria *Criteria `protobuf:"bytes,1,opt,name=criteria,proto3" json:"criteria,omitempty"`
	// Matched annotations for the criteria.
	MatchedAnnotations []*Annotation `protobuf:"bytes,2,rep,name=matched_annotations,json=matchedAnnotations,proto3" json:"matched_annotations,omitempty"`
	// Status of the match result. Possible values:
	// FAILED_PRECONDITION - the criteria is not eligible for match.
	// OK - matching is performed.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *AnnotationMatchingResult) Reset() {
	*x = AnnotationMatchingResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[136]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationMatchingResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationMatchingResult) ProtoMessage() {}

func (x *AnnotationMatchingResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[136]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationMatchingResult.ProtoReflect.Descriptor instead.
func (*AnnotationMatchingResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{136}
}

func (x *AnnotationMatchingResult) GetCriteria() *Criteria {
	if x != nil {
		return x.Criteria
	}
	return nil
}

func (x *AnnotationMatchingResult) GetMatchedAnnotations() []*Annotation {
	if x != nil {
		return x.MatchedAnnotations
	}
	return nil
}

func (x *AnnotationMatchingResult) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// Search result contains asset name and corresponding time ranges.
type SearchResultItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the asset.
	// Format:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Asset string `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// The matched asset segments.
	// Deprecated: please use singular `segment` field.
	//
	// Deprecated: Marked as deprecated in google/cloud/visionai/v1/warehouse.proto.
	Segments []*Partition_TemporalPartition `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// The matched asset segment.
	Segment *Partition_TemporalPartition `protobuf:"bytes,5,opt,name=segment,proto3" json:"segment,omitempty"`
	// Relevance of this `SearchResultItem` to user search request.
	// Currently available only in Image Warehouse, and by default represents
	// cosine similarity.  In the future can be other measures such as "dot
	// product" or "topicality" requested in the search request.
	Relevance float64 `protobuf:"fixed64,6,opt,name=relevance,proto3" json:"relevance,omitempty"`
	// Search result annotations specified by result_annotation_keys in search
	// request.
	RequestedAnnotations []*Annotation `protobuf:"bytes,3,rep,name=requested_annotations,json=requestedAnnotations,proto3" json:"requested_annotations,omitempty"`
	// Criteria or facet-selection based annotation matching results associated to
	// this search result item. Only contains results for criteria or
	// facet_selections with fetch_matched_annotations=true.
	AnnotationMatchingResults []*AnnotationMatchingResult `protobuf:"bytes,4,rep,name=annotation_matching_results,json=annotationMatchingResults,proto3" json:"annotation_matching_results,omitempty"`
}

func (x *SearchResultItem) Reset() {
	*x = SearchResultItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[137]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResultItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResultItem) ProtoMessage() {}

func (x *SearchResultItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[137]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResultItem.ProtoReflect.Descriptor instead.
func (*SearchResultItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{137}
}

func (x *SearchResultItem) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/visionai/v1/warehouse.proto.
func (x *SearchResultItem) GetSegments() []*Partition_TemporalPartition {
	if x != nil {
		return x.Segments
	}
	return nil
}

func (x *SearchResultItem) GetSegment() *Partition_TemporalPartition {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *SearchResultItem) GetRelevance() float64 {
	if x != nil {
		return x.Relevance
	}
	return 0
}

func (x *SearchResultItem) GetRequestedAnnotations() []*Annotation {
	if x != nil {
		return x.RequestedAnnotations
	}
	return nil
}

func (x *SearchResultItem) GetAnnotationMatchingResults() []*AnnotationMatchingResult {
	if x != nil {
		return x.AnnotationMatchingResults
	}
	return nil
}

// Response message for SearchAssets.
type SearchAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned search results.
	SearchResultItems []*SearchResultItem `protobuf:"bytes,1,rep,name=search_result_items,json=searchResultItems,proto3" json:"search_result_items,omitempty"`
	// The next-page continuation token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Facet search results of a given query, which contains user's
	// already-selected facet values and updated facet search results.
	FacetResults []*FacetGroup `protobuf:"bytes,3,rep,name=facet_results,json=facetResults,proto3" json:"facet_results,omitempty"`
}

func (x *SearchAssetsResponse) Reset() {
	*x = SearchAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[138]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAssetsResponse) ProtoMessage() {}

func (x *SearchAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[138]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAssetsResponse.ProtoReflect.Descriptor instead.
func (*SearchAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{138}
}

func (x *SearchAssetsResponse) GetSearchResultItems() []*SearchResultItem {
	if x != nil {
		return x.SearchResultItems
	}
	return nil
}

func (x *SearchAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchAssetsResponse) GetFacetResults() []*FacetGroup {
	if x != nil {
		return x.FacetResults
	}
	return nil
}

// Response message for SearchIndexEndpoint.
type SearchIndexEndpointResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned search results.
	SearchResultItems []*SearchResultItem `protobuf:"bytes,1,rep,name=search_result_items,json=searchResultItems,proto3" json:"search_result_items,omitempty"`
	// The next-page continuation token.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchIndexEndpointResponse) Reset() {
	*x = SearchIndexEndpointResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[139]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchIndexEndpointResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchIndexEndpointResponse) ProtoMessage() {}

func (x *SearchIndexEndpointResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[139]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchIndexEndpointResponse.ProtoReflect.Descriptor instead.
func (*SearchIndexEndpointResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{139}
}

func (x *SearchIndexEndpointResponse) GetSearchResultItems() []*SearchResultItem {
	if x != nil {
		return x.SearchResultItems
	}
	return nil
}

func (x *SearchIndexEndpointResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Integer range type.
type IntRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the int range.
	Start *int64 `protobuf:"varint,1,opt,name=start,proto3,oneof" json:"start,omitempty"`
	// End of the int range.
	End *int64 `protobuf:"varint,2,opt,name=end,proto3,oneof" json:"end,omitempty"`
}

func (x *IntRange) Reset() {
	*x = IntRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[140]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntRange) ProtoMessage() {}

func (x *IntRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[140]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntRange.ProtoReflect.Descriptor instead.
func (*IntRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{140}
}

func (x *IntRange) GetStart() int64 {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return 0
}

func (x *IntRange) GetEnd() int64 {
	if x != nil && x.End != nil {
		return *x.End
	}
	return 0
}

// Float range type.
type FloatRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the float range.
	Start *float32 `protobuf:"fixed32,1,opt,name=start,proto3,oneof" json:"start,omitempty"`
	// End of the float range.
	End *float32 `protobuf:"fixed32,2,opt,name=end,proto3,oneof" json:"end,omitempty"`
}

func (x *FloatRange) Reset() {
	*x = FloatRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[141]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FloatRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloatRange) ProtoMessage() {}

func (x *FloatRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[141]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FloatRange.ProtoReflect.Descriptor instead.
func (*FloatRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{141}
}

func (x *FloatRange) GetStart() float32 {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return 0
}

func (x *FloatRange) GetEnd() float32 {
	if x != nil && x.End != nil {
		return *x.End
	}
	return 0
}

// A list of string-type values.
type StringArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// String type values.
	TxtValues []string `protobuf:"bytes,1,rep,name=txt_values,json=txtValues,proto3" json:"txt_values,omitempty"`
}

func (x *StringArray) Reset() {
	*x = StringArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[142]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StringArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringArray) ProtoMessage() {}

func (x *StringArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[142]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringArray.ProtoReflect.Descriptor instead.
func (*StringArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{142}
}

func (x *StringArray) GetTxtValues() []string {
	if x != nil {
		return x.TxtValues
	}
	return nil
}

// A list of integer range values.
type IntRangeArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Int range values.
	IntRanges []*IntRange `protobuf:"bytes,1,rep,name=int_ranges,json=intRanges,proto3" json:"int_ranges,omitempty"`
}

func (x *IntRangeArray) Reset() {
	*x = IntRangeArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[143]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntRangeArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntRangeArray) ProtoMessage() {}

func (x *IntRangeArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[143]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntRangeArray.ProtoReflect.Descriptor instead.
func (*IntRangeArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{143}
}

func (x *IntRangeArray) GetIntRanges() []*IntRange {
	if x != nil {
		return x.IntRanges
	}
	return nil
}

// A list of float range values.
type FloatRangeArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Float range values.
	FloatRanges []*FloatRange `protobuf:"bytes,1,rep,name=float_ranges,json=floatRanges,proto3" json:"float_ranges,omitempty"`
}

func (x *FloatRangeArray) Reset() {
	*x = FloatRangeArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[144]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FloatRangeArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloatRangeArray) ProtoMessage() {}

func (x *FloatRangeArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[144]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FloatRangeArray.ProtoReflect.Descriptor instead.
func (*FloatRangeArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{144}
}

func (x *FloatRangeArray) GetFloatRanges() []*FloatRange {
	if x != nil {
		return x.FloatRanges
	}
	return nil
}

// Datetime range type.
type DateTimeRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start date time.
	Start *datetime.DateTime `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// End data time.
	End *datetime.DateTime `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *DateTimeRange) Reset() {
	*x = DateTimeRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[145]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTimeRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTimeRange) ProtoMessage() {}

func (x *DateTimeRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[145]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTimeRange.ProtoReflect.Descriptor instead.
func (*DateTimeRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{145}
}

func (x *DateTimeRange) GetStart() *datetime.DateTime {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *DateTimeRange) GetEnd() *datetime.DateTime {
	if x != nil {
		return x.End
	}
	return nil
}

// A list of datetime range values.
type DateTimeRangeArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Date time ranges.
	DateTimeRanges []*DateTimeRange `protobuf:"bytes,1,rep,name=date_time_ranges,json=dateTimeRanges,proto3" json:"date_time_ranges,omitempty"`
}

func (x *DateTimeRangeArray) Reset() {
	*x = DateTimeRangeArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[146]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTimeRangeArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTimeRangeArray) ProtoMessage() {}

func (x *DateTimeRangeArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[146]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTimeRangeArray.ProtoReflect.Descriptor instead.
func (*DateTimeRangeArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{146}
}

func (x *DateTimeRangeArray) GetDateTimeRanges() []*DateTimeRange {
	if x != nil {
		return x.DateTimeRanges
	}
	return nil
}

// Representation of a circle area.
type CircleArea struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Latitude of circle area's center. Degrees [-90 .. 90]
	Latitude float64 `protobuf:"fixed64,1,opt,name=latitude,proto3" json:"latitude,omitempty"`
	// Longitude of circle area's center. Degrees [-180 .. 180]
	Longitude float64 `protobuf:"fixed64,2,opt,name=longitude,proto3" json:"longitude,omitempty"`
	// Radius of the circle area in meters.
	RadiusMeter float64 `protobuf:"fixed64,3,opt,name=radius_meter,json=radiusMeter,proto3" json:"radius_meter,omitempty"`
}

func (x *CircleArea) Reset() {
	*x = CircleArea{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[147]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CircleArea) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CircleArea) ProtoMessage() {}

func (x *CircleArea) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[147]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CircleArea.ProtoReflect.Descriptor instead.
func (*CircleArea) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{147}
}

func (x *CircleArea) GetLatitude() float64 {
	if x != nil {
		return x.Latitude
	}
	return 0
}

func (x *CircleArea) GetLongitude() float64 {
	if x != nil {
		return x.Longitude
	}
	return 0
}

func (x *CircleArea) GetRadiusMeter() float64 {
	if x != nil {
		return x.RadiusMeter
	}
	return 0
}

// A list of locations.
type GeoLocationArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of circle areas.
	CircleAreas []*CircleArea `protobuf:"bytes,1,rep,name=circle_areas,json=circleAreas,proto3" json:"circle_areas,omitempty"`
}

func (x *GeoLocationArray) Reset() {
	*x = GeoLocationArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[148]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GeoLocationArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeoLocationArray) ProtoMessage() {}

func (x *GeoLocationArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[148]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeoLocationArray.ProtoReflect.Descriptor instead.
func (*GeoLocationArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{148}
}

func (x *GeoLocationArray) GetCircleAreas() []*CircleArea {
	if x != nil {
		return x.CircleAreas
	}
	return nil
}

type BoolValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value bool `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *BoolValue) Reset() {
	*x = BoolValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[149]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoolValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoolValue) ProtoMessage() {}

func (x *BoolValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[149]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoolValue.ProtoReflect.Descriptor instead.
func (*BoolValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{149}
}

func (x *BoolValue) GetValue() bool {
	if x != nil {
		return x.Value
	}
	return false
}

// Filter criteria applied to current search results.
type Criteria struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*Criteria_TextArray
	//	*Criteria_IntRangeArray
	//	*Criteria_FloatRangeArray
	//	*Criteria_DateTimeRangeArray
	//	*Criteria_GeoLocationArray
	//	*Criteria_BoolValue
	Value isCriteria_Value `protobuf_oneof:"value"`
	// The UGA field or ML field to apply filtering criteria.
	Field string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// If true, return query matched annotations for this criteria.
	// This option is only applicable for inclusion criteria, i.e., not exclusion
	// criteria, with partition level annotations.  It supports the following data
	// types:
	//   - INTEGER
	//   - FLOAT
	//   - STRING (DataSchema.SearchStrategy.EXACT_SEARCH only)
	//   - BOOLEAN
	FetchMatchedAnnotations bool `protobuf:"varint,8,opt,name=fetch_matched_annotations,json=fetchMatchedAnnotations,proto3" json:"fetch_matched_annotations,omitempty"`
}

func (x *Criteria) Reset() {
	*x = Criteria{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[150]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Criteria) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Criteria) ProtoMessage() {}

func (x *Criteria) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[150]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Criteria.ProtoReflect.Descriptor instead.
func (*Criteria) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{150}
}

func (m *Criteria) GetValue() isCriteria_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Criteria) GetTextArray() *StringArray {
	if x, ok := x.GetValue().(*Criteria_TextArray); ok {
		return x.TextArray
	}
	return nil
}

func (x *Criteria) GetIntRangeArray() *IntRangeArray {
	if x, ok := x.GetValue().(*Criteria_IntRangeArray); ok {
		return x.IntRangeArray
	}
	return nil
}

func (x *Criteria) GetFloatRangeArray() *FloatRangeArray {
	if x, ok := x.GetValue().(*Criteria_FloatRangeArray); ok {
		return x.FloatRangeArray
	}
	return nil
}

func (x *Criteria) GetDateTimeRangeArray() *DateTimeRangeArray {
	if x, ok := x.GetValue().(*Criteria_DateTimeRangeArray); ok {
		return x.DateTimeRangeArray
	}
	return nil
}

func (x *Criteria) GetGeoLocationArray() *GeoLocationArray {
	if x, ok := x.GetValue().(*Criteria_GeoLocationArray); ok {
		return x.GeoLocationArray
	}
	return nil
}

func (x *Criteria) GetBoolValue() *BoolValue {
	if x, ok := x.GetValue().(*Criteria_BoolValue); ok {
		return x.BoolValue
	}
	return nil
}

func (x *Criteria) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *Criteria) GetFetchMatchedAnnotations() bool {
	if x != nil {
		return x.FetchMatchedAnnotations
	}
	return false
}

type isCriteria_Value interface {
	isCriteria_Value()
}

type Criteria_TextArray struct {
	// The text values associated with the field.
	TextArray *StringArray `protobuf:"bytes,2,opt,name=text_array,json=textArray,proto3,oneof"`
}

type Criteria_IntRangeArray struct {
	// The integer ranges associated with the field.
	IntRangeArray *IntRangeArray `protobuf:"bytes,3,opt,name=int_range_array,json=intRangeArray,proto3,oneof"`
}

type Criteria_FloatRangeArray struct {
	// The float ranges associated with the field.
	FloatRangeArray *FloatRangeArray `protobuf:"bytes,4,opt,name=float_range_array,json=floatRangeArray,proto3,oneof"`
}

type Criteria_DateTimeRangeArray struct {
	// The datetime ranges associated with the field.
	DateTimeRangeArray *DateTimeRangeArray `protobuf:"bytes,5,opt,name=date_time_range_array,json=dateTimeRangeArray,proto3,oneof"`
}

type Criteria_GeoLocationArray struct {
	// Geo Location array.
	GeoLocationArray *GeoLocationArray `protobuf:"bytes,6,opt,name=geo_location_array,json=geoLocationArray,proto3,oneof"`
}

type Criteria_BoolValue struct {
	// A Boolean value.
	BoolValue *BoolValue `protobuf:"bytes,7,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

func (*Criteria_TextArray) isCriteria_Value() {}

func (*Criteria_IntRangeArray) isCriteria_Value() {}

func (*Criteria_FloatRangeArray) isCriteria_Value() {}

func (*Criteria_DateTimeRangeArray) isCriteria_Value() {}

func (*Criteria_GeoLocationArray) isCriteria_Value() {}

func (*Criteria_BoolValue) isCriteria_Value() {}

// Partition to specify the partition in time and space for sub-asset level
// annotation.
type Partition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partition of asset in time.
	TemporalPartition *Partition_TemporalPartition `protobuf:"bytes,1,opt,name=temporal_partition,json=temporalPartition,proto3" json:"temporal_partition,omitempty"`
	// Partition of asset in space.
	SpatialPartition *Partition_SpatialPartition `protobuf:"bytes,2,opt,name=spatial_partition,json=spatialPartition,proto3" json:"spatial_partition,omitempty"`
	// Partition of asset in time.
	RelativeTemporalPartition *Partition_RelativeTemporalPartition `protobuf:"bytes,3,opt,name=relative_temporal_partition,json=relativeTemporalPartition,proto3" json:"relative_temporal_partition,omitempty"`
}

func (x *Partition) Reset() {
	*x = Partition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[151]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition) ProtoMessage() {}

func (x *Partition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[151]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition.ProtoReflect.Descriptor instead.
func (*Partition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{151}
}

func (x *Partition) GetTemporalPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartition
	}
	return nil
}

func (x *Partition) GetSpatialPartition() *Partition_SpatialPartition {
	if x != nil {
		return x.SpatialPartition
	}
	return nil
}

func (x *Partition) GetRelativeTemporalPartition() *Partition_RelativeTemporalPartition {
	if x != nil {
		return x.RelativeTemporalPartition
	}
	return nil
}

// The asset source is from Cloud Storage.
type AssetSource_AssetGcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud storage uri.
	GcsUri string `protobuf:"bytes,1,opt,name=gcs_uri,json=gcsUri,proto3" json:"gcs_uri,omitempty"`
}

func (x *AssetSource_AssetGcsSource) Reset() {
	*x = AssetSource_AssetGcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[152]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetSource_AssetGcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetSource_AssetGcsSource) ProtoMessage() {}

func (x *AssetSource_AssetGcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[152]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetSource_AssetGcsSource.ProtoReflect.Descriptor instead.
func (*AssetSource_AssetGcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{6, 0}
}

func (x *AssetSource_AssetGcsSource) GetGcsUri() string {
	if x != nil {
		return x.GcsUri
	}
	return ""
}

// The content of the asset.
type AssetSource_AssetContentData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AssetContentData []byte `protobuf:"bytes,1,opt,name=asset_content_data,json=assetContentData,proto3" json:"asset_content_data,omitempty"`
}

func (x *AssetSource_AssetContentData) Reset() {
	*x = AssetSource_AssetContentData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[153]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssetSource_AssetContentData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssetSource_AssetContentData) ProtoMessage() {}

func (x *AssetSource_AssetContentData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[153]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssetSource_AssetContentData.ProtoReflect.Descriptor instead.
func (*AssetSource_AssetContentData) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{6, 1}
}

func (x *AssetSource_AssetContentData) GetAssetContentData() []byte {
	if x != nil {
		return x.AssetContentData
	}
	return nil
}

// The status of analysis on each search capability.
type AnalyzeAssetMetadata_AnalysisStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	State         AnalyzeAssetMetadata_AnalysisStatus_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.visionai.v1.AnalyzeAssetMetadata_AnalysisStatus_State" json:"state,omitempty"`
	StatusMessage string                                    `protobuf:"bytes,3,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// The search capability requested.
	SearchCapability *SearchCapability `protobuf:"bytes,4,opt,name=search_capability,json=searchCapability,proto3" json:"search_capability,omitempty"`
}

func (x *AnalyzeAssetMetadata_AnalysisStatus) Reset() {
	*x = AnalyzeAssetMetadata_AnalysisStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[154]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeAssetMetadata_AnalysisStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeAssetMetadata_AnalysisStatus) ProtoMessage() {}

func (x *AnalyzeAssetMetadata_AnalysisStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[154]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeAssetMetadata_AnalysisStatus.ProtoReflect.Descriptor instead.
func (*AnalyzeAssetMetadata_AnalysisStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{14, 0}
}

func (x *AnalyzeAssetMetadata_AnalysisStatus) GetState() AnalyzeAssetMetadata_AnalysisStatus_State {
	if x != nil {
		return x.State
	}
	return AnalyzeAssetMetadata_AnalysisStatus_STATE_UNSPECIFIED
}

func (x *AnalyzeAssetMetadata_AnalysisStatus) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *AnalyzeAssetMetadata_AnalysisStatus) GetSearchCapability() *SearchCapability {
	if x != nil {
		return x.SearchCapability
	}
	return nil
}

// The configuration for `PROTO_ANY` data type.
type DataSchemaDetails_ProtoAnyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type URI of the proto message.
	TypeUri string `protobuf:"bytes,1,opt,name=type_uri,json=typeUri,proto3" json:"type_uri,omitempty"`
}

func (x *DataSchemaDetails_ProtoAnyConfig) Reset() {
	*x = DataSchemaDetails_ProtoAnyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[155]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails_ProtoAnyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails_ProtoAnyConfig) ProtoMessage() {}

func (x *DataSchemaDetails_ProtoAnyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[155]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails_ProtoAnyConfig.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails_ProtoAnyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68, 0}
}

func (x *DataSchemaDetails_ProtoAnyConfig) GetTypeUri() string {
	if x != nil {
		return x.TypeUri
	}
	return ""
}

// The configuration for `LIST` data type.
type DataSchemaDetails_ListConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value's data schema in the list.
	ValueSchema *DataSchemaDetails `protobuf:"bytes,1,opt,name=value_schema,json=valueSchema,proto3" json:"value_schema,omitempty"`
}

func (x *DataSchemaDetails_ListConfig) Reset() {
	*x = DataSchemaDetails_ListConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[156]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails_ListConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails_ListConfig) ProtoMessage() {}

func (x *DataSchemaDetails_ListConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[156]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails_ListConfig.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails_ListConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68, 1}
}

func (x *DataSchemaDetails_ListConfig) GetValueSchema() *DataSchemaDetails {
	if x != nil {
		return x.ValueSchema
	}
	return nil
}

// The configuration for `CUSTOMIZED_STRUCT` data type.
type DataSchemaDetails_CustomizedStructConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Direct child elements data schemas.
	FieldSchemas map[string]*DataSchemaDetails `protobuf:"bytes,1,rep,name=field_schemas,json=fieldSchemas,proto3" json:"field_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DataSchemaDetails_CustomizedStructConfig) Reset() {
	*x = DataSchemaDetails_CustomizedStructConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[157]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails_CustomizedStructConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails_CustomizedStructConfig) ProtoMessage() {}

func (x *DataSchemaDetails_CustomizedStructConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[157]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails_CustomizedStructConfig.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails_CustomizedStructConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68, 2}
}

func (x *DataSchemaDetails_CustomizedStructConfig) GetFieldSchemas() map[string]*DataSchemaDetails {
	if x != nil {
		return x.FieldSchemas
	}
	return nil
}

// The search strategy for annotations value of the `key`.
type DataSchemaDetails_SearchStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of search strategy to be applied on the `key` above.
	// The allowed `search_strategy_type` is different for different data types,
	// which is documented in the DataSchemaDetails.DataType. Specifying
	// unsupported `search_strategy_type` for data types will result in
	// INVALID_ARGUMENT error.
	SearchStrategyType *DataSchemaDetails_SearchStrategy_SearchStrategyType `protobuf:"varint,1,opt,name=search_strategy_type,json=searchStrategyType,proto3,enum=google.cloud.visionai.v1.DataSchemaDetails_SearchStrategy_SearchStrategyType,oneof" json:"search_strategy_type,omitempty"`
	// Optional. Configs the path to the confidence score, and the threshold.
	// Only if the score is greater than the threshold, current field will be
	// built into the index. Only applies to leaf nodes using EXACT_SEARCH or
	// SMART_SEARCH.
	ConfidenceScoreIndexConfig *DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig `protobuf:"bytes,2,opt,name=confidence_score_index_config,json=confidenceScoreIndexConfig,proto3" json:"confidence_score_index_config,omitempty"`
}

func (x *DataSchemaDetails_SearchStrategy) Reset() {
	*x = DataSchemaDetails_SearchStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[158]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails_SearchStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails_SearchStrategy) ProtoMessage() {}

func (x *DataSchemaDetails_SearchStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[158]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails_SearchStrategy.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails_SearchStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68, 3}
}

func (x *DataSchemaDetails_SearchStrategy) GetSearchStrategyType() DataSchemaDetails_SearchStrategy_SearchStrategyType {
	if x != nil && x.SearchStrategyType != nil {
		return *x.SearchStrategyType
	}
	return DataSchemaDetails_SearchStrategy_NO_SEARCH
}

func (x *DataSchemaDetails_SearchStrategy) GetConfidenceScoreIndexConfig() *DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig {
	if x != nil {
		return x.ConfidenceScoreIndexConfig
	}
	return nil
}

// Filter on the confidence score. Only adds to index if the confidence
// score is higher than the threshold.
// Example data schema:
// key: "name-confidence-pair"
// type: CUSTOMIZED_STRUCT
// granularity: GRANULARITY_PARTITION_LEVEL
//
//	customized_struct_config {
//	  field_schemas {
//	    key: "name"
//	    type: STRING
//	    granularity: GRANULARITY_PARTITION_LEVEL
//	    search_strategy {
//	      search_strategy_type: SMART_SEARCH
//	      confidence_score_index_config {
//	        field_path: "name-confidence-pair.score"
//	        threshold: 0.6
//	      }
//	    }
//	  }
//	  field_schemas {
//	    key: "score"
//	    type: FLOAT
//	    granularity: GRANULARITY_PARTITION_LEVEL
//	  }
//	}
//
// This means only "name" with score > 0.6 will be indexed.
type DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The path to the confidence score field. It is a string that
	// concatenates all the data schema keys along the path. See the example
	// above. If the data schema contains LIST, use '_ENTRIES' to concatenate.
	// Example data schema contains a list:
	// "key": "list-name-score",
	//
	//	"schemaDetails": {
	//	  "type": "LIST",
	//	  "granularity": "GRANULARITY_PARTITION_LEVEL",
	//	  "listConfig": {
	//	    "valueSchema": {
	//	      "type": "CUSTOMIZED_STRUCT",
	//	      "granularity": "GRANULARITY_PARTITION_LEVEL",
	//	      "customizedStructConfig": {
	//	        "fieldSchemas": {
	//	          "name": {
	//	            "type": "STRING",
	//	            "granularity": "GRANULARITY_PARTITION_LEVEL",
	//	            "searchStrategy": {
	//	              "searchStrategyType": "SMART_SEARCH"
	//	              "confidence_score_index_config": {
	//	                "field_path": "list-name-score._ENTRIES.score",
	//	                "threshold": "0.9",
	//	              }
	//	            }
	//	          },
	//	          "score": {
	//	            "type": "FLOAT",
	//	            "granularity": "GRANULARITY_PARTITION_LEVEL",
	//	          }
	//	        }
	//	      }
	//	    }
	//	  }
	//	}
	FieldPath string `protobuf:"bytes,1,opt,name=field_path,json=fieldPath,proto3" json:"field_path,omitempty"`
	// Required. The threshold.
	Threshold float32 `protobuf:"fixed32,2,opt,name=threshold,proto3" json:"threshold,omitempty"`
}

func (x *DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig) Reset() {
	*x = DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[160]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig) ProtoMessage() {}

func (x *DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[160]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{68, 3, 0}
}

func (x *DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig) GetFieldPath() string {
	if x != nil {
		return x.FieldPath
	}
	return ""
}

func (x *DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig) GetThreshold() float32 {
	if x != nil {
		return x.Threshold
	}
	return 0
}

// If bucket type is FIXED_RANGE, specify how values are bucketized. Use
// FixedRangeBucketSpec when you want to create multiple buckets with equal
// granularities. Using integer bucket value as an example, when
// bucket_start = 0, bucket_granularity = 10, bucket_count = 5, this facet
// will be aggregated via the following buckets:
// [-inf, 0), [0, 10), [10, 20), [20, 30), [30, inf).
// Notably, bucket_count <= 1 is an invalid spec.
type FacetProperty_FixedRangeBucketSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound of the bucket. NOTE: Only integer type is currently supported
	// for this field.
	BucketStart *FacetValue `protobuf:"bytes,1,opt,name=bucket_start,json=bucketStart,proto3" json:"bucket_start,omitempty"`
	// Bucket granularity. NOTE: Only integer type is currently supported for
	// this field.
	BucketGranularity *FacetValue `protobuf:"bytes,2,opt,name=bucket_granularity,json=bucketGranularity,proto3" json:"bucket_granularity,omitempty"`
	// Total number of buckets.
	BucketCount int32 `protobuf:"varint,3,opt,name=bucket_count,json=bucketCount,proto3" json:"bucket_count,omitempty"`
}

func (x *FacetProperty_FixedRangeBucketSpec) Reset() {
	*x = FacetProperty_FixedRangeBucketSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[163]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetProperty_FixedRangeBucketSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetProperty_FixedRangeBucketSpec) ProtoMessage() {}

func (x *FacetProperty_FixedRangeBucketSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[163]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetProperty_FixedRangeBucketSpec.ProtoReflect.Descriptor instead.
func (*FacetProperty_FixedRangeBucketSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{113, 0}
}

func (x *FacetProperty_FixedRangeBucketSpec) GetBucketStart() *FacetValue {
	if x != nil {
		return x.BucketStart
	}
	return nil
}

func (x *FacetProperty_FixedRangeBucketSpec) GetBucketGranularity() *FacetValue {
	if x != nil {
		return x.BucketGranularity
	}
	return nil
}

func (x *FacetProperty_FixedRangeBucketSpec) GetBucketCount() int32 {
	if x != nil {
		return x.BucketCount
	}
	return 0
}

// If bucket type is CUSTOM_RANGE, specify how values are bucketized. Use
// integer bucket value as an example, when the endpoints are 0, 10, 100, and
// 1000, we will generate the following facets:
// [-inf, 0), [0, 10), [10, 100), [100, 1000), [1000, inf).
// Notably:
//   - endpoints must be listed in ascending order. Otherwise, the SearchConfig
//     API will reject the facet config.
//   - < 1 endpoints is an invalid spec.
type FacetProperty_CustomRangeBucketSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Currently, only integer type is supported for this field.
	Endpoints []*FacetValue `protobuf:"bytes,1,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
}

func (x *FacetProperty_CustomRangeBucketSpec) Reset() {
	*x = FacetProperty_CustomRangeBucketSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[164]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetProperty_CustomRangeBucketSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetProperty_CustomRangeBucketSpec) ProtoMessage() {}

func (x *FacetProperty_CustomRangeBucketSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[164]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetProperty_CustomRangeBucketSpec.ProtoReflect.Descriptor instead.
func (*FacetProperty_CustomRangeBucketSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{113, 1}
}

func (x *FacetProperty_CustomRangeBucketSpec) GetEndpoints() []*FacetValue {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

// If bucket type is DATE, specify how date values are bucketized.
type FacetProperty_DateTimeBucketSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Granularity of date type facet.
	Granularity FacetProperty_DateTimeBucketSpec_Granularity `protobuf:"varint,1,opt,name=granularity,proto3,enum=google.cloud.visionai.v1.FacetProperty_DateTimeBucketSpec_Granularity" json:"granularity,omitempty"`
}

func (x *FacetProperty_DateTimeBucketSpec) Reset() {
	*x = FacetProperty_DateTimeBucketSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[165]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetProperty_DateTimeBucketSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetProperty_DateTimeBucketSpec) ProtoMessage() {}

func (x *FacetProperty_DateTimeBucketSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[165]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetProperty_DateTimeBucketSpec.ProtoReflect.Descriptor instead.
func (*FacetProperty_DateTimeBucketSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{113, 2}
}

func (x *FacetProperty_DateTimeBucketSpec) GetGranularity() FacetProperty_DateTimeBucketSpec_Granularity {
	if x != nil {
		return x.Granularity
	}
	return FacetProperty_DateTimeBucketSpec_GRANULARITY_UNSPECIFIED
}

// The range of values [start, end) for which faceting is applied.
type FacetBucket_Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the range. Non-existence indicates some bound (e.g. -inf).
	Start *FacetValue `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// End of the range. Non-existence indicates some bound (e.g. inf).
	End *FacetValue `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *FacetBucket_Range) Reset() {
	*x = FacetBucket_Range{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[166]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetBucket_Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetBucket_Range) ProtoMessage() {}

func (x *FacetBucket_Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[166]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetBucket_Range.ProtoReflect.Descriptor instead.
func (*FacetBucket_Range) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{123, 0}
}

func (x *FacetBucket_Range) GetStart() *FacetValue {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *FacetBucket_Range) GetEnd() *FacetValue {
	if x != nil {
		return x.End
	}
	return nil
}

// Configuration for the data.
type IngestAssetRequest_Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to DataType:
	//
	//	*IngestAssetRequest_Config_VideoType_
	DataType isIngestAssetRequest_Config_DataType `protobuf_oneof:"data_type"`
	// Required. The resource name of the asset that the ingested data belongs
	// to.
	Asset string `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
}

func (x *IngestAssetRequest_Config) Reset() {
	*x = IngestAssetRequest_Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[167]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetRequest_Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetRequest_Config) ProtoMessage() {}

func (x *IngestAssetRequest_Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[167]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetRequest_Config.ProtoReflect.Descriptor instead.
func (*IngestAssetRequest_Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{125, 0}
}

func (m *IngestAssetRequest_Config) GetDataType() isIngestAssetRequest_Config_DataType {
	if m != nil {
		return m.DataType
	}
	return nil
}

func (x *IngestAssetRequest_Config) GetVideoType() *IngestAssetRequest_Config_VideoType {
	if x, ok := x.GetDataType().(*IngestAssetRequest_Config_VideoType_); ok {
		return x.VideoType
	}
	return nil
}

func (x *IngestAssetRequest_Config) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

type isIngestAssetRequest_Config_DataType interface {
	isIngestAssetRequest_Config_DataType()
}

type IngestAssetRequest_Config_VideoType_ struct {
	// Type information for video data.
	VideoType *IngestAssetRequest_Config_VideoType `protobuf:"bytes,2,opt,name=video_type,json=videoType,proto3,oneof"`
}

func (*IngestAssetRequest_Config_VideoType_) isIngestAssetRequest_Config_DataType() {}

// Contains the data and the corresponding time range this data is for.
type IngestAssetRequest_TimeIndexedData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data to be ingested.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Time range of the data.
	TemporalPartition *Partition_TemporalPartition `protobuf:"bytes,2,opt,name=temporal_partition,json=temporalPartition,proto3" json:"temporal_partition,omitempty"`
}

func (x *IngestAssetRequest_TimeIndexedData) Reset() {
	*x = IngestAssetRequest_TimeIndexedData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[168]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetRequest_TimeIndexedData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetRequest_TimeIndexedData) ProtoMessage() {}

func (x *IngestAssetRequest_TimeIndexedData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[168]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetRequest_TimeIndexedData.ProtoReflect.Descriptor instead.
func (*IngestAssetRequest_TimeIndexedData) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{125, 1}
}

func (x *IngestAssetRequest_TimeIndexedData) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *IngestAssetRequest_TimeIndexedData) GetTemporalPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartition
	}
	return nil
}

// Type information for video data.
type IngestAssetRequest_Config_VideoType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Container format of the video data.
	ContainerFormat IngestAssetRequest_Config_VideoType_ContainerFormat `protobuf:"varint,1,opt,name=container_format,json=containerFormat,proto3,enum=google.cloud.visionai.v1.IngestAssetRequest_Config_VideoType_ContainerFormat" json:"container_format,omitempty"`
}

func (x *IngestAssetRequest_Config_VideoType) Reset() {
	*x = IngestAssetRequest_Config_VideoType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[169]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetRequest_Config_VideoType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetRequest_Config_VideoType) ProtoMessage() {}

func (x *IngestAssetRequest_Config_VideoType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[169]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetRequest_Config_VideoType.ProtoReflect.Descriptor instead.
func (*IngestAssetRequest_Config_VideoType) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{125, 0, 0}
}

func (x *IngestAssetRequest_Config_VideoType) GetContainerFormat() IngestAssetRequest_Config_VideoType_ContainerFormat {
	if x != nil {
		return x.ContainerFormat
	}
	return IngestAssetRequest_Config_VideoType_CONTAINER_FORMAT_UNSPECIFIED
}

// Signed uri with corresponding time range.
type ClipAssetResponse_TimeIndexedUri struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time range of the video that the uri is for.
	TemporalPartition *Partition_TemporalPartition `protobuf:"bytes,1,opt,name=temporal_partition,json=temporalPartition,proto3" json:"temporal_partition,omitempty"`
	// Signed uri to download the video clip.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *ClipAssetResponse_TimeIndexedUri) Reset() {
	*x = ClipAssetResponse_TimeIndexedUri{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[170]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClipAssetResponse_TimeIndexedUri) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClipAssetResponse_TimeIndexedUri) ProtoMessage() {}

func (x *ClipAssetResponse_TimeIndexedUri) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[170]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClipAssetResponse_TimeIndexedUri.ProtoReflect.Descriptor instead.
func (*ClipAssetResponse_TimeIndexedUri) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{128, 0}
}

func (x *ClipAssetResponse_TimeIndexedUri) GetTemporalPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartition
	}
	return nil
}

func (x *ClipAssetResponse_TimeIndexedUri) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Option for one data schema key.
type SchemaKeySortingStrategy_Option struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data used to sort.
	DataSchemaKey string `protobuf:"bytes,1,opt,name=data_schema_key,json=dataSchemaKey,proto3" json:"data_schema_key,omitempty"`
	// Whether to sort in decreasing order or increasing order.
	// By default, results are sorted in incresing order.
	SortDecreasing bool `protobuf:"varint,2,opt,name=sort_decreasing,json=sortDecreasing,proto3" json:"sort_decreasing,omitempty"`
	// Aggregate method for the current data schema key.
	AggregateMethod *SchemaKeySortingStrategy_Option_AggregateMethod `protobuf:"varint,3,opt,name=aggregate_method,json=aggregateMethod,proto3,enum=google.cloud.visionai.v1.SchemaKeySortingStrategy_Option_AggregateMethod,oneof" json:"aggregate_method,omitempty"`
}

func (x *SchemaKeySortingStrategy_Option) Reset() {
	*x = SchemaKeySortingStrategy_Option{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[171]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemaKeySortingStrategy_Option) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaKeySortingStrategy_Option) ProtoMessage() {}

func (x *SchemaKeySortingStrategy_Option) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[171]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaKeySortingStrategy_Option.ProtoReflect.Descriptor instead.
func (*SchemaKeySortingStrategy_Option) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{134, 0}
}

func (x *SchemaKeySortingStrategy_Option) GetDataSchemaKey() string {
	if x != nil {
		return x.DataSchemaKey
	}
	return ""
}

func (x *SchemaKeySortingStrategy_Option) GetSortDecreasing() bool {
	if x != nil {
		return x.SortDecreasing
	}
	return false
}

func (x *SchemaKeySortingStrategy_Option) GetAggregateMethod() SchemaKeySortingStrategy_Option_AggregateMethod {
	if x != nil && x.AggregateMethod != nil {
		return *x.AggregateMethod
	}
	return SchemaKeySortingStrategy_Option_AGGREGATE_METHOD_UNSPECIFIED
}

// Partition of asset in UTC Epoch time. Supported by STREAM_VIDEO corpus
// type.
type Partition_TemporalPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time of the partition.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the partition.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Partition_TemporalPartition) Reset() {
	*x = Partition_TemporalPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[172]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition_TemporalPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition_TemporalPartition) ProtoMessage() {}

func (x *Partition_TemporalPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[172]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition_TemporalPartition.ProtoReflect.Descriptor instead.
func (*Partition_TemporalPartition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{151, 0}
}

func (x *Partition_TemporalPartition) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Partition_TemporalPartition) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Partition of asset in space.
type Partition_SpatialPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum x coordinate value.
	XMin *int64 `protobuf:"varint,1,opt,name=x_min,json=xMin,proto3,oneof" json:"x_min,omitempty"`
	// The minimum y coordinate value.
	YMin *int64 `protobuf:"varint,2,opt,name=y_min,json=yMin,proto3,oneof" json:"y_min,omitempty"`
	// The maximum x coordinate value.
	XMax *int64 `protobuf:"varint,3,opt,name=x_max,json=xMax,proto3,oneof" json:"x_max,omitempty"`
	// The maximum y coordinate value.
	YMax *int64 `protobuf:"varint,4,opt,name=y_max,json=yMax,proto3,oneof" json:"y_max,omitempty"`
}

func (x *Partition_SpatialPartition) Reset() {
	*x = Partition_SpatialPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[173]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition_SpatialPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition_SpatialPartition) ProtoMessage() {}

func (x *Partition_SpatialPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[173]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition_SpatialPartition.ProtoReflect.Descriptor instead.
func (*Partition_SpatialPartition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{151, 1}
}

func (x *Partition_SpatialPartition) GetXMin() int64 {
	if x != nil && x.XMin != nil {
		return *x.XMin
	}
	return 0
}

func (x *Partition_SpatialPartition) GetYMin() int64 {
	if x != nil && x.YMin != nil {
		return *x.YMin
	}
	return 0
}

func (x *Partition_SpatialPartition) GetXMax() int64 {
	if x != nil && x.XMax != nil {
		return *x.XMax
	}
	return 0
}

func (x *Partition_SpatialPartition) GetYMax() int64 {
	if x != nil && x.YMax != nil {
		return *x.YMax
	}
	return 0
}

// Partition of asset in relative time. Supported by VIDEO_ON_DEMAND corpus
// type.
type Partition_RelativeTemporalPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time offset of the partition.
	StartOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// End time offset of the partition.
	EndOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
}

func (x *Partition_RelativeTemporalPartition) Reset() {
	*x = Partition_RelativeTemporalPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[174]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition_RelativeTemporalPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition_RelativeTemporalPartition) ProtoMessage() {}

func (x *Partition_RelativeTemporalPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_warehouse_proto_msgTypes[174]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition_RelativeTemporalPartition.ProtoReflect.Descriptor instead.
func (*Partition_RelativeTemporalPartition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP(), []int{151, 2}
}

func (x *Partition_RelativeTemporalPartition) GetStartOffset() *durationpb.Duration {
	if x != nil {
		return x.StartOffset
	}
	return nil
}

func (x *Partition_RelativeTemporalPartition) GetEndOffset() *durationpb.Duration {
	if x != nil {
		return x.EndOffset
	}
	return nil
}

var File_google_cloud_visionai_v1_warehouse_proto protoreflect.FileDescriptor

var file_google_cloud_visionai_v1_warehouse_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xc2, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x12, 0x23, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x49, 0x64, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x22, 0x4c, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1f, 0x12, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x75, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x05, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x4f, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f,
	0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd3, 0x02, 0x0a, 0x0b, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x60, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x67,
	0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x47, 0x63, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x47, 0x63,
	0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x66, 0x0a, 0x12, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x10, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x1a,
	0x29, 0x0a, 0x0e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x1a, 0x40, 0x0a, 0x10, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2c,
	0x0a, 0x12, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x42, 0x0d, 0x0a, 0x0b,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x22, 0x99, 0x01, 0x0a, 0x12,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a,
	0x0c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0b, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x15, 0x0a, 0x13, 0x55, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8d,
	0x01, 0x0a, 0x13, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x58,
	0x0a, 0x1b, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x3d, 0x0a, 0x1c, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x55, 0x72, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x55, 0x72, 0x69, 0x22, 0xa1, 0x02, 0x0a, 0x05, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x74,
	0x74, 0x6c, 0x12, 0x63, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x47, 0x63,
	0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3a, 0x72, 0xea, 0x41, 0x6f, 0x0a, 0x1d, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x4e, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x7d, 0x22, 0x50, 0x0a, 0x13, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb0, 0x04,
	0x0a, 0x14, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x66, 0x0a, 0x0f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xb7, 0x02, 0x0a, 0x0e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x59, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x57, 0x0a, 0x11, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x22, 0x4a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03,
	0x22, 0x16, 0x0a, 0x14, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x49, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x4a, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x22, 0x8b, 0x01, 0x0a, 0x11, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xce, 0x01, 0x0a, 0x12, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x14, 0x0a, 0x12, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x91,
	0x01, 0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f,
	0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x22, 0xe5, 0x01, 0x0a, 0x18, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x51, 0x0a, 0x0f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8c, 0x02, 0x0a, 0x0c, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x3b, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x18, 0x56, 0x69, 0x65, 0x77, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3b, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x22, 0x92, 0x01, 0x0a, 0x19, 0x56, 0x69, 0x65, 0x77, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4d, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x71, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x06,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x90, 0x01, 0x0a, 0x14,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x8b,
	0x01, 0x0a, 0x10, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x32, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4d, 0x42, 0x45, 0x44, 0x44,
	0x49, 0x4e, 0x47, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x01, 0x22, 0x76, 0x0a, 0x17,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x5b, 0x0a, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x22, 0x76, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x5a, 0x0a, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xe5, 0x01, 0x0a,
	0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x88,
	0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x22, 0x76, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x5a, 0x0a, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x59, 0x0a, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa1, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x98, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x89,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5d, 0x0a, 0x18, 0x41, 0x64,
	0x64, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x22, 0x59, 0x0a, 0x19, 0x41, 0x64, 0x64,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04,
	0x69, 0x74, 0x65, 0x6d, 0x22, 0x60, 0x0a, 0x1b, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x22, 0x5c, 0x0a, 0x1c, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x04,
	0x69, 0x74, 0x65, 0x6d, 0x22, 0xa4, 0x01, 0x0a, 0x1a, 0x56, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x85, 0x01, 0x0a, 0x1b,
	0x56, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74,
	0x65, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x69,
	0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xf8, 0x01, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e,
	0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xf7,
	0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x69, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0x27, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x41, 0x53, 0x53, 0x45, 0x54, 0x10, 0x01, 0x22, 0xb0, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1e, 0x0a, 0x08, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x49, 0x64, 0x12,
	0x3a, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x71, 0x0a, 0x13, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x5a, 0x0a, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x92,
	0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x71, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5a, 0x0a, 0x12, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x4c, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x78, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a,
	0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x4f, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x15, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8c, 0x05, 0x0a, 0x05, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x25, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x69, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x65, 0x6e, 0x74,
	0x69, 0x72, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x22, 0x47, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x3a, 0x73, 0xea, 0x41, 0x70, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x7d, 0x42, 0x0e, 0x0a, 0x0c, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x6e, 0x0a, 0x16, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x54, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x05, 0xfa, 0x41,
	0x27, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x91, 0x04, 0x0a, 0x06, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x0b, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x74, 0x74, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x54, 0x74, 0x6c, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x6d, 0x0a, 0x19, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x17, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x4e, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x5f, 0x56, 0x49,
	0x44, 0x45, 0x4f, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x02,
	0x12, 0x13, 0x0a, 0x0f, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d,
	0x41, 0x4e, 0x44, 0x10, 0x03, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x22, 0x4e, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x13,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x85, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x79, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a,
	0x0a, 0x07, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x52, 0x07, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x51, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x52, 0x0a, 0x14, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x15, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x47, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x17, 0x0a, 0x15, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x4a, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x90, 0x02, 0x0a,
	0x0a, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x52, 0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0d, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f,
	0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x12, 0x59, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x7d, 0x22,
	0xa2, 0x0e, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x64, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x61, 0x6e,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x41, 0x6e, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x41, 0x6e, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0b, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x7c, 0x0a, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x69, 0x7a, 0x65, 0x64, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x5e, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x01, 0x52, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x88, 0x01,
	0x01, 0x12, 0x63, 0x0a, 0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x1a, 0x2b, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x41,
	0x6e, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x79, 0x70, 0x65,
	0x55, 0x72, 0x69, 0x1a, 0x5c, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x4e, 0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x1a, 0x81, 0x02, 0x0a, 0x16, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x0d,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x1a, 0x6c, 0x0a, 0x11, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x41,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xfe, 0x03, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x84, 0x01, 0x0a, 0x14, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x9d, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x1a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0x63, 0x0a, 0x1a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a,
	0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x21, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x22, 0x47, 0x0a, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f,
	0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x58, 0x41,
	0x43, 0x54, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53,
	0x4d, 0x41, 0x52, 0x54, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x02, 0x42, 0x17, 0x0a,
	0x15, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x46,
	0x4c, 0x4f, 0x41, 0x54, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x05,
	0x12, 0x12, 0x0a, 0x0e, 0x47, 0x45, 0x4f, 0x5f, 0x43, 0x4f, 0x4f, 0x52, 0x44, 0x49, 0x4e, 0x41,
	0x54, 0x45, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x5f, 0x41, 0x4e,
	0x59, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x09,
	0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x0a, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x55,
	0x53, 0x54, 0x4f, 0x4d, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x10,
	0x06, 0x22, 0x68, 0x0a, 0x0b, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x1b, 0x0a, 0x17, 0x47, 0x52, 0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a,
	0x17, 0x47, 0x52, 0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x41, 0x53, 0x53,
	0x45, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x52,
	0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x02, 0x42, 0x07, 0x0a, 0x05, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61,
	0x72, 0x69, 0x74, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x59, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x98, 0x01, 0x0a,
	0x16, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12,
	0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe4, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x49, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x0d, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x22, 0xa3, 0x02, 0x0a, 0x0a,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6d,
	0x0a, 0x19, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x75, 0x73, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x91, 0x01,
	0xea, 0x41, 0x8d, 0x01, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x22, 0xb4, 0x01, 0x0a, 0x17, 0x55, 0x73, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x41, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x49, 0x0a, 0x0d, 0x47, 0x65, 0x6f, 0x43,
	0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x74,
	0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x74,
	0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74, 0x75,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74,
	0x75, 0x64, 0x65, 0x22, 0xee, 0x04, 0x0a, 0x0f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x66,
	0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x73, 0x74, 0x72,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08,
	0x73, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x27, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x65,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x50, 0x0a, 0x0e, 0x67, 0x65, 0x6f, 0x5f, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6f, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x65, 0x6f, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x61, 0x6e, 0x79,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x41, 0x6e, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x5a, 0x0a, 0x1c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a,
	0x65, 0x64, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65,
	0x64, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x49, 0x0a, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x09, 0x6c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x6e, 0x0a, 0x17, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x48, 0x00, 0x52, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x53, 0x0a, 0x0e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xe4, 0x01, 0x0a, 0x1a, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a,
	0x65, 0x64, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x12, 0x5e, 0x0a, 0x08, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x66, 0x0a, 0x0d, 0x45, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xa8, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f,
	0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x89, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa1, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x59, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x87,
	0x01, 0x0a, 0x13, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x47, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x3e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x5f, 0x0a, 0x14, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x47, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x16, 0x0a, 0x14, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xe2, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xaa, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x5a, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x5d, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9c,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x12, 0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x92, 0x01,
	0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0e, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xea, 0x02, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0e, 0x66, 0x61, 0x63, 0x65, 0x74,
	0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0d, 0x66, 0x61, 0x63, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x6a, 0x0a, 0x18, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x16, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x3a, 0x89, 0x01, 0xea, 0x41, 0x85, 0x01, 0x0a, 0x24, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x5d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x7d, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22,
	0xf1, 0x05, 0x0a, 0x0d, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x48,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x50, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x53, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x73,
	0xea, 0x41, 0x70, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x7d, 0x22, 0xe5, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x79, 0x0a, 0x1b, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5a, 0x0a, 0x12, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x5c, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x96, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x0f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xb3, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x53, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x79, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5a, 0x0a, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x5f, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x79, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x5a, 0x0a, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xbf,
	0x01, 0x0a, 0x12, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0d, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x22, 0x15, 0x0a, 0x13, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x5a, 0x0a, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4c, 0x0a, 0x0e, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xc1, 0x01, 0x0a, 0x15, 0x55, 0x6e,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x5a, 0x0a, 0x12, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x11, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x4c, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x0d,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x6c, 0x0a,
	0x14, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0d, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x17, 0x0a, 0x15, 0x55,
	0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0x0a, 0x0d, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x3b, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x22, 0xbd, 0x08, 0x0a, 0x0d, 0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x75, 0x0a, 0x17, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x46,
	0x69, 0x78, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x14, 0x66, 0x69, 0x78, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x78, 0x0a, 0x18, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x15,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6e, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x44, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x48,
	0x00, 0x52, 0x12, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x61,
	0x70, 0x70, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x4a,
	0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xd7, 0x01, 0x0a, 0x14, 0x46,
	0x69, 0x78, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x47, 0x0a, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x53, 0x0a, 0x12,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x5b, 0x0a, 0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x42, 0x0a,
	0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x1a, 0xc8, 0x01, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x68, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c,
	0x61, 0x72, 0x69, 0x74, 0x79, 0x52, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x22, 0x48, 0x0a, 0x0b, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x52, 0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08,
	0x0a, 0x04, 0x59, 0x45, 0x41, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x54,
	0x48, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x41, 0x59, 0x10, 0x03, 0x42, 0x14, 0x0a, 0x12,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0xf8, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70,
	0x65, 0x72, 0x6e, 0x79, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x79, 0x70,
	0x65, 0x72, 0x6e, 0x79, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x79,
	0x70, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x68, 0x79, 0x70, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x3a, 0x8f, 0x01, 0xea, 0x41,
	0x8b, 0x01, 0x0a, 0x26, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x12, 0x61, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x7d, 0x22, 0x84, 0x02,
	0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79,
	0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a,
	0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70,
	0x65, 0x72, 0x6e, 0x79, 0x6d, 0x12, 0x36, 0x0a, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x49, 0x64, 0x88, 0x01, 0x01, 0x42, 0x15, 0x0a,
	0x13, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79,
	0x6d, 0x5f, 0x69, 0x64, 0x22, 0xb2, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x68,
	0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48,
	0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5e, 0x0a, 0x18, 0x47, 0x65, 0x74,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x6e, 0x79, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x61, 0x0a, 0x1b, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79,
	0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79,
	0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a,
	0x1a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x6e, 0x79, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x28, 0x12, 0x26, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x9a, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79,
	0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x53, 0x0a, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e,
	0x79, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x6e, 0x79, 0x6d, 0x52, 0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x6e, 0x79, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x3d, 0x0a, 0x16,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x70, 0x70, 0x65, 0x64,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6d,
	0x61, 0x70, 0x70, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0xa1, 0x01, 0x0a, 0x0a,
	0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x25, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65,
	0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3e, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xb9, 0x02, 0x0a, 0x0b, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x3c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43, 0x0a,
	0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x05, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x1a, 0x7b,
	0x0a, 0x05, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x12, 0x36, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x93, 0x02, 0x0a, 0x0a,
	0x46, 0x61, 0x63, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x66, 0x61,
	0x63, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x61,
	0x63, 0x65, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a, 0x19, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x66, 0x65, 0x74, 0x63, 0x68, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0xfe, 0x05, 0x0a, 0x12, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x11, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x1a, 0x89, 0x03, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e,
	0x0a, 0x0a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x48, 0x00, 0x52, 0x09, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b,
	0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x1a, 0xd4, 0x01, 0x0a, 0x09,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x78, 0x0a, 0x10, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x54, 0x79,
	0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x22, 0x4d, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49,
	0x4e, 0x45, 0x52, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x4f, 0x4e, 0x54,
	0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x4d, 0x50, 0x34,
	0x10, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a,
	0x8b, 0x01, 0x0a, 0x0f, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f,
	0x72, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x74, 0x65, 0x6d, 0x70,
	0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x13, 0x0a,
	0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x22, 0x94, 0x01, 0x0a, 0x13, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7d, 0x0a, 0x1f, 0x73, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x69, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1d, 0x73, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb8, 0x01, 0x0a, 0x10, 0x43, 0x6c,
	0x69, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x69, 0x0a, 0x12, 0x74, 0x65, 0x6d,
	0x70, 0x6f, 0x72, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f,
	0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x86, 0x02, 0x0a, 0x11, 0x43, 0x6c, 0x69, 0x70, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x11, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x69, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x55, 0x72,
	0x69, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x55, 0x72,
	0x69, 0x73, 0x1a, 0x88, 0x01, 0x0a, 0x0e, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x65, 0x64, 0x55, 0x72, 0x69, 0x12, 0x64, 0x0a, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61,
	0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72,
	0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xe6, 0x01,
	0x0a, 0x15, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x73, 0x55, 0x72, 0x69,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x66, 0x0a, 0x13, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x69,
	0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6c, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x92, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x48, 0x6c, 0x73, 0x55, 0x72, 0x69, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x12, 0x66, 0x0a, 0x13, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xdb, 0x04, 0x0a, 0x13,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x73, 0x0a, 0x1b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x73, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65, 0x79, 0x53, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x18,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65, 0x79, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x3e, 0x0a, 0x06, 0x63, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x52, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x5c, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x52,
	0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x12, 0x3e, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x61, 0x12, 0x4f, 0x0a, 0x10, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x0f, 0x66, 0x61, 0x63, 0x65, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x14, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x0b, 0x0a, 0x09,
	0x73, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0xb4, 0x03, 0x0a, 0x1a, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x0b, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x1f, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x54, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x61, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x08,
	0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x51, 0x0a, 0x12, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x22, 0x74, 0x0a, 0x0a, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x21,
	0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x12, 0x3a, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x48, 0x00, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x42, 0x07, 0x0a,
	0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x22, 0xcd, 0x03, 0x0a, 0x18, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x4b, 0x65, 0x79, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x12, 0x53, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65, 0x79, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xdb, 0x02, 0x0a, 0x06, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x73,
	0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x63, 0x72, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x63, 0x72, 0x65, 0x61,
	0x73, 0x69, 0x6e, 0x67, 0x12, 0x79, 0x0a, 0x10, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x4b, 0x65, 0x79, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x88, 0x01, 0x01, 0x22,
	0x70, 0x0a, 0x0f, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x45, 0x5f,
	0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54,
	0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x53, 0x54,
	0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x45, 0x5f,
	0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x45, 0x53, 0x54, 0x10,
	0x02, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x15, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xdd, 0x01,
	0x0a, 0x18, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3e, 0x0a, 0x08, 0x63, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61,
	0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x55, 0x0a, 0x13, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xbd, 0x03,
	0x0a, 0x10, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49, 0x74,
	0x65, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x55, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x4f, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x59,
	0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x72, 0x0a, 0x1b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x19, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0xe5, 0x01,
	0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52,
	0x11, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49, 0x74, 0x65,
	0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x49, 0x0a, 0x0d, 0x66, 0x61,
	0x63, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0c, 0x66, 0x61, 0x63, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0xa1, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x11,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49, 0x74, 0x65, 0x6d,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4e, 0x0a, 0x08, 0x49, 0x6e, 0x74,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x15, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52,
	0x03, 0x65, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x65, 0x6e, 0x64, 0x22, 0x50, 0x0a, 0x0a, 0x46, 0x6c, 0x6f,
	0x61, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x88,
	0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48,
	0x01, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x65, 0x6e, 0x64, 0x22, 0x2c, 0x0a, 0x0b, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x78,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09,
	0x74, 0x78, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x52, 0x0a, 0x0d, 0x49, 0x6e, 0x74,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x41, 0x0a, 0x0a, 0x69, 0x6e,
	0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0x5a, 0x0a,
	0x0f, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79,
	0x12, 0x47, 0x0a, 0x0c, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0b, 0x66, 0x6c,
	0x6f, 0x61, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0x65, 0x0a, 0x0d, 0x44, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x27, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x03, 0x65, 0x6e, 0x64,
	0x22, 0x67, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x51, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0x69, 0x0a, 0x0a, 0x43, 0x69, 0x72,
	0x63, 0x6c, 0x65, 0x41, 0x72, 0x65, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x74, 0x69, 0x74,
	0x75, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x74, 0x69, 0x74,
	0x75, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74, 0x75, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74, 0x75, 0x64,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x4d,
	0x65, 0x74, 0x65, 0x72, 0x22, 0x5b, 0x0a, 0x10, 0x47, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x47, 0x0a, 0x0c, 0x63, 0x69, 0x72, 0x63,
	0x6c, 0x65, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x69, 0x72, 0x63, 0x6c, 0x65,
	0x41, 0x72, 0x65, 0x61, 0x52, 0x0b, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x41, 0x72, 0x65, 0x61,
	0x73, 0x22, 0x21, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0xde, 0x04, 0x0a, 0x08, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x12, 0x46, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x09,
	0x74, 0x65, 0x78, 0x74, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x51, 0x0a, 0x0f, 0x69, 0x6e, 0x74,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x69,
	0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x57, 0x0a, 0x11,
	0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x61, 0x72, 0x72, 0x61,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72,
	0x61, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x61, 0x0a, 0x15, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72,
	0x61, 0x79, 0x48, 0x00, 0x52, 0x12, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x5a, 0x0a, 0x12, 0x67, 0x65, 0x6f, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72, 0x72, 0x61, 0x79,
	0x48, 0x00, 0x52, 0x10, 0x67, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x72, 0x72, 0x61, 0x79, 0x12, 0x44, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52,
	0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x3a, 0x0a, 0x19, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x17, 0x66, 0x65, 0x74, 0x63, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x07, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x96, 0x06, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x11, 0x73, 0x70, 0x61,
	0x74, 0x69, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x70, 0x61, 0x74, 0x69, 0x61,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x73, 0x70, 0x61, 0x74,
	0x69, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x1b,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61,
	0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x54,
	0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x19, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72,
	0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x85, 0x01, 0x0a, 0x11,
	0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0xa2, 0x01, 0x0a, 0x10, 0x53, 0x70, 0x61, 0x74, 0x69, 0x61, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x69,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x04, 0x78, 0x4d, 0x69, 0x6e, 0x88,
	0x01, 0x01, 0x12, 0x18, 0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x01, 0x52, 0x04, 0x79, 0x4d, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x18, 0x0a, 0x05,
	0x78, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52, 0x04, 0x78,
	0x4d, 0x61, 0x78, 0x88, 0x01, 0x01, 0x12, 0x18, 0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x61, 0x78, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x04, 0x79, 0x4d, 0x61, 0x78, 0x88, 0x01, 0x01,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x78, 0x5f, 0x6d, 0x69, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x79,
	0x5f, 0x6d, 0x69, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x78, 0x5f, 0x6d, 0x61, 0x78, 0x42, 0x08,
	0x0a, 0x06, 0x5f, 0x79, 0x5f, 0x6d, 0x61, 0x78, 0x1a, 0x93, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x2a, 0xb8,
	0x01, 0x0a, 0x0f, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b,
	0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42,
	0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45,
	0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b,
	0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d, 0x45,
	0x10, 0x02, 0x12, 0x21, 0x0a, 0x1d, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b,
	0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x49, 0x58, 0x45, 0x44, 0x5f, 0x52, 0x41,
	0x4e, 0x47, 0x45, 0x10, 0x03, 0x12, 0x22, 0x0a, 0x1e, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42,
	0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f,
	0x4d, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x04, 0x32, 0x91, 0x66, 0x0a, 0x09, 0x57, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x12, 0xb9, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x22, 0x5b, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x22, 0x34, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x22, 0x5d, 0xda, 0x41, 0x11, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x05,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0x9b, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xae, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x12, 0xce, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0xca,
	0x41, 0x2c, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x2a, 0x34, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xcf, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73,
	0xca, 0x41, 0x2a, 0x0a, 0x13, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x13, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x40, 0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0xdb, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c,
	0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x55, 0x72,
	0x6c, 0x12, 0xd4, 0x01, 0x0a, 0x0c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x76, 0xca, 0x41, 0x2c, 0x0a, 0x14, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x12, 0xca, 0x01, 0x0a, 0x0a, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x70, 0xca, 0x41, 0x28, 0x0a, 0x12, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0xe9, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0xca,
	0x41, 0x34, 0x0a, 0x18, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22,
	0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0xcf, 0x01, 0x0a, 0x11, 0x56, 0x69, 0x65, 0x77, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65,
	0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x51, 0xda, 0x41, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43,
	0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x69, 0x65, 0x77, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x12, 0xd7, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x7b, 0xca, 0x41, 0x1c, 0x0a, 0x05, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x2c, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0xd9, 0x01,
	0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7d, 0xca, 0x41, 0x1c, 0x0a,
	0x05, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x11, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x32, 0x3b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9c, 0x01, 0x0a, 0x08, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb2, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0xcf, 0x01,
	0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x2c, 0x0a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xca, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c,
	0xca, 0x41, 0x1e, 0x0a, 0x06, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x14, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22,
	0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x95, 0x01, 0x0a,
	0x09, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x57, 0xda, 0x41, 0x12, 0x63, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3c, 0x3a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x32, 0x32, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x12,
	0xa8, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x91, 0x01, 0x0a, 0x0c, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x12, 0xcf,
	0x01, 0x0a, 0x0d, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x6f, 0xca, 0x41, 0x2e, 0x0a, 0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x01, 0x2a, 0x22, 0x33, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x12, 0xd0, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x63,
	0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x0b, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x73, 0x12, 0xe1, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x22, 0x74, 0xda, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x54, 0x3a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x32, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaf, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22,
	0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa7, 0x01, 0x0a, 0x10, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0xe5, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x78, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50,
	0x3a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x42, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xb8, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcb, 0x01, 0x0a, 0x0f,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe7, 0x01, 0x0a, 0x10, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a, 0xda, 0x41, 0x16, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x3a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x32, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x44, 0x2a, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x70, 0x0a, 0x0b, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0xaa, 0x01, 0x0a, 0x09, 0x43, 0x6c, 0x69,
	0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x69, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x69, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x63, 0x6c, 0x69, 0x70, 0x12, 0xc3, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x48, 0x6c, 0x73, 0x55, 0x72, 0x69, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x73, 0x55,
	0x72, 0x69, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x73,
	0x55, 0x72, 0x69, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x48, 0x3a, 0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x73, 0x55, 0x72, 0x69, 0x12, 0xd3, 0x01, 0x0a, 0x0c,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x2c, 0x0a,
	0x14, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x40, 0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0xed, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x7a, 0xda, 0x41, 0x25, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x12, 0xef, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x7c, 0xda, 0x41, 0x19, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xb7, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xad, 0x01,
	0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xca, 0x01,
	0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xfc, 0x01, 0x0a, 0x14, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x6e, 0x79, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x6e, 0x79, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65,
	0x72, 0x6e, 0x79, 0x6d, 0x22, 0x82, 0x01, 0xda, 0x41, 0x29, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d,
	0x2c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x12, 0xfe, 0x01, 0x0a, 0x14, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e,
	0x79, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e,
	0x79, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x6e, 0x79, 0x6d, 0x22, 0x84, 0x01, 0xda, 0x41, 0x1b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x3a, 0x0f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x32, 0x4d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x68, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79,
	0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79,
	0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbf, 0x01, 0x0a, 0x11, 0x47,
	0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x22, 0x4c,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb3, 0x01, 0x0a,
	0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70,
	0x65, 0x72, 0x6e, 0x79, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70,
	0x65, 0x72, 0x6e, 0x79, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xd2, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79, 0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x79,
	0x70, 0x65, 0x72, 0x6e, 0x79, 0x6d, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a,
	0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a,
	0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0xdf,
	0x01, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x5b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x90, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa3, 0x01,
	0xca, 0x41, 0x2c, 0x0a, 0x0d, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a,
	0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22,
	0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x12, 0xb1, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc4, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x92,
	0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa5, 0x01, 0xca, 0x41,
	0x2c, 0x0a, 0x0d, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1a,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53,
	0x3a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xe4, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x78, 0xca, 0x41, 0x34, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x1b, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdd, 0x01, 0x0a, 0x0b, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0xca, 0x41, 0x2a, 0x0a, 0x13, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x13, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x01, 0x2a,
	0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0xe7, 0x01, 0x0a, 0x0d, 0x55,
	0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x86, 0x01, 0xca, 0x41,
	0x2e, 0x0a, 0x15, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0xff, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0xca, 0x41,
	0x26, 0x0a, 0x0a, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a,
	0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x39, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe2, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0xca,
	0x41, 0x31, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaf, 0x01, 0x0a, 0x0d,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01,
	0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0xda, 0x41, 0x16,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x0a, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xe6, 0x01, 0x0a, 0x11, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x68, 0xda, 0x41, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x5b, 0x3a, 0x01, 0x2a, 0x22, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x74, 0x65, 0x6d, 0x2e,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x12, 0xf2, 0x01, 0x0a,
	0x14, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6b, 0xda, 0x41, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x5e, 0x3a, 0x01, 0x2a, 0x22, 0x59, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x74, 0x65,
	0x6d, 0x2e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0xec, 0x01, 0x0a, 0x13, 0x56, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x68, 0xda, 0x41, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x12, 0x53, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x69, 0x65,
	0x77, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x1a, 0x4b, 0xca, 0x41, 0x17, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xbe, 0x01,
	0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x42, 0x0e,
	0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x70, 0x62, 0x3b,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x49, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visionai_v1_warehouse_proto_rawDescOnce sync.Once
	file_google_cloud_visionai_v1_warehouse_proto_rawDescData = file_google_cloud_visionai_v1_warehouse_proto_rawDesc
)

func file_google_cloud_visionai_v1_warehouse_proto_rawDescGZIP() []byte {
	file_google_cloud_visionai_v1_warehouse_proto_rawDescOnce.Do(func() {
		file_google_cloud_visionai_v1_warehouse_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visionai_v1_warehouse_proto_rawDescData)
	})
	return file_google_cloud_visionai_v1_warehouse_proto_rawDescData
}

var file_google_cloud_visionai_v1_warehouse_proto_enumTypes = make([]protoimpl.EnumInfo, 14)
var file_google_cloud_visionai_v1_warehouse_proto_msgTypes = make([]protoimpl.MessageInfo, 175)
var file_google_cloud_visionai_v1_warehouse_proto_goTypes = []interface{}{
	(FacetBucketType)(0),                                                // 0: google.cloud.visionai.v1.FacetBucketType
	(AnalyzeAssetMetadata_AnalysisStatus_State)(0),                      // 1: google.cloud.visionai.v1.AnalyzeAssetMetadata.AnalysisStatus.State
	(IndexingStatus_State)(0),                                           // 2: google.cloud.visionai.v1.IndexingStatus.State
	(SearchCapability_Type)(0),                                          // 3: google.cloud.visionai.v1.SearchCapability.Type
	(CollectionItem_Type)(0),                                            // 4: google.cloud.visionai.v1.CollectionItem.Type
	(Index_State)(0),                                                    // 5: google.cloud.visionai.v1.Index.State
	(Corpus_Type)(0),                                                    // 6: google.cloud.visionai.v1.Corpus.Type
	(DataSchemaDetails_DataType)(0),                                     // 7: google.cloud.visionai.v1.DataSchemaDetails.DataType
	(DataSchemaDetails_Granularity)(0),                                  // 8: google.cloud.visionai.v1.DataSchemaDetails.Granularity
	(DataSchemaDetails_SearchStrategy_SearchStrategyType)(0),            // 9: google.cloud.visionai.v1.DataSchemaDetails.SearchStrategy.SearchStrategyType
	(IndexEndpoint_State)(0),                                            // 10: google.cloud.visionai.v1.IndexEndpoint.State
	(FacetProperty_DateTimeBucketSpec_Granularity)(0),                   // 11: google.cloud.visionai.v1.FacetProperty.DateTimeBucketSpec.Granularity
	(IngestAssetRequest_Config_VideoType_ContainerFormat)(0),            // 12: google.cloud.visionai.v1.IngestAssetRequest.Config.VideoType.ContainerFormat
	(SchemaKeySortingStrategy_Option_AggregateMethod)(0),                // 13: google.cloud.visionai.v1.SchemaKeySortingStrategy.Option.AggregateMethod
	(*CreateAssetRequest)(nil),                                          // 14: google.cloud.visionai.v1.CreateAssetRequest
	(*GetAssetRequest)(nil),                                             // 15: google.cloud.visionai.v1.GetAssetRequest
	(*ListAssetsRequest)(nil),                                           // 16: google.cloud.visionai.v1.ListAssetsRequest
	(*ListAssetsResponse)(nil),                                          // 17: google.cloud.visionai.v1.ListAssetsResponse
	(*UpdateAssetRequest)(nil),                                          // 18: google.cloud.visionai.v1.UpdateAssetRequest
	(*DeleteAssetRequest)(nil),                                          // 19: google.cloud.visionai.v1.DeleteAssetRequest
	(*AssetSource)(nil),                                                 // 20: google.cloud.visionai.v1.AssetSource
	(*UploadAssetRequest)(nil),                                          // 21: google.cloud.visionai.v1.UploadAssetRequest
	(*UploadAssetResponse)(nil),                                         // 22: google.cloud.visionai.v1.UploadAssetResponse
	(*UploadAssetMetadata)(nil),                                         // 23: google.cloud.visionai.v1.UploadAssetMetadata
	(*GenerateRetrievalUrlRequest)(nil),                                 // 24: google.cloud.visionai.v1.GenerateRetrievalUrlRequest
	(*GenerateRetrievalUrlResponse)(nil),                                // 25: google.cloud.visionai.v1.GenerateRetrievalUrlResponse
	(*Asset)(nil),                                                       // 26: google.cloud.visionai.v1.Asset
	(*AnalyzeAssetRequest)(nil),                                         // 27: google.cloud.visionai.v1.AnalyzeAssetRequest
	(*AnalyzeAssetMetadata)(nil),                                        // 28: google.cloud.visionai.v1.AnalyzeAssetMetadata
	(*AnalyzeAssetResponse)(nil),                                        // 29: google.cloud.visionai.v1.AnalyzeAssetResponse
	(*IndexingStatus)(nil),                                              // 30: google.cloud.visionai.v1.IndexingStatus
	(*IndexAssetRequest)(nil),                                           // 31: google.cloud.visionai.v1.IndexAssetRequest
	(*IndexAssetMetadata)(nil),                                          // 32: google.cloud.visionai.v1.IndexAssetMetadata
	(*IndexAssetResponse)(nil),                                          // 33: google.cloud.visionai.v1.IndexAssetResponse
	(*RemoveIndexAssetRequest)(nil),                                     // 34: google.cloud.visionai.v1.RemoveIndexAssetRequest
	(*RemoveIndexAssetMetadata)(nil),                                    // 35: google.cloud.visionai.v1.RemoveIndexAssetMetadata
	(*RemoveIndexAssetResponse)(nil),                                    // 36: google.cloud.visionai.v1.RemoveIndexAssetResponse
	(*IndexedAsset)(nil),                                                // 37: google.cloud.visionai.v1.IndexedAsset
	(*ViewIndexedAssetsRequest)(nil),                                    // 38: google.cloud.visionai.v1.ViewIndexedAssetsRequest
	(*ViewIndexedAssetsResponse)(nil),                                   // 39: google.cloud.visionai.v1.ViewIndexedAssetsResponse
	(*CreateCorpusRequest)(nil),                                         // 40: google.cloud.visionai.v1.CreateCorpusRequest
	(*CreateCorpusMetadata)(nil),                                        // 41: google.cloud.visionai.v1.CreateCorpusMetadata
	(*SearchCapability)(nil),                                            // 42: google.cloud.visionai.v1.SearchCapability
	(*SearchCapabilitySetting)(nil),                                     // 43: google.cloud.visionai.v1.SearchCapabilitySetting
	(*CreateCollectionMetadata)(nil),                                    // 44: google.cloud.visionai.v1.CreateCollectionMetadata
	(*CreateCollectionRequest)(nil),                                     // 45: google.cloud.visionai.v1.CreateCollectionRequest
	(*DeleteCollectionMetadata)(nil),                                    // 46: google.cloud.visionai.v1.DeleteCollectionMetadata
	(*DeleteCollectionRequest)(nil),                                     // 47: google.cloud.visionai.v1.DeleteCollectionRequest
	(*GetCollectionRequest)(nil),                                        // 48: google.cloud.visionai.v1.GetCollectionRequest
	(*UpdateCollectionRequest)(nil),                                     // 49: google.cloud.visionai.v1.UpdateCollectionRequest
	(*ListCollectionsRequest)(nil),                                      // 50: google.cloud.visionai.v1.ListCollectionsRequest
	(*ListCollectionsResponse)(nil),                                     // 51: google.cloud.visionai.v1.ListCollectionsResponse
	(*AddCollectionItemRequest)(nil),                                    // 52: google.cloud.visionai.v1.AddCollectionItemRequest
	(*AddCollectionItemResponse)(nil),                                   // 53: google.cloud.visionai.v1.AddCollectionItemResponse
	(*RemoveCollectionItemRequest)(nil),                                 // 54: google.cloud.visionai.v1.RemoveCollectionItemRequest
	(*RemoveCollectionItemResponse)(nil),                                // 55: google.cloud.visionai.v1.RemoveCollectionItemResponse
	(*ViewCollectionItemsRequest)(nil),                                  // 56: google.cloud.visionai.v1.ViewCollectionItemsRequest
	(*ViewCollectionItemsResponse)(nil),                                 // 57: google.cloud.visionai.v1.ViewCollectionItemsResponse
	(*Collection)(nil),                                                  // 58: google.cloud.visionai.v1.Collection
	(*CollectionItem)(nil),                                              // 59: google.cloud.visionai.v1.CollectionItem
	(*CreateIndexRequest)(nil),                                          // 60: google.cloud.visionai.v1.CreateIndexRequest
	(*CreateIndexMetadata)(nil),                                         // 61: google.cloud.visionai.v1.CreateIndexMetadata
	(*UpdateIndexRequest)(nil),                                          // 62: google.cloud.visionai.v1.UpdateIndexRequest
	(*UpdateIndexMetadata)(nil),                                         // 63: google.cloud.visionai.v1.UpdateIndexMetadata
	(*GetIndexRequest)(nil),                                             // 64: google.cloud.visionai.v1.GetIndexRequest
	(*ListIndexesRequest)(nil),                                          // 65: google.cloud.visionai.v1.ListIndexesRequest
	(*ListIndexesResponse)(nil),                                         // 66: google.cloud.visionai.v1.ListIndexesResponse
	(*DeleteIndexRequest)(nil),                                          // 67: google.cloud.visionai.v1.DeleteIndexRequest
	(*DeleteIndexMetadata)(nil),                                         // 68: google.cloud.visionai.v1.DeleteIndexMetadata
	(*Index)(nil),                                                       // 69: google.cloud.visionai.v1.Index
	(*DeployedIndexReference)(nil),                                      // 70: google.cloud.visionai.v1.DeployedIndexReference
	(*Corpus)(nil),                                                      // 71: google.cloud.visionai.v1.Corpus
	(*GetCorpusRequest)(nil),                                            // 72: google.cloud.visionai.v1.GetCorpusRequest
	(*UpdateCorpusRequest)(nil),                                         // 73: google.cloud.visionai.v1.UpdateCorpusRequest
	(*ListCorporaRequest)(nil),                                          // 74: google.cloud.visionai.v1.ListCorporaRequest
	(*ListCorporaResponse)(nil),                                         // 75: google.cloud.visionai.v1.ListCorporaResponse
	(*DeleteCorpusRequest)(nil),                                         // 76: google.cloud.visionai.v1.DeleteCorpusRequest
	(*AnalyzeCorpusRequest)(nil),                                        // 77: google.cloud.visionai.v1.AnalyzeCorpusRequest
	(*AnalyzeCorpusMetadata)(nil),                                       // 78: google.cloud.visionai.v1.AnalyzeCorpusMetadata
	(*AnalyzeCorpusResponse)(nil),                                       // 79: google.cloud.visionai.v1.AnalyzeCorpusResponse
	(*CreateDataSchemaRequest)(nil),                                     // 80: google.cloud.visionai.v1.CreateDataSchemaRequest
	(*DataSchema)(nil),                                                  // 81: google.cloud.visionai.v1.DataSchema
	(*DataSchemaDetails)(nil),                                           // 82: google.cloud.visionai.v1.DataSchemaDetails
	(*UpdateDataSchemaRequest)(nil),                                     // 83: google.cloud.visionai.v1.UpdateDataSchemaRequest
	(*GetDataSchemaRequest)(nil),                                        // 84: google.cloud.visionai.v1.GetDataSchemaRequest
	(*DeleteDataSchemaRequest)(nil),                                     // 85: google.cloud.visionai.v1.DeleteDataSchemaRequest
	(*ListDataSchemasRequest)(nil),                                      // 86: google.cloud.visionai.v1.ListDataSchemasRequest
	(*ListDataSchemasResponse)(nil),                                     // 87: google.cloud.visionai.v1.ListDataSchemasResponse
	(*CreateAnnotationRequest)(nil),                                     // 88: google.cloud.visionai.v1.CreateAnnotationRequest
	(*Annotation)(nil),                                                  // 89: google.cloud.visionai.v1.Annotation
	(*UserSpecifiedAnnotation)(nil),                                     // 90: google.cloud.visionai.v1.UserSpecifiedAnnotation
	(*GeoCoordinate)(nil),                                               // 91: google.cloud.visionai.v1.GeoCoordinate
	(*AnnotationValue)(nil),                                             // 92: google.cloud.visionai.v1.AnnotationValue
	(*AnnotationList)(nil),                                              // 93: google.cloud.visionai.v1.AnnotationList
	(*AnnotationCustomizedStruct)(nil),                                  // 94: google.cloud.visionai.v1.AnnotationCustomizedStruct
	(*ListAnnotationsRequest)(nil),                                      // 95: google.cloud.visionai.v1.ListAnnotationsRequest
	(*ListAnnotationsResponse)(nil),                                     // 96: google.cloud.visionai.v1.ListAnnotationsResponse
	(*GetAnnotationRequest)(nil),                                        // 97: google.cloud.visionai.v1.GetAnnotationRequest
	(*UpdateAnnotationRequest)(nil),                                     // 98: google.cloud.visionai.v1.UpdateAnnotationRequest
	(*DeleteAnnotationRequest)(nil),                                     // 99: google.cloud.visionai.v1.DeleteAnnotationRequest
	(*ImportAssetsRequest)(nil),                                         // 100: google.cloud.visionai.v1.ImportAssetsRequest
	(*ImportAssetsMetadata)(nil),                                        // 101: google.cloud.visionai.v1.ImportAssetsMetadata
	(*ImportAssetsResponse)(nil),                                        // 102: google.cloud.visionai.v1.ImportAssetsResponse
	(*CreateSearchConfigRequest)(nil),                                   // 103: google.cloud.visionai.v1.CreateSearchConfigRequest
	(*UpdateSearchConfigRequest)(nil),                                   // 104: google.cloud.visionai.v1.UpdateSearchConfigRequest
	(*GetSearchConfigRequest)(nil),                                      // 105: google.cloud.visionai.v1.GetSearchConfigRequest
	(*DeleteSearchConfigRequest)(nil),                                   // 106: google.cloud.visionai.v1.DeleteSearchConfigRequest
	(*ListSearchConfigsRequest)(nil),                                    // 107: google.cloud.visionai.v1.ListSearchConfigsRequest
	(*ListSearchConfigsResponse)(nil),                                   // 108: google.cloud.visionai.v1.ListSearchConfigsResponse
	(*SearchConfig)(nil),                                                // 109: google.cloud.visionai.v1.SearchConfig
	(*IndexEndpoint)(nil),                                               // 110: google.cloud.visionai.v1.IndexEndpoint
	(*CreateIndexEndpointRequest)(nil),                                  // 111: google.cloud.visionai.v1.CreateIndexEndpointRequest
	(*CreateIndexEndpointMetadata)(nil),                                 // 112: google.cloud.visionai.v1.CreateIndexEndpointMetadata
	(*GetIndexEndpointRequest)(nil),                                     // 113: google.cloud.visionai.v1.GetIndexEndpointRequest
	(*ListIndexEndpointsRequest)(nil),                                   // 114: google.cloud.visionai.v1.ListIndexEndpointsRequest
	(*ListIndexEndpointsResponse)(nil),                                  // 115: google.cloud.visionai.v1.ListIndexEndpointsResponse
	(*UpdateIndexEndpointRequest)(nil),                                  // 116: google.cloud.visionai.v1.UpdateIndexEndpointRequest
	(*UpdateIndexEndpointMetadata)(nil),                                 // 117: google.cloud.visionai.v1.UpdateIndexEndpointMetadata
	(*DeleteIndexEndpointRequest)(nil),                                  // 118: google.cloud.visionai.v1.DeleteIndexEndpointRequest
	(*DeleteIndexEndpointMetadata)(nil),                                 // 119: google.cloud.visionai.v1.DeleteIndexEndpointMetadata
	(*DeployIndexRequest)(nil),                                          // 120: google.cloud.visionai.v1.DeployIndexRequest
	(*DeployIndexResponse)(nil),                                         // 121: google.cloud.visionai.v1.DeployIndexResponse
	(*DeployIndexMetadata)(nil),                                         // 122: google.cloud.visionai.v1.DeployIndexMetadata
	(*UndeployIndexMetadata)(nil),                                       // 123: google.cloud.visionai.v1.UndeployIndexMetadata
	(*UndeployIndexRequest)(nil),                                        // 124: google.cloud.visionai.v1.UndeployIndexRequest
	(*UndeployIndexResponse)(nil),                                       // 125: google.cloud.visionai.v1.UndeployIndexResponse
	(*DeployedIndex)(nil),                                               // 126: google.cloud.visionai.v1.DeployedIndex
	(*FacetProperty)(nil),                                               // 127: google.cloud.visionai.v1.FacetProperty
	(*SearchHypernym)(nil),                                              // 128: google.cloud.visionai.v1.SearchHypernym
	(*CreateSearchHypernymRequest)(nil),                                 // 129: google.cloud.visionai.v1.CreateSearchHypernymRequest
	(*UpdateSearchHypernymRequest)(nil),                                 // 130: google.cloud.visionai.v1.UpdateSearchHypernymRequest
	(*GetSearchHypernymRequest)(nil),                                    // 131: google.cloud.visionai.v1.GetSearchHypernymRequest
	(*DeleteSearchHypernymRequest)(nil),                                 // 132: google.cloud.visionai.v1.DeleteSearchHypernymRequest
	(*ListSearchHypernymsRequest)(nil),                                  // 133: google.cloud.visionai.v1.ListSearchHypernymsRequest
	(*ListSearchHypernymsResponse)(nil),                                 // 134: google.cloud.visionai.v1.ListSearchHypernymsResponse
	(*SearchCriteriaProperty)(nil),                                      // 135: google.cloud.visionai.v1.SearchCriteriaProperty
	(*FacetValue)(nil),                                                  // 136: google.cloud.visionai.v1.FacetValue
	(*FacetBucket)(nil),                                                 // 137: google.cloud.visionai.v1.FacetBucket
	(*FacetGroup)(nil),                                                  // 138: google.cloud.visionai.v1.FacetGroup
	(*IngestAssetRequest)(nil),                                          // 139: google.cloud.visionai.v1.IngestAssetRequest
	(*IngestAssetResponse)(nil),                                         // 140: google.cloud.visionai.v1.IngestAssetResponse
	(*ClipAssetRequest)(nil),                                            // 141: google.cloud.visionai.v1.ClipAssetRequest
	(*ClipAssetResponse)(nil),                                           // 142: google.cloud.visionai.v1.ClipAssetResponse
	(*GenerateHlsUriRequest)(nil),                                       // 143: google.cloud.visionai.v1.GenerateHlsUriRequest
	(*GenerateHlsUriResponse)(nil),                                      // 144: google.cloud.visionai.v1.GenerateHlsUriResponse
	(*SearchAssetsRequest)(nil),                                         // 145: google.cloud.visionai.v1.SearchAssetsRequest
	(*SearchIndexEndpointRequest)(nil),                                  // 146: google.cloud.visionai.v1.SearchIndexEndpointRequest
	(*ImageQuery)(nil),                                                  // 147: google.cloud.visionai.v1.ImageQuery
	(*SchemaKeySortingStrategy)(nil),                                    // 148: google.cloud.visionai.v1.SchemaKeySortingStrategy
	(*DeleteAssetMetadata)(nil),                                         // 149: google.cloud.visionai.v1.DeleteAssetMetadata
	(*AnnotationMatchingResult)(nil),                                    // 150: google.cloud.visionai.v1.AnnotationMatchingResult
	(*SearchResultItem)(nil),                                            // 151: google.cloud.visionai.v1.SearchResultItem
	(*SearchAssetsResponse)(nil),                                        // 152: google.cloud.visionai.v1.SearchAssetsResponse
	(*SearchIndexEndpointResponse)(nil),                                 // 153: google.cloud.visionai.v1.SearchIndexEndpointResponse
	(*IntRange)(nil),                                                    // 154: google.cloud.visionai.v1.IntRange
	(*FloatRange)(nil),                                                  // 155: google.cloud.visionai.v1.FloatRange
	(*StringArray)(nil),                                                 // 156: google.cloud.visionai.v1.StringArray
	(*IntRangeArray)(nil),                                               // 157: google.cloud.visionai.v1.IntRangeArray
	(*FloatRangeArray)(nil),                                             // 158: google.cloud.visionai.v1.FloatRangeArray
	(*DateTimeRange)(nil),                                               // 159: google.cloud.visionai.v1.DateTimeRange
	(*DateTimeRangeArray)(nil),                                          // 160: google.cloud.visionai.v1.DateTimeRangeArray
	(*CircleArea)(nil),                                                  // 161: google.cloud.visionai.v1.CircleArea
	(*GeoLocationArray)(nil),                                            // 162: google.cloud.visionai.v1.GeoLocationArray
	(*BoolValue)(nil),                                                   // 163: google.cloud.visionai.v1.BoolValue
	(*Criteria)(nil),                                                    // 164: google.cloud.visionai.v1.Criteria
	(*Partition)(nil),                                                   // 165: google.cloud.visionai.v1.Partition
	(*AssetSource_AssetGcsSource)(nil),                                  // 166: google.cloud.visionai.v1.AssetSource.AssetGcsSource
	(*AssetSource_AssetContentData)(nil),                                // 167: google.cloud.visionai.v1.AssetSource.AssetContentData
	(*AnalyzeAssetMetadata_AnalysisStatus)(nil),                         // 168: google.cloud.visionai.v1.AnalyzeAssetMetadata.AnalysisStatus
	(*DataSchemaDetails_ProtoAnyConfig)(nil),                            // 169: google.cloud.visionai.v1.DataSchemaDetails.ProtoAnyConfig
	(*DataSchemaDetails_ListConfig)(nil),                                // 170: google.cloud.visionai.v1.DataSchemaDetails.ListConfig
	(*DataSchemaDetails_CustomizedStructConfig)(nil),                    // 171: google.cloud.visionai.v1.DataSchemaDetails.CustomizedStructConfig
	(*DataSchemaDetails_SearchStrategy)(nil),                            // 172: google.cloud.visionai.v1.DataSchemaDetails.SearchStrategy
	nil,                                                                 // 173: google.cloud.visionai.v1.DataSchemaDetails.CustomizedStructConfig.FieldSchemasEntry
	(*DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig)(nil), // 174: google.cloud.visionai.v1.DataSchemaDetails.SearchStrategy.ConfidenceScoreIndexConfig
	nil, // 175: google.cloud.visionai.v1.AnnotationCustomizedStruct.ElementsEntry
	nil, // 176: google.cloud.visionai.v1.IndexEndpoint.LabelsEntry
	(*FacetProperty_FixedRangeBucketSpec)(nil),  // 177: google.cloud.visionai.v1.FacetProperty.FixedRangeBucketSpec
	(*FacetProperty_CustomRangeBucketSpec)(nil), // 178: google.cloud.visionai.v1.FacetProperty.CustomRangeBucketSpec
	(*FacetProperty_DateTimeBucketSpec)(nil),    // 179: google.cloud.visionai.v1.FacetProperty.DateTimeBucketSpec
	(*FacetBucket_Range)(nil),                   // 180: google.cloud.visionai.v1.FacetBucket.Range
	(*IngestAssetRequest_Config)(nil),           // 181: google.cloud.visionai.v1.IngestAssetRequest.Config
	(*IngestAssetRequest_TimeIndexedData)(nil),  // 182: google.cloud.visionai.v1.IngestAssetRequest.TimeIndexedData
	(*IngestAssetRequest_Config_VideoType)(nil), // 183: google.cloud.visionai.v1.IngestAssetRequest.Config.VideoType
	(*ClipAssetResponse_TimeIndexedUri)(nil),    // 184: google.cloud.visionai.v1.ClipAssetResponse.TimeIndexedUri
	(*SchemaKeySortingStrategy_Option)(nil),     // 185: google.cloud.visionai.v1.SchemaKeySortingStrategy.Option
	(*Partition_TemporalPartition)(nil),         // 186: google.cloud.visionai.v1.Partition.TemporalPartition
	(*Partition_SpatialPartition)(nil),          // 187: google.cloud.visionai.v1.Partition.SpatialPartition
	(*Partition_RelativeTemporalPartition)(nil), // 188: google.cloud.visionai.v1.Partition.RelativeTemporalPartition
	(*fieldmaskpb.FieldMask)(nil),               // 189: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),               // 190: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                 // 191: google.protobuf.Duration
	(*OperationMetadata)(nil),                   // 192: google.cloud.visionai.v1.OperationMetadata
	(*anypb.Any)(nil),                           // 193: google.protobuf.Any
	(*structpb.Struct)(nil),                     // 194: google.protobuf.Struct
	(*datetime.DateTime)(nil),                   // 195: google.type.DateTime
	(*status.Status)(nil),                       // 196: google.rpc.Status
	(*longrunningpb.Operation)(nil),             // 197: google.longrunning.Operation
	(*emptypb.Empty)(nil),                       // 198: google.protobuf.Empty
}
var file_google_cloud_visionai_v1_warehouse_proto_depIdxs = []int32{
	26,  // 0: google.cloud.visionai.v1.CreateAssetRequest.asset:type_name -> google.cloud.visionai.v1.Asset
	26,  // 1: google.cloud.visionai.v1.ListAssetsResponse.assets:type_name -> google.cloud.visionai.v1.Asset
	26,  // 2: google.cloud.visionai.v1.UpdateAssetRequest.asset:type_name -> google.cloud.visionai.v1.Asset
	189, // 3: google.cloud.visionai.v1.UpdateAssetRequest.update_mask:type_name -> google.protobuf.FieldMask
	166, // 4: google.cloud.visionai.v1.AssetSource.asset_gcs_source:type_name -> google.cloud.visionai.v1.AssetSource.AssetGcsSource
	167, // 5: google.cloud.visionai.v1.AssetSource.asset_content_data:type_name -> google.cloud.visionai.v1.AssetSource.AssetContentData
	20,  // 6: google.cloud.visionai.v1.UploadAssetRequest.asset_source:type_name -> google.cloud.visionai.v1.AssetSource
	190, // 7: google.cloud.visionai.v1.UploadAssetMetadata.start_time:type_name -> google.protobuf.Timestamp
	190, // 8: google.cloud.visionai.v1.UploadAssetMetadata.update_time:type_name -> google.protobuf.Timestamp
	191, // 9: google.cloud.visionai.v1.Asset.ttl:type_name -> google.protobuf.Duration
	166, // 10: google.cloud.visionai.v1.Asset.asset_gcs_source:type_name -> google.cloud.visionai.v1.AssetSource.AssetGcsSource
	168, // 11: google.cloud.visionai.v1.AnalyzeAssetMetadata.analysis_status:type_name -> google.cloud.visionai.v1.AnalyzeAssetMetadata.AnalysisStatus
	190, // 12: google.cloud.visionai.v1.AnalyzeAssetMetadata.start_time:type_name -> google.protobuf.Timestamp
	190, // 13: google.cloud.visionai.v1.AnalyzeAssetMetadata.update_time:type_name -> google.protobuf.Timestamp
	2,   // 14: google.cloud.visionai.v1.IndexingStatus.state:type_name -> google.cloud.visionai.v1.IndexingStatus.State
	30,  // 15: google.cloud.visionai.v1.IndexAssetMetadata.status:type_name -> google.cloud.visionai.v1.IndexingStatus
	190, // 16: google.cloud.visionai.v1.IndexAssetMetadata.start_time:type_name -> google.protobuf.Timestamp
	190, // 17: google.cloud.visionai.v1.IndexAssetMetadata.update_time:type_name -> google.protobuf.Timestamp
	30,  // 18: google.cloud.visionai.v1.RemoveIndexAssetMetadata.indexing_status:type_name -> google.cloud.visionai.v1.IndexingStatus
	190, // 19: google.cloud.visionai.v1.RemoveIndexAssetMetadata.start_time:type_name -> google.protobuf.Timestamp
	190, // 20: google.cloud.visionai.v1.RemoveIndexAssetMetadata.update_time:type_name -> google.protobuf.Timestamp
	190, // 21: google.cloud.visionai.v1.IndexedAsset.create_time:type_name -> google.protobuf.Timestamp
	190, // 22: google.cloud.visionai.v1.IndexedAsset.update_time:type_name -> google.protobuf.Timestamp
	37,  // 23: google.cloud.visionai.v1.ViewIndexedAssetsResponse.indexed_assets:type_name -> google.cloud.visionai.v1.IndexedAsset
	71,  // 24: google.cloud.visionai.v1.CreateCorpusRequest.corpus:type_name -> google.cloud.visionai.v1.Corpus
	190, // 25: google.cloud.visionai.v1.CreateCorpusMetadata.create_time:type_name -> google.protobuf.Timestamp
	190, // 26: google.cloud.visionai.v1.CreateCorpusMetadata.update_time:type_name -> google.protobuf.Timestamp
	3,   // 27: google.cloud.visionai.v1.SearchCapability.type:type_name -> google.cloud.visionai.v1.SearchCapability.Type
	42,  // 28: google.cloud.visionai.v1.SearchCapabilitySetting.search_capabilities:type_name -> google.cloud.visionai.v1.SearchCapability
	192, // 29: google.cloud.visionai.v1.CreateCollectionMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	58,  // 30: google.cloud.visionai.v1.CreateCollectionRequest.collection:type_name -> google.cloud.visionai.v1.Collection
	192, // 31: google.cloud.visionai.v1.DeleteCollectionMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	58,  // 32: google.cloud.visionai.v1.UpdateCollectionRequest.collection:type_name -> google.cloud.visionai.v1.Collection
	189, // 33: google.cloud.visionai.v1.UpdateCollectionRequest.update_mask:type_name -> google.protobuf.FieldMask
	58,  // 34: google.cloud.visionai.v1.ListCollectionsResponse.collections:type_name -> google.cloud.visionai.v1.Collection
	59,  // 35: google.cloud.visionai.v1.AddCollectionItemRequest.item:type_name -> google.cloud.visionai.v1.CollectionItem
	59,  // 36: google.cloud.visionai.v1.AddCollectionItemResponse.item:type_name -> google.cloud.visionai.v1.CollectionItem
	59,  // 37: google.cloud.visionai.v1.RemoveCollectionItemRequest.item:type_name -> google.cloud.visionai.v1.CollectionItem
	59,  // 38: google.cloud.visionai.v1.RemoveCollectionItemResponse.item:type_name -> google.cloud.visionai.v1.CollectionItem
	59,  // 39: google.cloud.visionai.v1.ViewCollectionItemsResponse.items:type_name -> google.cloud.visionai.v1.CollectionItem
	4,   // 40: google.cloud.visionai.v1.CollectionItem.type:type_name -> google.cloud.visionai.v1.CollectionItem.Type
	69,  // 41: google.cloud.visionai.v1.CreateIndexRequest.index:type_name -> google.cloud.visionai.v1.Index
	192, // 42: google.cloud.visionai.v1.CreateIndexMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	69,  // 43: google.cloud.visionai.v1.UpdateIndexRequest.index:type_name -> google.cloud.visionai.v1.Index
	189, // 44: google.cloud.visionai.v1.UpdateIndexRequest.update_mask:type_name -> google.protobuf.FieldMask
	192, // 45: google.cloud.visionai.v1.UpdateIndexMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	69,  // 46: google.cloud.visionai.v1.ListIndexesResponse.indexes:type_name -> google.cloud.visionai.v1.Index
	5,   // 47: google.cloud.visionai.v1.Index.state:type_name -> google.cloud.visionai.v1.Index.State
	190, // 48: google.cloud.visionai.v1.Index.create_time:type_name -> google.protobuf.Timestamp
	190, // 49: google.cloud.visionai.v1.Index.update_time:type_name -> google.protobuf.Timestamp
	70,  // 50: google.cloud.visionai.v1.Index.deployed_indexes:type_name -> google.cloud.visionai.v1.DeployedIndexReference
	191, // 51: google.cloud.visionai.v1.Corpus.default_ttl:type_name -> google.protobuf.Duration
	6,   // 52: google.cloud.visionai.v1.Corpus.type:type_name -> google.cloud.visionai.v1.Corpus.Type
	43,  // 53: google.cloud.visionai.v1.Corpus.search_capability_setting:type_name -> google.cloud.visionai.v1.SearchCapabilitySetting
	71,  // 54: google.cloud.visionai.v1.UpdateCorpusRequest.corpus:type_name -> google.cloud.visionai.v1.Corpus
	189, // 55: google.cloud.visionai.v1.UpdateCorpusRequest.update_mask:type_name -> google.protobuf.FieldMask
	71,  // 56: google.cloud.visionai.v1.ListCorporaResponse.corpora:type_name -> google.cloud.visionai.v1.Corpus
	192, // 57: google.cloud.visionai.v1.AnalyzeCorpusMetadata.metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	81,  // 58: google.cloud.visionai.v1.CreateDataSchemaRequest.data_schema:type_name -> google.cloud.visionai.v1.DataSchema
	82,  // 59: google.cloud.visionai.v1.DataSchema.schema_details:type_name -> google.cloud.visionai.v1.DataSchemaDetails
	7,   // 60: google.cloud.visionai.v1.DataSchemaDetails.type:type_name -> google.cloud.visionai.v1.DataSchemaDetails.DataType
	169, // 61: google.cloud.visionai.v1.DataSchemaDetails.proto_any_config:type_name -> google.cloud.visionai.v1.DataSchemaDetails.ProtoAnyConfig
	170, // 62: google.cloud.visionai.v1.DataSchemaDetails.list_config:type_name -> google.cloud.visionai.v1.DataSchemaDetails.ListConfig
	171, // 63: google.cloud.visionai.v1.DataSchemaDetails.customized_struct_config:type_name -> google.cloud.visionai.v1.DataSchemaDetails.CustomizedStructConfig
	8,   // 64: google.cloud.visionai.v1.DataSchemaDetails.granularity:type_name -> google.cloud.visionai.v1.DataSchemaDetails.Granularity
	172, // 65: google.cloud.visionai.v1.DataSchemaDetails.search_strategy:type_name -> google.cloud.visionai.v1.DataSchemaDetails.SearchStrategy
	81,  // 66: google.cloud.visionai.v1.UpdateDataSchemaRequest.data_schema:type_name -> google.cloud.visionai.v1.DataSchema
	189, // 67: google.cloud.visionai.v1.UpdateDataSchemaRequest.update_mask:type_name -> google.protobuf.FieldMask
	81,  // 68: google.cloud.visionai.v1.ListDataSchemasResponse.data_schemas:type_name -> google.cloud.visionai.v1.DataSchema
	89,  // 69: google.cloud.visionai.v1.CreateAnnotationRequest.annotation:type_name -> google.cloud.visionai.v1.Annotation
	90,  // 70: google.cloud.visionai.v1.Annotation.user_specified_annotation:type_name -> google.cloud.visionai.v1.UserSpecifiedAnnotation
	92,  // 71: google.cloud.visionai.v1.UserSpecifiedAnnotation.value:type_name -> google.cloud.visionai.v1.AnnotationValue
	165, // 72: google.cloud.visionai.v1.UserSpecifiedAnnotation.partition:type_name -> google.cloud.visionai.v1.Partition
	91,  // 73: google.cloud.visionai.v1.AnnotationValue.geo_coordinate:type_name -> google.cloud.visionai.v1.GeoCoordinate
	193, // 74: google.cloud.visionai.v1.AnnotationValue.proto_any_value:type_name -> google.protobuf.Any
	194, // 75: google.cloud.visionai.v1.AnnotationValue.customized_struct_data_value:type_name -> google.protobuf.Struct
	93,  // 76: google.cloud.visionai.v1.AnnotationValue.list_value:type_name -> google.cloud.visionai.v1.AnnotationList
	94,  // 77: google.cloud.visionai.v1.AnnotationValue.customized_struct_value:type_name -> google.cloud.visionai.v1.AnnotationCustomizedStruct
	92,  // 78: google.cloud.visionai.v1.AnnotationList.values:type_name -> google.cloud.visionai.v1.AnnotationValue
	175, // 79: google.cloud.visionai.v1.AnnotationCustomizedStruct.elements:type_name -> google.cloud.visionai.v1.AnnotationCustomizedStruct.ElementsEntry
	89,  // 80: google.cloud.visionai.v1.ListAnnotationsResponse.annotations:type_name -> google.cloud.visionai.v1.Annotation
	89,  // 81: google.cloud.visionai.v1.UpdateAnnotationRequest.annotation:type_name -> google.cloud.visionai.v1.Annotation
	189, // 82: google.cloud.visionai.v1.UpdateAnnotationRequest.update_mask:type_name -> google.protobuf.FieldMask
	192, // 83: google.cloud.visionai.v1.ImportAssetsMetadata.metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	109, // 84: google.cloud.visionai.v1.CreateSearchConfigRequest.search_config:type_name -> google.cloud.visionai.v1.SearchConfig
	109, // 85: google.cloud.visionai.v1.UpdateSearchConfigRequest.search_config:type_name -> google.cloud.visionai.v1.SearchConfig
	189, // 86: google.cloud.visionai.v1.UpdateSearchConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	109, // 87: google.cloud.visionai.v1.ListSearchConfigsResponse.search_configs:type_name -> google.cloud.visionai.v1.SearchConfig
	127, // 88: google.cloud.visionai.v1.SearchConfig.facet_property:type_name -> google.cloud.visionai.v1.FacetProperty
	135, // 89: google.cloud.visionai.v1.SearchConfig.search_criteria_property:type_name -> google.cloud.visionai.v1.SearchCriteriaProperty
	126, // 90: google.cloud.visionai.v1.IndexEndpoint.deployed_index:type_name -> google.cloud.visionai.v1.DeployedIndex
	10,  // 91: google.cloud.visionai.v1.IndexEndpoint.state:type_name -> google.cloud.visionai.v1.IndexEndpoint.State
	176, // 92: google.cloud.visionai.v1.IndexEndpoint.labels:type_name -> google.cloud.visionai.v1.IndexEndpoint.LabelsEntry
	190, // 93: google.cloud.visionai.v1.IndexEndpoint.create_time:type_name -> google.protobuf.Timestamp
	190, // 94: google.cloud.visionai.v1.IndexEndpoint.update_time:type_name -> google.protobuf.Timestamp
	110, // 95: google.cloud.visionai.v1.CreateIndexEndpointRequest.index_endpoint:type_name -> google.cloud.visionai.v1.IndexEndpoint
	192, // 96: google.cloud.visionai.v1.CreateIndexEndpointMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	110, // 97: google.cloud.visionai.v1.ListIndexEndpointsResponse.index_endpoints:type_name -> google.cloud.visionai.v1.IndexEndpoint
	110, // 98: google.cloud.visionai.v1.UpdateIndexEndpointRequest.index_endpoint:type_name -> google.cloud.visionai.v1.IndexEndpoint
	189, // 99: google.cloud.visionai.v1.UpdateIndexEndpointRequest.update_mask:type_name -> google.protobuf.FieldMask
	192, // 100: google.cloud.visionai.v1.UpdateIndexEndpointMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	192, // 101: google.cloud.visionai.v1.DeleteIndexEndpointMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	126, // 102: google.cloud.visionai.v1.DeployIndexRequest.deployed_index:type_name -> google.cloud.visionai.v1.DeployedIndex
	192, // 103: google.cloud.visionai.v1.DeployIndexMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	192, // 104: google.cloud.visionai.v1.UndeployIndexMetadata.operation_metadata:type_name -> google.cloud.visionai.v1.OperationMetadata
	177, // 105: google.cloud.visionai.v1.FacetProperty.fixed_range_bucket_spec:type_name -> google.cloud.visionai.v1.FacetProperty.FixedRangeBucketSpec
	178, // 106: google.cloud.visionai.v1.FacetProperty.custom_range_bucket_spec:type_name -> google.cloud.visionai.v1.FacetProperty.CustomRangeBucketSpec
	179, // 107: google.cloud.visionai.v1.FacetProperty.datetime_bucket_spec:type_name -> google.cloud.visionai.v1.FacetProperty.DateTimeBucketSpec
	0,   // 108: google.cloud.visionai.v1.FacetProperty.bucket_type:type_name -> google.cloud.visionai.v1.FacetBucketType
	128, // 109: google.cloud.visionai.v1.CreateSearchHypernymRequest.search_hypernym:type_name -> google.cloud.visionai.v1.SearchHypernym
	128, // 110: google.cloud.visionai.v1.UpdateSearchHypernymRequest.search_hypernym:type_name -> google.cloud.visionai.v1.SearchHypernym
	189, // 111: google.cloud.visionai.v1.UpdateSearchHypernymRequest.update_mask:type_name -> google.protobuf.FieldMask
	128, // 112: google.cloud.visionai.v1.ListSearchHypernymsResponse.search_hypernyms:type_name -> google.cloud.visionai.v1.SearchHypernym
	195, // 113: google.cloud.visionai.v1.FacetValue.datetime_value:type_name -> google.type.DateTime
	136, // 114: google.cloud.visionai.v1.FacetBucket.value:type_name -> google.cloud.visionai.v1.FacetValue
	180, // 115: google.cloud.visionai.v1.FacetBucket.range:type_name -> google.cloud.visionai.v1.FacetBucket.Range
	137, // 116: google.cloud.visionai.v1.FacetGroup.buckets:type_name -> google.cloud.visionai.v1.FacetBucket
	0,   // 117: google.cloud.visionai.v1.FacetGroup.bucket_type:type_name -> google.cloud.visionai.v1.FacetBucketType
	181, // 118: google.cloud.visionai.v1.IngestAssetRequest.config:type_name -> google.cloud.visionai.v1.IngestAssetRequest.Config
	182, // 119: google.cloud.visionai.v1.IngestAssetRequest.time_indexed_data:type_name -> google.cloud.visionai.v1.IngestAssetRequest.TimeIndexedData
	186, // 120: google.cloud.visionai.v1.IngestAssetResponse.successfully_ingested_partition:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	186, // 121: google.cloud.visionai.v1.ClipAssetRequest.temporal_partition:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	184, // 122: google.cloud.visionai.v1.ClipAssetResponse.time_indexed_uris:type_name -> google.cloud.visionai.v1.ClipAssetResponse.TimeIndexedUri
	186, // 123: google.cloud.visionai.v1.GenerateHlsUriRequest.temporal_partitions:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	186, // 124: google.cloud.visionai.v1.GenerateHlsUriResponse.temporal_partitions:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	148, // 125: google.cloud.visionai.v1.SearchAssetsRequest.schema_key_sorting_strategy:type_name -> google.cloud.visionai.v1.SchemaKeySortingStrategy
	160, // 126: google.cloud.visionai.v1.SearchAssetsRequest.content_time_ranges:type_name -> google.cloud.visionai.v1.DateTimeRangeArray
	164, // 127: google.cloud.visionai.v1.SearchAssetsRequest.criteria:type_name -> google.cloud.visionai.v1.Criteria
	138, // 128: google.cloud.visionai.v1.SearchAssetsRequest.facet_selections:type_name -> google.cloud.visionai.v1.FacetGroup
	147, // 129: google.cloud.visionai.v1.SearchIndexEndpointRequest.image_query:type_name -> google.cloud.visionai.v1.ImageQuery
	164, // 130: google.cloud.visionai.v1.SearchIndexEndpointRequest.criteria:type_name -> google.cloud.visionai.v1.Criteria
	164, // 131: google.cloud.visionai.v1.SearchIndexEndpointRequest.exclusion_criteria:type_name -> google.cloud.visionai.v1.Criteria
	185, // 132: google.cloud.visionai.v1.SchemaKeySortingStrategy.options:type_name -> google.cloud.visionai.v1.SchemaKeySortingStrategy.Option
	164, // 133: google.cloud.visionai.v1.AnnotationMatchingResult.criteria:type_name -> google.cloud.visionai.v1.Criteria
	89,  // 134: google.cloud.visionai.v1.AnnotationMatchingResult.matched_annotations:type_name -> google.cloud.visionai.v1.Annotation
	196, // 135: google.cloud.visionai.v1.AnnotationMatchingResult.status:type_name -> google.rpc.Status
	186, // 136: google.cloud.visionai.v1.SearchResultItem.segments:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	186, // 137: google.cloud.visionai.v1.SearchResultItem.segment:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	89,  // 138: google.cloud.visionai.v1.SearchResultItem.requested_annotations:type_name -> google.cloud.visionai.v1.Annotation
	150, // 139: google.cloud.visionai.v1.SearchResultItem.annotation_matching_results:type_name -> google.cloud.visionai.v1.AnnotationMatchingResult
	151, // 140: google.cloud.visionai.v1.SearchAssetsResponse.search_result_items:type_name -> google.cloud.visionai.v1.SearchResultItem
	138, // 141: google.cloud.visionai.v1.SearchAssetsResponse.facet_results:type_name -> google.cloud.visionai.v1.FacetGroup
	151, // 142: google.cloud.visionai.v1.SearchIndexEndpointResponse.search_result_items:type_name -> google.cloud.visionai.v1.SearchResultItem
	154, // 143: google.cloud.visionai.v1.IntRangeArray.int_ranges:type_name -> google.cloud.visionai.v1.IntRange
	155, // 144: google.cloud.visionai.v1.FloatRangeArray.float_ranges:type_name -> google.cloud.visionai.v1.FloatRange
	195, // 145: google.cloud.visionai.v1.DateTimeRange.start:type_name -> google.type.DateTime
	195, // 146: google.cloud.visionai.v1.DateTimeRange.end:type_name -> google.type.DateTime
	159, // 147: google.cloud.visionai.v1.DateTimeRangeArray.date_time_ranges:type_name -> google.cloud.visionai.v1.DateTimeRange
	161, // 148: google.cloud.visionai.v1.GeoLocationArray.circle_areas:type_name -> google.cloud.visionai.v1.CircleArea
	156, // 149: google.cloud.visionai.v1.Criteria.text_array:type_name -> google.cloud.visionai.v1.StringArray
	157, // 150: google.cloud.visionai.v1.Criteria.int_range_array:type_name -> google.cloud.visionai.v1.IntRangeArray
	158, // 151: google.cloud.visionai.v1.Criteria.float_range_array:type_name -> google.cloud.visionai.v1.FloatRangeArray
	160, // 152: google.cloud.visionai.v1.Criteria.date_time_range_array:type_name -> google.cloud.visionai.v1.DateTimeRangeArray
	162, // 153: google.cloud.visionai.v1.Criteria.geo_location_array:type_name -> google.cloud.visionai.v1.GeoLocationArray
	163, // 154: google.cloud.visionai.v1.Criteria.bool_value:type_name -> google.cloud.visionai.v1.BoolValue
	186, // 155: google.cloud.visionai.v1.Partition.temporal_partition:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	187, // 156: google.cloud.visionai.v1.Partition.spatial_partition:type_name -> google.cloud.visionai.v1.Partition.SpatialPartition
	188, // 157: google.cloud.visionai.v1.Partition.relative_temporal_partition:type_name -> google.cloud.visionai.v1.Partition.RelativeTemporalPartition
	1,   // 158: google.cloud.visionai.v1.AnalyzeAssetMetadata.AnalysisStatus.state:type_name -> google.cloud.visionai.v1.AnalyzeAssetMetadata.AnalysisStatus.State
	42,  // 159: google.cloud.visionai.v1.AnalyzeAssetMetadata.AnalysisStatus.search_capability:type_name -> google.cloud.visionai.v1.SearchCapability
	82,  // 160: google.cloud.visionai.v1.DataSchemaDetails.ListConfig.value_schema:type_name -> google.cloud.visionai.v1.DataSchemaDetails
	173, // 161: google.cloud.visionai.v1.DataSchemaDetails.CustomizedStructConfig.field_schemas:type_name -> google.cloud.visionai.v1.DataSchemaDetails.CustomizedStructConfig.FieldSchemasEntry
	9,   // 162: google.cloud.visionai.v1.DataSchemaDetails.SearchStrategy.search_strategy_type:type_name -> google.cloud.visionai.v1.DataSchemaDetails.SearchStrategy.SearchStrategyType
	174, // 163: google.cloud.visionai.v1.DataSchemaDetails.SearchStrategy.confidence_score_index_config:type_name -> google.cloud.visionai.v1.DataSchemaDetails.SearchStrategy.ConfidenceScoreIndexConfig
	82,  // 164: google.cloud.visionai.v1.DataSchemaDetails.CustomizedStructConfig.FieldSchemasEntry.value:type_name -> google.cloud.visionai.v1.DataSchemaDetails
	92,  // 165: google.cloud.visionai.v1.AnnotationCustomizedStruct.ElementsEntry.value:type_name -> google.cloud.visionai.v1.AnnotationValue
	136, // 166: google.cloud.visionai.v1.FacetProperty.FixedRangeBucketSpec.bucket_start:type_name -> google.cloud.visionai.v1.FacetValue
	136, // 167: google.cloud.visionai.v1.FacetProperty.FixedRangeBucketSpec.bucket_granularity:type_name -> google.cloud.visionai.v1.FacetValue
	136, // 168: google.cloud.visionai.v1.FacetProperty.CustomRangeBucketSpec.endpoints:type_name -> google.cloud.visionai.v1.FacetValue
	11,  // 169: google.cloud.visionai.v1.FacetProperty.DateTimeBucketSpec.granularity:type_name -> google.cloud.visionai.v1.FacetProperty.DateTimeBucketSpec.Granularity
	136, // 170: google.cloud.visionai.v1.FacetBucket.Range.start:type_name -> google.cloud.visionai.v1.FacetValue
	136, // 171: google.cloud.visionai.v1.FacetBucket.Range.end:type_name -> google.cloud.visionai.v1.FacetValue
	183, // 172: google.cloud.visionai.v1.IngestAssetRequest.Config.video_type:type_name -> google.cloud.visionai.v1.IngestAssetRequest.Config.VideoType
	186, // 173: google.cloud.visionai.v1.IngestAssetRequest.TimeIndexedData.temporal_partition:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	12,  // 174: google.cloud.visionai.v1.IngestAssetRequest.Config.VideoType.container_format:type_name -> google.cloud.visionai.v1.IngestAssetRequest.Config.VideoType.ContainerFormat
	186, // 175: google.cloud.visionai.v1.ClipAssetResponse.TimeIndexedUri.temporal_partition:type_name -> google.cloud.visionai.v1.Partition.TemporalPartition
	13,  // 176: google.cloud.visionai.v1.SchemaKeySortingStrategy.Option.aggregate_method:type_name -> google.cloud.visionai.v1.SchemaKeySortingStrategy.Option.AggregateMethod
	190, // 177: google.cloud.visionai.v1.Partition.TemporalPartition.start_time:type_name -> google.protobuf.Timestamp
	190, // 178: google.cloud.visionai.v1.Partition.TemporalPartition.end_time:type_name -> google.protobuf.Timestamp
	191, // 179: google.cloud.visionai.v1.Partition.RelativeTemporalPartition.start_offset:type_name -> google.protobuf.Duration
	191, // 180: google.cloud.visionai.v1.Partition.RelativeTemporalPartition.end_offset:type_name -> google.protobuf.Duration
	14,  // 181: google.cloud.visionai.v1.Warehouse.CreateAsset:input_type -> google.cloud.visionai.v1.CreateAssetRequest
	18,  // 182: google.cloud.visionai.v1.Warehouse.UpdateAsset:input_type -> google.cloud.visionai.v1.UpdateAssetRequest
	15,  // 183: google.cloud.visionai.v1.Warehouse.GetAsset:input_type -> google.cloud.visionai.v1.GetAssetRequest
	16,  // 184: google.cloud.visionai.v1.Warehouse.ListAssets:input_type -> google.cloud.visionai.v1.ListAssetsRequest
	19,  // 185: google.cloud.visionai.v1.Warehouse.DeleteAsset:input_type -> google.cloud.visionai.v1.DeleteAssetRequest
	21,  // 186: google.cloud.visionai.v1.Warehouse.UploadAsset:input_type -> google.cloud.visionai.v1.UploadAssetRequest
	24,  // 187: google.cloud.visionai.v1.Warehouse.GenerateRetrievalUrl:input_type -> google.cloud.visionai.v1.GenerateRetrievalUrlRequest
	27,  // 188: google.cloud.visionai.v1.Warehouse.AnalyzeAsset:input_type -> google.cloud.visionai.v1.AnalyzeAssetRequest
	31,  // 189: google.cloud.visionai.v1.Warehouse.IndexAsset:input_type -> google.cloud.visionai.v1.IndexAssetRequest
	34,  // 190: google.cloud.visionai.v1.Warehouse.RemoveIndexAsset:input_type -> google.cloud.visionai.v1.RemoveIndexAssetRequest
	38,  // 191: google.cloud.visionai.v1.Warehouse.ViewIndexedAssets:input_type -> google.cloud.visionai.v1.ViewIndexedAssetsRequest
	60,  // 192: google.cloud.visionai.v1.Warehouse.CreateIndex:input_type -> google.cloud.visionai.v1.CreateIndexRequest
	62,  // 193: google.cloud.visionai.v1.Warehouse.UpdateIndex:input_type -> google.cloud.visionai.v1.UpdateIndexRequest
	64,  // 194: google.cloud.visionai.v1.Warehouse.GetIndex:input_type -> google.cloud.visionai.v1.GetIndexRequest
	65,  // 195: google.cloud.visionai.v1.Warehouse.ListIndexes:input_type -> google.cloud.visionai.v1.ListIndexesRequest
	67,  // 196: google.cloud.visionai.v1.Warehouse.DeleteIndex:input_type -> google.cloud.visionai.v1.DeleteIndexRequest
	40,  // 197: google.cloud.visionai.v1.Warehouse.CreateCorpus:input_type -> google.cloud.visionai.v1.CreateCorpusRequest
	72,  // 198: google.cloud.visionai.v1.Warehouse.GetCorpus:input_type -> google.cloud.visionai.v1.GetCorpusRequest
	73,  // 199: google.cloud.visionai.v1.Warehouse.UpdateCorpus:input_type -> google.cloud.visionai.v1.UpdateCorpusRequest
	74,  // 200: google.cloud.visionai.v1.Warehouse.ListCorpora:input_type -> google.cloud.visionai.v1.ListCorporaRequest
	76,  // 201: google.cloud.visionai.v1.Warehouse.DeleteCorpus:input_type -> google.cloud.visionai.v1.DeleteCorpusRequest
	77,  // 202: google.cloud.visionai.v1.Warehouse.AnalyzeCorpus:input_type -> google.cloud.visionai.v1.AnalyzeCorpusRequest
	80,  // 203: google.cloud.visionai.v1.Warehouse.CreateDataSchema:input_type -> google.cloud.visionai.v1.CreateDataSchemaRequest
	83,  // 204: google.cloud.visionai.v1.Warehouse.UpdateDataSchema:input_type -> google.cloud.visionai.v1.UpdateDataSchemaRequest
	84,  // 205: google.cloud.visionai.v1.Warehouse.GetDataSchema:input_type -> google.cloud.visionai.v1.GetDataSchemaRequest
	85,  // 206: google.cloud.visionai.v1.Warehouse.DeleteDataSchema:input_type -> google.cloud.visionai.v1.DeleteDataSchemaRequest
	86,  // 207: google.cloud.visionai.v1.Warehouse.ListDataSchemas:input_type -> google.cloud.visionai.v1.ListDataSchemasRequest
	88,  // 208: google.cloud.visionai.v1.Warehouse.CreateAnnotation:input_type -> google.cloud.visionai.v1.CreateAnnotationRequest
	97,  // 209: google.cloud.visionai.v1.Warehouse.GetAnnotation:input_type -> google.cloud.visionai.v1.GetAnnotationRequest
	95,  // 210: google.cloud.visionai.v1.Warehouse.ListAnnotations:input_type -> google.cloud.visionai.v1.ListAnnotationsRequest
	98,  // 211: google.cloud.visionai.v1.Warehouse.UpdateAnnotation:input_type -> google.cloud.visionai.v1.UpdateAnnotationRequest
	99,  // 212: google.cloud.visionai.v1.Warehouse.DeleteAnnotation:input_type -> google.cloud.visionai.v1.DeleteAnnotationRequest
	139, // 213: google.cloud.visionai.v1.Warehouse.IngestAsset:input_type -> google.cloud.visionai.v1.IngestAssetRequest
	141, // 214: google.cloud.visionai.v1.Warehouse.ClipAsset:input_type -> google.cloud.visionai.v1.ClipAssetRequest
	143, // 215: google.cloud.visionai.v1.Warehouse.GenerateHlsUri:input_type -> google.cloud.visionai.v1.GenerateHlsUriRequest
	100, // 216: google.cloud.visionai.v1.Warehouse.ImportAssets:input_type -> google.cloud.visionai.v1.ImportAssetsRequest
	103, // 217: google.cloud.visionai.v1.Warehouse.CreateSearchConfig:input_type -> google.cloud.visionai.v1.CreateSearchConfigRequest
	104, // 218: google.cloud.visionai.v1.Warehouse.UpdateSearchConfig:input_type -> google.cloud.visionai.v1.UpdateSearchConfigRequest
	105, // 219: google.cloud.visionai.v1.Warehouse.GetSearchConfig:input_type -> google.cloud.visionai.v1.GetSearchConfigRequest
	106, // 220: google.cloud.visionai.v1.Warehouse.DeleteSearchConfig:input_type -> google.cloud.visionai.v1.DeleteSearchConfigRequest
	107, // 221: google.cloud.visionai.v1.Warehouse.ListSearchConfigs:input_type -> google.cloud.visionai.v1.ListSearchConfigsRequest
	129, // 222: google.cloud.visionai.v1.Warehouse.CreateSearchHypernym:input_type -> google.cloud.visionai.v1.CreateSearchHypernymRequest
	130, // 223: google.cloud.visionai.v1.Warehouse.UpdateSearchHypernym:input_type -> google.cloud.visionai.v1.UpdateSearchHypernymRequest
	131, // 224: google.cloud.visionai.v1.Warehouse.GetSearchHypernym:input_type -> google.cloud.visionai.v1.GetSearchHypernymRequest
	132, // 225: google.cloud.visionai.v1.Warehouse.DeleteSearchHypernym:input_type -> google.cloud.visionai.v1.DeleteSearchHypernymRequest
	133, // 226: google.cloud.visionai.v1.Warehouse.ListSearchHypernyms:input_type -> google.cloud.visionai.v1.ListSearchHypernymsRequest
	145, // 227: google.cloud.visionai.v1.Warehouse.SearchAssets:input_type -> google.cloud.visionai.v1.SearchAssetsRequest
	146, // 228: google.cloud.visionai.v1.Warehouse.SearchIndexEndpoint:input_type -> google.cloud.visionai.v1.SearchIndexEndpointRequest
	111, // 229: google.cloud.visionai.v1.Warehouse.CreateIndexEndpoint:input_type -> google.cloud.visionai.v1.CreateIndexEndpointRequest
	113, // 230: google.cloud.visionai.v1.Warehouse.GetIndexEndpoint:input_type -> google.cloud.visionai.v1.GetIndexEndpointRequest
	114, // 231: google.cloud.visionai.v1.Warehouse.ListIndexEndpoints:input_type -> google.cloud.visionai.v1.ListIndexEndpointsRequest
	116, // 232: google.cloud.visionai.v1.Warehouse.UpdateIndexEndpoint:input_type -> google.cloud.visionai.v1.UpdateIndexEndpointRequest
	118, // 233: google.cloud.visionai.v1.Warehouse.DeleteIndexEndpoint:input_type -> google.cloud.visionai.v1.DeleteIndexEndpointRequest
	120, // 234: google.cloud.visionai.v1.Warehouse.DeployIndex:input_type -> google.cloud.visionai.v1.DeployIndexRequest
	124, // 235: google.cloud.visionai.v1.Warehouse.UndeployIndex:input_type -> google.cloud.visionai.v1.UndeployIndexRequest
	45,  // 236: google.cloud.visionai.v1.Warehouse.CreateCollection:input_type -> google.cloud.visionai.v1.CreateCollectionRequest
	47,  // 237: google.cloud.visionai.v1.Warehouse.DeleteCollection:input_type -> google.cloud.visionai.v1.DeleteCollectionRequest
	48,  // 238: google.cloud.visionai.v1.Warehouse.GetCollection:input_type -> google.cloud.visionai.v1.GetCollectionRequest
	49,  // 239: google.cloud.visionai.v1.Warehouse.UpdateCollection:input_type -> google.cloud.visionai.v1.UpdateCollectionRequest
	50,  // 240: google.cloud.visionai.v1.Warehouse.ListCollections:input_type -> google.cloud.visionai.v1.ListCollectionsRequest
	52,  // 241: google.cloud.visionai.v1.Warehouse.AddCollectionItem:input_type -> google.cloud.visionai.v1.AddCollectionItemRequest
	54,  // 242: google.cloud.visionai.v1.Warehouse.RemoveCollectionItem:input_type -> google.cloud.visionai.v1.RemoveCollectionItemRequest
	56,  // 243: google.cloud.visionai.v1.Warehouse.ViewCollectionItems:input_type -> google.cloud.visionai.v1.ViewCollectionItemsRequest
	26,  // 244: google.cloud.visionai.v1.Warehouse.CreateAsset:output_type -> google.cloud.visionai.v1.Asset
	26,  // 245: google.cloud.visionai.v1.Warehouse.UpdateAsset:output_type -> google.cloud.visionai.v1.Asset
	26,  // 246: google.cloud.visionai.v1.Warehouse.GetAsset:output_type -> google.cloud.visionai.v1.Asset
	17,  // 247: google.cloud.visionai.v1.Warehouse.ListAssets:output_type -> google.cloud.visionai.v1.ListAssetsResponse
	197, // 248: google.cloud.visionai.v1.Warehouse.DeleteAsset:output_type -> google.longrunning.Operation
	197, // 249: google.cloud.visionai.v1.Warehouse.UploadAsset:output_type -> google.longrunning.Operation
	25,  // 250: google.cloud.visionai.v1.Warehouse.GenerateRetrievalUrl:output_type -> google.cloud.visionai.v1.GenerateRetrievalUrlResponse
	197, // 251: google.cloud.visionai.v1.Warehouse.AnalyzeAsset:output_type -> google.longrunning.Operation
	197, // 252: google.cloud.visionai.v1.Warehouse.IndexAsset:output_type -> google.longrunning.Operation
	197, // 253: google.cloud.visionai.v1.Warehouse.RemoveIndexAsset:output_type -> google.longrunning.Operation
	39,  // 254: google.cloud.visionai.v1.Warehouse.ViewIndexedAssets:output_type -> google.cloud.visionai.v1.ViewIndexedAssetsResponse
	197, // 255: google.cloud.visionai.v1.Warehouse.CreateIndex:output_type -> google.longrunning.Operation
	197, // 256: google.cloud.visionai.v1.Warehouse.UpdateIndex:output_type -> google.longrunning.Operation
	69,  // 257: google.cloud.visionai.v1.Warehouse.GetIndex:output_type -> google.cloud.visionai.v1.Index
	66,  // 258: google.cloud.visionai.v1.Warehouse.ListIndexes:output_type -> google.cloud.visionai.v1.ListIndexesResponse
	197, // 259: google.cloud.visionai.v1.Warehouse.DeleteIndex:output_type -> google.longrunning.Operation
	197, // 260: google.cloud.visionai.v1.Warehouse.CreateCorpus:output_type -> google.longrunning.Operation
	71,  // 261: google.cloud.visionai.v1.Warehouse.GetCorpus:output_type -> google.cloud.visionai.v1.Corpus
	71,  // 262: google.cloud.visionai.v1.Warehouse.UpdateCorpus:output_type -> google.cloud.visionai.v1.Corpus
	75,  // 263: google.cloud.visionai.v1.Warehouse.ListCorpora:output_type -> google.cloud.visionai.v1.ListCorporaResponse
	198, // 264: google.cloud.visionai.v1.Warehouse.DeleteCorpus:output_type -> google.protobuf.Empty
	197, // 265: google.cloud.visionai.v1.Warehouse.AnalyzeCorpus:output_type -> google.longrunning.Operation
	81,  // 266: google.cloud.visionai.v1.Warehouse.CreateDataSchema:output_type -> google.cloud.visionai.v1.DataSchema
	81,  // 267: google.cloud.visionai.v1.Warehouse.UpdateDataSchema:output_type -> google.cloud.visionai.v1.DataSchema
	81,  // 268: google.cloud.visionai.v1.Warehouse.GetDataSchema:output_type -> google.cloud.visionai.v1.DataSchema
	198, // 269: google.cloud.visionai.v1.Warehouse.DeleteDataSchema:output_type -> google.protobuf.Empty
	87,  // 270: google.cloud.visionai.v1.Warehouse.ListDataSchemas:output_type -> google.cloud.visionai.v1.ListDataSchemasResponse
	89,  // 271: google.cloud.visionai.v1.Warehouse.CreateAnnotation:output_type -> google.cloud.visionai.v1.Annotation
	89,  // 272: google.cloud.visionai.v1.Warehouse.GetAnnotation:output_type -> google.cloud.visionai.v1.Annotation
	96,  // 273: google.cloud.visionai.v1.Warehouse.ListAnnotations:output_type -> google.cloud.visionai.v1.ListAnnotationsResponse
	89,  // 274: google.cloud.visionai.v1.Warehouse.UpdateAnnotation:output_type -> google.cloud.visionai.v1.Annotation
	198, // 275: google.cloud.visionai.v1.Warehouse.DeleteAnnotation:output_type -> google.protobuf.Empty
	140, // 276: google.cloud.visionai.v1.Warehouse.IngestAsset:output_type -> google.cloud.visionai.v1.IngestAssetResponse
	142, // 277: google.cloud.visionai.v1.Warehouse.ClipAsset:output_type -> google.cloud.visionai.v1.ClipAssetResponse
	144, // 278: google.cloud.visionai.v1.Warehouse.GenerateHlsUri:output_type -> google.cloud.visionai.v1.GenerateHlsUriResponse
	197, // 279: google.cloud.visionai.v1.Warehouse.ImportAssets:output_type -> google.longrunning.Operation
	109, // 280: google.cloud.visionai.v1.Warehouse.CreateSearchConfig:output_type -> google.cloud.visionai.v1.SearchConfig
	109, // 281: google.cloud.visionai.v1.Warehouse.UpdateSearchConfig:output_type -> google.cloud.visionai.v1.SearchConfig
	109, // 282: google.cloud.visionai.v1.Warehouse.GetSearchConfig:output_type -> google.cloud.visionai.v1.SearchConfig
	198, // 283: google.cloud.visionai.v1.Warehouse.DeleteSearchConfig:output_type -> google.protobuf.Empty
	108, // 284: google.cloud.visionai.v1.Warehouse.ListSearchConfigs:output_type -> google.cloud.visionai.v1.ListSearchConfigsResponse
	128, // 285: google.cloud.visionai.v1.Warehouse.CreateSearchHypernym:output_type -> google.cloud.visionai.v1.SearchHypernym
	128, // 286: google.cloud.visionai.v1.Warehouse.UpdateSearchHypernym:output_type -> google.cloud.visionai.v1.SearchHypernym
	128, // 287: google.cloud.visionai.v1.Warehouse.GetSearchHypernym:output_type -> google.cloud.visionai.v1.SearchHypernym
	198, // 288: google.cloud.visionai.v1.Warehouse.DeleteSearchHypernym:output_type -> google.protobuf.Empty
	134, // 289: google.cloud.visionai.v1.Warehouse.ListSearchHypernyms:output_type -> google.cloud.visionai.v1.ListSearchHypernymsResponse
	152, // 290: google.cloud.visionai.v1.Warehouse.SearchAssets:output_type -> google.cloud.visionai.v1.SearchAssetsResponse
	153, // 291: google.cloud.visionai.v1.Warehouse.SearchIndexEndpoint:output_type -> google.cloud.visionai.v1.SearchIndexEndpointResponse
	197, // 292: google.cloud.visionai.v1.Warehouse.CreateIndexEndpoint:output_type -> google.longrunning.Operation
	110, // 293: google.cloud.visionai.v1.Warehouse.GetIndexEndpoint:output_type -> google.cloud.visionai.v1.IndexEndpoint
	115, // 294: google.cloud.visionai.v1.Warehouse.ListIndexEndpoints:output_type -> google.cloud.visionai.v1.ListIndexEndpointsResponse
	197, // 295: google.cloud.visionai.v1.Warehouse.UpdateIndexEndpoint:output_type -> google.longrunning.Operation
	197, // 296: google.cloud.visionai.v1.Warehouse.DeleteIndexEndpoint:output_type -> google.longrunning.Operation
	197, // 297: google.cloud.visionai.v1.Warehouse.DeployIndex:output_type -> google.longrunning.Operation
	197, // 298: google.cloud.visionai.v1.Warehouse.UndeployIndex:output_type -> google.longrunning.Operation
	197, // 299: google.cloud.visionai.v1.Warehouse.CreateCollection:output_type -> google.longrunning.Operation
	197, // 300: google.cloud.visionai.v1.Warehouse.DeleteCollection:output_type -> google.longrunning.Operation
	58,  // 301: google.cloud.visionai.v1.Warehouse.GetCollection:output_type -> google.cloud.visionai.v1.Collection
	58,  // 302: google.cloud.visionai.v1.Warehouse.UpdateCollection:output_type -> google.cloud.visionai.v1.Collection
	51,  // 303: google.cloud.visionai.v1.Warehouse.ListCollections:output_type -> google.cloud.visionai.v1.ListCollectionsResponse
	53,  // 304: google.cloud.visionai.v1.Warehouse.AddCollectionItem:output_type -> google.cloud.visionai.v1.AddCollectionItemResponse
	55,  // 305: google.cloud.visionai.v1.Warehouse.RemoveCollectionItem:output_type -> google.cloud.visionai.v1.RemoveCollectionItemResponse
	57,  // 306: google.cloud.visionai.v1.Warehouse.ViewCollectionItems:output_type -> google.cloud.visionai.v1.ViewCollectionItemsResponse
	244, // [244:307] is the sub-list for method output_type
	181, // [181:244] is the sub-list for method input_type
	181, // [181:181] is the sub-list for extension type_name
	181, // [181:181] is the sub-list for extension extendee
	0,   // [0:181] is the sub-list for field type_name
}

func init() { file_google_cloud_visionai_v1_warehouse_proto_init() }
func file_google_cloud_visionai_v1_warehouse_proto_init() {
	if File_google_cloud_visionai_v1_warehouse_proto != nil {
		return
	}
	file_google_cloud_visionai_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadAssetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadAssetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateRetrievalUrlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateRetrievalUrlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeAssetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeAssetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexingStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexAssetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexAssetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveIndexAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveIndexAssetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveIndexAssetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexedAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ViewIndexedAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ViewIndexedAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCorpusMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCapability); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCapabilitySetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCollectionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCollectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCollectionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCollectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCollectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCollectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCollectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCollectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddCollectionItemRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddCollectionItemResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveCollectionItemRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveCollectionItemResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ViewCollectionItemsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ViewCollectionItemsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Collection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CollectionItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIndexMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIndexMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIndexMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Index); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployedIndexReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Corpus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCorporaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCorporaResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeCorpusMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeCorpusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataSchemasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataSchemasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Annotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSpecifiedAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GeoCoordinate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationCustomizedStruct); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAssetsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSearchConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSearchConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSearchConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSearchConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSearchConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSearchConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexEndpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIndexEndpointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIndexEndpointMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIndexEndpointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexEndpointsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexEndpointsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIndexEndpointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIndexEndpointMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIndexEndpointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIndexEndpointMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIndexResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployIndexMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[109].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIndexMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployIndexResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[112].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployedIndex); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[113].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[114].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchHypernym); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[115].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSearchHypernymRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[116].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSearchHypernymRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[117].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSearchHypernymRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[118].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSearchHypernymRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[119].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSearchHypernymsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[120].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSearchHypernymsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[121].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCriteriaProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[122].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[123].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[124].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[125].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[126].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[127].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClipAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[128].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClipAssetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[129].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateHlsUriRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[130].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateHlsUriResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[131].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[132].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchIndexEndpointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[133].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[134].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemaKeySortingStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[135].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAssetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[136].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationMatchingResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[137].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResultItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[138].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[139].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchIndexEndpointResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[140].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[141].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FloatRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[142].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StringArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[143].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntRangeArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[144].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FloatRangeArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[145].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTimeRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[146].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTimeRangeArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[147].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CircleArea); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[148].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GeoLocationArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[149].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoolValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[150].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Criteria); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[151].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[152].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetSource_AssetGcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[153].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssetSource_AssetContentData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[154].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeAssetMetadata_AnalysisStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[155].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails_ProtoAnyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[156].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails_ListConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[157].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails_CustomizedStructConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[158].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails_SearchStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[160].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails_SearchStrategy_ConfidenceScoreIndexConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[163].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetProperty_FixedRangeBucketSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[164].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetProperty_CustomRangeBucketSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[165].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetProperty_DateTimeBucketSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[166].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetBucket_Range); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[167].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetRequest_Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[168].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetRequest_TimeIndexedData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[169].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetRequest_Config_VideoType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[170].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClipAssetResponse_TimeIndexedUri); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[171].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemaKeySortingStrategy_Option); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[172].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition_TemporalPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[173].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition_SpatialPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_warehouse_proto_msgTypes[174].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition_RelativeTemporalPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*AssetSource_AssetGcsSource_)(nil),
		(*AssetSource_AssetContentData_)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[31].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[55].OneofWrappers = []interface{}{
		(*Index_EntireCorpus)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[68].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[74].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[78].OneofWrappers = []interface{}{
		(*AnnotationValue_IntValue)(nil),
		(*AnnotationValue_FloatValue)(nil),
		(*AnnotationValue_StrValue)(nil),
		(*AnnotationValue_DatetimeValue)(nil),
		(*AnnotationValue_GeoCoordinate)(nil),
		(*AnnotationValue_ProtoAnyValue)(nil),
		(*AnnotationValue_BoolValue)(nil),
		(*AnnotationValue_CustomizedStructDataValue)(nil),
		(*AnnotationValue_ListValue)(nil),
		(*AnnotationValue_CustomizedStructValue)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[86].OneofWrappers = []interface{}{
		(*ImportAssetsRequest_AssetsGcsUri)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[113].OneofWrappers = []interface{}{
		(*FacetProperty_FixedRangeBucketSpec_)(nil),
		(*FacetProperty_CustomRangeBucketSpec_)(nil),
		(*FacetProperty_DatetimeBucketSpec)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[115].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[122].OneofWrappers = []interface{}{
		(*FacetValue_StringValue)(nil),
		(*FacetValue_IntegerValue)(nil),
		(*FacetValue_DatetimeValue)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[123].OneofWrappers = []interface{}{
		(*FacetBucket_Value)(nil),
		(*FacetBucket_Range_)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[125].OneofWrappers = []interface{}{
		(*IngestAssetRequest_Config_)(nil),
		(*IngestAssetRequest_TimeIndexedData_)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[131].OneofWrappers = []interface{}{
		(*SearchAssetsRequest_SchemaKeySortingStrategy)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[132].OneofWrappers = []interface{}{
		(*SearchIndexEndpointRequest_ImageQuery)(nil),
		(*SearchIndexEndpointRequest_TextQuery)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[133].OneofWrappers = []interface{}{
		(*ImageQuery_InputImage)(nil),
		(*ImageQuery_Asset)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[140].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[141].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[150].OneofWrappers = []interface{}{
		(*Criteria_TextArray)(nil),
		(*Criteria_IntRangeArray)(nil),
		(*Criteria_FloatRangeArray)(nil),
		(*Criteria_DateTimeRangeArray)(nil),
		(*Criteria_GeoLocationArray)(nil),
		(*Criteria_BoolValue)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[158].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[167].OneofWrappers = []interface{}{
		(*IngestAssetRequest_Config_VideoType_)(nil),
	}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[171].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1_warehouse_proto_msgTypes[173].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visionai_v1_warehouse_proto_rawDesc,
			NumEnums:      14,
			NumMessages:   175,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_visionai_v1_warehouse_proto_goTypes,
		DependencyIndexes: file_google_cloud_visionai_v1_warehouse_proto_depIdxs,
		EnumInfos:         file_google_cloud_visionai_v1_warehouse_proto_enumTypes,
		MessageInfos:      file_google_cloud_visionai_v1_warehouse_proto_msgTypes,
	}.Build()
	File_google_cloud_visionai_v1_warehouse_proto = out.File
	file_google_cloud_visionai_v1_warehouse_proto_rawDesc = nil
	file_google_cloud_visionai_v1_warehouse_proto_goTypes = nil
	file_google_cloud_visionai_v1_warehouse_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// WarehouseClient is the client API for Warehouse service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WarehouseClient interface {
	// Creates an asset inside corpus.
	CreateAsset(ctx context.Context, in *CreateAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Updates an asset inside corpus.
	UpdateAsset(ctx context.Context, in *UpdateAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Reads an asset inside corpus.
	GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Lists an list of assets inside corpus.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Deletes asset inside corpus.
	DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Upload asset by specifing the asset Cloud Storage uri.
	// For video warehouse, it requires users who call this API have read access
	// to the cloud storage file. Once it is uploaded, it can be retrieved by
	// GenerateRetrievalUrl API which by default, only can retrieve cloud storage
	// files from the same project of the warehouse. To allow retrieval cloud
	// storage files that are in a separate project, it requires to find the
	// vision ai service account (Go to IAM, check checkbox to show "Include
	// Google-provided role grants", search for "Cloud Vision AI Service Agent")
	// and grant the read access of the cloud storage files to that service
	// account.
	UploadAsset(ctx context.Context, in *UploadAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Generates a signed url for downloading the asset.
	// For video warehouse, please see comment of UploadAsset about how to allow
	// retrieval of cloud storage files in a different project.
	GenerateRetrievalUrl(ctx context.Context, in *GenerateRetrievalUrlRequest, opts ...grpc.CallOption) (*GenerateRetrievalUrlResponse, error)
	// Analyze asset to power search capability.
	AnalyzeAsset(ctx context.Context, in *AnalyzeAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Index one asset for search.
	// Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
	IndexAsset(ctx context.Context, in *IndexAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Remove one asset's index data for search.
	// Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
	RemoveIndexAsset(ctx context.Context, in *RemoveIndexAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists assets inside an index.
	ViewIndexedAssets(ctx context.Context, in *ViewIndexedAssetsRequest, opts ...grpc.CallOption) (*ViewIndexedAssetsResponse, error)
	// Creates an Index under the corpus.
	CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an Index under the corpus.
	// Users can perform a metadata-only update or trigger a full index rebuild
	// with different update_mask values.
	UpdateIndex(ctx context.Context, in *UpdateIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the details of a single Index under a Corpus.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// List all Indexes in a given Corpus.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
	// Delete a single Index. In order to delete an index, the caller must
	// make sure that it is not deployed to any index endpoint.
	DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a corpus inside a project.
	CreateCorpus(ctx context.Context, in *CreateCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets corpus details inside a project.
	GetCorpus(ctx context.Context, in *GetCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Updates a corpus in a project.
	UpdateCorpus(ctx context.Context, in *UpdateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Lists all corpora in a project.
	ListCorpora(ctx context.Context, in *ListCorporaRequest, opts ...grpc.CallOption) (*ListCorporaResponse, error)
	// Deletes a corpus only if its empty.
	// Returns empty response.
	DeleteCorpus(ctx context.Context, in *DeleteCorpusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Analyzes a corpus.
	AnalyzeCorpus(ctx context.Context, in *AnalyzeCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates data schema inside corpus.
	CreateDataSchema(ctx context.Context, in *CreateDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error)
	// Updates data schema inside corpus.
	UpdateDataSchema(ctx context.Context, in *UpdateDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error)
	// Gets data schema inside corpus.
	GetDataSchema(ctx context.Context, in *GetDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error)
	// Deletes data schema inside corpus.
	DeleteDataSchema(ctx context.Context, in *DeleteDataSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists a list of data schemas inside corpus.
	ListDataSchemas(ctx context.Context, in *ListDataSchemasRequest, opts ...grpc.CallOption) (*ListDataSchemasResponse, error)
	// Creates annotation inside asset.
	CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Reads annotation inside asset.
	GetAnnotation(ctx context.Context, in *GetAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Lists a list of annotations inside asset.
	ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error)
	// Updates annotation inside asset.
	UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Deletes annotation inside asset.
	DeleteAnnotation(ctx context.Context, in *DeleteAnnotationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Ingests data for the asset. It is not allowed to ingest a data chunk which
	// is already expired according to TTL.
	// This method is only available via the gRPC API (not HTTP since
	// bi-directional streaming is not supported via HTTP).
	IngestAsset(ctx context.Context, opts ...grpc.CallOption) (Warehouse_IngestAssetClient, error)
	// Generates clips for downloading. The api takes in a time range, and
	// generates a clip of the first content available after start_time and
	// before end_time, which may overflow beyond these bounds.
	// Returned clips are truncated if the total size of the clips are larger
	// than 100MB.
	ClipAsset(ctx context.Context, in *ClipAssetRequest, opts ...grpc.CallOption) (*ClipAssetResponse, error)
	// Generates a uri for an HLS manifest. The api takes in a collection of time
	// ranges, and generates a URI for an HLS manifest that covers all the
	// requested time ranges.
	GenerateHlsUri(ctx context.Context, in *GenerateHlsUriRequest, opts ...grpc.CallOption) (*GenerateHlsUriResponse, error)
	// Imports assets (images plus annotations) from a meta file on cloud storage.
	// Each row in the meta file is corresponding to an image (specified by a
	// cloud storage uri) and its annotations.
	ImportAssets(ctx context.Context, in *ImportAssetsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a search configuration inside a corpus.
	//
	// Please follow the rules below to create a valid CreateSearchConfigRequest.
	// --- General Rules ---
	//  1. Request.search_config_id must not be associated with an existing
	//     SearchConfig.
	//  2. Request must contain at least one non-empty search_criteria_property or
	//     facet_property.
	//  3. mapped_fields must not be empty, and must map to existing UGA keys.
	//  4. All mapped_fields must be of the same type.
	//  5. All mapped_fields must share the same granularity.
	//  6. All mapped_fields must share the same semantic SearchConfig match
	//     options.
	//
	// For property-specific rules, please reference the comments for
	// FacetProperty and SearchCriteriaProperty.
	CreateSearchConfig(ctx context.Context, in *CreateSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error)
	// Updates a search configuration inside a corpus.
	//
	// Please follow the rules below to create a valid UpdateSearchConfigRequest.
	// --- General Rules ---
	// 1. Request.search_configuration.name must already exist.
	// 2. Request must contain at least one non-empty search_criteria_property or
	// facet_property.
	//  3. mapped_fields must not be empty, and must map to existing UGA keys.
	//  4. All mapped_fields must be of the same type.
	//  5. All mapped_fields must share the same granularity.
	//  6. All mapped_fields must share the same semantic SearchConfig match
	//     options.
	//
	// For property-specific rules, please reference the comments for
	// FacetProperty and SearchCriteriaProperty.
	UpdateSearchConfig(ctx context.Context, in *UpdateSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error)
	// Gets a search configuration inside a corpus.
	GetSearchConfig(ctx context.Context, in *GetSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error)
	// Deletes a search configuration inside a corpus.
	//
	// For a DeleteSearchConfigRequest to be valid,
	// Request.search_configuration.name must already exist.
	DeleteSearchConfig(ctx context.Context, in *DeleteSearchConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all search configurations inside a corpus.
	ListSearchConfigs(ctx context.Context, in *ListSearchConfigsRequest, opts ...grpc.CallOption) (*ListSearchConfigsResponse, error)
	// Creates a SearchHypernym inside a corpus.
	CreateSearchHypernym(ctx context.Context, in *CreateSearchHypernymRequest, opts ...grpc.CallOption) (*SearchHypernym, error)
	// Updates a SearchHypernym inside a corpus.
	UpdateSearchHypernym(ctx context.Context, in *UpdateSearchHypernymRequest, opts ...grpc.CallOption) (*SearchHypernym, error)
	// Gets a SearchHypernym inside a corpus.
	GetSearchHypernym(ctx context.Context, in *GetSearchHypernymRequest, opts ...grpc.CallOption) (*SearchHypernym, error)
	// Deletes a SearchHypernym inside a corpus.
	DeleteSearchHypernym(ctx context.Context, in *DeleteSearchHypernymRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists SearchHypernyms inside a corpus.
	ListSearchHypernyms(ctx context.Context, in *ListSearchHypernymsRequest, opts ...grpc.CallOption) (*ListSearchHypernymsResponse, error)
	// Search media asset.
	SearchAssets(ctx context.Context, in *SearchAssetsRequest, opts ...grpc.CallOption) (*SearchAssetsResponse, error)
	// Search a deployed index endpoint (IMAGE corpus type only).
	SearchIndexEndpoint(ctx context.Context, in *SearchIndexEndpointRequest, opts ...grpc.CallOption) (*SearchIndexEndpointResponse, error)
	// Creates an IndexEndpoint.
	CreateIndexEndpoint(ctx context.Context, in *CreateIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an IndexEndpoint.
	GetIndexEndpoint(ctx context.Context, in *GetIndexEndpointRequest, opts ...grpc.CallOption) (*IndexEndpoint, error)
	// Lists all IndexEndpoints in a project.
	ListIndexEndpoints(ctx context.Context, in *ListIndexEndpointsRequest, opts ...grpc.CallOption) (*ListIndexEndpointsResponse, error)
	// Updates an IndexEndpoint.
	UpdateIndexEndpoint(ctx context.Context, in *UpdateIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an IndexEndpoint.
	DeleteIndexEndpoint(ctx context.Context, in *DeleteIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys an Index to IndexEndpoint.
	DeployIndex(ctx context.Context, in *DeployIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys an Index from IndexEndpoint.
	UndeployIndex(ctx context.Context, in *UndeployIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a collection.
	CreateCollection(ctx context.Context, in *CreateCollectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a collection.
	DeleteCollection(ctx context.Context, in *DeleteCollectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a collection.
	GetCollection(ctx context.Context, in *GetCollectionRequest, opts ...grpc.CallOption) (*Collection, error)
	// Updates a collection.
	UpdateCollection(ctx context.Context, in *UpdateCollectionRequest, opts ...grpc.CallOption) (*Collection, error)
	// Lists collections inside a corpus.
	ListCollections(ctx context.Context, in *ListCollectionsRequest, opts ...grpc.CallOption) (*ListCollectionsResponse, error)
	// Adds an item into a Collection.
	AddCollectionItem(ctx context.Context, in *AddCollectionItemRequest, opts ...grpc.CallOption) (*AddCollectionItemResponse, error)
	// Removes an item from a collection.
	RemoveCollectionItem(ctx context.Context, in *RemoveCollectionItemRequest, opts ...grpc.CallOption) (*RemoveCollectionItemResponse, error)
	// View items inside a collection.
	ViewCollectionItems(ctx context.Context, in *ViewCollectionItemsRequest, opts ...grpc.CallOption) (*ViewCollectionItemsResponse, error)
}

type warehouseClient struct {
	cc grpc.ClientConnInterface
}

func NewWarehouseClient(cc grpc.ClientConnInterface) WarehouseClient {
	return &warehouseClient{cc}
}

func (c *warehouseClient) CreateAsset(ctx context.Context, in *CreateAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateAsset(ctx context.Context, in *UpdateAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UploadAsset(ctx context.Context, in *UploadAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UploadAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GenerateRetrievalUrl(ctx context.Context, in *GenerateRetrievalUrlRequest, opts ...grpc.CallOption) (*GenerateRetrievalUrlResponse, error) {
	out := new(GenerateRetrievalUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GenerateRetrievalUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) AnalyzeAsset(ctx context.Context, in *AnalyzeAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/AnalyzeAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) IndexAsset(ctx context.Context, in *IndexAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/IndexAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) RemoveIndexAsset(ctx context.Context, in *RemoveIndexAssetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/RemoveIndexAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ViewIndexedAssets(ctx context.Context, in *ViewIndexedAssetsRequest, opts ...grpc.CallOption) (*ViewIndexedAssetsResponse, error) {
	out := new(ViewIndexedAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ViewIndexedAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateIndex(ctx context.Context, in *UpdateIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListIndexes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateCorpus(ctx context.Context, in *CreateCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetCorpus(ctx context.Context, in *GetCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateCorpus(ctx context.Context, in *UpdateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListCorpora(ctx context.Context, in *ListCorporaRequest, opts ...grpc.CallOption) (*ListCorporaResponse, error) {
	out := new(ListCorporaResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListCorpora", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteCorpus(ctx context.Context, in *DeleteCorpusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) AnalyzeCorpus(ctx context.Context, in *AnalyzeCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/AnalyzeCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateDataSchema(ctx context.Context, in *CreateDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error) {
	out := new(DataSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateDataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateDataSchema(ctx context.Context, in *UpdateDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error) {
	out := new(DataSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateDataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetDataSchema(ctx context.Context, in *GetDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error) {
	out := new(DataSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetDataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteDataSchema(ctx context.Context, in *DeleteDataSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteDataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListDataSchemas(ctx context.Context, in *ListDataSchemasRequest, opts ...grpc.CallOption) (*ListDataSchemasResponse, error) {
	out := new(ListDataSchemasResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListDataSchemas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetAnnotation(ctx context.Context, in *GetAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error) {
	out := new(ListAnnotationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListAnnotations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteAnnotation(ctx context.Context, in *DeleteAnnotationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) IngestAsset(ctx context.Context, opts ...grpc.CallOption) (Warehouse_IngestAssetClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Warehouse_serviceDesc.Streams[0], "/google.cloud.visionai.v1.Warehouse/IngestAsset", opts...)
	if err != nil {
		return nil, err
	}
	x := &warehouseIngestAssetClient{stream}
	return x, nil
}

type Warehouse_IngestAssetClient interface {
	Send(*IngestAssetRequest) error
	Recv() (*IngestAssetResponse, error)
	grpc.ClientStream
}

type warehouseIngestAssetClient struct {
	grpc.ClientStream
}

func (x *warehouseIngestAssetClient) Send(m *IngestAssetRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *warehouseIngestAssetClient) Recv() (*IngestAssetResponse, error) {
	m := new(IngestAssetResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *warehouseClient) ClipAsset(ctx context.Context, in *ClipAssetRequest, opts ...grpc.CallOption) (*ClipAssetResponse, error) {
	out := new(ClipAssetResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ClipAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GenerateHlsUri(ctx context.Context, in *GenerateHlsUriRequest, opts ...grpc.CallOption) (*GenerateHlsUriResponse, error) {
	out := new(GenerateHlsUriResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GenerateHlsUri", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ImportAssets(ctx context.Context, in *ImportAssetsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ImportAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateSearchConfig(ctx context.Context, in *CreateSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error) {
	out := new(SearchConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateSearchConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateSearchConfig(ctx context.Context, in *UpdateSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error) {
	out := new(SearchConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateSearchConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetSearchConfig(ctx context.Context, in *GetSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error) {
	out := new(SearchConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetSearchConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteSearchConfig(ctx context.Context, in *DeleteSearchConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteSearchConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListSearchConfigs(ctx context.Context, in *ListSearchConfigsRequest, opts ...grpc.CallOption) (*ListSearchConfigsResponse, error) {
	out := new(ListSearchConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListSearchConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateSearchHypernym(ctx context.Context, in *CreateSearchHypernymRequest, opts ...grpc.CallOption) (*SearchHypernym, error) {
	out := new(SearchHypernym)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateSearchHypernym", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateSearchHypernym(ctx context.Context, in *UpdateSearchHypernymRequest, opts ...grpc.CallOption) (*SearchHypernym, error) {
	out := new(SearchHypernym)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateSearchHypernym", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetSearchHypernym(ctx context.Context, in *GetSearchHypernymRequest, opts ...grpc.CallOption) (*SearchHypernym, error) {
	out := new(SearchHypernym)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetSearchHypernym", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteSearchHypernym(ctx context.Context, in *DeleteSearchHypernymRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteSearchHypernym", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListSearchHypernyms(ctx context.Context, in *ListSearchHypernymsRequest, opts ...grpc.CallOption) (*ListSearchHypernymsResponse, error) {
	out := new(ListSearchHypernymsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListSearchHypernyms", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) SearchAssets(ctx context.Context, in *SearchAssetsRequest, opts ...grpc.CallOption) (*SearchAssetsResponse, error) {
	out := new(SearchAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/SearchAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) SearchIndexEndpoint(ctx context.Context, in *SearchIndexEndpointRequest, opts ...grpc.CallOption) (*SearchIndexEndpointResponse, error) {
	out := new(SearchIndexEndpointResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/SearchIndexEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateIndexEndpoint(ctx context.Context, in *CreateIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateIndexEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetIndexEndpoint(ctx context.Context, in *GetIndexEndpointRequest, opts ...grpc.CallOption) (*IndexEndpoint, error) {
	out := new(IndexEndpoint)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetIndexEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListIndexEndpoints(ctx context.Context, in *ListIndexEndpointsRequest, opts ...grpc.CallOption) (*ListIndexEndpointsResponse, error) {
	out := new(ListIndexEndpointsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListIndexEndpoints", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateIndexEndpoint(ctx context.Context, in *UpdateIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateIndexEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteIndexEndpoint(ctx context.Context, in *DeleteIndexEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteIndexEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeployIndex(ctx context.Context, in *DeployIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeployIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UndeployIndex(ctx context.Context, in *UndeployIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UndeployIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateCollection(ctx context.Context, in *CreateCollectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/CreateCollection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteCollection(ctx context.Context, in *DeleteCollectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/DeleteCollection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetCollection(ctx context.Context, in *GetCollectionRequest, opts ...grpc.CallOption) (*Collection, error) {
	out := new(Collection)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/GetCollection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateCollection(ctx context.Context, in *UpdateCollectionRequest, opts ...grpc.CallOption) (*Collection, error) {
	out := new(Collection)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/UpdateCollection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListCollections(ctx context.Context, in *ListCollectionsRequest, opts ...grpc.CallOption) (*ListCollectionsResponse, error) {
	out := new(ListCollectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ListCollections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) AddCollectionItem(ctx context.Context, in *AddCollectionItemRequest, opts ...grpc.CallOption) (*AddCollectionItemResponse, error) {
	out := new(AddCollectionItemResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/AddCollectionItem", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) RemoveCollectionItem(ctx context.Context, in *RemoveCollectionItemRequest, opts ...grpc.CallOption) (*RemoveCollectionItemResponse, error) {
	out := new(RemoveCollectionItemResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/RemoveCollectionItem", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ViewCollectionItems(ctx context.Context, in *ViewCollectionItemsRequest, opts ...grpc.CallOption) (*ViewCollectionItemsResponse, error) {
	out := new(ViewCollectionItemsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.Warehouse/ViewCollectionItems", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WarehouseServer is the server API for Warehouse service.
type WarehouseServer interface {
	// Creates an asset inside corpus.
	CreateAsset(context.Context, *CreateAssetRequest) (*Asset, error)
	// Updates an asset inside corpus.
	UpdateAsset(context.Context, *UpdateAssetRequest) (*Asset, error)
	// Reads an asset inside corpus.
	GetAsset(context.Context, *GetAssetRequest) (*Asset, error)
	// Lists an list of assets inside corpus.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Deletes asset inside corpus.
	DeleteAsset(context.Context, *DeleteAssetRequest) (*longrunningpb.Operation, error)
	// Upload asset by specifing the asset Cloud Storage uri.
	// For video warehouse, it requires users who call this API have read access
	// to the cloud storage file. Once it is uploaded, it can be retrieved by
	// GenerateRetrievalUrl API which by default, only can retrieve cloud storage
	// files from the same project of the warehouse. To allow retrieval cloud
	// storage files that are in a separate project, it requires to find the
	// vision ai service account (Go to IAM, check checkbox to show "Include
	// Google-provided role grants", search for "Cloud Vision AI Service Agent")
	// and grant the read access of the cloud storage files to that service
	// account.
	UploadAsset(context.Context, *UploadAssetRequest) (*longrunningpb.Operation, error)
	// Generates a signed url for downloading the asset.
	// For video warehouse, please see comment of UploadAsset about how to allow
	// retrieval of cloud storage files in a different project.
	GenerateRetrievalUrl(context.Context, *GenerateRetrievalUrlRequest) (*GenerateRetrievalUrlResponse, error)
	// Analyze asset to power search capability.
	AnalyzeAsset(context.Context, *AnalyzeAssetRequest) (*longrunningpb.Operation, error)
	// Index one asset for search.
	// Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
	IndexAsset(context.Context, *IndexAssetRequest) (*longrunningpb.Operation, error)
	// Remove one asset's index data for search.
	// Supported corpus type: Corpus.Type.VIDEO_ON_DEMAND
	RemoveIndexAsset(context.Context, *RemoveIndexAssetRequest) (*longrunningpb.Operation, error)
	// Lists assets inside an index.
	ViewIndexedAssets(context.Context, *ViewIndexedAssetsRequest) (*ViewIndexedAssetsResponse, error)
	// Creates an Index under the corpus.
	CreateIndex(context.Context, *CreateIndexRequest) (*longrunningpb.Operation, error)
	// Updates an Index under the corpus.
	// Users can perform a metadata-only update or trigger a full index rebuild
	// with different update_mask values.
	UpdateIndex(context.Context, *UpdateIndexRequest) (*longrunningpb.Operation, error)
	// Gets the details of a single Index under a Corpus.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// List all Indexes in a given Corpus.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
	// Delete a single Index. In order to delete an index, the caller must
	// make sure that it is not deployed to any index endpoint.
	DeleteIndex(context.Context, *DeleteIndexRequest) (*longrunningpb.Operation, error)
	// Creates a corpus inside a project.
	CreateCorpus(context.Context, *CreateCorpusRequest) (*longrunningpb.Operation, error)
	// Gets corpus details inside a project.
	GetCorpus(context.Context, *GetCorpusRequest) (*Corpus, error)
	// Updates a corpus in a project.
	UpdateCorpus(context.Context, *UpdateCorpusRequest) (*Corpus, error)
	// Lists all corpora in a project.
	ListCorpora(context.Context, *ListCorporaRequest) (*ListCorporaResponse, error)
	// Deletes a corpus only if its empty.
	// Returns empty response.
	DeleteCorpus(context.Context, *DeleteCorpusRequest) (*emptypb.Empty, error)
	// Analyzes a corpus.
	AnalyzeCorpus(context.Context, *AnalyzeCorpusRequest) (*longrunningpb.Operation, error)
	// Creates data schema inside corpus.
	CreateDataSchema(context.Context, *CreateDataSchemaRequest) (*DataSchema, error)
	// Updates data schema inside corpus.
	UpdateDataSchema(context.Context, *UpdateDataSchemaRequest) (*DataSchema, error)
	// Gets data schema inside corpus.
	GetDataSchema(context.Context, *GetDataSchemaRequest) (*DataSchema, error)
	// Deletes data schema inside corpus.
	DeleteDataSchema(context.Context, *DeleteDataSchemaRequest) (*emptypb.Empty, error)
	// Lists a list of data schemas inside corpus.
	ListDataSchemas(context.Context, *ListDataSchemasRequest) (*ListDataSchemasResponse, error)
	// Creates annotation inside asset.
	CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error)
	// Reads annotation inside asset.
	GetAnnotation(context.Context, *GetAnnotationRequest) (*Annotation, error)
	// Lists a list of annotations inside asset.
	ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error)
	// Updates annotation inside asset.
	UpdateAnnotation(context.Context, *UpdateAnnotationRequest) (*Annotation, error)
	// Deletes annotation inside asset.
	DeleteAnnotation(context.Context, *DeleteAnnotationRequest) (*emptypb.Empty, error)
	// Ingests data for the asset. It is not allowed to ingest a data chunk which
	// is already expired according to TTL.
	// This method is only available via the gRPC API (not HTTP since
	// bi-directional streaming is not supported via HTTP).
	IngestAsset(Warehouse_IngestAssetServer) error
	// Generates clips for downloading. The api takes in a time range, and
	// generates a clip of the first content available after start_time and
	// before end_time, which may overflow beyond these bounds.
	// Returned clips are truncated if the total size of the clips are larger
	// than 100MB.
	ClipAsset(context.Context, *ClipAssetRequest) (*ClipAssetResponse, error)
	// Generates a uri for an HLS manifest. The api takes in a collection of time
	// ranges, and generates a URI for an HLS manifest that covers all the
	// requested time ranges.
	GenerateHlsUri(context.Context, *GenerateHlsUriRequest) (*GenerateHlsUriResponse, error)
	// Imports assets (images plus annotations) from a meta file on cloud storage.
	// Each row in the meta file is corresponding to an image (specified by a
	// cloud storage uri) and its annotations.
	ImportAssets(context.Context, *ImportAssetsRequest) (*longrunningpb.Operation, error)
	// Creates a search configuration inside a corpus.
	//
	// Please follow the rules below to create a valid CreateSearchConfigRequest.
	// --- General Rules ---
	//  1. Request.search_config_id must not be associated with an existing
	//     SearchConfig.
	//  2. Request must contain at least one non-empty search_criteria_property or
	//     facet_property.
	//  3. mapped_fields must not be empty, and must map to existing UGA keys.
	//  4. All mapped_fields must be of the same type.
	//  5. All mapped_fields must share the same granularity.
	//  6. All mapped_fields must share the same semantic SearchConfig match
	//     options.
	//
	// For property-specific rules, please reference the comments for
	// FacetProperty and SearchCriteriaProperty.
	CreateSearchConfig(context.Context, *CreateSearchConfigRequest) (*SearchConfig, error)
	// Updates a search configuration inside a corpus.
	//
	// Please follow the rules below to create a valid UpdateSearchConfigRequest.
	// --- General Rules ---
	// 1. Request.search_configuration.name must already exist.
	// 2. Request must contain at least one non-empty search_criteria_property or
	// facet_property.
	//  3. mapped_fields must not be empty, and must map to existing UGA keys.
	//  4. All mapped_fields must be of the same type.
	//  5. All mapped_fields must share the same granularity.
	//  6. All mapped_fields must share the same semantic SearchConfig match
	//     options.
	//
	// For property-specific rules, please reference the comments for
	// FacetProperty and SearchCriteriaProperty.
	UpdateSearchConfig(context.Context, *UpdateSearchConfigRequest) (*SearchConfig, error)
	// Gets a search configuration inside a corpus.
	GetSearchConfig(context.Context, *GetSearchConfigRequest) (*SearchConfig, error)
	// Deletes a search configuration inside a corpus.
	//
	// For a DeleteSearchConfigRequest to be valid,
	// Request.search_configuration.name must already exist.
	DeleteSearchConfig(context.Context, *DeleteSearchConfigRequest) (*emptypb.Empty, error)
	// Lists all search configurations inside a corpus.
	ListSearchConfigs(context.Context, *ListSearchConfigsRequest) (*ListSearchConfigsResponse, error)
	// Creates a SearchHypernym inside a corpus.
	CreateSearchHypernym(context.Context, *CreateSearchHypernymRequest) (*SearchHypernym, error)
	// Updates a SearchHypernym inside a corpus.
	UpdateSearchHypernym(context.Context, *UpdateSearchHypernymRequest) (*SearchHypernym, error)
	// Gets a SearchHypernym inside a corpus.
	GetSearchHypernym(context.Context, *GetSearchHypernymRequest) (*SearchHypernym, error)
	// Deletes a SearchHypernym inside a corpus.
	DeleteSearchHypernym(context.Context, *DeleteSearchHypernymRequest) (*emptypb.Empty, error)
	// Lists SearchHypernyms inside a corpus.
	ListSearchHypernyms(context.Context, *ListSearchHypernymsRequest) (*ListSearchHypernymsResponse, error)
	// Search media asset.
	SearchAssets(context.Context, *SearchAssetsRequest) (*SearchAssetsResponse, error)
	// Search a deployed index endpoint (IMAGE corpus type only).
	SearchIndexEndpoint(context.Context, *SearchIndexEndpointRequest) (*SearchIndexEndpointResponse, error)
	// Creates an IndexEndpoint.
	CreateIndexEndpoint(context.Context, *CreateIndexEndpointRequest) (*longrunningpb.Operation, error)
	// Gets an IndexEndpoint.
	GetIndexEndpoint(context.Context, *GetIndexEndpointRequest) (*IndexEndpoint, error)
	// Lists all IndexEndpoints in a project.
	ListIndexEndpoints(context.Context, *ListIndexEndpointsRequest) (*ListIndexEndpointsResponse, error)
	// Updates an IndexEndpoint.
	UpdateIndexEndpoint(context.Context, *UpdateIndexEndpointRequest) (*longrunningpb.Operation, error)
	// Deletes an IndexEndpoint.
	DeleteIndexEndpoint(context.Context, *DeleteIndexEndpointRequest) (*longrunningpb.Operation, error)
	// Deploys an Index to IndexEndpoint.
	DeployIndex(context.Context, *DeployIndexRequest) (*longrunningpb.Operation, error)
	// Undeploys an Index from IndexEndpoint.
	UndeployIndex(context.Context, *UndeployIndexRequest) (*longrunningpb.Operation, error)
	// Creates a collection.
	CreateCollection(context.Context, *CreateCollectionRequest) (*longrunningpb.Operation, error)
	// Deletes a collection.
	DeleteCollection(context.Context, *DeleteCollectionRequest) (*longrunningpb.Operation, error)
	// Gets a collection.
	GetCollection(context.Context, *GetCollectionRequest) (*Collection, error)
	// Updates a collection.
	UpdateCollection(context.Context, *UpdateCollectionRequest) (*Collection, error)
	// Lists collections inside a corpus.
	ListCollections(context.Context, *ListCollectionsRequest) (*ListCollectionsResponse, error)
	// Adds an item into a Collection.
	AddCollectionItem(context.Context, *AddCollectionItemRequest) (*AddCollectionItemResponse, error)
	// Removes an item from a collection.
	RemoveCollectionItem(context.Context, *RemoveCollectionItemRequest) (*RemoveCollectionItemResponse, error)
	// View items inside a collection.
	ViewCollectionItems(context.Context, *ViewCollectionItemsRequest) (*ViewCollectionItemsResponse, error)
}

// UnimplementedWarehouseServer can be embedded to have forward compatible implementations.
type UnimplementedWarehouseServer struct {
}

func (*UnimplementedWarehouseServer) CreateAsset(context.Context, *CreateAssetRequest) (*Asset, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAsset not implemented")
}
func (*UnimplementedWarehouseServer) UpdateAsset(context.Context, *UpdateAssetRequest) (*Asset, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateAsset not implemented")
}
func (*UnimplementedWarehouseServer) GetAsset(context.Context, *GetAssetRequest) (*Asset, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAsset not implemented")
}
func (*UnimplementedWarehouseServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (*UnimplementedWarehouseServer) DeleteAsset(context.Context, *DeleteAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAsset not implemented")
}
func (*UnimplementedWarehouseServer) UploadAsset(context.Context, *UploadAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UploadAsset not implemented")
}
func (*UnimplementedWarehouseServer) GenerateRetrievalUrl(context.Context, *GenerateRetrievalUrlRequest) (*GenerateRetrievalUrlResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateRetrievalUrl not implemented")
}
func (*UnimplementedWarehouseServer) AnalyzeAsset(context.Context, *AnalyzeAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeAsset not implemented")
}
func (*UnimplementedWarehouseServer) IndexAsset(context.Context, *IndexAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method IndexAsset not implemented")
}
func (*UnimplementedWarehouseServer) RemoveIndexAsset(context.Context, *RemoveIndexAssetRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RemoveIndexAsset not implemented")
}
func (*UnimplementedWarehouseServer) ViewIndexedAssets(context.Context, *ViewIndexedAssetsRequest) (*ViewIndexedAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ViewIndexedAssets not implemented")
}
func (*UnimplementedWarehouseServer) CreateIndex(context.Context, *CreateIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateIndex not implemented")
}
func (*UnimplementedWarehouseServer) UpdateIndex(context.Context, *UpdateIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateIndex not implemented")
}
func (*UnimplementedWarehouseServer) GetIndex(context.Context, *GetIndexRequest) (*Index, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetIndex not implemented")
}
func (*UnimplementedWarehouseServer) ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListIndexes not implemented")
}
func (*UnimplementedWarehouseServer) DeleteIndex(context.Context, *DeleteIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteIndex not implemented")
}
func (*UnimplementedWarehouseServer) CreateCorpus(context.Context, *CreateCorpusRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCorpus not implemented")
}
func (*UnimplementedWarehouseServer) GetCorpus(context.Context, *GetCorpusRequest) (*Corpus, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCorpus not implemented")
}
func (*UnimplementedWarehouseServer) UpdateCorpus(context.Context, *UpdateCorpusRequest) (*Corpus, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateCorpus not implemented")
}
func (*UnimplementedWarehouseServer) ListCorpora(context.Context, *ListCorporaRequest) (*ListCorporaResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCorpora not implemented")
}
func (*UnimplementedWarehouseServer) DeleteCorpus(context.Context, *DeleteCorpusRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteCorpus not implemented")
}
func (*UnimplementedWarehouseServer) AnalyzeCorpus(context.Context, *AnalyzeCorpusRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeCorpus not implemented")
}
func (*UnimplementedWarehouseServer) CreateDataSchema(context.Context, *CreateDataSchemaRequest) (*DataSchema, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateDataSchema not implemented")
}
func (*UnimplementedWarehouseServer) UpdateDataSchema(context.Context, *UpdateDataSchemaRequest) (*DataSchema, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateDataSchema not implemented")
}
func (*UnimplementedWarehouseServer) GetDataSchema(context.Context, *GetDataSchemaRequest) (*DataSchema, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDataSchema not implemented")
}
func (*UnimplementedWarehouseServer) DeleteDataSchema(context.Context, *DeleteDataSchemaRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteDataSchema not implemented")
}
func (*UnimplementedWarehouseServer) ListDataSchemas(context.Context, *ListDataSchemasRequest) (*ListDataSchemasResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDataSchemas not implemented")
}
func (*UnimplementedWarehouseServer) CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAnnotation not implemented")
}
func (*UnimplementedWarehouseServer) GetAnnotation(context.Context, *GetAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAnnotation not implemented")
}
func (*UnimplementedWarehouseServer) ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAnnotations not implemented")
}
func (*UnimplementedWarehouseServer) UpdateAnnotation(context.Context, *UpdateAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateAnnotation not implemented")
}
func (*UnimplementedWarehouseServer) DeleteAnnotation(context.Context, *DeleteAnnotationRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAnnotation not implemented")
}
func (*UnimplementedWarehouseServer) IngestAsset(Warehouse_IngestAssetServer) error {
	return status1.Errorf(codes.Unimplemented, "method IngestAsset not implemented")
}
func (*UnimplementedWarehouseServer) ClipAsset(context.Context, *ClipAssetRequest) (*ClipAssetResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ClipAsset not implemented")
}
func (*UnimplementedWarehouseServer) GenerateHlsUri(context.Context, *GenerateHlsUriRequest) (*GenerateHlsUriResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateHlsUri not implemented")
}
func (*UnimplementedWarehouseServer) ImportAssets(context.Context, *ImportAssetsRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ImportAssets not implemented")
}
func (*UnimplementedWarehouseServer) CreateSearchConfig(context.Context, *CreateSearchConfigRequest) (*SearchConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSearchConfig not implemented")
}
func (*UnimplementedWarehouseServer) UpdateSearchConfig(context.Context, *UpdateSearchConfigRequest) (*SearchConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSearchConfig not implemented")
}
func (*UnimplementedWarehouseServer) GetSearchConfig(context.Context, *GetSearchConfigRequest) (*SearchConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSearchConfig not implemented")
}
func (*UnimplementedWarehouseServer) DeleteSearchConfig(context.Context, *DeleteSearchConfigRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSearchConfig not implemented")
}
func (*UnimplementedWarehouseServer) ListSearchConfigs(context.Context, *ListSearchConfigsRequest) (*ListSearchConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSearchConfigs not implemented")
}
func (*UnimplementedWarehouseServer) CreateSearchHypernym(context.Context, *CreateSearchHypernymRequest) (*SearchHypernym, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSearchHypernym not implemented")
}
func (*UnimplementedWarehouseServer) UpdateSearchHypernym(context.Context, *UpdateSearchHypernymRequest) (*SearchHypernym, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSearchHypernym not implemented")
}
func (*UnimplementedWarehouseServer) GetSearchHypernym(context.Context, *GetSearchHypernymRequest) (*SearchHypernym, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSearchHypernym not implemented")
}
func (*UnimplementedWarehouseServer) DeleteSearchHypernym(context.Context, *DeleteSearchHypernymRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSearchHypernym not implemented")
}
func (*UnimplementedWarehouseServer) ListSearchHypernyms(context.Context, *ListSearchHypernymsRequest) (*ListSearchHypernymsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSearchHypernyms not implemented")
}
func (*UnimplementedWarehouseServer) SearchAssets(context.Context, *SearchAssetsRequest) (*SearchAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAssets not implemented")
}
func (*UnimplementedWarehouseServer) SearchIndexEndpoint(context.Context, *SearchIndexEndpointRequest) (*SearchIndexEndpointResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchIndexEndpoint not implemented")
}
func (*UnimplementedWarehouseServer) CreateIndexEndpoint(context.Context, *CreateIndexEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateIndexEndpoint not implemented")
}
func (*UnimplementedWarehouseServer) GetIndexEndpoint(context.Context, *GetIndexEndpointRequest) (*IndexEndpoint, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetIndexEndpoint not implemented")
}
func (*UnimplementedWarehouseServer) ListIndexEndpoints(context.Context, *ListIndexEndpointsRequest) (*ListIndexEndpointsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListIndexEndpoints not implemented")
}
func (*UnimplementedWarehouseServer) UpdateIndexEndpoint(context.Context, *UpdateIndexEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateIndexEndpoint not implemented")
}
func (*UnimplementedWarehouseServer) DeleteIndexEndpoint(context.Context, *DeleteIndexEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteIndexEndpoint not implemented")
}
func (*UnimplementedWarehouseServer) DeployIndex(context.Context, *DeployIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeployIndex not implemented")
}
func (*UnimplementedWarehouseServer) UndeployIndex(context.Context, *UndeployIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UndeployIndex not implemented")
}
func (*UnimplementedWarehouseServer) CreateCollection(context.Context, *CreateCollectionRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCollection not implemented")
}
func (*UnimplementedWarehouseServer) DeleteCollection(context.Context, *DeleteCollectionRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteCollection not implemented")
}
func (*UnimplementedWarehouseServer) GetCollection(context.Context, *GetCollectionRequest) (*Collection, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCollection not implemented")
}
func (*UnimplementedWarehouseServer) UpdateCollection(context.Context, *UpdateCollectionRequest) (*Collection, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateCollection not implemented")
}
func (*UnimplementedWarehouseServer) ListCollections(context.Context, *ListCollectionsRequest) (*ListCollectionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCollections not implemented")
}
func (*UnimplementedWarehouseServer) AddCollectionItem(context.Context, *AddCollectionItemRequest) (*AddCollectionItemResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddCollectionItem not implemented")
}
func (*UnimplementedWarehouseServer) RemoveCollectionItem(context.Context, *RemoveCollectionItemRequest) (*RemoveCollectionItemResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RemoveCollectionItem not implemented")
}
func (*UnimplementedWarehouseServer) ViewCollectionItems(context.Context, *ViewCollectionItemsRequest) (*ViewCollectionItemsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ViewCollectionItems not implemented")
}

func RegisterWarehouseServer(s *grpc.Server, srv WarehouseServer) {
	s.RegisterService(&_Warehouse_serviceDesc, srv)
}

func _Warehouse_CreateAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateAsset(ctx, req.(*CreateAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateAsset(ctx, req.(*UpdateAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetAsset(ctx, req.(*GetAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteAsset(ctx, req.(*DeleteAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UploadAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UploadAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UploadAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UploadAsset(ctx, req.(*UploadAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GenerateRetrievalUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateRetrievalUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GenerateRetrievalUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GenerateRetrievalUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GenerateRetrievalUrl(ctx, req.(*GenerateRetrievalUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_AnalyzeAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).AnalyzeAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/AnalyzeAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).AnalyzeAsset(ctx, req.(*AnalyzeAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_IndexAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IndexAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).IndexAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/IndexAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).IndexAsset(ctx, req.(*IndexAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_RemoveIndexAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveIndexAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).RemoveIndexAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/RemoveIndexAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).RemoveIndexAsset(ctx, req.(*RemoveIndexAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ViewIndexedAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ViewIndexedAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ViewIndexedAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ViewIndexedAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ViewIndexedAssets(ctx, req.(*ViewIndexedAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateIndex(ctx, req.(*CreateIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateIndex(ctx, req.(*UpdateIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListIndexes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteIndex(ctx, req.(*DeleteIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateCorpus(ctx, req.(*CreateCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetCorpus(ctx, req.(*GetCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateCorpus(ctx, req.(*UpdateCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListCorpora_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCorporaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListCorpora(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListCorpora",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListCorpora(ctx, req.(*ListCorporaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteCorpus(ctx, req.(*DeleteCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_AnalyzeCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).AnalyzeCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/AnalyzeCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).AnalyzeCorpus(ctx, req.(*AnalyzeCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateDataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateDataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateDataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateDataSchema(ctx, req.(*CreateDataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateDataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateDataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateDataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateDataSchema(ctx, req.(*UpdateDataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetDataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetDataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetDataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetDataSchema(ctx, req.(*GetDataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteDataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteDataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteDataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteDataSchema(ctx, req.(*DeleteDataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListDataSchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataSchemasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListDataSchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListDataSchemas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListDataSchemas(ctx, req.(*ListDataSchemasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateAnnotation(ctx, req.(*CreateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetAnnotation(ctx, req.(*GetAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListAnnotations(ctx, req.(*ListAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateAnnotation(ctx, req.(*UpdateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteAnnotation(ctx, req.(*DeleteAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_IngestAsset_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WarehouseServer).IngestAsset(&warehouseIngestAssetServer{stream})
}

type Warehouse_IngestAssetServer interface {
	Send(*IngestAssetResponse) error
	Recv() (*IngestAssetRequest, error)
	grpc.ServerStream
}

type warehouseIngestAssetServer struct {
	grpc.ServerStream
}

func (x *warehouseIngestAssetServer) Send(m *IngestAssetResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *warehouseIngestAssetServer) Recv() (*IngestAssetRequest, error) {
	m := new(IngestAssetRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Warehouse_ClipAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClipAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ClipAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ClipAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ClipAsset(ctx, req.(*ClipAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GenerateHlsUri_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateHlsUriRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GenerateHlsUri(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GenerateHlsUri",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GenerateHlsUri(ctx, req.(*GenerateHlsUriRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ImportAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ImportAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ImportAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ImportAssets(ctx, req.(*ImportAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateSearchConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSearchConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateSearchConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateSearchConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateSearchConfig(ctx, req.(*CreateSearchConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateSearchConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSearchConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateSearchConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateSearchConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateSearchConfig(ctx, req.(*UpdateSearchConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetSearchConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSearchConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetSearchConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetSearchConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetSearchConfig(ctx, req.(*GetSearchConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteSearchConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSearchConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteSearchConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteSearchConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteSearchConfig(ctx, req.(*DeleteSearchConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListSearchConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSearchConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListSearchConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListSearchConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListSearchConfigs(ctx, req.(*ListSearchConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateSearchHypernym_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSearchHypernymRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateSearchHypernym(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateSearchHypernym",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateSearchHypernym(ctx, req.(*CreateSearchHypernymRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateSearchHypernym_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSearchHypernymRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateSearchHypernym(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateSearchHypernym",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateSearchHypernym(ctx, req.(*UpdateSearchHypernymRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetSearchHypernym_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSearchHypernymRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetSearchHypernym(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetSearchHypernym",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetSearchHypernym(ctx, req.(*GetSearchHypernymRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteSearchHypernym_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSearchHypernymRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteSearchHypernym(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteSearchHypernym",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteSearchHypernym(ctx, req.(*DeleteSearchHypernymRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListSearchHypernyms_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSearchHypernymsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListSearchHypernyms(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListSearchHypernyms",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListSearchHypernyms(ctx, req.(*ListSearchHypernymsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_SearchAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).SearchAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/SearchAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).SearchAssets(ctx, req.(*SearchAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_SearchIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).SearchIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/SearchIndexEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).SearchIndexEndpoint(ctx, req.(*SearchIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateIndexEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateIndexEndpoint(ctx, req.(*CreateIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetIndexEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetIndexEndpoint(ctx, req.(*GetIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListIndexEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexEndpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListIndexEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListIndexEndpoints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListIndexEndpoints(ctx, req.(*ListIndexEndpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateIndexEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateIndexEndpoint(ctx, req.(*UpdateIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteIndexEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteIndexEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteIndexEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteIndexEndpoint(ctx, req.(*DeleteIndexEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeployIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeployIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeployIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeployIndex(ctx, req.(*DeployIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UndeployIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UndeployIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UndeployIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UndeployIndex(ctx, req.(*UndeployIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/CreateCollection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateCollection(ctx, req.(*CreateCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/DeleteCollection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteCollection(ctx, req.(*DeleteCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/GetCollection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetCollection(ctx, req.(*GetCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/UpdateCollection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateCollection(ctx, req.(*UpdateCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListCollections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCollectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListCollections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ListCollections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListCollections(ctx, req.(*ListCollectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_AddCollectionItem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddCollectionItemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).AddCollectionItem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/AddCollectionItem",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).AddCollectionItem(ctx, req.(*AddCollectionItemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_RemoveCollectionItem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveCollectionItemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).RemoveCollectionItem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/RemoveCollectionItem",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).RemoveCollectionItem(ctx, req.(*RemoveCollectionItemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ViewCollectionItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ViewCollectionItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ViewCollectionItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.Warehouse/ViewCollectionItems",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ViewCollectionItems(ctx, req.(*ViewCollectionItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Warehouse_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.visionai.v1.Warehouse",
	HandlerType: (*WarehouseServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAsset",
			Handler:    _Warehouse_CreateAsset_Handler,
		},
		{
			MethodName: "UpdateAsset",
			Handler:    _Warehouse_UpdateAsset_Handler,
		},
		{
			MethodName: "GetAsset",
			Handler:    _Warehouse_GetAsset_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _Warehouse_ListAssets_Handler,
		},
		{
			MethodName: "DeleteAsset",
			Handler:    _Warehouse_DeleteAsset_Handler,
		},
		{
			MethodName: "UploadAsset",
			Handler:    _Warehouse_UploadAsset_Handler,
		},
		{
			MethodName: "GenerateRetrievalUrl",
			Handler:    _Warehouse_GenerateRetrievalUrl_Handler,
		},
		{
			MethodName: "AnalyzeAsset",
			Handler:    _Warehouse_AnalyzeAsset_Handler,
		},
		{
			MethodName: "IndexAsset",
			Handler:    _Warehouse_IndexAsset_Handler,
		},
		{
			MethodName: "RemoveIndexAsset",
			Handler:    _Warehouse_RemoveIndexAsset_Handler,
		},
		{
			MethodName: "ViewIndexedAssets",
			Handler:    _Warehouse_ViewIndexedAssets_Handler,
		},
		{
			MethodName: "CreateIndex",
			Handler:    _Warehouse_CreateIndex_Handler,
		},
		{
			MethodName: "UpdateIndex",
			Handler:    _Warehouse_UpdateIndex_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _Warehouse_GetIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _Warehouse_ListIndexes_Handler,
		},
		{
			MethodName: "DeleteIndex",
			Handler:    _Warehouse_DeleteIndex_Handler,
		},
		{
			MethodName: "CreateCorpus",
			Handler:    _Warehouse_CreateCorpus_Handler,
		},
		{
			MethodName: "GetCorpus",
			Handler:    _Warehouse_GetCorpus_Handler,
		},
		{
			MethodName: "UpdateCorpus",
			Handler:    _Warehouse_UpdateCorpus_Handler,
		},
		{
			MethodName: "ListCorpora",
			Handler:    _Warehouse_ListCorpora_Handler,
		},
		{
			MethodName: "DeleteCorpus",
			Handler:    _Warehouse_DeleteCorpus_Handler,
		},
		{
			MethodName: "AnalyzeCorpus",
			Handler:    _Warehouse_AnalyzeCorpus_Handler,
		},
		{
			MethodName: "CreateDataSchema",
			Handler:    _Warehouse_CreateDataSchema_Handler,
		},
		{
			MethodName: "UpdateDataSchema",
			Handler:    _Warehouse_UpdateDataSchema_Handler,
		},
		{
			MethodName: "GetDataSchema",
			Handler:    _Warehouse_GetDataSchema_Handler,
		},
		{
			MethodName: "DeleteDataSchema",
			Handler:    _Warehouse_DeleteDataSchema_Handler,
		},
		{
			MethodName: "ListDataSchemas",
			Handler:    _Warehouse_ListDataSchemas_Handler,
		},
		{
			MethodName: "CreateAnnotation",
			Handler:    _Warehouse_CreateAnnotation_Handler,
		},
		{
			MethodName: "GetAnnotation",
			Handler:    _Warehouse_GetAnnotation_Handler,
		},
		{
			MethodName: "ListAnnotations",
			Handler:    _Warehouse_ListAnnotations_Handler,
		},
		{
			MethodName: "UpdateAnnotation",
			Handler:    _Warehouse_UpdateAnnotation_Handler,
		},
		{
			MethodName: "DeleteAnnotation",
			Handler:    _Warehouse_DeleteAnnotation_Handler,
		},
		{
			MethodName: "ClipAsset",
			Handler:    _Warehouse_ClipAsset_Handler,
		},
		{
			MethodName: "GenerateHlsUri",
			Handler:    _Warehouse_GenerateHlsUri_Handler,
		},
		{
			MethodName: "ImportAssets",
			Handler:    _Warehouse_ImportAssets_Handler,
		},
		{
			MethodName: "CreateSearchConfig",
			Handler:    _Warehouse_CreateSearchConfig_Handler,
		},
		{
			MethodName: "UpdateSearchConfig",
			Handler:    _Warehouse_UpdateSearchConfig_Handler,
		},
		{
			MethodName: "GetSearchConfig",
			Handler:    _Warehouse_GetSearchConfig_Handler,
		},
		{
			MethodName: "DeleteSearchConfig",
			Handler:    _Warehouse_DeleteSearchConfig_Handler,
		},
		{
			MethodName: "ListSearchConfigs",
			Handler:    _Warehouse_ListSearchConfigs_Handler,
		},
		{
			MethodName: "CreateSearchHypernym",
			Handler:    _Warehouse_CreateSearchHypernym_Handler,
		},
		{
			MethodName: "UpdateSearchHypernym",
			Handler:    _Warehouse_UpdateSearchHypernym_Handler,
		},
		{
			MethodName: "GetSearchHypernym",
			Handler:    _Warehouse_GetSearchHypernym_Handler,
		},
		{
			MethodName: "DeleteSearchHypernym",
			Handler:    _Warehouse_DeleteSearchHypernym_Handler,
		},
		{
			MethodName: "ListSearchHypernyms",
			Handler:    _Warehouse_ListSearchHypernyms_Handler,
		},
		{
			MethodName: "SearchAssets",
			Handler:    _Warehouse_SearchAssets_Handler,
		},
		{
			MethodName: "SearchIndexEndpoint",
			Handler:    _Warehouse_SearchIndexEndpoint_Handler,
		},
		{
			MethodName: "CreateIndexEndpoint",
			Handler:    _Warehouse_CreateIndexEndpoint_Handler,
		},
		{
			MethodName: "GetIndexEndpoint",
			Handler:    _Warehouse_GetIndexEndpoint_Handler,
		},
		{
			MethodName: "ListIndexEndpoints",
			Handler:    _Warehouse_ListIndexEndpoints_Handler,
		},
		{
			MethodName: "UpdateIndexEndpoint",
			Handler:    _Warehouse_UpdateIndexEndpoint_Handler,
		},
		{
			MethodName: "DeleteIndexEndpoint",
			Handler:    _Warehouse_DeleteIndexEndpoint_Handler,
		},
		{
			MethodName: "DeployIndex",
			Handler:    _Warehouse_DeployIndex_Handler,
		},
		{
			MethodName: "UndeployIndex",
			Handler:    _Warehouse_UndeployIndex_Handler,
		},
		{
			MethodName: "CreateCollection",
			Handler:    _Warehouse_CreateCollection_Handler,
		},
		{
			MethodName: "DeleteCollection",
			Handler:    _Warehouse_DeleteCollection_Handler,
		},
		{
			MethodName: "GetCollection",
			Handler:    _Warehouse_GetCollection_Handler,
		},
		{
			MethodName: "UpdateCollection",
			Handler:    _Warehouse_UpdateCollection_Handler,
		},
		{
			MethodName: "ListCollections",
			Handler:    _Warehouse_ListCollections_Handler,
		},
		{
			MethodName: "AddCollectionItem",
			Handler:    _Warehouse_AddCollectionItem_Handler,
		},
		{
			MethodName: "RemoveCollectionItem",
			Handler:    _Warehouse_RemoveCollectionItem_Handler,
		},
		{
			MethodName: "ViewCollectionItems",
			Handler:    _Warehouse_ViewCollectionItems_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "IngestAsset",
			Handler:       _Warehouse_IngestAsset_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/visionai/v1/warehouse.proto",
}
