# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import AzureDigitalTwinsAPIConfiguration
from .._utils.serialization import Deserializer, Serializer

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_query_twins_request(
    *,
    traceparent: Optional[str] = None,
    tracestate: Optional[str] = None,
    max_items_per_page: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-31"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/query")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if traceparent is not None:
        _headers["traceparent"] = _SERIALIZER.header("traceparent", traceparent, "str")
    if tracestate is not None:
        _headers["tracestate"] = _SERIALIZER.header("tracestate", tracestate, "str")
    if max_items_per_page is not None:
        _headers["max-items-per-page"] = _SERIALIZER.header("max_items_per_page", max_items_per_page, "int")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class QueryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.digitaltwins.core.AzureDigitalTwinsAPI`'s
        :attr:`query` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AzureDigitalTwinsAPIConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def query_twins(
        self,
        query_specification: _models.QuerySpecification,
        query_twins_options: Optional[_models.QueryTwinsOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.QueryResult:
        """Executes a query that allows traversing relationships and filtering by property values.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * BadRequest - The continuation token is invalid.
          * SqlQueryError - The query contains some errors.
          * TimeoutError - The query execution timed out after 60 seconds. Try simplifying the query or
        adding conditions to reduce the result size.
          * 429 Too Many Requests
          * QuotaReachedError - The maximum query rate limit has been reached.

        :param query_specification: The query specification to execute. Required.
        :type query_specification: ~azure.digitaltwins.core.models.QuerySpecification
        :param query_twins_options: Parameter group. Default value is None.
        :type query_twins_options: ~azure.digitaltwins.core.models.QueryTwinsOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QueryResult or the result of cls(response)
        :rtype: ~azure.digitaltwins.core.models.QueryResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def query_twins(
        self,
        query_specification: IO[bytes],
        query_twins_options: Optional[_models.QueryTwinsOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.QueryResult:
        """Executes a query that allows traversing relationships and filtering by property values.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * BadRequest - The continuation token is invalid.
          * SqlQueryError - The query contains some errors.
          * TimeoutError - The query execution timed out after 60 seconds. Try simplifying the query or
        adding conditions to reduce the result size.
          * 429 Too Many Requests
          * QuotaReachedError - The maximum query rate limit has been reached.

        :param query_specification: The query specification to execute. Required.
        :type query_specification: IO[bytes]
        :param query_twins_options: Parameter group. Default value is None.
        :type query_twins_options: ~azure.digitaltwins.core.models.QueryTwinsOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QueryResult or the result of cls(response)
        :rtype: ~azure.digitaltwins.core.models.QueryResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def query_twins(
        self,
        query_specification: Union[_models.QuerySpecification, IO[bytes]],
        query_twins_options: Optional[_models.QueryTwinsOptions] = None,
        **kwargs: Any
    ) -> _models.QueryResult:
        """Executes a query that allows traversing relationships and filtering by property values.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * BadRequest - The continuation token is invalid.
          * SqlQueryError - The query contains some errors.
          * TimeoutError - The query execution timed out after 60 seconds. Try simplifying the query or
        adding conditions to reduce the result size.
          * 429 Too Many Requests
          * QuotaReachedError - The maximum query rate limit has been reached.

        :param query_specification: The query specification to execute. Is either a QuerySpecification
         type or a IO[bytes] type. Required.
        :type query_specification: ~azure.digitaltwins.core.models.QuerySpecification or IO[bytes]
        :param query_twins_options: Parameter group. Default value is None.
        :type query_twins_options: ~azure.digitaltwins.core.models.QueryTwinsOptions
        :return: QueryResult or the result of cls(response)
        :rtype: ~azure.digitaltwins.core.models.QueryResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.QueryResult] = kwargs.pop("cls", None)

        _traceparent = None
        _tracestate = None
        _max_items_per_page = None
        if query_twins_options is not None:
            _max_items_per_page = query_twins_options.max_items_per_page
            _traceparent = query_twins_options.traceparent
            _tracestate = query_twins_options.tracestate
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(query_specification, (IOBase, bytes)):
            _content = query_specification
        else:
            _json = self._serialize.body(query_specification, "QuerySpecification")

        _request = build_query_twins_request(
            traceparent=_traceparent,
            tracestate=_tracestate,
            max_items_per_page=_max_items_per_page,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["query-charge"] = self._deserialize("float", response.headers.get("query-charge"))

        deserialized = self._deserialize("QueryResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
