"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cff2IVS = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const var_store_1 = require("@ot-builder/var-store");
exports.Cff2IVS = {
    ...(0, bin_util_1.Read)((view, designSpace) => {
        view.uint16(); // IVS length -- not used
        return view.liftRelative(0).next(var_store_1.ReadTimeIVS, designSpace);
    }),
    ...(0, bin_util_1.Write)((frag, ivs, designSpace) => {
        const bContent = bin_util_1.Frag.pack(bin_util_1.Frag.from(var_store_1.WriteTimeIVS, ivs, { designSpace }));
        frag.uint16(bContent.byteLength).bytes(bContent);
    })
};
//# sourceMappingURL=cff2-ivs.js.map