
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_struct_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CommPkgDestroy_pre( HYPRE_Precision precision, HYPRE_CommPkg comm_pkg )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CommPkgDestroy_flt( comm_pkg );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CommPkgDestroy_dbl( comm_pkg );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CommPkgDestroy_long_dbl( comm_pkg );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridAssemble_pre( HYPRE_Precision precision, HYPRE_StructGrid grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridAssemble_flt( grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridAssemble_dbl( grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridAssemble_long_dbl( grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridCoarsen_pre( HYPRE_Precision precision, HYPRE_StructGrid grid, HYPRE_Int *stride, HYPRE_StructGrid *cgrid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridCoarsen_flt( grid, stride, cgrid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridCoarsen_dbl( grid, stride, cgrid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridCoarsen_long_dbl( grid, stride, cgrid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Int ndim, HYPRE_StructGrid *grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridCreate_flt( comm, ndim, grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridCreate_dbl( comm, ndim, grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridCreate_long_dbl( comm, ndim, grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridDestroy_pre( HYPRE_Precision precision, HYPRE_StructGrid grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridDestroy_flt( grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridDestroy_dbl( grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridDestroy_long_dbl( grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridPrintVTK_pre( HYPRE_Precision precision, const char *filename, HYPRE_StructGrid grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridPrintVTK_flt( filename, grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridPrintVTK_dbl( filename, grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridPrintVTK_long_dbl( filename, grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridProjectBox_pre( HYPRE_Precision precision, HYPRE_StructGrid grid, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *origin, HYPRE_Int *stride )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridProjectBox_flt( grid, ilower, iupper, origin, stride );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridProjectBox_dbl( grid, ilower, iupper, origin, stride );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridProjectBox_long_dbl( grid, ilower, iupper, origin, stride );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridSetExtents_pre( HYPRE_Precision precision, HYPRE_StructGrid grid, HYPRE_Int *ilower, HYPRE_Int *iupper )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridSetExtents_flt( grid, ilower, iupper );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridSetExtents_dbl( grid, ilower, iupper );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridSetExtents_long_dbl( grid, ilower, iupper );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridSetNumGhost_pre( HYPRE_Precision precision, HYPRE_StructGrid grid, HYPRE_Int *num_ghost )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridSetNumGhost_flt( grid, num_ghost );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridSetNumGhost_dbl( grid, num_ghost );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridSetNumGhost_long_dbl( grid, num_ghost );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGridSetPeriodic_pre( HYPRE_Precision precision, HYPRE_StructGrid grid, HYPRE_Int *periodic )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGridSetPeriodic_flt( grid, periodic );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGridSetPeriodic_dbl( grid, periodic );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGridSetPeriodic_long_dbl( grid, periodic );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAddToBoxValues_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixAddToBoxValues_flt( matrix, ilower, iupper, nentries, entries, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixAddToBoxValues_dbl( matrix, ilower, iupper, nentries, entries, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixAddToBoxValues_long_dbl( matrix, ilower, iupper, nentries, entries, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAddToBoxValues2_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixAddToBoxValues2_flt( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixAddToBoxValues2_dbl( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixAddToBoxValues2_long_dbl( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAddToConstantValues_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixAddToConstantValues_flt( matrix, nentries, entries, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixAddToConstantValues_dbl( matrix, nentries, entries, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixAddToConstantValues_long_dbl( matrix, nentries, entries, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAddToValues_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *index, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixAddToValues_flt( matrix, index, nentries, entries, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixAddToValues_dbl( matrix, index, nentries, entries, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixAddToValues_long_dbl( matrix, index, nentries, entries, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixAssemble_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixAssemble_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixAssemble_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixAssemble_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixClearBoundary_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixClearBoundary_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixClearBoundary_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixClearBoundary_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructGrid grid, HYPRE_StructStencil stencil, HYPRE_StructMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixCreate_flt( comm, grid, stencil, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixCreate_dbl( comm, grid, stencil, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixCreate_long_dbl( comm, grid, stencil, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixDestroy_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixGetBoxValues_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixGetBoxValues_flt( matrix, ilower, iupper, nentries, entries, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixGetBoxValues_dbl( matrix, ilower, iupper, nentries, entries, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixGetBoxValues_long_dbl( matrix, ilower, iupper, nentries, entries, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixGetBoxValues2_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixGetBoxValues2_flt( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixGetBoxValues2_dbl( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixGetBoxValues2_long_dbl( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixGetGrid_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_StructGrid *grid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixGetGrid_flt( matrix, grid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixGetGrid_dbl( matrix, grid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixGetGrid_long_dbl( matrix, grid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixGetValues_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *index, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixGetValues_flt( matrix, index, nentries, entries, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixGetValues_dbl( matrix, index, nentries, entries, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixGetValues_long_dbl( matrix, index, nentries, entries, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixInitialize_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixInitialize_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixInitialize_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixInitialize_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixMatmat_pre( HYPRE_Precision precision, HYPRE_StructMatrix A, HYPRE_Int Atranspose, HYPRE_StructMatrix B, HYPRE_Int Btranspose, HYPRE_StructMatrix *C )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixMatmat_flt( A, Atranspose, B, Btranspose, C );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixMatmat_dbl( A, Atranspose, B, Btranspose, C );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixMatmat_long_dbl( A, Atranspose, B, Btranspose, C );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixMatvec_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_StructMatrix A, HYPRE_StructVector x, hypre_long_double beta, HYPRE_StructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixMatvec_flt( (hypre_float)alpha, A, x, (hypre_float)beta, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixMatvec_dbl( (hypre_double)alpha, A, x, (hypre_double)beta, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixMatvec_long_dbl( (hypre_long_double)alpha, A, x, (hypre_long_double)beta, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixMatvecT_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_StructMatrix A, HYPRE_StructVector x, hypre_long_double beta, HYPRE_StructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixMatvecT_flt( (hypre_float)alpha, A, x, (hypre_float)beta, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixMatvecT_dbl( (hypre_double)alpha, A, x, (hypre_double)beta, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixMatvecT_long_dbl( (hypre_long_double)alpha, A, x, (hypre_long_double)beta, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixPrint_pre( HYPRE_Precision precision, const char *filename, HYPRE_StructMatrix matrix, HYPRE_Int all )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixPrint_flt( filename, matrix, all );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixPrint_dbl( filename, matrix, all );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixPrint_long_dbl( filename, matrix, all );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixRead_pre( HYPRE_Precision precision, MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost, HYPRE_StructMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixRead_flt( comm, filename, num_ghost, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixRead_dbl( comm, filename, num_ghost, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixRead_long_dbl( comm, filename, num_ghost, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetBoxValues_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetBoxValues_flt( matrix, ilower, iupper, nentries, entries, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetBoxValues_dbl( matrix, ilower, iupper, nentries, entries, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetBoxValues_long_dbl( matrix, ilower, iupper, nentries, entries, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetBoxValues2_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetBoxValues2_flt( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetBoxValues2_dbl( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetBoxValues2_long_dbl( matrix, ilower, iupper, nentries, entries, vilower, viupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetConstantEntries_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int nentries, HYPRE_Int *entries )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetConstantEntries_flt( matrix, nentries, entries );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetConstantEntries_dbl( matrix, nentries, entries );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetConstantEntries_long_dbl( matrix, nentries, entries );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetConstantValues_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetConstantValues_flt( matrix, nentries, entries, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetConstantValues_dbl( matrix, nentries, entries, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetConstantValues_long_dbl( matrix, nentries, entries, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetDomainStride_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *domain_stride )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetDomainStride_flt( matrix, domain_stride );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetDomainStride_dbl( matrix, domain_stride );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetDomainStride_long_dbl( matrix, domain_stride );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetNumGhost_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *num_ghost )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetNumGhost_flt( matrix, num_ghost );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetNumGhost_dbl( matrix, num_ghost );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetNumGhost_long_dbl( matrix, num_ghost );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetRangeStride_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *range_stride )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetRangeStride_flt( matrix, range_stride );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetRangeStride_dbl( matrix, range_stride );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetRangeStride_long_dbl( matrix, range_stride );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetSymmetric_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int symmetric )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetSymmetric_flt( matrix, symmetric );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetSymmetric_dbl( matrix, symmetric );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetSymmetric_long_dbl( matrix, symmetric );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetTranspose_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int transpose )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetTranspose_flt( matrix, transpose );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetTranspose_dbl( matrix, transpose );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetTranspose_long_dbl( matrix, transpose );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructMatrixSetValues_pre( HYPRE_Precision precision, HYPRE_StructMatrix matrix, HYPRE_Int *index, HYPRE_Int nentries, HYPRE_Int *entries, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructMatrixSetValues_flt( matrix, index, nentries, entries, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructMatrixSetValues_dbl( matrix, index, nentries, entries, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructMatrixSetValues_long_dbl( matrix, index, nentries, entries, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructStencilCreate_pre( HYPRE_Precision precision, HYPRE_Int ndim, HYPRE_Int size, HYPRE_StructStencil *stencil )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructStencilCreate_flt( ndim, size, stencil );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructStencilCreate_dbl( ndim, size, stencil );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructStencilCreate_long_dbl( ndim, size, stencil );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructStencilDestroy_pre( HYPRE_Precision precision, HYPRE_StructStencil stencil )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructStencilDestroy_flt( stencil );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructStencilDestroy_dbl( stencil );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructStencilDestroy_long_dbl( stencil );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructStencilSetElement_pre( HYPRE_Precision precision, HYPRE_StructStencil stencil, HYPRE_Int entry, HYPRE_Int *offset )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructStencilSetElement_flt( stencil, entry, offset );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructStencilSetElement_dbl( stencil, entry, offset );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructStencilSetElement_long_dbl( stencil, entry, offset );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructStencilSetEntry_pre( HYPRE_Precision precision, HYPRE_StructStencil stencil, HYPRE_Int entry, HYPRE_Int *offset )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructStencilSetEntry_flt( stencil, entry, offset );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructStencilSetEntry_dbl( stencil, entry, offset );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructStencilSetEntry_long_dbl( stencil, entry, offset );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAddToBoxValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorAddToBoxValues_flt( vector, ilower, iupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorAddToBoxValues_dbl( vector, ilower, iupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorAddToBoxValues_long_dbl( vector, ilower, iupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAddToBoxValues2_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorAddToBoxValues2_flt( vector, ilower, iupper, vilower, viupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorAddToBoxValues2_dbl( vector, ilower, iupper, vilower, viupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorAddToBoxValues2_long_dbl( vector, ilower, iupper, vilower, viupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAddToValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *index, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorAddToValues_flt( vector, index, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorAddToValues_dbl( vector, index, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorAddToValues_long_dbl( vector, index, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAssemble_pre( HYPRE_Precision precision, HYPRE_StructVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorAssemble_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorAssemble_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorAssemble_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorAxpy_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_StructVector x, hypre_long_double beta, HYPRE_StructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorAxpy_flt( (hypre_float)alpha, x, (hypre_float)beta, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorAxpy_dbl( (hypre_double)alpha, x, (hypre_double)beta, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorAxpy_long_dbl( (hypre_long_double)alpha, x, (hypre_long_double)beta, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorClone_pre( HYPRE_Precision precision, HYPRE_StructVector x, HYPRE_StructVector *y_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorClone_flt( x, y_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorClone_dbl( x, y_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorClone_long_dbl( x, y_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorCopy_pre( HYPRE_Precision precision, HYPRE_StructVector x, HYPRE_StructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorCopy_flt( x, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorCopy_dbl( x, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorCopy_long_dbl( x, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructGrid grid, HYPRE_StructVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorCreate_flt( comm, grid, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorCreate_dbl( comm, grid, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorCreate_long_dbl( comm, grid, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorDestroy_pre( HYPRE_Precision precision, HYPRE_StructVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorDestroy_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorDestroy_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorDestroy_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorGetBoxValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorGetBoxValues_flt( vector, ilower, iupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorGetBoxValues_dbl( vector, ilower, iupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorGetBoxValues_long_dbl( vector, ilower, iupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorGetBoxValues2_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorGetBoxValues2_flt( vector, ilower, iupper, vilower, viupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorGetBoxValues2_dbl( vector, ilower, iupper, vilower, viupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorGetBoxValues2_long_dbl( vector, ilower, iupper, vilower, viupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorGetMigrateCommPkg_pre( HYPRE_Precision precision, HYPRE_StructVector from_vector, HYPRE_StructVector to_vector, HYPRE_CommPkg *comm_pkg )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorGetMigrateCommPkg_flt( from_vector, to_vector, comm_pkg );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorGetMigrateCommPkg_dbl( from_vector, to_vector, comm_pkg );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorGetMigrateCommPkg_long_dbl( from_vector, to_vector, comm_pkg );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorGetValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *index, void *value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorGetValues_flt( vector, index, (hypre_float *)value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorGetValues_dbl( vector, index, (hypre_double *)value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorGetValues_long_dbl( vector, index, (hypre_long_double *)value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorInitialize_pre( HYPRE_Precision precision, HYPRE_StructVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorInitialize_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorInitialize_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorInitialize_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorInnerProd_pre( HYPRE_Precision precision, HYPRE_StructVector x, HYPRE_StructVector y, void *result )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorInnerProd_flt( x, y, (hypre_float *)result );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorInnerProd_dbl( x, y, (hypre_double *)result );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorInnerProd_long_dbl( x, y, (hypre_long_double *)result );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorMigrate_pre( HYPRE_Precision precision, HYPRE_CommPkg comm_pkg, HYPRE_StructVector from_vector, HYPRE_StructVector to_vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorMigrate_flt( comm_pkg, from_vector, to_vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorMigrate_dbl( comm_pkg, from_vector, to_vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorMigrate_long_dbl( comm_pkg, from_vector, to_vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorPrint_pre( HYPRE_Precision precision, const char *filename, HYPRE_StructVector vector, HYPRE_Int all )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorPrint_flt( filename, vector, all );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorPrint_dbl( filename, vector, all );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorPrint_long_dbl( filename, vector, all );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorRead_pre( HYPRE_Precision precision, MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost, HYPRE_StructVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorRead_flt( comm, filename, num_ghost, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorRead_dbl( comm, filename, num_ghost, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorRead_long_dbl( comm, filename, num_ghost, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorScale_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_StructVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorScale_flt( (hypre_float)alpha, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorScale_dbl( (hypre_double)alpha, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorScale_long_dbl( (hypre_long_double)alpha, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorScaleValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, hypre_long_double factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorScaleValues_flt( vector, (hypre_float)factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorScaleValues_dbl( vector, (hypre_double)factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorScaleValues_long_dbl( vector, (hypre_long_double)factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetBoxValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorSetBoxValues_flt( vector, ilower, iupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorSetBoxValues_dbl( vector, ilower, iupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorSetBoxValues_long_dbl( vector, ilower, iupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetBoxValues2_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *ilower, HYPRE_Int *iupper, HYPRE_Int *vilower, HYPRE_Int *viupper, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorSetBoxValues2_flt( vector, ilower, iupper, vilower, viupper, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorSetBoxValues2_dbl( vector, ilower, iupper, vilower, viupper, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorSetBoxValues2_long_dbl( vector, ilower, iupper, vilower, viupper, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetConstantValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, hypre_long_double value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorSetConstantValues_flt( vector, (hypre_float)value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorSetConstantValues_dbl( vector, (hypre_double)value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorSetConstantValues_long_dbl( vector, (hypre_long_double)value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetNumGhost_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *num_ghost )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorSetNumGhost_flt( vector, num_ghost );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorSetNumGhost_dbl( vector, num_ghost );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorSetNumGhost_long_dbl( vector, num_ghost );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetRandomValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int seed )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorSetRandomValues_flt( vector, seed );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorSetRandomValues_dbl( vector, seed );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorSetRandomValues_long_dbl( vector, seed );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetStride_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *stride )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorSetStride_flt( vector, stride );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorSetStride_dbl( vector, stride );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorSetStride_long_dbl( vector, stride );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructVectorSetValues_pre( HYPRE_Precision precision, HYPRE_StructVector vector, HYPRE_Int *index, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructVectorSetValues_flt( vector, index, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructVectorSetValues_dbl( vector, index, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructVectorSetValues_long_dbl( vector, index, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

