/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#pragma once

// property ids

enum PropertyId
{
    PROPERTY_ID_URL                        = 2,
    PROPERTY_ID_INFO                       = 4,
    PROPERTY_ID_ISPASSWORDREQUIRED         = 5,
    PROPERTY_ID_TABLEFILTER                = 6,
    PROPERTY_ID_NAME                       = 7,
    PROPERTY_ID_SCHEMANAME                 = 8,
    PROPERTY_ID_CATALOGNAME                = 9,
    PROPERTY_ID_PRIVILEGES                 = 10,
    PROPERTY_ID_ESCAPE_PROCESSING          = 11,
    PROPERTY_ID_COMMAND                    = 12,
    PROPERTY_ID_TYPE                       = 13,
    PROPERTY_ID_TYPENAME                   = 14,
    PROPERTY_ID_PRECISION                  = 15,
    PROPERTY_ID_SCALE                      = 16,
    PROPERTY_ID_ISNULLABLE                 = 17,
    PROPERTY_ID_ISAUTOINCREMENT            = 18,
    PROPERTY_ID_ISROWVERSION               = 19,
    PROPERTY_ID_DESCRIPTION                = 20,
    PROPERTY_ID_DEFAULTVALUE               = 21,
    PROPERTY_ID_NUMBERFORMAT               = 22,
    PROPERTY_ID_QUERYTIMEOUT               = 23,
    PROPERTY_ID_MAXFIELDSIZE               = 24,
    PROPERTY_ID_MAXROWS                    = 25,
    PROPERTY_ID_CURSORNAME                 = 26,
    PROPERTY_ID_RESULTSETCONCURRENCY       = 27,
    PROPERTY_ID_RESULTSETTYPE              = 28,
    PROPERTY_ID_FETCHDIRECTION             = 29,
    PROPERTY_ID_FETCHSIZE                  = 30,
    PROPERTY_ID_USEBOOKMARKS               = 31,
    PROPERTY_ID_ISSEARCHABLE               = 32,
    PROPERTY_ID_ISCURRENCY                 = 33,
    PROPERTY_ID_ISSIGNED                   = 34,
    PROPERTY_ID_DISPLAYSIZE                = 35,
    PROPERTY_ID_LABEL                      = 36,
    PROPERTY_ID_ISREADONLY                 = 37,
    PROPERTY_ID_ISWRITABLE                 = 38,
    PROPERTY_ID_ISDEFINITELYWRITABLE       = 39,
    PROPERTY_ID_VALUE                      = 40,
    PROPERTY_ID_TABLENAME                  = 41,
    PROPERTY_ID_ISCASESENSITIVE            = 42,
    PROPERTY_ID_SERVICENAME                = 43,
    PROPERTY_ID_ISBOOKMARKABLE             = 44,
    PROPERTY_ID_CANUPDATEINSERTEDROWS      = 45,
    PROPERTY_ID_NUMBERFORMATSSUPPLIER      = 48,
    PROPERTY_ID_DATASOURCENAME             = 50,
    PROPERTY_ID_TRANSACTIONISOLATION       = 51,
    PROPERTY_ID_TYPEMAP                    = 52,
    PROPERTY_ID_USER                       = 53,
    PROPERTY_ID_PASSWORD                   = 54,
    PROPERTY_ID_COMMAND_TYPE               = 55,
    PROPERTY_ID_ACTIVECOMMAND              = 56,
    PROPERTY_ID_ACTIVE_CONNECTION          = 57,
    PROPERTY_ID_FILTER                     = 58,
    PROPERTY_ID_APPLYFILTER                = 59,
    PROPERTY_ID_ORDER                      = 60,
    PROPERTY_ID_ISMODIFIED                 = 61,
    PROPERTY_ID_ISNEW                      = 62,
    PROPERTY_ID_ROWCOUNT                   = 63,
    PROPERTY_ID_ISROWCOUNTFINAL            = 64,
    PROPERTY_ID_REALNAME                   = 66,
    PROPERTY_ID_HIDDEN                     = 67,
    PROPERTY_ID_ALIGN                      = 68,
    PROPERTY_ID_WIDTH                      = 69,
    PROPERTY_ID_TABLETYPEFILTER            = 70,
    PROPERTY_ID_DATABASE_LOCATION          = 71,
    PROPERTY_ID_FONT                       = 72,
    PROPERTY_ID_ROW_HEIGHT                 = 73,
    PROPERTY_ID_TEXTCOLOR                  = 74,
    PROPERTY_ID_UPDATE_TABLENAME           = 75,
    PROPERTY_ID_UPDATE_SCHEMANAME          = 76,
    PROPERTY_ID_UPDATE_CATALOGNAME         = 77,
    PROPERTY_ID_CONTROLMODEL               = 78,
    PROPERTY_ID_RELATIVEPOSITION           = 79,
    PROPERTY_ID_ISASCENDING                = 80,
    PROPERTY_ID_RELATEDCOLUMN              = 81,
    PROPERTY_ID_ISUNIQUE                   = 82,
    PROPERTY_ID_ISPRIMARYKEYINDEX          = 83,
    PROPERTY_ID_IGNORERESULT               = 84,
    PROPERTY_ID_DELETERULE                 = 85,
    PROPERTY_ID_UPDATERULE                 = 86,
    PROPERTY_ID_REFERENCEDTABLE            = 87,
    PROPERTY_ID_SQLEXCEPTION               = 90,
    PROPERTY_ID_SUPPRESSVERSIONCL          = 92,
    PROPERTY_ID_LAYOUTINFORMATION          = 93,
    PROPERTY_ID_TEXTLINECOLOR              = 94,
    PROPERTY_ID_TEXTEMPHASIS               = 95,
    PROPERTY_ID_TEXTRELIEF                 = 96,
    PROPERTY_ID_HELPTEXT                   = 97,
    PROPERTY_ID_CONTROLDEFAULT             = 98,
    PROPERTY_ID_AUTOINCREMENTCREATION      = 99,
    PROPERTY_ID_FONTCHARWIDTH              = 101,
    PROPERTY_ID_FONTCHARSET                = 102,
    PROPERTY_ID_FONTFAMILY                 = 103,
    PROPERTY_ID_FONTHEIGHT                 = 104,
    PROPERTY_ID_FONTKERNING                = 105,
    PROPERTY_ID_FONTNAME                   = 106,
    PROPERTY_ID_FONTORIENTATION            = 107,
    PROPERTY_ID_FONTPITCH                  = 108,
    PROPERTY_ID_FONTSLANT                  = 109,
    PROPERTY_ID_FONTSTRIKEOUT              = 110,
    PROPERTY_ID_FONTSTYLENAME              = 111,
    PROPERTY_ID_FONTUNDERLINE              = 112,
    PROPERTY_ID_FONTWEIGHT                 = 113,
    PROPERTY_ID_FONTWIDTH                  = 114,
    PROPERTY_ID_FONTWORDLINEMODE           = 115,
    PROPERTY_ID_FONTTYPE                   = 116,
    PROPERTY_ID_PERSISTENT_NAME            = 117,
    PROPERTY_ID_ORIGINAL                   = 118,
    PROPERTY_ID_TABSTOP                    = 119,
    PROPERTY_ID_DEFAULTCONTROL             = 120,
    PROPERTY_ID_ENABLED                    = 121,
    PROPERTY_ID_BORDER                     = 122,
    PROPERTY_ID_COLUMN                     = 123,
    PROPERTY_ID_AS_TEMPLATE                = 124,
    PROPERTY_ID_IS_FORM                    = 125,
    PROPERTY_ID_HAVING_CLAUSE              = 126,
    PROPERTY_ID_GROUP_BY                   = 127,
    PROPERTY_ID_EDIT_WIDTH                 = 128,
    PROPERTY_ID_SETTINGS                   = 129,
    PROPERTY_ID_CONNECTION_RESOURCE        = 130,
    PROPERTY_ID_RESULT_SET                 = 131,
    PROPERTY_ID_SELECTION                  = 132,
    PROPERTY_ID_BOOKMARK_SELECTION         = 133,
    PROPERTY_ID_COLUMN_NAME                = 134,
    PROPERTY_ID_CONNECTION_INFO            = 135,
    PROPERTY_ID_HEADER_LINE                = 136,
    PROPERTY_ID_FIELD_DELIMITER            = 137,
    PROPERTY_ID_STRING_DELIMITER           = 138,
    PROPERTY_ID_DECIMAL_DELIMITER          = 139,
    PROPERTY_ID_THOUSAND_DELIMITER         = 140,
    PROPERTY_ID_ENCODING                   = 141,
    PROPERTY_ID_HELP_URL                   = 142,
    PROPERTY_ID_PERSISTENT_PATH            = 143,
    PROPERTY_ID_CURRENT_QUERY_DESIGN       = 144,
    PROPERTY_ID_SINGLESELECTQUERYCOMPOSER  = 145,
    PROPERTY_ID_PROPCHANGE_NOTIFY          = 146,
    PROPERTY_ID_AUTOGROW                   = 147
};

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
