% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{border}
\alias{border}
\title{Set cell borders}
\usage{
border(
  x,
  i = NULL,
  j = NULL,
  border = NULL,
  border.top = NULL,
  border.bottom = NULL,
  border.left = NULL,
  border.right = NULL,
  part = "body"
)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{border}{border (shortcut for top, bottom, left and right)}

\item{border.top}{border top}

\item{border.bottom}{border bottom}

\item{border.left}{border left}

\item{border.right}{border right}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
change borders of selected rows and columns of a flextable.
This function is \strong{not to be used by end user} (it requires careful
settings to avoid overlapping borders) but only for programming purposes.

If you need to add borders, use instead other functions:

These set borders for the whole table : \code{\link[=border_outer]{border_outer()}},
\code{\link[=border_inner_h]{border_inner_h()}} and \code{\link[=border_inner_v]{border_inner_v()}}.

To add horizontal or vertical lines in the table at specific location,
use:
\itemize{
\item \code{\link[=hline]{hline()}}: set bottom borders (inner horizontal)
\item \code{\link[=vline]{vline()}}: set right borders (inner vertical)
}

To add following horizontal or vertical lines at
beginning or end of the table, use:
\itemize{
\item \code{\link[=hline_top]{hline_top()}}: set the top border (outer horizontal)
\item \code{\link[=hline_bottom]{hline_bottom()}}: set the bottom border (outer horizontal)
\item \code{\link[=vline_left]{vline_left()}}: set the left border (outer vertical)
\item \code{\link[=vline_right]{vline_right()}}: set the right border (outer vertical)
}

If you want to highlight specific cells with some borders, use
\code{\link[=surround]{surround()}}.
}
\note{
pdf and pptx outputs do not support \code{border()} usage.
}
\examples{
library(officer)
ftab <- flextable(head(mtcars))
ftab <- border(ftab, border.top = fp_border(color = "orange"))
ftab
}
\keyword{internal}
