#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Blackwell series:
# - Blackwell 1
# - Blackwell 2
# - Blackwell 3
# - Blackwell 4
# - Blackwell 5
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250722.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID_BLACKWELL1='blackwell-1'
GAME_NAME_BLACKWELL1='Blackwell 1: The Blackwell Legacy'

GAME_ID_BLACKWELL2='blackwell-2'
GAME_NAME_BLACKWELL2='Blackwell 2: Blackwell Unbound'

GAME_ID_BLACKWELL3='blackwell-3'
GAME_NAME_BLACKWELL3='Blackwell 3: The Blackwell Convergence'

GAME_ID_BLACKWELL4='blackwell-4'
GAME_NAME_BLACKWELL4='Blackwell 4: The Blackwell Deception'

GAME_ID_BLACKWELL5='blackwell-5'
GAME_NAME_BLACKWELL5='Blackwell 5: The Blackwell Epiphany'

# Game archives

## Blackwell 1

ARCHIVE_BASE_BLACKWELL1_9_NAME='blackwell_legacy_4_0c_83072.sh'
ARCHIVE_BASE_BLACKWELL1_9_MD5='49e613195092d1b0ec88dcb3caf67a90'
ARCHIVE_BASE_BLACKWELL1_9_SIZE='317377'
ARCHIVE_BASE_BLACKWELL1_9_VERSION='4.0c-gog83072'
ARCHIVE_BASE_BLACKWELL1_9_URL='https://www.gog.com/game/blackwell_bundle'

ARCHIVE_BASE_BLACKWELL1_8_NAME='blackwell_legacy_4_0b_81238.sh'
ARCHIVE_BASE_BLACKWELL1_8_MD5='03b3da181b08c148781d422165fbeaf4'
ARCHIVE_BASE_BLACKWELL1_8_SIZE='317376'
ARCHIVE_BASE_BLACKWELL1_8_VERSION='4.0b-gog81238'

ARCHIVE_BASE_BLACKWELL1_7_NAME='blackwell_legacy_4_0_79895.sh'
ARCHIVE_BASE_BLACKWELL1_7_MD5='3606c861a4d62a55f8a451a9d07e3b1b'
ARCHIVE_BASE_BLACKWELL1_7_SIZE='312096'
ARCHIVE_BASE_BLACKWELL1_7_VERSION='4.0-gog79895'

ARCHIVE_BASE_BLACKWELL1_6_NAME='blackwell_legacy_3_7_76434.sh'
ARCHIVE_BASE_BLACKWELL1_6_MD5='2cfc73a83548212940a995ab4b01dd50'
ARCHIVE_BASE_BLACKWELL1_6_SIZE='312095'
ARCHIVE_BASE_BLACKWELL1_6_VERSION='3.7-gog76434'

ARCHIVE_BASE_BLACKWELL1_5_NAME='blackwell_legacy_3_5_71786.sh'
ARCHIVE_BASE_BLACKWELL1_5_MD5='3b1b569ec92ff53a8ad243627a13c6a2'
ARCHIVE_BASE_BLACKWELL1_5_SIZE='312061'
ARCHIVE_BASE_BLACKWELL1_5_VERSION='3.5-gog71786'

ARCHIVE_BASE_BLACKWELL1_4_NAME='blackwell_legacy_3_1_67142.sh'
ARCHIVE_BASE_BLACKWELL1_4_MD5='840ad19ae85cbfdcbc431e8333767f0d'
ARCHIVE_BASE_BLACKWELL1_4_SIZE='312516'
ARCHIVE_BASE_BLACKWELL1_4_VERSION='3.1-gog67142'

ARCHIVE_BASE_BLACKWELL1_3_NAME='blackwell_legacy_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL1_3_MD5='f21fa6de53dc115ccfb769ffe3ef9e70'
ARCHIVE_BASE_BLACKWELL1_3_SIZE='320000'
ARCHIVE_BASE_BLACKWELL1_3_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL1_2_NAME='blackwell_legacy_2_4a_55329.sh'
ARCHIVE_BASE_BLACKWELL1_2_MD5='4ac2a52315daa0ccde214adf68dadfc9'
ARCHIVE_BASE_BLACKWELL1_2_SIZE='320000'
ARCHIVE_BASE_BLACKWELL1_2_VERSION='2.4a-gog55329'

ARCHIVE_BASE_BLACKWELL1_1_NAME='blackwell_legacy_2_2_3_53579.sh'
ARCHIVE_BASE_BLACKWELL1_1_MD5='1649b8c1c430dd24b0bbe89f7ccb541b'
ARCHIVE_BASE_BLACKWELL1_1_SIZE='320000'
ARCHIVE_BASE_BLACKWELL1_1_VERSION='2.2.3-gog53579'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME_BLACKWELL1='blackwell-1_icons.tar.xz'
ARCHIVE_OPTIONAL_ICONS_MD5_BLACKWELL1='3352b2267c9200b1c06d21c5d65ddef8'
ARCHIVE_OPTIONAL_ICONS_URL_BLACKWELL1='https://downloads.dotslashplay.it/games/blackwell/'
CONTENT_ICONS_PATH_BLACKWELL1='.'
CONTENT_ICONS_FILES_BLACKWELL1='
16x16
24x24
32x32
48x48
256x256'

## Blackwell 2

ARCHIVE_BASE_BLACKWELL2_8_NAME='blackwell_unbound_4_4a_81600.sh'
ARCHIVE_BASE_BLACKWELL2_8_MD5='eedcfdacbd2b2a659d46bc4f4eca463b'
ARCHIVE_BASE_BLACKWELL2_8_SIZE='268420'
ARCHIVE_BASE_BLACKWELL2_8_VERSION='4.4a-gog81600'
ARCHIVE_BASE_BLACKWELL2_8_URL='https://www.gog.com/game/blackwell_bundle'

ARCHIVE_BASE_BLACKWELL2_7_NAME='blackwell_unbound_4_3_80449.sh'
ARCHIVE_BASE_BLACKWELL2_7_MD5='239baa7241c168919308e1b1cd6d1cd9'
ARCHIVE_BASE_BLACKWELL2_7_SIZE='263139'
ARCHIVE_BASE_BLACKWELL2_7_VERSION='4.3-gog80449'

ARCHIVE_BASE_BLACKWELL2_6_NAME='blackwell_unbound_4_2_80305.sh'
ARCHIVE_BASE_BLACKWELL2_6_MD5='70f444e9b31bb77452f7978d087336cb'
ARCHIVE_BASE_BLACKWELL2_6_SIZE='263130'
ARCHIVE_BASE_BLACKWELL2_6_VERSION='4.2-gog80305'

ARCHIVE_BASE_BLACKWELL2_5_NAME='blackwell_unbound_3_1a_71097.sh'
ARCHIVE_BASE_BLACKWELL2_5_MD5='9bcabf910cf4f719ecb2f4d8a8d033ad'
ARCHIVE_BASE_BLACKWELL2_5_SIZE='263113'
ARCHIVE_BASE_BLACKWELL2_5_VERSION='3.1a-gog71097'

ARCHIVE_BASE_BLACKWELL2_4_NAME='blackwell_unbound_3_0_67142.sh'
ARCHIVE_BASE_BLACKWELL2_4_MD5='8336d9714956fbe4b2a872afdabca960'
ARCHIVE_BASE_BLACKWELL2_4_SIZE='263568'
ARCHIVE_BASE_BLACKWELL2_4_VERSION='3.0-gog67142'

ARCHIVE_BASE_BLACKWELL2_3_NAME='blackwell_unbound_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL2_3_MD5='efcc0c8bb1643ca653b72a3675534dee'
ARCHIVE_BASE_BLACKWELL2_3_SIZE='270000'
ARCHIVE_BASE_BLACKWELL2_3_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL2_2_NAME='blackwell_unbound_2_4_57370.sh'
ARCHIVE_BASE_BLACKWELL2_2_MD5='3eaef9e29721384d1aec74fe0901f195'
ARCHIVE_BASE_BLACKWELL2_2_SIZE='260000'
ARCHIVE_BASE_BLACKWELL2_2_VERSION='2.4-gog57370'

ARCHIVE_BASE_BLACKWELL2_1_NAME='blackwell_unbound_2_2_2_1_53176.sh'
ARCHIVE_BASE_BLACKWELL2_1_MD5='026d7f9171819be7bd4d4bfe3b9e9f6e'
ARCHIVE_BASE_BLACKWELL2_1_SIZE='260000'
ARCHIVE_BASE_BLACKWELL2_1_VERSION='2.2.2.1-gog53176'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME_BLACKWELL2='blackwell-2_icons.tar.xz'
ARCHIVE_OPTIONAL_ICONS_MD5_BLACKWELL2='e7bef09076eaf830effc44d7fe6b8a9e'
ARCHIVE_OPTIONAL_ICONS_URL_BLACKWELL2='https://downloads.dotslashplay.it/games/blackwell/'
CONTENT_ICONS_PATH_BLACKWELL2='.'
CONTENT_ICONS_FILES_BLACKWELL2='
16x16
24x24
32x32
48x48
256x256'

## Blackwell 3

ARCHIVE_BASE_BLACKWELL3_5_NAME='blackwell_convergence_3_1c_81238.sh'
ARCHIVE_BASE_BLACKWELL3_5_MD5='61d6ec1f808ccbae6e81e1bad5731a93'
ARCHIVE_BASE_BLACKWELL3_5_SIZE='330405'
ARCHIVE_BASE_BLACKWELL3_5_VERSION='3.1c-gog81238'
ARCHIVE_BASE_BLACKWELL3_5_URL='https://www.gog.com/game/blackwell_bundle'

ARCHIVE_BASE_BLACKWELL3_4_NAME='blackwell_convergence_3_1a_71097.sh'
ARCHIVE_BASE_BLACKWELL3_4_MD5='1ca9574462053e33555da972f02accbc'
ARCHIVE_BASE_BLACKWELL3_4_SIZE='325125'
ARCHIVE_BASE_BLACKWELL3_4_VERSION='3.1a-gog71097'

ARCHIVE_BASE_BLACKWELL3_3_NAME='blackwell_convergence_3_0_67142.sh'
ARCHIVE_BASE_BLACKWELL3_3_MD5='a0e8f8eb25df6e3aab086424c4e5c8e7'
ARCHIVE_BASE_BLACKWELL3_3_SIZE='325592'
ARCHIVE_BASE_BLACKWELL3_3_VERSION='3.0-gog67142'

ARCHIVE_BASE_BLACKWELL3_2_NAME='blackwell_convergence_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL3_2_MD5='2c074d610175629e72e1f7e4970e9342'
ARCHIVE_BASE_BLACKWELL3_2_SIZE='330000'
ARCHIVE_BASE_BLACKWELL3_2_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL3_1_NAME='blackwell_convergence_2_2_2_53176.sh'
ARCHIVE_BASE_BLACKWELL3_1_MD5='e0e6b8c425c35804f47aa0ffe41ff98d'
ARCHIVE_BASE_BLACKWELL3_1_SIZE='380000'
ARCHIVE_BASE_BLACKWELL3_1_VERSION='2.2.2-gog53176'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME_BLACKWELL3='blackwell-3_icons.tar.xz'
ARCHIVE_OPTIONAL_ICONS_MD5_BLACKWELL3='49cb2320d1a32788399493dd42e3d607'
ARCHIVE_OPTIONAL_ICONS_URL_BLACKWELL3='https://downloads.dotslashplay.it/games/blackwell/'
CONTENT_ICONS_PATH_BLACKWELL3='.'
CONTENT_ICONS_FILES_BLACKWELL3='
32x32
64x64
256x256'

## Blackwell 4

ARCHIVE_BASE_BLACKWELL4_8_NAME='blackwell_deception_3_5_82978.sh'
ARCHIVE_BASE_BLACKWELL4_8_MD5='f6a7bb4f86a9cd9dd789e3b94ce3192c'
ARCHIVE_BASE_BLACKWELL4_8_SIZE='590765'
ARCHIVE_BASE_BLACKWELL4_8_VERSION='3.5-gog82978'
ARCHIVE_BASE_BLACKWELL4_8_URL='https://www.gog.com/game/blackwell_bundle'

ARCHIVE_BASE_BLACKWELL4_7_NAME='blackwell_deception_3_3d_82942.sh'
ARCHIVE_BASE_BLACKWELL4_7_MD5='ba5f8461ef4206863391fabad12d6fb9'
ARCHIVE_BASE_BLACKWELL4_7_SIZE='590764'
ARCHIVE_BASE_BLACKWELL4_7_VERSION='3.3d-gog82942'

ARCHIVE_BASE_BLACKWELL4_6_NAME='blackwell_deception_3_3_76159.sh'
ARCHIVE_BASE_BLACKWELL4_6_MD5='a65df9a5e03d9c656c5fda6075e698a5'
ARCHIVE_BASE_BLACKWELL4_6_SIZE='585481'
ARCHIVE_BASE_BLACKWELL4_6_VERSION='3.3-gog76159'

ARCHIVE_BASE_BLACKWELL4_4_NAME='blackwell_deception_3_2_72383.sh'
ARCHIVE_BASE_BLACKWELL4_4_MD5='65531d5078cefc73589ddefcb4e10672'
ARCHIVE_BASE_BLACKWELL4_4_SIZE='585481'
ARCHIVE_BASE_BLACKWELL4_4_VERSION='3.2-gog72383'

ARCHIVE_BASE_BLACKWELL4_3_NAME='blackwell_deception_3_0_67142.sh'
ARCHIVE_BASE_BLACKWELL4_3_MD5='c4823fb1410fd412b6262323d9b05a19'
ARCHIVE_BASE_BLACKWELL4_3_SIZE='585944'
ARCHIVE_BASE_BLACKWELL4_3_VERSION='3.0-gog67142'

ARCHIVE_BASE_BLACKWELL4_2_NAME='blackwell_deception_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL4_2_MD5='c8839642e293df1a016db8ed6046dbee'
ARCHIVE_BASE_BLACKWELL4_2_SIZE='590000'
ARCHIVE_BASE_BLACKWELL4_2_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL4_1_NAME='blackwell_deception_1_3_53244.sh'
ARCHIVE_BASE_BLACKWELL4_1_MD5='61c144995e396515948fbb15c3467494'
ARCHIVE_BASE_BLACKWELL4_1_SIZE='660000'
ARCHIVE_BASE_BLACKWELL4_1_VERSION='1.3-gog53244'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME_BLACKWELL4='blackwell-4_icons.tar.xz'
ARCHIVE_OPTIONAL_ICONS_MD5_BLACKWELL4='d9dae751697727cb42e43221755f507a'
ARCHIVE_OPTIONAL_ICONS_URL_BLACKWELL4='https://downloads.dotslashplay.it/games/blackwell/'
CONTENT_ICONS_PATH_BLACKWELL4='.'
CONTENT_ICONS_FILES_BLACKWELL4='
16x16
24x24
32x32
48x48
256x256'

## Blackwell 5

ARCHIVE_BASE_BLACKWELL5_6_NAME='blackwell_epiphany_3_3c_81238.sh'
ARCHIVE_BASE_BLACKWELL5_6_MD5='9d6e3f969f8c267a8e53ec519dc361f5'
ARCHIVE_BASE_BLACKWELL5_6_SIZE='869580'
ARCHIVE_BASE_BLACKWELL5_6_VERSION='3.3c-gog81238'
ARCHIVE_BASE_BLACKWELL5_6_URL='https://www.gog.com/game/blackwell_epiphany_the'

ARCHIVE_BASE_BLACKWELL5_5_NAME='blackwell_epiphany_3_3a_78230.sh'
ARCHIVE_BASE_BLACKWELL5_5_MD5='765e4f7f90161c7708728f7096d2a495'
ARCHIVE_BASE_BLACKWELL5_5_SIZE='864300'
ARCHIVE_BASE_BLACKWELL5_5_VERSION='3.3a-gog78230'

ARCHIVE_BASE_BLACKWELL5_4_NAME='blackwell_epiphany_3_1a_71097.sh'
ARCHIVE_BASE_BLACKWELL5_4_MD5='b313ed9ee4a8531a2205f3d9f1932f9d'
ARCHIVE_BASE_BLACKWELL5_4_SIZE='864300'
ARCHIVE_BASE_BLACKWELL5_4_VERSION='3.1a-gog71097'

ARCHIVE_BASE_BLACKWELL5_3_NAME='blackwell_epiphany_3_0_67142.sh'
ARCHIVE_BASE_BLACKWELL5_3_MD5='bc979e295bee8e1e7e59299bea33080f'
ARCHIVE_BASE_BLACKWELL5_3_SIZE='864772'
ARCHIVE_BASE_BLACKWELL5_3_VERSION='3.0-gog67142'

ARCHIVE_BASE_BLACKWELL5_2_NAME='blackwell_epiphany_3_0_66153.sh'
ARCHIVE_BASE_BLACKWELL5_2_MD5='c0865ccac7ad31c7dc95a0b1a171e589'
ARCHIVE_BASE_BLACKWELL5_2_SIZE='870000'
ARCHIVE_BASE_BLACKWELL5_2_VERSION='3.0-gog66153'

ARCHIVE_BASE_BLACKWELL5_1_NAME='blackwell_epiphany_2_2_53244.sh'
ARCHIVE_BASE_BLACKWELL5_1_MD5='6ffbcfb56b62e476a0255eaa1a2aae6d'
ARCHIVE_BASE_BLACKWELL5_1_SIZE='890000'
ARCHIVE_BASE_BLACKWELL5_1_VERSION='2.2-gog53244'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME_BLACKWELL5='blackwell-5_icons.tar.xz'
ARCHIVE_OPTIONAL_ICONS_MD5_BLACKWELL5='7f054b2b1c499de5d992adbfe07411ba'
ARCHIVE_OPTIONAL_ICONS_URL_BLACKWELL5='https://downloads.dotslashplay.it/games/blackwell/'
CONTENT_ICONS_PATH_BLACKWELL5='.'
CONTENT_ICONS_FILES_BLACKWELL5='
16x16
24x24
32x32
48x48
256x256'


AGS_NAME_BLACKWELL1='blackwell1'
AGS_NAME_BLACKWELL2='blackwell2'
AGS_NAME_BLACKWELL3='blackwell3'
AGS_NAME_BLACKWELL4='blackwell4'
AGS_NAME_BLACKWELL5='blackwell5'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_ICON='../support/icon.png'
APP_MAIN_ICON_BLACKWELL1_1='Blackwell Legacy.exe'
APP_MAIN_ICON_BLACKWELL1_2='Blackwell Legacy.exe'
APP_MAIN_ICON_BLACKWELL2_1='Unbound.exe'
APP_MAIN_ICON_BLACKWELL2_2='Unbound.exe'
APP_MAIN_ICON_BLACKWELL3_1='Convergence.exe'
APP_MAIN_ICON_BLACKWELL4_1='Deception.exe'
APP_MAIN_ICON_BLACKWELL5_1='Epiphany.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
