/*
 * AntilagServer.h, part of VCMI engine
 *
 * Authors: listed in file AUTHORS in main folder
 *
 * License: GNU General Public License v2.0 or later
 * Full text of license available in license.txt file, in main folder
 *
 */
#pragma once

#include "../../lib/networkPacks/NetPackVisitor.h"

/// Class that filters which client request to server can be predicted, at least partially
class NetworkLagPredictionTestVisitor final : public ICPackVisitor
{
	bool canBeAppliedValue = false;

	//void visitSaveGame(SaveGame & pack) override;
	//void visitGamePause(GamePause & pack) override;
	//void visitEndTurn(EndTurn & pack) override;
	//void visitDismissHero(DismissHero & pack) override;
	void visitMoveHero(MoveHero & pack) override
	{
		canBeAppliedValue = true;
	}
	//void visitCastleTeleportHero(CastleTeleportHero & pack) override;
	void visitArrangeStacks(ArrangeStacks & pack) override
	{
		canBeAppliedValue = true;
	}
	//void visitBulkMoveArmy(BulkMoveArmy & pack) override;
	//void visitBulkSplitStack(BulkSplitStack & pack) override;
	//void visitBulkMergeStacks(BulkMergeStacks & pack) override;
	//void visitBulkSplitAndRebalanceStack(BulkSplitAndRebalanceStack & pack) override;
	//void visitDisbandCreature(DisbandCreature & pack) override;
	//void visitBuildStructure(BuildStructure & pack) override;
	//void visitSpellResearch(SpellResearch & pack) override;
	//void visitVisitTownBuilding(VisitTownBuilding & pack) override;
	//void visitRecruitCreatures(RecruitCreatures & pack) override;
	//void visitUpgradeCreature(UpgradeCreature & pack) override;
	//void visitGarrisonHeroSwap(GarrisonHeroSwap & pack) override;
	//void visitExchangeArtifacts(ExchangeArtifacts & pack) override;
	//void visitBulkExchangeArtifacts(BulkExchangeArtifacts & pack) override;
	//void visitManageBackpackArtifacts(ManageBackpackArtifacts & pack) override;
	//void visitManageEquippedArtifacts(ManageEquippedArtifacts & pack) override;
	//void visitAssembleArtifacts(AssembleArtifacts & pack) override;
	//void visitEraseArtifactByClient(EraseArtifactByClient & pack) override;
	//void visitBuyArtifact(BuyArtifact & pack) override;
	//void visitTradeOnMarketplace(TradeOnMarketplace & pack) override;
	//void visitSetFormation(SetFormation & pack) override;
	//void visitSetTactics(SetTactics & pack) override;
	//void visitHireHero(HireHero & pack) override;
	//void visitBuildBoat(BuildBoat & pack) override;
	//void visitQueryReply(QueryReply & pack) override;
	//void visitMakeAction(MakeAction & pack) override;
	//void visitDigWithHero(DigWithHero & pack) override;
	//void visitCastAdvSpell(CastAdvSpell & pack) override;
	//void visitRequestStatistic(RequestStatistic & pack) override;
	//void visitPlayerMessage(PlayerMessage & pack) override;
	//void visitSaveLocalState(SaveLocalState & pack) override;

public:
	/// Returns true if game should try to predict results of pack on which this class was applied
	bool canBeApplied() const
	{
		return canBeAppliedValue;
	}
};
