# Remove & Retention
<!--
SPDX-FileCopyrightText: © 2025 Christian Buhtz <c.buhtz@posteo.jp>

SPDX-License-Identifier: GPL-2.0-or-later

This file is part of the program "Back In Time" which is released under GNU
General Public License v2 (GPLv2). See LICENSES directory or go to
<https://spdx.org/licenses/GPL-2.0-or-later.html>
-->
## Overview
Backups can be automatically deleted or retained based on rules.
These rules allow for fine-grained management of the backup archive,
reducing storage space usage. The process runs at the end of every backup
run, even if no new backup is created.

!!! note
    The feature was also known as _Auto-remove_ or _Smart Remove_ in earlier
    versions of _Back In Time_ (prior to 1.6.0).

![Dialog tab - Remove and Retention](_images/tab_remove_retention.png)

Here is a brief overview of the rules available:
      
- **Keep the most recent backup**: The last (or freshest) backup will be retained.
- **Keep named backups**: All backups with a name are excluded from every
  rule and never removed. This is the only one rule that can not be overruled
  by other rules.
- **Remove backups older than `N` Days/Weeks/Years**: Backups older than
  the specified time period are removed immediately.
- **Retention policy**: Rules about which backups to keep. The
  rest will be removed immediately.
    - **Keep all backups for the last `N` days**
    - **Keep the last backup for each day/week/month for the last `N` days/weeks/months**
    - **Keep the last backup for each year for all years**
- **Remove oldest backup if the free space is less than `N` GiB/MiB**: If the
  threshold of free storage space is reached, the oldest backups will be
  removed until enough storage space is available again.
- **Remove oldest backup if the free inodes are less than `N` %**: If the
  threshold of free inodes is reached, the oldest backups will be
  removed until enough inodes are available again.

!!! warning
    All rules are processed from top to bottom, as presented in the GUI or in
    this manual. Later rules **do override** earlier ones and are **not
    constrained** by them. The only exception is the first rule
    *Keep named backups*.

In the examples below:

- The <span style="color: #e655ec;"><strong>item in pink is the current backup</strong></span>.
- <strong>Items in black are the existing backups</strong>.
- <span style="color: #60a776;"><strong>Items in green are backups identified for retention</strong></span>.
- <span style="color: #d23c48;"><strong>Items in red are backups identified for removal</strong></span>.
- <span style="color: #6681a5;"><strong>Items in blue (sometimes <span style="color: #e655ec;">mixed with pink</span>) in the final column are the final retained backups</strong></span>.

## Rules in details
### Keep the most recent backups
The most recently created backups, in other words the freshest one, will be
retained and not deleted by any of the configured rules. Despite it is present
in the graphical frontend, that behavior cannot be changed.

### Keep named backups
Beside the timestamp regularly used to identify backups, it is possible to
attach a name to it. Those named backups are never touched by any other
rule. It is a guarantee that they won't be removed. See
[Main Window](main_window.md) for more details about named backups.

### Remove backups older than …

**Remove backups older than `N` Years**

- Calculation is based on 12 months.
- Current month is ignored.
- _Example_: Older than two years, at date 2025-04-17, result in
  removing backups before (or older than) 2023-04-01.
![Rule - Remove older than 2 years](_images/rule_older_than_n_years.png)

**Remove backups older than `N` Weeks**

- Calculation is based on calendar weeks with Monday as first day of a week.
- Current week is ignored.
- _Example_: Older than two weeks, at Friday 2025-08-29, result in removing
  backups before (or older than) Monday 2025-08-11.

![Rule - Remove older than 2 weeks](_images/rule_older_than_n_weeks.png)

**Remove backups older than `N` Days**

- Calculation is based on full days from 0:00 to 23:59.
- Current day is ignored.
- _Example_: Older than 3 days, at date 2025-01-10, result in removing backups
  before (or older than) 2025-01-07.

![Rule - Remove older than 3 days](_images/rule_older_than_n_days.png)

### Retention policy
Backups are retained if they fit at least one of the the rules from the
retention policy. All other backups, not covered by the retention policy,
will be removed.

The values specified are treated as a period rather than a count. For example,
imagine keeping the last backup of each month for the past six months,
including the current running months. However, only four of these six months
have backups. In this case, only four backups are retained. The period is
not extended further into the past to reach a total of six backups. See the
rules below for more illustrated examples.

**Keep all backups for the last `N` days**

- Calculation is based on full days from 0:00 to 23:59.
- Current day is included.

_Example_:

![Rule - Keep all for the last 2 days](_images/rule_keep_all_for_n_days.png)

**Keep the last backup for each day for the last `N` days**

- Calculation is based on full days from 0:00 to 23:59.
- Current day is included.

_Example_:

![Rule - Keep last for each day for the last 5 days](_images/rule_keep_last_each_day_for_n_days.png)

**Keep the last backup for each week for the last `N` weeks**

- Calculation is based on full calendar weeks starting from Monday.
- Current week is included.

_Example_:

![Rule - Keep last for each week for the last 4 weeks](_images/rule_keep_last_each_week_for_n_weeks.png)

**Keep the last backup for each month for the last `N` months**

- Calculation is based on full calendar months.
- Current month is included.

_Example_:

![Rule - Keep last for each months for the last 4 months](_images/rule_keep_last_each_month_for_n_months.png)

**Keep the last backup for each year for all years**

- Calculation is based on calendar years.
- Current year is included.
- Despite it is present in the graphical frontend, that behavior cannot be
  changed, if _Retention Policy_ is enabled.

_Example_:

![Rule - Keep last for each year for all years](_images/rule_keep_last_each_year_for_all_years.png)

### Run in background mode on remote host
The remove command can be executed on the local machine or on a remote host via
SSH. The latter can save time and resources.

## Interactions between and mutual constraints of the rules
All rules are applied and executed immediately one by one and in the order as
presented in the GUI and here in the manual. This contain the potential of
confusing interactions between the rules.

### Example: Three years and all years.
Imagine this two rules:

1. Remove backups older than 3 years.
2. Keep last backup for each year for all years.

We continue to assume that multiple backups per year have been available over
the past five years.

Rule 2 in isolation would result in five retained backups, one for each of the
five existing years. But rule 1 will be executed beforehand. Rule 1 will remove
all backups from four and five years ago.
    
### Example: Six months but less storage space
Imagine this two rules:

1. Keep last backup for each months for 6 months.
2. Remove oldest backups if the free space is less than 100 GiB.

The consequence of rule 1 is that six backups are kept, one for each
months. Additionally imagine some more backups because of the other keep rules
beforehand. This consumes so much storage space that there is only 80 GiB free
space left. This is less than the 100 GiB limit configured in rule 2. Because
of that the two oldest backups (of months five and six) will be
removed. After this 105 GiB storage space is available again and the rule
stops. The final consequence is that backups of four months are kept, instead
of six months as configured in rule 1.

