#ifndef INCLUDED_CASUPLOAD_OCI_PROCESSARGS
#define INCLUDED_CASUPLOAD_OCI_PROCESSARGS

#include <buildboxcommon_connectionoptions.h>
#include <buildboxcommon_logging.h>
#include <buildboxcommon_merklize.h>
#include <string>

namespace casupload_oci {

struct ProcessedArgs {
    bool d_processed;
    bool d_valid;

    buildboxcommon::LogLevel d_logLevel;

    buildboxcommon::ConnectionOptions d_casConnectionOptions;
    buildboxcommon::ConnectionOptions d_assetConnectionOptions;

    std::string d_ociUri;

    std::string d_outputRootDigestFile;
    std::string d_outputTreeDigestFile;
    std::string d_authTokenPath;

    buildboxcommon::DigestFunction_Value d_digestFunctionValue;

    int d_numParallelLayerThreads;
};

ProcessedArgs processArgs(int argc, char *argv[]);

} // namespace casupload_oci

#endif
