--------------------------------------------------------------------------------
--                       FixRealKCM_F0_uid6_T0_F0_uid9
-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: Florent de Dinechin, Bogdan Pasca (2007-2020)
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X
-- Output signals: Y

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library std;
use std.textio.all;
library work;

entity FixRealKCM_F0_uid6_T0_F0_uid9 is
    port (X : in  std_logic_vector(4 downto 0);
          Y : out  std_logic_vector(18 downto 0)   );
end entity;

architecture arch of FixRealKCM_F0_uid6_T0_F0_uid9 is
signal Y0 :  std_logic_vector(18 downto 0);
attribute ram_extract: string;
attribute ram_style: string;
attribute ram_extract of Y0: signal is "yes";
attribute ram_style of Y0: signal is "distributed";
signal Y1 :  std_logic_vector(18 downto 0);
begin
   with X  select  Y0 <= 
      "0000000000000000010" when "00000",
      "0000011001001000110" when "00001",
      "0000110010010001010" when "00010",
      "0001001011011001110" when "00011",
      "0001100100100010010" when "00100",
      "0001111101101010110" when "00101",
      "0010010110110011010" when "00110",
      "0010101111111011110" when "00111",
      "0011001001000100010" when "01000",
      "0011100010001100110" when "01001",
      "0011111011010101010" when "01010",
      "0100010100011101110" when "01011",
      "0100101101100110010" when "01100",
      "0101000110101110110" when "01101",
      "0101011111110111001" when "01110",
      "0101111000111111101" when "01111",
      "0110010010001000001" when "10000",
      "0110101011010000101" when "10001",
      "0111000100011001001" when "10010",
      "0111011101100001101" when "10011",
      "0111110110101010001" when "10100",
      "1000001111110010101" when "10101",
      "1000101000111011001" when "10110",
      "1001000010000011101" when "10111",
      "1001011011001100001" when "11000",
      "1001110100010100101" when "11001",
      "1010001101011101001" when "11010",
      "1010100110100101101" when "11011",
      "1010111111101110001" when "11100",
      "1011011000110110101" when "11101",
      "1011110001111111001" when "11110",
      "1100001011000111101" when "11111",
      "-------------------" when others;
Y1 <= Y0; -- for the possible blockram register
   Y <= Y1;
end architecture;

--------------------------------------------------------------------------------
--                       FixRealKCM_F0_uid6_T1_F0_uid11
-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: Florent de Dinechin, Bogdan Pasca (2007-2020)
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X
-- Output signals: Y

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library std;
use std.textio.all;
library work;

entity FixRealKCM_F0_uid6_T1_F0_uid11 is
    port (X : in  std_logic_vector(4 downto 0);
          Y : out  std_logic_vector(13 downto 0)   );
end entity;

architecture arch of FixRealKCM_F0_uid6_T1_F0_uid11 is
signal Y0 :  std_logic_vector(13 downto 0);
attribute ram_extract: string;
attribute ram_style: string;
attribute ram_extract of Y0: signal is "yes";
attribute ram_style of Y0: signal is "distributed";
signal Y1 :  std_logic_vector(13 downto 0);
begin
   with X  select  Y0 <= 
      "00000000000000" when "00000",
      "00000110010010" when "00001",
      "00001100100100" when "00010",
      "00010010110110" when "00011",
      "00011001001000" when "00100",
      "00011111011011" when "00101",
      "00100101101101" when "00110",
      "00101011111111" when "00111",
      "00110010010001" when "01000",
      "00111000100011" when "01001",
      "00111110110101" when "01010",
      "01000101000111" when "01011",
      "01001011011001" when "01100",
      "01010001101100" when "01101",
      "01010111111110" when "01110",
      "01011110010000" when "01111",
      "01100100100010" when "10000",
      "01101010110100" when "10001",
      "01110001000110" when "10010",
      "01110111011000" when "10011",
      "01111101101010" when "10100",
      "10000011111101" when "10101",
      "10001010001111" when "10110",
      "10010000100001" when "10111",
      "10010110110011" when "11000",
      "10011101000101" when "11001",
      "10100011010111" when "11010",
      "10101001101001" when "11011",
      "10101111111011" when "11100",
      "10110110001110" when "11101",
      "10111100100000" when "11110",
      "11000010110010" when "11111",
      "--------------" when others;
Y1 <= Y0; -- for the possible blockram register
   Y <= Y1;
end architecture;

--------------------------------------------------------------------------------
--                       FixRealKCM_F0_uid6_T2_F0_uid13
-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: Florent de Dinechin, Bogdan Pasca (2007-2020)
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X
-- Output signals: Y

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library std;
use std.textio.all;
library work;

entity FixRealKCM_F0_uid6_T2_F0_uid13 is
    port (X : in  std_logic_vector(4 downto 0);
          Y : out  std_logic_vector(8 downto 0)   );
end entity;

architecture arch of FixRealKCM_F0_uid6_T2_F0_uid13 is
signal Y0 :  std_logic_vector(8 downto 0);
attribute ram_extract: string;
attribute ram_style: string;
attribute ram_extract of Y0: signal is "yes";
attribute ram_style of Y0: signal is "distributed";
signal Y1 :  std_logic_vector(8 downto 0);
begin
   with X  select  Y0 <= 
      "000000000" when "00000",
      "000001101" when "00001",
      "000011001" when "00010",
      "000100110" when "00011",
      "000110010" when "00100",
      "000111111" when "00101",
      "001001011" when "00110",
      "001011000" when "00111",
      "001100101" when "01000",
      "001110001" when "01001",
      "001111110" when "01010",
      "010001010" when "01011",
      "010010111" when "01100",
      "010100011" when "01101",
      "010110000" when "01110",
      "010111100" when "01111",
      "011001001" when "10000",
      "011010110" when "10001",
      "011100010" when "10010",
      "011101111" when "10011",
      "011111011" when "10100",
      "100001000" when "10101",
      "100010100" when "10110",
      "100100001" when "10111",
      "100101110" when "11000",
      "100111010" when "11001",
      "101000111" when "11010",
      "101010011" when "11011",
      "101100000" when "11100",
      "101101100" when "11101",
      "101111001" when "11110",
      "110000110" when "11111",
      "---------" when others;
Y1 <= Y0; -- for the possible blockram register
   Y <= Y1;
end architecture;

--------------------------------------------------------------------------------
--                          Compressor_23_3_F0_uid16
-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: 
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X1 X0
-- Output signals: R

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library std;
use std.textio.all;
library work;

entity Compressor_23_3_F0_uid16 is
    port (X1 : in  std_logic_vector(1 downto 0);
          X0 : in  std_logic_vector(2 downto 0);
          R : out  std_logic_vector(2 downto 0)   );
end entity;

architecture arch of Compressor_23_3_F0_uid16 is
signal X :  std_logic_vector(4 downto 0);
signal R0 :  std_logic_vector(2 downto 0);
begin
   X <= X1 & X0 ;

   with X  select  R0 <= 
      "000" when "00000",
      "001" when "00001" | "00010" | "00100",
      "010" when "00011" | "00101" | "00110" | "01000" | "10000",
      "011" when "00111" | "01001" | "01010" | "01100" | "10001" | "10010" | "10100",
      "100" when "01011" | "01101" | "01110" | "10011" | "10101" | "10110" | "11000",
      "101" when "01111" | "10111" | "11001" | "11010" | "11100",
      "110" when "11011" | "11101" | "11110",
      "111" when "11111",
      "---" when others;
   R <= R0;
end architecture;

--------------------------------------------------------------------------------
--                        FixFunctionByTable_F0_uid27
-- Evaluator for x*x on [0,1) for lsbIn=-6 (wIn=6), msbout=0, lsbOut=-6 (wOut=7). Out interval: [0; 1]. Output is unsigned

-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: Florent de Dinechin (2010-2018)
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X
-- Output signals: Y

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library std;
use std.textio.all;
library work;

entity FixFunctionByTable_F0_uid27 is
    port (X : in  std_logic_vector(5 downto 0);
          Y : out  std_logic_vector(6 downto 0)   );
end entity;

architecture arch of FixFunctionByTable_F0_uid27 is
signal Y0 :  std_logic_vector(6 downto 0);
attribute ram_extract: string;
attribute ram_style: string;
attribute ram_extract of Y0: signal is "yes";
attribute ram_style of Y0: signal is "distributed";
signal Y1 :  std_logic_vector(6 downto 0);
begin
   with X  select  Y0 <= 
      "0000000" when "000000",
      "0000000" when "000001",
      "0000000" when "000010",
      "0000000" when "000011",
      "0000000" when "000100",
      "0000000" when "000101",
      "0000001" when "000110",
      "0000001" when "000111",
      "0000001" when "001000",
      "0000001" when "001001",
      "0000010" when "001010",
      "0000010" when "001011",
      "0000010" when "001100",
      "0000011" when "001101",
      "0000011" when "001110",
      "0000100" when "001111",
      "0000100" when "010000",
      "0000101" when "010001",
      "0000101" when "010010",
      "0000110" when "010011",
      "0000110" when "010100",
      "0000111" when "010101",
      "0001000" when "010110",
      "0001000" when "010111",
      "0001001" when "011000",
      "0001010" when "011001",
      "0001011" when "011010",
      "0001011" when "011011",
      "0001100" when "011100",
      "0001101" when "011101",
      "0001110" when "011110",
      "0001111" when "011111",
      "0010000" when "100000",
      "0010001" when "100001",
      "0010010" when "100010",
      "0010011" when "100011",
      "0010100" when "100100",
      "0010101" when "100101",
      "0010111" when "100110",
      "0011000" when "100111",
      "0011001" when "101000",
      "0011010" when "101001",
      "0011100" when "101010",
      "0011101" when "101011",
      "0011110" when "101100",
      "0100000" when "101101",
      "0100001" when "101110",
      "0100011" when "101111",
      "0100100" when "110000",
      "0100110" when "110001",
      "0100111" when "110010",
      "0101001" when "110011",
      "0101010" when "110100",
      "0101100" when "110101",
      "0101110" when "110110",
      "0101111" when "110111",
      "0110001" when "111000",
      "0110011" when "111001",
      "0110101" when "111010",
      "0110110" when "111011",
      "0111000" when "111100",
      "0111010" when "111101",
      "0111100" when "111110",
      "0111110" when "111111",
      "-------" when others;
Y1 <= Y0; -- for the possible blockram register
   Y <= Y1;
end architecture;

--------------------------------------------------------------------------------
--                           sinCosPiATable_F0_uid4
-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: Florent de Dinechin, Bogdan Pasca (2007-2020)
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X
-- Output signals: Y

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library std;
use std.textio.all;
library work;

entity sinCosPiATable_F0_uid4 is
    port (X : in  std_logic_vector(9 downto 0);
          Y : out  std_logic_vector(53 downto 0)   );
end entity;

architecture arch of sinCosPiATable_F0_uid4 is
signal Y0 :  std_logic_vector(53 downto 0);
attribute ram_extract: string;
attribute ram_style: string;
attribute ram_extract of Y0: signal is "yes";
attribute ram_style of Y0: signal is "block";
signal Y1 :  std_logic_vector(53 downto 0);
begin
   with X  select  Y0 <= 
      "000000000000000000000001000111111111111111111111111000" when "0000000000",
      "000000000011001001000101000111111111111111111111010001" when "0000000001",
      "000000000110010010001000111111111111111111111101011010" when "0000000010",
      "000000001001011011001100111111111111111111111010010101" when "0000000011",
      "000000001100100100010000110111111111111111110110000000" when "0000000100",
      "000000001111101101010100101111111111111111110000011101" when "0000000101",
      "000000010010110110011000100111111111111111101001101011" when "0000000110",
      "000000010101111111011100010111111111111111100001101010" when "0000000111",
      "000000011001001000100000000111111111111111011000011001" when "0000001000",
      "000000011100010001100011110111111111111111001101111010" when "0000001001",
      "000000011111011010100111011111111111111111000010001100" when "0000001010",
      "000000100010100011101010111111111111111110110101001111" when "0000001011",
      "000000100101101100101110011111111111111110100111000011" when "0000001100",
      "000000101000110101110001110111111111111110010111101000" when "0000001101",
      "000000101011111110110101000111111111111110000110111110" when "0000001110",
      "000000101111000111111000001111111111111101110101000101" when "0000001111",
      "000000110010010000111011010111111111111101100001111110" when "0000010000",
      "000000110101011001111110001111111111111101001101100111" when "0000010001",
      "000000111000100011000001000111111111111100111000000001" when "0000010010",
      "000000111011101100000011101111111111111100100001001101" when "0000010011",
      "000000111110110101000110001111111111111100001001001001" when "0000010100",
      "000001000001111110001000100111111111111011101111110110" when "0000010101",
      "000001000101000111001010110111111111111011010101010101" when "0000010110",
      "000001001000010000001100110111111111111010111001100100" when "0000010111",
      "000001001011011001001110101111111111111010011100100101" when "0000011000",
      "000001001110100010010000011111111111111001111110010111" when "0000011001",
      "000001010001101011010001111111111111111001011110111001" when "0000011010",
      "000001010100110100010011001111111111111000111110001101" when "0000011011",
      "000001010111111101010100010111111111111000011100010010" when "0000011100",
      "000001011011000110010101001111111111110111111001001000" when "0000011101",
      "000001011110001111010101110111111111110111010100101111" when "0000011110",
      "000001100001011000010110010111111111110110101111000111" when "0000011111",
      "000001100100100001010110100111111111110110001000010000" when "0000100000",
      "000001100111101010010110011111111111110101100000001010" when "0000100001",
      "000001101010110011010110001111111111110100110110110110" when "0000100010",
      "000001101101111100010101101111111111110100001100010010" when "0000100011",
      "000001110001000101010100110111111111110011100000011111" when "0000100100",
      "000001110100001110010011110111111111110010110011011110" when "0000100101",
      "000001110111010111010010011111111111110010000101001101" when "0000100110",
      "000001111010100000010000101111111111110001010101101110" when "0000100111",
      "000001111101101001001110110111111111110000100100111111" when "0000101000",
      "000010000000110010001100100111111111101111110011000010" when "0000101001",
      "000010000011111011001001111111111111101110111111110110" when "0000101010",
      "000010000111000100000111000111111111101110001011011011" when "0000101011",
      "000010001010001101000011111111111111101101010101110001" when "0000101100",
      "000010001101010110000000011111111111101100011110111000" when "0000101101",
      "000010010000011110111100100111111111101011100110110000" when "0000101110",
      "000010010011100111111000010111111111101010101101011010" when "0000101111",
      "000010010110110000110011101111111111101001110010110100" when "0000110000",
      "000010011001111001101110110111111111101000110110111111" when "0000110001",
      "000010011101000010101001011111111111100111111001111100" when "0000110010",
      "000010100000001011100011110111111111100110111011101010" when "0000110011",
      "000010100011010100011101101111111111100101111100001001" when "0000110100",
      "000010100110011101010111001111111111100100111011011000" when "0000110101",
      "000010101001100110010000010111111111100011111001011001" when "0000110110",
      "000010101100101111001001000111111111100010110110001100" when "0000110111",
      "000010101111111000000001011111111111100001110001101111" when "0000111000",
      "000010110011000000111001010111111111100000101100000011" when "0000111001",
      "000010110110001001110000101111111111011111100101001001" when "0000111010",
      "000010111001010010100111101111111111011110011100111111" when "0000111011",
      "000010111100011011011110010111111111011101010011100111" when "0000111100",
      "000010111111100100010100011111111111011100001001000000" when "0000111101",
      "000011000010101101001010000111111111011010111101001010" when "0000111110",
      "000011000101110101111111001111111111011001110000000101" when "0000111111",
      "000011001000111110110011111111111111011000100001110001" when "0001000000",
      "000011001100000111101000001111111111010111010010001110" when "0001000001",
      "000011001111010000011011111111111111010110000001011101" when "0001000010",
      "000011010010011001001111000111111111010100101111011100" when "0001000011",
      "000011010101100010000001110111111111010011011100001101" when "0001000100",
      "000011011000101010110100000111111111010010000111101111" when "0001000101",
      "000011011011110011100101101111111111010000110010000010" when "0001000110",
      "000011011110111100010110110111111111001111011011000110" when "0001000111",
      "000011100010000101000111011111111111001110000010111100" when "0001001000",
      "000011100101001101110111100111111111001100101001100010" when "0001001001",
      "000011101000010110100111000111111111001011001110111010" when "0001001010",
      "000011101011011111010110000111111111001001110011000011" when "0001001011",
      "000011101110101000000100011111111111001000010101111101" when "0001001100",
      "000011110001110000110010010111111111000110110111101001" when "0001001101",
      "000011110100111001011111011111111111000101011000000101" when "0001001110",
      "000011111000000010001100001111111111000011110111010011" when "0001001111",
      "000011111011001010111000001111111111000010010101010001" when "0001010000",
      "000011111110010011100011100111111111000000110010000001" when "0001010001",
      "000100000001011100001110011111111110111111001101100011" when "0001010010",
      "000100000100100100111000101111111110111101100111110101" when "0001010011",
      "000100000111101101100010001111111110111100000000111001" when "0001010100",
      "000100001010110110001011001111111110111010011000101101" when "0001010101",
      "000100001101111110110011011111111110111000101111010100" when "0001010110",
      "000100010001000111011011001111111110110111000100101011" when "0001010111",
      "000100010100010000000010001111111110110101011000110011" when "0001011000",
      "000100010111011000101000011111111110110011101011101101" when "0001011001",
      "000100011010100001001110000111111110110001111101011000" when "0001011010",
      "000100011101101001110011000111111110110000001101110100" when "0001011011",
      "000100100000110010010111011111111110101110011101000001" when "0001011100",
      "000100100011111010111010111111111110101100101011000000" when "0001011101",
      "000100100111000011011101110111111110101010110111110000" when "0001011110",
      "000100101010001100000000000111111110101001000011010001" when "0001011111",
      "000100101101010100100001011111111110100111001101100011" when "0001100000",
      "000100110000011101000010001111111110100101010110100111" when "0001100001",
      "000100110011100101100010001111111110100011011110011100" when "0001100010",
      "000100110110101110000001011111111110100001100101000010" when "0001100011",
      "000100111001110110011111111111111110011111101010011001" when "0001100100",
      "000100111100111110111101101111111110011101101110100010" when "0001100101",
      "000101000000000111011010101111111110011011110001011100" when "0001100110",
      "000101000011001111110110111111111110011001110011000111" when "0001100111",
      "000101000110011000010010011111111110010111110011100100" when "0001101000",
      "000101001001100000101101000111111110010101110010110010" when "0001101001",
      "000101001100101001000110111111111110010011110000110001" when "0001101010",
      "000101001111110001011111111111111110010001101101100001" when "0001101011",
      "000101010010111001111000001111111110001111101001000011" when "0001101100",
      "000101010110000010001111100111111110001101100011010110" when "0001101101",
      "000101011001001010100110001111111110001011011100011010" when "0001101110",
      "000101011100010010111011111111111110001001010100010000" when "0001101111",
      "000101011111011011010000111111111110000111001010110111" when "0001110000",
      "000101100010100011100101000111111110000101000000010000" when "0001110001",
      "000101100101101011111000010111111110000010110100011001" when "0001110010",
      "000101101000110100001010101111111110000000100111010100" when "0001110011",
      "000101101011111100011100001111111101111110011001000001" when "0001110100",
      "000101101111000100101100110111111101111100001001011111" when "0001110101",
      "000101110010001100111100011111111101111001111000101110" when "0001110110",
      "000101110101010101001011010111111101110111100110101110" when "0001110111",
      "000101111000011101011001010111111101110101010011100000" when "0001111000",
      "000101111011100101100110010111111101110010111111000011" when "0001111001",
      "000101111110101101110010011111111101110000101001011000" when "0001111010",
      "000110000001110101111101101111111101101110010010011110" when "0001111011",
      "000110000100111110000111111111111101101011111010010101" when "0001111100",
      "000110001000000110010001010111111101101001100000111110" when "0001111101",
      "000110001011001110011001101111111101100111000110011000" when "0001111110",
      "000110001110010110100001000111111101100100101010100100" when "0001111111",
      "000110010001011110100111100111111101100010001101100001" when "0010000000",
      "000110010100100110101101000111111101011111101111001111" when "0010000001",
      "000110010111101110110001101111111101011101001111101111" when "0010000010",
      "000110011010110110110101001111111101011010101111000001" when "0010000011",
      "000110011101111110110111110111111101011000001101000011" when "0010000100",
      "000110100001000110111001010111111101010101101001111000" when "0010000101",
      "000110100100001110111001111111111101010011000101011101" when "0010000110",
      "000110100111010110111001011111111101010000011111110101" when "0010000111",
      "000110101010011110110111111111111101001101111000111101" when "0010001000",
      "000110101101100110110101100111111101001011010000110111" when "0010001001",
      "000110110000101110110001111111111101001000100111100011" when "0010001010",
      "000110110011110110101101011111111101000101111101000000" when "0010001011",
      "000110110110111110100111110111111101000011010001001110" when "0010001100",
      "000110111010000110100001000111111101000000100100001110" when "0010001101",
      "000110111101001110011001010111111100111101110110000000" when "0010001110",
      "000111000000010110010000100111111100111011000110100011" when "0010001111",
      "000111000011011110000110100111111100111000010101110111" when "0010010000",
      "000111000110100101111011101111111100110101100011111110" when "0010010001",
      "000111001001101101101111100111111100110010110000110101" when "0010010010",
      "000111001100110101100010010111111100101111111100011110" when "0010010011",
      "000111001111111101010100000111111100101101000110111001" when "0010010100",
      "000111010011000101000100101111111100101010010000000101" when "0010010101",
      "000111010110001100110100000111111100100111011000000011" when "0010010110",
      "000111011001010100100010011111111100100100011110110010" when "0010010111",
      "000111011100011100001111101111111100100001100100010011" when "0010011000",
      "000111011111100011111011101111111100011110101000100110" when "0010011001",
      "000111100010101011100110100111111100011011101011101010" when "0010011010",
      "000111100101110011010000010111111100011000101101100000" when "0010011011",
      "000111101000111010111000110111111100010101101110000111" when "0010011100",
      "000111101100000010100000001111111100010010101101100000" when "0010011101",
      "000111101111001010000110010111111100001111101011101010" when "0010011110",
      "000111110010010001101011010111111100001100101000100111" when "0010011111",
      "000111110101011001001111001111111100001001100100010100" when "0010100000",
      "000111111000100000110001101111111100000110011110110100" when "0010100001",
      "000111111011101000010011000111111100000011011000000101" when "0010100010",
      "000111111110101111110011010111111100000000010000001000" when "0010100011",
      "001000000001110111010010001111111011111101000110111100" when "0010100100",
      "001000000100111110101111110111111011111001111100100010" when "0010100101",
      "001000001000000110001100010111111011110110110000111010" when "0010100110",
      "001000001011001101100111011111111011110011100100000011" when "0010100111",
      "001000001110010101000001010111111011110000010101111110" when "0010101000",
      "001000010001011100011010000111111011101101000110101011" when "0010101001",
      "001000010100100011110001011111111011101001110110001001" when "0010101010",
      "001000010111101011000111011111111011100110100100011010" when "0010101011",
      "001000011010110010011100010111111011100011010001011011" when "0010101100",
      "001000011101111001101111110111111011011111111101001111" when "0010101101",
      "001000100001000001000001111111111011011100100111110101" when "0010101110",
      "001000100100001000010010110111111011011001010001001100" when "0010101111",
      "001000100111001111100010011111111011010101111001010101" when "0010110000",
      "001000101010010110110000101111111011010010100000001111" when "0010110001",
      "001000101101011101111101100111111011001111000101111100" when "0010110010",
      "001000110000100101001001000111111011001011101010011010" when "0010110011",
      "001000110011101100010011010111111011001000001101101010" when "0010110100",
      "001000110110110011011100001111111011000100101111101100" when "0010110101",
      "001000111001111010100011100111111011000001010000011111" when "0010110110",
      "001000111101000001101001101111111010111101110000000101" when "0010110111",
      "001001000000001000101110011111111010111010001110011100" when "0010111000",
      "001001000011001111110001110111111010110110101011100101" when "0010111001",
      "001001000110010110110011101111111010110011000111100000" when "0010111010",
      "001001001001011101110100010111111010101111100010001100" when "0010111011",
      "001001001100100100110011011111111010101011111011101011" when "0010111100",
      "001001001111101011110001000111111010101000010011111011" when "0010111101",
      "001001010010110010101101010111111010100100101010111110" when "0010111110",
      "001001010101111001101000001111111010100001000000110010" when "0010111111",
      "001001011001000000100001101111111010011101010101011000" when "0011000000",
      "001001011100000111011001100111111010011001101000110000" when "0011000001",
      "001001011111001110010000000111111010010101111010111010" when "0011000010",
      "001001100010010101000101001111111010010010001011110110" when "0011000011",
      "001001100101011011111000101111111010001110011011100011" when "0011000100",
      "001001101000100010101010110111111010001010101010000011" when "0011000101",
      "001001101011101001011011011111111010000110110111010101" when "0011000110",
      "001001101110110000001010100111111010000011000011011000" when "0011000111",
      "001001110001110110111000001111111001111111001110001110" when "0011001000",
      "001001110100111101100100001111111001111011010111110101" when "0011001001",
      "001001111000000100001110110111111001110111100000001111" when "0011001010",
      "001001111011001010110111111111111001110011100111011010" when "0011001011",
      "001001111110010001011111011111111001101111101101010111" when "0011001100",
      "001010000001011000000101011111111001101011110010000111" when "0011001101",
      "001010000100011110101001111111111001100111110101101000" when "0011001110",
      "001010000111100101001100110111111001100011110111111100" when "0011001111",
      "001010001010101011101110001111111001011111111001000001" when "0011010000",
      "001010001101110010001101111111111001011011111000111001" when "0011010001",
      "001010010000111000101100000111111001010111110111100011" when "0011010010",
      "001010010011111111001000101111111001010011110100111110" when "0011010011",
      "001010010111000101100011101111111001001111110001001100" when "0011010100",
      "001010011010001011111101001111111001001011101100001100" when "0011010101",
      "001010011101010010010100111111111001000111100101111110" when "0011010110",
      "001010100000011000101011001111111001000011011110100010" when "0011010111",
      "001010100011011110111111110111111000111111010101111000" when "0011011000",
      "001010100110100101010010101111111000111011001100000000" when "0011011001",
      "001010101001101011100100000111111000110111000000111011" when "0011011010",
      "001010101100110001110011101111111000110010110100100111" when "0011011011",
      "001010101111111000000001110111111000101110100111000110" when "0011011100",
      "001010110010111110001110001111111000101010011000010111" when "0011011101",
      "001010110110000100011000110111111000100110001000011010" when "0011011110",
      "001010111001001010100001111111111000100001110111001111" when "0011011111",
      "001010111100010000101001010111111000011101100100110111" when "0011100000",
      "001010111111010110101110111111111000011001010001010001" when "0011100001",
      "001011000010011100110010111111111000010100111100011100" when "0011100010",
      "001011000101100010110101001111111000010000100110011010" when "0011100011",
      "001011001000101000110101101111111000001100001111001011" when "0011100100",
      "001011001011101110110100100111111000000111110110101101" when "0011100101",
      "001011001110110100110001101111111000000011011101000010" when "0011100110",
      "001011010001111010101101000111110111111111000010001001" when "0011100111",
      "001011010101000000100110101111110111111010100110000011" when "0011101000",
      "001011011000000110011110101111110111110110001000101110" when "0011101001",
      "001011011011001100010100110111110111110001101010001100" when "0011101010",
      "001011011110010010001001001111110111101101001010011101" when "0011101011",
      "001011100001010111111011110111110111101000101001011111" when "0011101100",
      "001011100100011101101100101111110111100100000111010100" when "0011101101",
      "001011100111100011011011101111110111011111100011111100" when "0011101110",
      "001011101010101001001000111111110111011010111111010101" when "0011101111",
      "001011101101101110110100011111110111010110011001100001" when "0011110000",
      "001011110000110100011110000111110111010001110010100000" when "0011110001",
      "001011110011111010000101111111110111001101001010010000" when "0011110010",
      "001011110110111111101011111111110111001000100000110100" when "0011110011",
      "001011111010000101010000001111110111000011110110001001" when "0011110100",
      "001011111101001010110010100111110110111111001010010001" when "0011110101",
      "001100000000010000010011000111110110111010011101001100" when "0011110110",
      "001100000011010101110001101111110110110101101110111000" when "0011110111",
      "001100000110011011001110100111110110110000111111011000" when "0011111000",
      "001100001001100000101001011111110110101100001110101010" when "0011111001",
      "001100001100100110000010100111110110100111011100101110" when "0011111010",
      "001100001111101011011001101111110110100010101001100101" when "0011111011",
      "001100010010110000101110111111110110011101110101001110" when "0011111100",
      "001100010101110110000010011111110110011000111111101010" when "0011111101",
      "001100011000111011010011111111110110010100001000111000" when "0011111110",
      "001100011100000000100011011111110110001111010000111001" when "0011111111",
      "001100011111000101110001001111110110001010010111101100" when "0100000000",
      "001100100010001010111100111111110110000101011101010010" when "0100000001",
      "001100100101010000000110101111110110000000100001101011" when "0100000010",
      "001100101000010101001110100111110101111011100100110110" when "0100000011",
      "001100101011011010010100011111110101110110100110110100" when "0100000100",
      "001100101110011111011000011111110101110001100111100100" when "0100000101",
      "001100110001100100011010011111110101101100100111000111" when "0100000110",
      "001100110100101001011010011111110101100111100101011100" when "0100000111",
      "001100110111101110011000100111110101100010100010100101" when "0100001000",
      "001100111010110011010100101111110101011101011110100000" when "0100001001",
      "001100111101111000001110101111110101011000011001001101" when "0100001010",
      "001101000000111101000110110111110101010011010010101101" when "0100001011",
      "001101000100000001111100110111110101001110001011000000" when "0100001100",
      "001101000111000110110000111111110101001001000010000110" when "0100001101",
      "001101001010001011100010111111110101000011110111111110" when "0100001110",
      "001101001101010000010010111111110100111110101100101001" when "0100001111",
      "001101010000010101000000111111110100111001100000000111" when "0100010000",
      "001101010011011001101100110111110100110100010010011000" when "0100010001",
      "001101010110011110010110101111110100101111000011011011" when "0100010010",
      "001101011001100010111110100111110100101001110011010001" when "0100010011",
      "001101011100100111100100010111110100100100100001111010" when "0100010100",
      "001101011111101100000111111111110100011111001111010110" when "0100010101",
      "001101100010110000101001100111110100011001111011100100" when "0100010110",
      "001101100101110101001001000111110100010100100110100110" when "0100010111",
      "001101101000111001100110100111110100001111010000011010" when "0100011000",
      "001101101011111110000001110111110100001001111001000001" when "0100011001",
      "001101101111000010011011000111110100000100100000011011" when "0100011010",
      "001101110010000110110010000111110011111111000110101000" when "0100011011",
      "001101110101001011000111000111110011111001101011100111" when "0100011100",
      "001101111000001111011001110111110011110100001111011010" when "0100011101",
      "001101111011010011101010100111110011101110110010000000" when "0100011110",
      "001101111110010111111001000111110011101001010011011000" when "0100011111",
      "001110000001011100000101011111110011100011110011100011" when "0100100000",
      "001110000100100000001111101111110011011110010010100010" when "0100100001",
      "001110000111100100010111101111110011011000110000010011" when "0100100010",
      "001110001010101000011101100111110011010011001100111000" when "0100100011",
      "001110001101101100100001010111110011001101101000001111" when "0100100100",
      "001110010000110000100010110111110011001000000010011001" when "0100100101",
      "001110010011110100100010000111110011000010011011010111" when "0100100110",
      "001110010110111000011111001111110010111100110011000111" when "0100100111",
      "001110011001111100011010000111110010110111001001101011" when "0100101000",
      "001110011101000000010010101111110010110001011111000001" when "0100101001",
      "001110100000000100001001000111110010101011110011001011" when "0100101010",
      "001110100011000111111101010111110010100110000110001000" when "0100101011",
      "001110100110001011101111001111110010100000010111110111" when "0100101100",
      "001110101001001111011110111111110010011010101000011010" when "0100101101",
      "001110101100010011001100010111110010010100110111110001" when "0100101110",
      "001110101111010110110111011111110010001111000101111010" when "0100101111",
      "001110110010011010100000011111110010001001010010110110" when "0100110000",
      "001110110101011110000111000111110010000011011110100110" when "0100110001",
      "001110111000100001101011010111110001111101101001001001" when "0100110010",
      "001110111011100101001101010111110001110111110010011111" when "0100110011",
      "001110111110101000101101000111110001110001111010101000" when "0100110100",
      "001111000001101100001010100111110001101100000001100100" when "0100110101",
      "001111000100101111100101100111110001100110000111010100" when "0100110110",
      "001111000111110010111110011111110001100000001011110111" when "0100110111",
      "001111001010110110010100110111110001011010001111001101" when "0100111000",
      "001111001101111001101000111111110001010100010001010111" when "0100111001",
      "001111010000111100111010101111110001001110010010010100" when "0100111010",
      "001111010100000000001010000111110001001000010010000100" when "0100111011",
      "001111010111000011010111001111110001000010010000101000" when "0100111100",
      "001111011010000110100001110111110000111100001101111110" when "0100111101",
      "001111011101001001101010000111110000110110001010001001" when "0100111110",
      "001111100000001100110000000111110000110000000101000110" when "0100111111",
      "001111100011001111110011100111110000101001111110110111" when "0101000000",
      "001111100110010010110100101111110000100011110111011100" when "0101000001",
      "001111101001010101110011011111110000011101101110110100" when "0101000010",
      "001111101100011000101111101111110000010111100100111111" when "0101000011",
      "001111101111011011101001100111110000010001011001111110" when "0101000100",
      "001111110010011110100001000111110000001011001101110000" when "0101000101",
      "001111110101100001010110000111110000000101000000010110" when "0101000110",
      "001111111000100100001000101111101111111110110001101111" when "0101000111",
      "001111111011100110111000110111101111111000100001111100" when "0101001000",
      "001111111110101001100110011111101111110010010000111100" when "0101001001",
      "010000000001101100010001101111101111101011111110110000" when "0101001010",
      "010000000100101110111010011111101111100101101011010111" when "0101001011",
      "010000000111110001100000101111101111011111010110110010" when "0101001100",
      "010000001010110100000100011111101111011001000001000000" when "0101001101",
      "010000001101110110100101101111101111010010101010000010" when "0101001110",
      "010000010000111001000100100111101111001100010001111000" when "0101001111",
      "010000010011111011100000110111101111000101111000100010" when "0101010000",
      "010000010110111101111010100111101110111111011101111111" when "0101010001",
      "010000011010000000010001110111101110111001000010001111" when "0101010010",
      "010000011101000010100110011111101110110010100101010100" when "0101010011",
      "010000100000000100111000101111101110101100000111001100" when "0101010100",
      "010000100011000111001000010111101110100101100111110111" when "0101010101",
      "010000100110001001010101010111101110011111000111010111" when "0101010110",
      "010000101001001011011111110111101110011000100101101010" when "0101010111",
      "010000101100001101100111110111101110010010000010110001" when "0101011000",
      "010000101111001111101101001111101110001011011110101100" when "0101011001",
      "010000110010010001101111111111101110000100111001011010" when "0101011010",
      "010000110101010011110000001111101101111110010010111101" when "0101011011",
      "010000111000010101101101110111101101110111101011010011" when "0101011100",
      "010000111011010111101000110111101101110001000010011101" when "0101011101",
      "010000111110011001100001001111101101101010011000011011" when "0101011110",
      "010001000001011011010110111111101101100011101101001101" when "0101011111",
      "010001000100011101001010000111101101011101000000110010" when "0101100000",
      "010001000111011110111010100111101101010110010011001100" when "0101100001",
      "010001001010100000101000011111101101001111100100011001" when "0101100010",
      "010001001101100010010011101111101101001000110100011011" when "0101100011",
      "010001010000100011111100010111101101000010000011010000" when "0101100100",
      "010001010011100101100010001111101100111011010000111010" when "0101100101",
      "010001010110100111000101011111101100110100011101010111" when "0101100110",
      "010001011001101000100101111111101100101101101000101000" when "0101100111",
      "010001011100101010000011111111101100100110110010101110" when "0101101000",
      "010001011111101011011111000111101100011111111011100111" when "0101101001",
      "010001100010101100110111100111101100011001000011010100" when "0101101010",
      "010001100101101110001101010111101100010010001001110110" when "0101101011",
      "010001101000101111100000011111101100001011001111001011" when "0101101100",
      "010001101011110000110000110111101100000100010011010101" when "0101101101",
      "010001101110110001111110011111101011111101010110010011" when "0101101110",
      "010001110001110011001001010111101011110110011000000101" when "0101101111",
      "010001110100110100010001011111101011101111011000101011" when "0101110000",
      "010001110111110101010110111111101011101000011000000101" when "0101110001",
      "010001111010110110011001100111101011100001010110010100" when "0101110010",
      "010001111101110111011001011111101011011010010011010110" when "0101110011",
      "010010000000111000010110100111101011010011001111001101" when "0101110100",
      "010010000011111001010000111111101011001100001001111000" when "0101110101",
      "010010000110111010001000011111101011000101000011010111" when "0101110110",
      "010010001001111010111101001111101010111101111011101011" when "0101110111",
      "010010001100111011101111001111101010110110110010110011" when "0101111000",
      "010010001111111100011110010111101010101111101000101111" when "0101111001",
      "010010010010111101001010101111101010101000011101100000" when "0101111010",
      "010010010101111101110100001111101010100001010001000100" when "0101111011",
      "010010011000111110011010111111101010011010000011011110" when "0101111100",
      "010010011011111110111110101111101010010010110100101011" when "0101111101",
      "010010011110111111011111101111101010001011100100101101" when "0101111110",
      "010010100001111111111101111111101010000100010011100100" when "0101111111",
      "010010100101000000011001001111101001111101000001001110" when "0110000000",
      "010010101000000000110001101111101001110101101101101110" when "0110000001",
      "010010101011000001000111001111101001101110011001000001" when "0110000010",
      "010010101110000001011001111111101001100111000011001010" when "0110000011",
      "010010110001000001101001101111101001011111101100000110" when "0110000100",
      "010010110100000001110110100111101001011000010011110111" when "0110000101",
      "010010110111000010000000100111101001010000111010011101" when "0110000110",
      "010010111010000010000111101111101001001001011111110111" when "0110000111",
      "010010111101000010001011111111101001000010000100000110" when "0110001000",
      "010011000000000010001101001111101000111010100111001010" when "0110001001",
      "010011000011000010001011011111101000110011001001000010" when "0110001010",
      "010011000110000010000110110111101000101011101001101110" when "0110001011",
      "010011001001000001111111010111101000100100001001010000" when "0110001100",
      "010011001100000001110100110111101000011100100111100110" when "0110001101",
      "010011001111000001100111010111101000010101000100110000" when "0110001110",
      "010011010010000001010110111111101000001101100000110000" when "0110001111",
      "010011010101000001000011100111101000000101111011100100" when "0110010000",
      "010011011000000000101101000111100111111110010101001100" when "0110010001",
      "010011011011000000010011101111100111110110101101101010" when "0110010010",
      "010011011101111111110111011111100111101111000100111100" when "0110010011",
      "010011100000111111011000000111100111100111011011000011" when "0110010100",
      "010011100011111110110101100111100111011111101111111111" when "0110010101",
      "010011100110111110010000001111100111011000000011110000" when "0110010110",
      "010011101001111101100111110111100111010000010110010101" when "0110010111",
      "010011101100111100111100010111100111001000100111110000" when "0110011000",
      "010011101111111100001101110111100111000000110111111111" when "0110011001",
      "010011110010111011011100010111100110111001000111000011" when "0110011010",
      "010011110101111010100111101111100110110001010100111100" when "0110011011",
      "010011111000111001110000000111100110101001100001101010" when "0110011100",
      "010011111011111000110101010111100110100001101101001101" when "0110011101",
      "010011111110110111110111100111100110011001110111100101" when "0110011110",
      "010100000001110110110110101111100110010010000000110010" when "0110011111",
      "010100000100110101110010101111100110001010001000110100" when "0110100000",
      "010100000111110100101011101111100110000010001111101011" when "0110100001",
      "010100001010110011100001100111100101111010010101010111" when "0110100010",
      "010100001101110010010100010111100101110010011001111000" when "0110100011",
      "010100010000110001000011111111100101101010011101001110" when "0110100100",
      "010100010011101111110000010111100101100010011111011001" when "0110100101",
      "010100010110101110011001101111100101011010100000011010" when "0110100110",
      "010100011001101100111111111111100101010010100000001111" when "0110100111",
      "010100011100101011100011000111100101001010011110111010" when "0110101000",
      "010100011111101010000010111111100101000010011100011010" when "0110101001",
      "010100100010101000011111101111100100111010011000101111" when "0110101010",
      "010100100101100110111001010111100100110010010011111001" when "0110101011",
      "010100101000100101001111101111100100101010001101111001" when "0110101100",
      "010100101011100011100010111111100100100010000110101110" when "0110101101",
      "010100101110100001110010111111100100011001111110011000" when "0110101110",
      "010100110001011111111111110111100100010001110100110111" when "0110101111",
      "010100110100011110001001011111100100001001101010001100" when "0110110000",
      "010100110111011100001111111111100100000001011110010110" when "0110110001",
      "010100111010011010010011000111100011111001010001010101" when "0110110010",
      "010100111101011000010011000111100011110001000011001010" when "0110110011",
      "010101000000010110001111110111100011101000110011110100" when "0110110100",
      "010101000011010100001001010111100011100000100011010100" when "0110110101",
      "010101000110010001111111101111100011011000010001101001" when "0110110110",
      "010101001001001111110010101111100011001111111110110011" when "0110110111",
      "010101001100001101100010011111100011000111101010110011" when "0110111000",
      "010101001111001011001110111111100010111111010101101000" when "0110111001",
      "010101010010001000111000000111100010110110111111010011" when "0110111010",
      "010101010101000110011110000111100010101110100111110100" when "0110111011",
      "010101011000000100000000101111100010100110001111001010" when "0110111100",
      "010101011011000001100000000111100010011101110101010110" when "0110111101",
      "010101011101111110111100000111100010010101011010010111" when "0110111110",
      "010101100000111100010100110111100010001100111110001110" when "0110111111",
      "010101100011111001101010001111100010000100100000111010" when "0111000000",
      "010101100110110110111100010111100001111100000010011100" when "0111000001",
      "010101101001110100001011000111100001110011100010110100" when "0111000010",
      "010101101100110001010110011111100001101011000010000010" when "0111000011",
      "010101101111101110011110100111100001100010100000000101" when "0111000100",
      "010101110010101011100011010111100001011001111100111110" when "0111000101",
      "010101110101101000100100101111100001010001011000101101" when "0111000110",
      "010101111000100101100010101111100001001000110011010001" when "0111000111",
      "010101111011100010011101001111100001000000001100101100" when "0111001000",
      "010101111110011111010100011111100000110111100100111100" when "0111001001",
      "010110000001011100001000010111100000101110111100000010" when "0111001010",
      "010110000100011000111000110111100000100110010001111110" when "0111001011",
      "010110000111010101100101110111100000011101100110101111" when "0111001100",
      "010110001010010010001111011111100000010100111010010111" when "0111001101",
      "010110001101001110110101101111100000001100001100110101" when "0111001110",
      "010110010000001011011000011111100000000011011110001000" when "0111001111",
      "010110010011000111110111110111011111111010101110010010" when "0111010000",
      "010110010110000100010011101111011111110001111101010001" when "0111010001",
      "010110011001000000101100001111011111101001001011000111" when "0111010010",
      "010110011011111101000001001111011111100000010111110010" when "0111010011",
      "010110011110111001010010110111011111010111100011010100" when "0111010100",
      "010110100001110101100000111111011111001110101101101011" when "0111010101",
      "010110100100110001101011100111011111000101110110111001" when "0111010110",
      "010110100111101101110010101111011110111100111110111101" when "0111010111",
      "010110101010101001110110010111011110110100000101110111" when "0111011000",
      "010110101101100101110110011111011110101011001011100111" when "0111011001",
      "010110110000100001110011001111011110100010010000001110" when "0111011010",
      "010110110011011101101100010111011110011001010011101010" when "0111011011",
      "010110110110011001100001111111011110010000010101111101" when "0111011100",
      "010110111001010101010100000111011110000111010111000110" when "0111011101",
      "010110111100010001000010100111011101111110010111000101" when "0111011110",
      "010110111111001100101101100111011101110101010101111011" when "0111011111",
      "010111000010001000010101000111011101101100010011100111" when "0111100000",
      "010111000101000011111001000111011101100011010000001001" when "0111100001",
      "010111000111111111011001011111011101011010001011100010" when "0111100010",
      "010111001010111010110110001111011101010001000101110001" when "0111100011",
      "010111001101110110001111011111011101000111111110110110" when "0111100100",
      "010111010000110001100101001111011100111110110110110010" when "0111100101",
      "010111010011101100110111001111011100110101101101100100" when "0111100110",
      "010111010110101000000101101111011100101100100011001101" when "0111100111",
      "010111011001100011010000100111011100100011010111101100" when "0111101000",
      "010111011100011110010111110111011100011010001011000010" when "0111101001",
      "010111011111011001011011011111011100010000111101001110" when "0111101010",
      "010111100010010100011011100111011100000111101110010001" when "0111101011",
      "010111100101001111010111111111011011111110011110001010" when "0111101100",
      "010111101000001010010000101111011011110101001100111010" when "0111101101",
      "010111101011000101000101110111011011101011111010100001" when "0111101110",
      "010111101101111111110111010111011011100010100110111110" when "0111101111",
      "010111110000111010100101000111011011011001010010010010" when "0111110000",
      "010111110011110101001111001111011011001111111100011100" when "0111110001",
      "010111110110101111110101101111011011000110100101011110" when "0111110010",
      "010111111001101010011000100111011010111101001101010110" when "0111110011",
      "010111111100100100110111100111011010110011110100000100" when "0111110100",
      "010111111111011111010011000111011010101010011001101010" when "0111110101",
      "011000000010011001101010110111011010100000111110000110" when "0111110110",
      "011000000101010011111110110111011010010111100001011001" when "0111110111",
      "011000001000001110001111000111011010001110000011100100" when "0111111000",
      "011000001011001000011011101111011010000100100100100100" when "0111111001",
      "011000001110000010100100011111011001111011000100011100" when "0111111010",
      "011000010000111100101001100111011001110001100011001011" when "0111111011",
      "011000010011110110101010111111011001101000000000110001" when "0111111100",
      "011000010110110000101000100111011001011110011101001101" when "0111111101",
      "011000011001101010100010011111011001010100111000100001" when "0111111110",
      "011000011100100100011000100111011001001011010010101011" when "0111111111",
      "011000011111011110001010111111011001000001101011101101" when "1000000000",
      "011000100010010111111001011111011000111000000011100110" when "1000000001",
      "011000100101010001100100001111011000101110011010010101" when "1000000010",
      "011000101000001011001011001111011000100100101111111100" when "1000000011",
      "011000101011000100101110011111011000011011000100011010" when "1000000100",
      "011000101101111110001101110111011000010001010111101111" when "1000000101",
      "011000110000110111101001010111011000000111101001111100" when "1000000110",
      "011000110011110001000001000111010111111101111010111111" when "1000000111",
      "011000110110101010010101000111010111110100001010111010" when "1000001000",
      "011000111001100011100101000111010111101010011001101100" when "1000001001",
      "011000111100011100110001010111010111100000100111010101" when "1000001010",
      "011000111111010101111001110111010111010110110011110110" when "1000001011",
      "011001000010001110111110010111010111001100111111001101" when "1000001100",
      "011001000101000111111110111111010111000011001001011101" when "1000001101",
      "011001001000000000111011110111010110111001010010100011" when "1000001110",
      "011001001010111001110100110111010110101111011010100001" when "1000001111",
      "011001001101110010101001110111010110100101100001010110" when "1000010000",
      "011001010000101011011011000111010110011011100111000011" when "1000010001",
      "011001010011100100001000010111010110010001101011100111" when "1000010010",
      "011001010110011100110001101111010110000111101111000011" when "1000010011",
      "011001011001010101010111001111010101111101110001010110" when "1000010100",
      "011001011100001101111000101111010101110011110010100001" when "1000010101",
      "011001011111000110010110010111010101101001110010100011" when "1000010110",
      "011001100001111110110000000111010101011111110001011101" when "1000010111",
      "011001100100110111000101110111010101010101101111001110" when "1000011000",
      "011001100111101111010111100111010101001011101011110111" when "1000011001",
      "011001101010100111100101011111010101000001100111011000" when "1000011010",
      "011001101101011111101111011111010100110111100001110000" when "1000011011",
      "011001110000010111110101010111010100101101011011000000" when "1000011100",
      "011001110011001111110111010111010100100011010011001000" when "1000011101",
      "011001110110000111110101010111010100011001001010000111" when "1000011110",
      "011001111000111111101111010111010100001110111111111111" when "1000011111",
      "011001111011110111100101010111010100000100110100101110" when "1000100000",
      "011001111110101111010111010111010011111010101000010101" when "1000100001",
      "011010000001100111000101010111010011110000011010110011" when "1000100010",
      "011010000100011110101111010111010011100110001100001010" when "1000100011",
      "011010000111010110010101010111010011011011111100011000" when "1000100100",
      "011010001010001101110111010111010011010001101011011111" when "1000100101",
      "011010001101000101010101001111010011000111011001011101" when "1000100110",
      "011010001111111100101111000111010010111101000110010011" when "1000100111",
      "011010010010110100000100110111010010110010110010000010" when "1000101000",
      "011010010101101011010110101111010010101000011100101000" when "1000101001",
      "011010011000100010100100010111010010011110000110000110" when "1000101010",
      "011010011011011001101101111111010010010011101110011101" when "1000101011",
      "011010011110010000110011100111010010001001010101101011" when "1000101100",
      "011010100001000111110101000111010001111110111011110010" when "1000101101",
      "011010100011111110110010011111010001110100100000110001" when "1000101110",
      "011010100110110101101011101111010001101010000100100111" when "1000101111",
      "011010101001101100100000111111010001011111100111010111" when "1000110000",
      "011010101100100011010001111111010001010101001000111110" when "1000110001",
      "011010101111011001111110111111010001001010101001011101" when "1000110010",
      "011010110010010000100111110111010001000000001000110101" when "1000110011",
      "011010110101000111001100100111010000110101100111000101" when "1000110100",
      "011010110111111101101101000111010000101011000100001110" when "1000110101",
      "011010111010110100001001100111010000100000100000001111" when "1000110110",
      "011010111101101010100001110111010000010101111011001000" when "1000110111",
      "011011000000100000110101111111010000001011010100111001" when "1000111000",
      "011011000011010111000101110111010000000000101101100011" when "1000111001",
      "011011000110001101010001101111001111110110000101000110" when "1000111010",
      "011011001001000011011001010111001111101011011011100000" when "1000111011",
      "011011001011111001011100101111001111100000110000110100" when "1000111100",
      "011011001110101111011011111111001111010110000101000000" when "1000111101",
      "011011010001100101010110111111001111001011011000000100" when "1000111110",
      "011011010100011011001101110111001111000000101010000001" when "1000111111",
      "011011010111010001000000010111001110110101111010110111" when "1001000000",
      "011011011010000110101110110111001110101011001010100101" when "1001000001",
      "011011011100111100011000111111001110100000011001001100" when "1001000010",
      "011011011111110001111110110111001110010101100110101011" when "1001000011",
      "011011100010100111100000100111001110001010110011000011" when "1001000100",
      "011011100101011100111101111111001101111111111110010100" when "1001000101",
      "011011101000010010010111001111001101110101001000011110" when "1001000110",
      "011011101011000111101100000111001101101010010001100001" when "1001000111",
      "011011101101111100111100101111001101011111011001011100" when "1001001000",
      "011011110000110010001001001111001101010100100000010000" when "1001001001",
      "011011110011100111010001001111001101001001100101111101" when "1001001010",
      "011011110110011100010101000111001100111110101010100011" when "1001001011",
      "011011111001010001010100100111001100110011101110000010" when "1001001100",
      "011011111100000110001111110111001100101000110000011010" when "1001001101",
      "011011111110111011000110101111001100011101110001101010" when "1001001110",
      "011100000001101111111001010111001100010010110001110100" when "1001001111",
      "011100000100100100100111100111001100000111110000110111" when "1001010000",
      "011100000111011001010001100111001011111100101110110010" when "1001010001",
      "011100001010001101110111000111001011110001101011100111" when "1001010010",
      "011100001101000010011000011111001011100110100111010101" when "1001010011",
      "011100001111110110110101010111001011011011100001111100" when "1001010100",
      "011100010010101011001101110111001011010000011011011100" when "1001010101",
      "011100010101011111100010000111001011000101010011110110" when "1001010110",
      "011100011000010011110001110111001010111010001011001000" when "1001010111",
      "011100011011000111111101010111001010101111000001010100" when "1001011000",
      "011100011101111100000100011111001010100011110110011001" when "1001011001",
      "011100100000110000000111000111001010011000101010010111" when "1001011010",
      "011100100011100100000101010111001010001101011101001111" when "1001011011",
      "011100100110010111111111001111001010000010001111000000" when "1001011100",
      "011100101001001011110100101111001001110110111111101010" when "1001011101",
      "011100101011111111100101101111001001101011101111001110" when "1001011110",
      "011100101110110011010010010111001001100000011101101011" when "1001011111",
      "011100110001100110111010100111001001010101001011000010" when "1001100000",
      "011100110100011010011110010111001001001001110111010010" when "1001100001",
      "011100110111001101111101101111001000111110100010011100" when "1001100010",
      "011100111010000001011000011111001000110011001100011111" when "1001100011",
      "011100111100110100101110111111001000100111110101011011" when "1001100100",
      "011100111111101000000000110111001000011100011101010010" when "1001100101",
      "011101000010011011001110010111001000010001000100000010" when "1001100110",
      "011101000101001110010111010111001000000101101001101011" when "1001100111",
      "011101001000000001011011110111000111111010001110001110" when "1001101000",
      "011101001010110100011011110111000111101110110001101011" when "1001101001",
      "011101001101100111010111010111000111100011010100000010" when "1001101010",
      "011101010000011010001110010111000111010111110101010010" when "1001101011",
      "011101010011001101000000110111000111001100010101011100" when "1001101100",
      "011101010101111111101110110111000111000000110100100000" when "1001101101",
      "011101011000110010011000010111000110110101010010011110" when "1001101110",
      "011101011011100100111101001111000110101001101111010101" when "1001101111",
      "011101011110010111011101100111000110011110001011000111" when "1001110000",
      "011101100001001001111001011111000110010010100101110010" when "1001110001",
      "011101100011111100010000101111000110000110111111011000" when "1001110010",
      "011101100110101110100011011111000101111011010111110111" when "1001110011",
      "011101101001100000110001100111000101101111101111010000" when "1001110100",
      "011101101100010010111011001111000101100100000101100100" when "1001110101",
      "011101101111000101000000001111000101011000011010110001" when "1001110110",
      "011101110001110111000000100111000101001100101110111001" when "1001110111",
      "011101110100101000111100011111000101000001000001111010" when "1001111000",
      "011101110111011010110011101111000100110101010011110110" when "1001111001",
      "011101111010001100100110010111000100101001100100101100" when "1001111010",
      "011101111100111110010100010111000100011101110100011100" when "1001111011",
      "011101111111101111111101101111000100010010000011000110" when "1001111100",
      "011110000010100001100010100111000100000110010000101011" when "1001111101",
      "011110000101010011000010101111000011111010011101001010" when "1001111110",
      "011110001000000100011110001111000011101110101000100011" when "1001111111",
      "011110001010110101110100111111000011100010110010110110" when "1010000000",
      "011110001101100111000111001111000011010110111100000100" when "1010000001",
      "011110010000011000010100101111000011001011000100001100" when "1010000010",
      "011110010011001001011101100111000010111111001011001111" when "1010000011",
      "011110010101111010100001110111000010110011010001001100" when "1010000100",
      "011110011000101011100001010111000010100111010110000100" when "1010000101",
      "011110011011011100011100001111000010011011011001110110" when "1010000110",
      "011110011110001101010010010111000010001111011100100011" when "1010000111",
      "011110100000111110000011110111000010000011011110001010" when "1010001000",
      "011110100011101110110000100111000001110111011110101100" when "1010001001",
      "011110100110011111011000100111000001101011011110001000" when "1010001010",
      "011110101001001111111011110111000001011111011100011111" when "1010001011",
      "011110101100000000011010011111000001010011011001110001" when "1010001100",
      "011110101110110000110100010111000001000111010101111110" when "1010001101",
      "011110110001100001001001011111000000111011010001000101" when "1010001110",
      "011110110100010001011001110111000000101111001011000111" when "1010001111",
      "011110110111000001100101011111000000100011000100000100" when "1010010000",
      "011110111001110001101100010111000000010110111011111011" when "1010010001",
      "011110111100100001101110010111000000001010110010101110" when "1010010010",
      "011110111111010001101011101110111111111110101000011011" when "1010010011",
      "011111000010000001100100001110111111110010011101000011" when "1010010100",
      "011111000100110001010111111110111111100110010000100111" when "1010010101",
      "011111000111100001000110111110111111011010000011000101" when "1010010110",
      "011111001010010000110001000110111111001101110100011110" when "1010010111",
      "011111001101000000010110011110111111000001100100110010" when "1010011000",
      "011111001111101111110110111110111110110101010100000010" when "1010011001",
      "011111010010011111010010101110111110101001000010001100" when "1010011010",
      "011111010101001110101001100110111110011100101111010010" when "1010011011",
      "011111010111111101111011101110111110010000011011010010" when "1010011100",
      "011111011010101101001000111110111110000100000110001110" when "1010011101",
      "011111011101011100010001010110111101110111110000000101" when "1010011110",
      "011111100000001011010100110110111101101011011000111000" when "1010011111",
      "011111100010111010010011100110111101011111000000100101" when "1010100000",
      "011111100101101001001101010110111101010010100111001110" when "1010100001",
      "011111101000011000000010010110111101000110001100110010" when "1010100010",
      "011111101011000110110010010110111100111001110001010010" when "1010100011",
      "011111101101110101011101100110111100101101010100101101" when "1010100100",
      "011111110000100100000011110110111100100000110111000011" when "1010100101",
      "011111110011010010100101001110111100010100011000010101" when "1010100110",
      "011111110110000001000001101110111100000111111000100010" when "1010100111",
      "011111111000101111011001010110111011111011010111101011" when "1010101000",
      "011111111011011101101011111110111011101110110101110000" when "1010101001",
      "011111111110001011111001101110111011100010010010110000" when "1010101010",
      "100000000000111010000010011110111011010101101110101011" when "1010101011",
      "100000000011101000000110010110111011001001001001100010" when "1010101100",
      "100000000110010110000101001110111010111100100011010101" when "1010101101",
      "100000001001000011111111001110111010101111111100000100" when "1010101110",
      "100000001011110001110100001110111010100011010011101110" when "1010101111",
      "100000001110011111100100010110111010010110101010010100" when "1010110000",
      "100000010001001101001111010110111010001001111111110110" when "1010110001",
      "100000010011111010110101011110111001111101010100010011" when "1010110010",
      "100000010110101000010110100110111001110000100111101101" when "1010110011",
      "100000011001010101110010101110111001100011111010000010" when "1010110100",
      "100000011100000011001001111110111001010111001011010011" when "1010110101",
      "100000011110110000011100000110111001001010011011100001" when "1010110110",
      "100000100001011101101001001110111000111101101010101010" when "1010110111",
      "100000100100001010110001010110111000110000111000101111" when "1010111000",
      "100000100110110111110100010110111000100100000101110000" when "1010111001",
      "100000101001100100110010011110111000010111010001101101" when "1010111010",
      "100000101100010001101011011110111000001010011100100111" when "1010111011",
      "100000101110111110011111011110110111111101100110011100" when "1010111100",
      "100000110001101011001110010110110111110000101111001110" when "1010111101",
      "100000110100010111111000001110110111100011110110111011" when "1010111110",
      "100000110111000100011101000110110111010110111101100101" when "1010111111",
      "100000111001110000111100110110110111001010000011001100" when "1011000000",
      "100000111100011101010111100110110110111101000111101110" when "1011000001",
      "100000111111001001101101000110110110110000001011001101" when "1011000010",
      "100001000001110101111101100110110110100011001101101000" when "1011000011",
      "100001000100100010001001000110110110010110001111000000" when "1011000100",
      "100001000111001110001111010110110110001001001111010011" when "1011000101",
      "100001001001111010010000100110110101111100001110100100" when "1011000110",
      "100001001100100110001100101110110101101111001100110001" when "1011000111",
      "100001001111010010000011101110110101100010001001111010" when "1011001000",
      "100001010001111101110101100110110101010101000110000000" when "1011001001",
      "100001010100101001100010001110110101001000000001000010" when "1011001010",
      "100001010111010101001001110110110100111010111011000001" when "1011001011",
      "100001011010000000101100010110110100101101110011111101" when "1011001100",
      "100001011100101100001001100110110100100000101011110101" when "1011001101",
      "100001011111010111100001101110110100010011100010101010" when "1011001110",
      "100001100010000010110100101110110100000110011000011100" when "1011001111",
      "100001100100101110000010011110110011111001001101001010" when "1011010000",
      "100001100111011001001011000110110011101100000000110101" when "1011010001",
      "100001101010000100001110011110110011011110110011011101" when "1011010010",
      "100001101100101111001100101110110011010001100101000010" when "1011010011",
      "100001101111011010000101110110110011000100010101100100" when "1011010100",
      "100001110010000100111001100110110010110111000101000011" when "1011010101",
      "100001110100101111101000001110110010101001110011011110" when "1011010110",
      "100001110111011010010001101110110010011100100000110111" when "1011010111",
      "100001111010000100110101110110110010001111001101001100" when "1011011000",
      "100001111100101111010100110110110010000001111000011111" when "1011011001",
      "100001111111011001101110100110110001110100100010101110" when "1011011010",
      "100010000010000100000011000110110001100111001011111011" when "1011011011",
      "100010000100101110010010010110110001011001110100000101" when "1011011100",
      "100010000111011000011100010110110001001100011011001100" when "1011011101",
      "100010001010000010100000111110110000111111000001010000" when "1011011110",
      "100010001100101100100000011110110000110001100110010010" when "1011011111",
      "100010001111010110011010100110110000100100001010010001" when "1011100000",
      "100010010010000000001111100110110000010110101101001101" when "1011100001",
      "100010010100101001111111001110110000001001001111000110" when "1011100010",
      "100010010111010011101001011110101111111011101111111101" when "1011100011",
      "100010011001111101001110011110101111101110001111110001" when "1011100100",
      "100010011100100110101110001110101111100000101110100010" when "1011100101",
      "100010011111010000001000100110101111010011001100010001" when "1011100110",
      "100010100001111001011101101110101111000101101000111110" when "1011100111",
      "100010100100100010101101011110101110111000000100101000" when "1011101000",
      "100010100111001011110111111110101110101010011111001111" when "1011101001",
      "100010101001110100111100111110101110011100111000110100" when "1011101010",
      "100010101100011101111100101110101110001111010001010111" when "1011101011",
      "100010101111000110110111001110101110000001101000110111" when "1011101100",
      "100010110001101111101100001110101101110011111111010101" when "1011101101",
      "100010110100011000011011110110101101100110010100110001" when "1011101110",
      "100010110111000001000110001110101101011000101001001011" when "1011101111",
      "100010111001101001101011000110101101001010111100100010" when "1011110000",
      "100010111100010010001010101110101100111101001110110111" when "1011110001",
      "100010111110111010100100110110101100101111100000001010" when "1011110010",
      "100011000001100010111001100110101100100001110000011011" when "1011110011",
      "100011000100001011001000111110101100010011111111101010" when "1011110100",
      "100011000110110011010010111110101100000110001101110111" when "1011110101",
      "100011001001011011010111011110101011111000011011000001" when "1011110110",
      "100011001100000011010110100110101011101010100111001010" when "1011110111",
      "100011001110101011010000010110101011011100110010010001" when "1011111000",
      "100011010001010011000100100110101011001110111100010110" when "1011111001",
      "100011010011111010110011010110101011000001000101011001" when "1011111010",
      "100011010110100010011100101110101010110011001101011010" when "1011111011",
      "100011011001001010000000101110101010100101010100011001" when "1011111100",
      "100011011011110001011111001110101010010111011010010111" when "1011111101",
      "100011011110011000111000001110101010001001011111010011" when "1011111110",
      "100011100001000000001011101110101001111011100011001101" when "1011111111",
      "100011100011100111011001110110101001101101100110000101" when "1100000000",
      "100011100110001110100010010110101001011111100111111100" when "1100000001",
      "100011101000110101100101011110101001010001101000110001" when "1100000010",
      "100011101011011100100011000110101001000011101000100100" when "1100000011",
      "100011101110000011011011000110101000110101100111010110" when "1100000100",
      "100011110000101010001101101110101000100111100101000111" when "1100000101",
      "100011110011010000111010101110101000011001100001110110" when "1100000110",
      "100011110101110111100010010110101000001011011101100011" when "1100000111",
      "100011111000011110000100010110100111111101011000001111" when "1100001000",
      "100011111011000100100000110110100111101111010001111010" when "1100001001",
      "100011111101101010110111101110100111100001001010100100" when "1100001010",
      "100100000000010001001001001110100111010011000010001100" when "1100001011",
      "100100000010110111010100111110100111000100111000110010" when "1100001100",
      "100100000101011101011011010110100110110110101110011000" when "1100001101",
      "100100001000000011011011111110100110101000100010111100" when "1100001110",
      "100100001010101001010111001110100110011010010110100000" when "1100001111",
      "100100001101001111001100101110100110001100001001000010" when "1100010000",
      "100100001111110100111100101110100101111101111010100010" when "1100010001",
      "100100010010011010100111000110100101101111101011000010" when "1100010010",
      "100100010101000000001011111110100101100001011010100001" when "1100010011",
      "100100010111100101101011000110100101010011001000111111" when "1100010100",
      "100100011010001011000100101110100101000100110110011100" when "1100010101",
      "100100011100110000011000101110100100110110100010111000" when "1100010110",
      "100100011111010101100111000110100100101000001110010011" when "1100010111",
      "100100100001111010101111110110100100011001111000101101" when "1100011000",
      "100100100100011111110010111110100100001011100010000110" when "1100011001",
      "100100100111000100110000010110100011111101001010011111" when "1100011010",
      "100100101001101001101000001110100011101110110001110110" when "1100011011",
      "100100101100001110011010010110100011100000011000001101" when "1100011100",
      "100100101110110011000110110110100011010001111101100100" when "1100011101",
      "100100110001010111101101101110100011000011100001111001" when "1100011110",
      "100100110011111100001110110110100010110101000101001111" when "1100011111",
      "100100110110100000101010010110100010100110100111100011" when "1100100000",
      "100100111001000101000000000110100010011000001000110111" when "1100100001",
      "100100111011101001010000001110100010001001101001001010" when "1100100010",
      "100100111110001101011010101110100001111011001000011101" when "1100100011",
      "100101000000110001011111011110100001101100100110110000" when "1100100100",
      "100101000011010101011110011110100001011110000100000010" when "1100100101",
      "100101000101111001010111101110100001001111100000010011" when "1100100110",
      "100101001000011101001011010110100001000000111011100101" when "1100100111",
      "100101001011000000111001001110100000110010010101110110" when "1100101000",
      "100101001101100100100001010110100000100011101111000110" when "1100101001",
      "100101010000001000000011101110100000010101000111010111" when "1100101010",
      "100101010010101011100000010110100000000110011110100111" when "1100101011",
      "100101010101001110110111001110011111110111110100110111" when "1100101100",
      "100101010111110010001000010110011111101001001010000111" when "1100101101",
      "100101011010010101010011101110011111011010011110010111" when "1100101110",
      "100101011100111000011001010110011111001011110001100111" when "1100101111",
      "100101011111011011011001000110011110111101000011110111" when "1100110000",
      "100101100001111110010011000110011110101110010101000111" when "1100110001",
      "100101100100100001000111010110011110011111100101010110" when "1100110010",
      "100101100111000011110101110110011110010000110100100110" when "1100110011",
      "100101101001100110011110011110011110000010000010110110" when "1100110100",
      "100101101100001001000001010110011101110011010000000111" when "1100110101",
      "100101101110101011011110011110011101100100011100010111" when "1100110110",
      "100101110001001101110101100110011101010101100111101000" when "1100110111",
      "100101110011110000000111000110011101000110110001111001" when "1100111000",
      "100101110110010010010010100110011100110111111011001010" when "1100111001",
      "100101111000110100011000010110011100101001000011011011" when "1100111010",
      "100101111011010110011000001110011100011010001010101101" when "1100111011",
      "100101111101111000010010001110011100001011010000111111" when "1100111100",
      "100110000000011010000110011110011011111100010110010010" when "1100111101",
      "100110000010111011110100101110011011101101011010100101" when "1100111110",
      "100110000101011101011101001110011011011110011101111001" when "1100111111",
      "100110000111111110111111110110011011001111100000001101" when "1101000000",
      "100110001010100000011100011110011011000000100001100010" when "1101000001",
      "100110001101000001110011010110011010110001100001110111" when "1101000010",
      "100110001111100011000100001110011010100010100001001101" when "1101000011",
      "100110010010000100001111010110011010010011011111100100" when "1101000100",
      "100110010100100101010100011110011010000100011100111100" when "1101000101",
      "100110010111000110010011100110011001110101011001010100" when "1101000110",
      "100110011001100111001100111110011001100110010100101101" when "1101000111",
      "100110011100001000000000010110011001010111001111000111" when "1101001000",
      "100110011110101000101101101110011001001000001000100010" when "1101001001",
      "100110100001001001010101001110011000111001000000111101" when "1101001010",
      "100110100011101001110110110110011000101001111000011010" when "1101001011",
      "100110100110001010010010011110011000011010101110111000" when "1101001100",
      "100110101000101010101000000110011000001011100100010110" when "1101001101",
      "100110101011001010110111110110010111111100011000110110" when "1101001110",
      "100110101101101011000001100110010111101101001100010111" when "1101001111",
      "100110110000001011000101011110010111011101111110111000" when "1101010000",
      "100110110010101011000011001110010111001110110000011100" when "1101010001",
      "100110110101001010111011000110010110111111100001000000" when "1101010010",
      "100110110111101010101100110110010110110000010000100101" when "1101010011",
      "100110111010001010011000101110010110100000111111001100" when "1101010100",
      "100110111100101001111110100110010110010001101100110100" when "1101010101",
      "100110111111001001011110011110010110000010011001011101" when "1101010110",
      "100111000001101000111000001110010101110011000101001000" when "1101010111",
      "100111000100001000001100000110010101100011101111110100" when "1101011000",
      "100111000110100111011001110110010101010100011001100010" when "1101011001",
      "100111001001000110100001100110010101000101000010010001" when "1101011010",
      "100111001011100101100011010110010100110101101010000010" when "1101011011",
      "100111001110000100011110111110010100100110010000110100" when "1101011100",
      "100111010000100011010100100110010100010110110110101000" when "1101011101",
      "100111010011000010000100001110010100000111011011011110" when "1101011110",
      "100111010101100000101101101110010011110111111111010101" when "1101011111",
      "100111010111111111010001000110010011101000100010001110" when "1101100000",
      "100111011010011101101110011110010011011001000100001000" when "1101100001",
      "100111011100111100000101110110010011001001100101000101" when "1101100010",
      "100111011111011010010111000110010010111010000101000011" when "1101100011",
      "100111100001111000100010000110010010101010100100000011" when "1101100100",
      "100111100100010110100111001110010010011011000010000101" when "1101100101",
      "100111100110110100100110000110010010001011011111001001" when "1101100110",
      "100111101001010010011110111110010001111011111011001111" when "1101100111",
      "100111101011110000010001100110010001101100010110010111" when "1101101000",
      "100111101110001101111110001110010001011100110000100001" when "1101101001",
      "100111110000101011100100101110010001001101001001101110" when "1101101010",
      "100111110011001001000100111110010000111101100001111100" when "1101101011",
      "100111110101100110011111001110010000101101111001001100" when "1101101100",
      "100111111000000011110011001110010000011110001111011111" when "1101101101",
      "100111111010100001000001000110010000001110100100110100" when "1101101110",
      "100111111100111110001000110110001111111110111001001011" when "1101101111",
      "100111111111011011001010011110001111101111001100100100" when "1101110000",
      "101000000001111000000101110110001111011111011111000000" when "1101110001",
      "101000000100010100111011000110001111001111110000011111" when "1101110010",
      "101000000110110001101010001110001111000000000000111111" when "1101110011",
      "101000001001001110010011000110001110110000010000100010" when "1101110100",
      "101000001011101010110101101110001110100000011111001000" when "1101110101",
      "101000001110000111010010001110001110010000101100110000" when "1101110110",
      "101000010000100011101000011110001110000000111001011011" when "1101110111",
      "101000010010111111111000100110001101110001000101001000" when "1101111000",
      "101000010101011100000010011110001101100001001111111000" when "1101111001",
      "101000010111111000000110000110001101010001011001101011" when "1101111010",
      "101000011010010100000011011110001101000001100010100001" when "1101111011",
      "101000011100101111111010101110001100110001101010011001" when "1101111100",
      "101000011111001011101011100110001100100001110001010100" when "1101111101",
      "101000100001100111010110010110001100010001110111010010" when "1101111110",
      "101000100100000010111010110110001100000001111100010011" when "1101111111",
      "101000100110011110011000111110001011110010000000010110" when "1110000000",
      "101000101000111001110000111110001011100010000011011101" when "1110000001",
      "101000101011010101000010100110001011010010000101100111" when "1110000010",
      "101000101101110000001101111110001011000010000110110100" when "1110000011",
      "101000110000001011010011000110001010110010000111000011" when "1110000100",
      "101000110010100110010001111110001010100010000110010110" when "1110000101",
      "101000110101000001001010011110001010010010000100101100" when "1110000110",
      "101000110111011011111100101110001010000010000010000110" when "1110000111",
      "101000111001110110101000101110001001110001111110100010" when "1110001000",
      "101000111100010001001110010110001001100001111010000010" when "1110001001",
      "101000111110101011101101100110001001010001110100100101" when "1110001010",
      "101001000001000110000110100110001001000001101110001100" when "1110001011",
      "101001000011100000011001010110001000110001100110110110" when "1110001100",
      "101001000101111010100101101110001000100001011110100011" when "1110001101",
      "101001001000010100101011101110001000010001010101010100" when "1110001110",
      "101001001010101110101011010110001000000001001011001000" when "1110001111",
      "101001001101001000100100101110000111110001000000000000" when "1110010000",
      "101001001111100010010111100110000111100000110011111011" when "1110010001",
      "101001010001111100000100001110000111010000100110111010" when "1110010010",
      "101001010100010101101010011110000111000000011000111101" when "1110010011",
      "101001010110101111001010010110000110110000001010000011" when "1110010100",
      "101001011001001000100011110110000110011111111010001101" when "1110010101",
      "101001011011100001110110111110000110001111101001011011" when "1110010110",
      "101001011101111011000011101110000101111111010111101101" when "1110010111",
      "101001100000010100001001111110000101101111000101000011" when "1110011000",
      "101001100010101101001001110110000101011110110001011100" when "1110011001",
      "101001100101000110000011011110000101001110011100111001" when "1110011010",
      "101001100111011110110110011110000100111110000111011011" when "1110011011",
      "101001101001110111100011001110000100101101110001000000" when "1110011100",
      "101001101100010000001001011110000100011101011001101010" when "1110011101",
      "101001101110101000101001010110000100001101000001010111" when "1110011110",
      "101001110001000001000010101110000011111100101000001001" when "1110011111",
      "101001110011011001010101101110000011101100001101111111" when "1110100000",
      "101001110101110001100010001110000011011011110010111001" when "1110100001",
      "101001111000001001101000001110000011001011010110110111" when "1110100010",
      "101001111010100001100111110110000010111010111001111010" when "1110100011",
      "101001111100111001100000111110000010101010011100000001" when "1110100100",
      "101001111111010001010011100110000010011001111101001100" when "1110100101",
      "101010000001101000111111110110000010001001011101011100" when "1110100110",
      "101010000100000000100101100110000001111000111100110000" when "1110100111",
      "101010000110011000000100101110000001101000011011001001" when "1110101000",
      "101010001000101111011101011110000001010111111000100110" when "1110101001",
      "101010001011000110101111101110000001000111010101001000" when "1110101010",
      "101010001101011101111011011110000000110110110000101110" when "1110101011",
      "101010001111110101000000101110000000100110001011011001" when "1110101100",
      "101010010010001011111111010110000000010101100101001001" when "1110101101",
      "101010010100100010110111100110000000000100111101111110" when "1110101110",
      "101010010110111001101001001101111111110100010101110111" when "1110101111",
      "101010011001010000010100010101111111100011101100110101" when "1110110000",
      "101010011011100110111000111101111111010011000010111000" when "1110110001",
      "101010011101111101010110111101111111000010011000000000" when "1110110010",
      "101010100000010011101110011101111110110001101100001100" when "1110110011",
      "101010100010101001111111011101111110100000111111011110" when "1110110100",
      "101010100101000000001001110101111110010000010001110101" when "1110110101",
      "101010100111010110001101100101111101111111100011010000" when "1110110110",
      "101010101001101100001010110101111101101110110011110001" when "1110110111",
      "101010101100000010000001011101111101011110000011010111" when "1110111000",
      "101010101110010111110001100101111101001101010010000010" when "1110111001",
      "101010110000101101011011000101111100111100011111110011" when "1110111010",
      "101010110011000010111101111101111100101011101100101000" when "1110111011",
      "101010110101011000011010010101111100011010111000100011" when "1110111100",
      "101010110111101101101111111101111100001010000011100100" when "1110111101",
      "101010111010000010111111000101111011111001001101101001" when "1110111110",
      "101010111100011000000111100101111011101000010110110100" when "1110111111",
      "101010111110101101001001010101111011010111011111000101" when "1111000000",
      "101011000001000010000100100101111011000110100110011011" when "1111000001",
      "101011000011010110111001001101111010110101101100110110" when "1111000010",
      "101011000101101011100111000101111010100100110010010111" when "1111000011",
      "101011001000000000001110011101111010010011110110111110" when "1111000100",
      "101011001010010100101111000101111010000010111010101011" when "1111000101",
      "101011001100101001001001000101111001110001111101011101" when "1111000110",
      "101011001110111101011100010101111001100000111111010100" when "1111000111",
      "101011010001010001101001000101111001010000000000010010" when "1111001000",
      "101011010011100101101111000101111000111111000000010101" when "1111001001",
      "101011010101111001101110010101111000101101111111011111" when "1111001010",
      "101011011000001101100110111101111000011100111101101110" when "1111001011",
      "101011011010100001011000111101111000001011111011000011" when "1111001100",
      "101011011100110101000100001101110111111010110111011110" when "1111001101",
      "101011011111001000101000101101110111101001110010111111" when "1111001110",
      "101011100001011100000110100101110111011000101101100111" when "1111001111",
      "101011100011101111011101101101110111000111100111010100" when "1111010000",
      "101011100110000010101110000101110110110110100000001000" when "1111010001",
      "101011101000010101110111101101110110100101011000000001" when "1111010010",
      "101011101010101000111010101101110110010100001111000001" when "1111010011",
      "101011101100111011110110111101110110000011000101000111" when "1111010100",
      "101011101111001110101100011101110101110001111010010100" when "1111010101",
      "101011110001100001011011001101110101100000101110100111" when "1111010110",
      "101011110011110100000011001101110101001111100010000000" when "1111010111",
      "101011110110000110100100010101110100111110010100100000" when "1111011000",
      "101011111000011000111110110101110100101101000110000110" when "1111011001",
      "101011111010101011010010100101110100011011110110110011" when "1111011010",
      "101011111100111101011111011101110100001010100110100110" when "1111011011",
      "101011111111001111100101100101110011111001010101100000" when "1111011100",
      "101100000001100001100100111101110011101000000011100000" when "1111011101",
      "101100000011110011011101100101110011010110110000101000" when "1111011110",
      "101100000110000101001111010101110011000101011100110110" when "1111011111",
      "101100001000010110111010010101110010110100001000001010" when "1111100000",
      "101100001010101000011110100101110010100010110010100110" when "1111100001",
      "101100001100111001111011111101110010010001011100001000" when "1111100010",
      "101100001111001011010010011101110010000000000100110010" when "1111100011",
      "101100010001011100100010001101110001101110101100100010" when "1111100100",
      "101100010011101101101011000101110001011101010011011001" when "1111100101",
      "101100010101111110101101001101110001001011111001010111" when "1111100110",
      "101100011000001111101000011101110000111010011110011101" when "1111100111",
      "101100011010100000011100110101110000101001000010101001" when "1111101000",
      "101100011100110001001010010101110000010111100101111101" when "1111101001",
      "101100011111000001110000111101110000000110001000011000" when "1111101010",
      "101100100001010010010000110101101111110100101001111010" when "1111101011",
      "101100100011100010101001110101101111100011001010100011" when "1111101100",
      "101100100101110010111011110101101111010001101010010100" when "1111101101",
      "101100101000000011000111000101101111000000001001001100" when "1111101110",
      "101100101010010011001011011101101110101110100111001011" when "1111101111",
      "101100101100100011001000110101101110011101000100010010" when "1111110000",
      "101100101110110010111111011101101110001011100000100000" when "1111110001",
      "101100110001000010101111000101101101111001111011110110" when "1111110010",
      "101100110011010010010111110101101101101000010110010011" when "1111110011",
      "101100110101100001111001101101101101010110101111111000" when "1111110100",
      "101100110111110001010100100101101101000101001000100101" when "1111110101",
      "101100111010000000101000100101101100110011100000011001" when "1111110110",
      "101100111100001111110101101101101100100001110111010110" when "1111110111",
      "101100111110011110111011110101101100010000001101011010" when "1111111000",
      "101101000000101101111011000101101011111110100010100101" when "1111111001",
      "101101000010111100110011010101101011101100110110111001" when "1111111010",
      "101101000101001011100100100101101011011011001010010100" when "1111111011",
      "101101000111011010001110111101101011001001011100111000" when "1111111100",
      "101101001001101000110010011101101010110111101110100011" when "1111111101",
      "101101001011110111001110110101101010100101111111010111" when "1111111110",
      "101101001110000101100100010101101010010100001111010011" when "1111111111",
      "------------------------------------------------------" when others;
Y1 <= Y0; -- for the possible blockram register
   Y <= Y1;
end architecture;

--------------------------------------------------------------------------------
--                            IntAdder_19_F0_uid25
-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: Bogdan Pasca, Florent de Dinechin (2008-2016)
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X Y Cin
-- Output signals: R

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library std;
use std.textio.all;
library work;

entity IntAdder_19_F0_uid25 is
    port (X : in  std_logic_vector(18 downto 0);
          Y : in  std_logic_vector(18 downto 0);
          Cin : in  std_logic;
          R : out  std_logic_vector(18 downto 0)   );
end entity;

architecture arch of IntAdder_19_F0_uid25 is
signal Rtmp :  std_logic_vector(18 downto 0);
begin
   Rtmp <= X + Y + Cin;
   R <= Rtmp;
end architecture;

--------------------------------------------------------------------------------
--                             FixRealKCM_F0_uid6
-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: Florent de Dinechin (2007-2016)
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X
-- Output signals: R

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
library std;
use std.textio.all;
library work;

entity FixRealKCM_F0_uid6 is
    port (X : in  std_logic_vector(14 downto 0);
          R : out  std_logic_vector(16 downto 0)   );
end entity;

architecture arch of FixRealKCM_F0_uid6 is
   component FixRealKCM_F0_uid6_T0_F0_uid9 is
      port ( X : in  std_logic_vector(4 downto 0);
             Y : out  std_logic_vector(18 downto 0)   );
   end component;

   component FixRealKCM_F0_uid6_T1_F0_uid11 is
      port ( X : in  std_logic_vector(4 downto 0);
             Y : out  std_logic_vector(13 downto 0)   );
   end component;

   component FixRealKCM_F0_uid6_T2_F0_uid13 is
      port ( X : in  std_logic_vector(4 downto 0);
             Y : out  std_logic_vector(8 downto 0)   );
   end component;

   component Compressor_23_3_F0_uid16 is
      port ( X1 : in  std_logic_vector(1 downto 0);
             X0 : in  std_logic_vector(2 downto 0);
             R : out  std_logic_vector(2 downto 0)   );
   end component;

   component IntAdder_19_F0_uid25 is
      port ( X : in  std_logic_vector(18 downto 0);
             Y : in  std_logic_vector(18 downto 0);
             Cin : in  std_logic;
             R : out  std_logic_vector(18 downto 0)   );
   end component;

signal FixRealKCM_F0_uid6_A0 :  std_logic_vector(4 downto 0);
signal FixRealKCM_F0_uid6_T0 :  std_logic_vector(18 downto 0);
signal bh7_w0_0 :  std_logic;
signal bh7_w1_0 :  std_logic;
signal bh7_w2_0 :  std_logic;
signal bh7_w3_0 :  std_logic;
signal bh7_w4_0 :  std_logic;
signal bh7_w5_0 :  std_logic;
signal bh7_w6_0 :  std_logic;
signal bh7_w7_0 :  std_logic;
signal bh7_w8_0 :  std_logic;
signal bh7_w9_0 :  std_logic;
signal bh7_w10_0 :  std_logic;
signal bh7_w11_0 :  std_logic;
signal bh7_w12_0 :  std_logic;
signal bh7_w13_0 :  std_logic;
signal bh7_w14_0 :  std_logic;
signal bh7_w15_0 :  std_logic;
signal bh7_w16_0 :  std_logic;
signal bh7_w17_0 :  std_logic;
signal bh7_w18_0 :  std_logic;
signal FixRealKCM_F0_uid6_A1 :  std_logic_vector(4 downto 0);
signal FixRealKCM_F0_uid6_T1 :  std_logic_vector(13 downto 0);
signal bh7_w0_1 :  std_logic;
signal bh7_w1_1 :  std_logic;
signal bh7_w2_1 :  std_logic;
signal bh7_w3_1 :  std_logic;
signal bh7_w4_1 :  std_logic;
signal bh7_w5_1 :  std_logic;
signal bh7_w6_1 :  std_logic;
signal bh7_w7_1 :  std_logic;
signal bh7_w8_1 :  std_logic;
signal bh7_w9_1 :  std_logic;
signal bh7_w10_1 :  std_logic;
signal bh7_w11_1 :  std_logic;
signal bh7_w12_1 :  std_logic;
signal bh7_w13_1 :  std_logic;
signal FixRealKCM_F0_uid6_A2 :  std_logic_vector(4 downto 0);
signal FixRealKCM_F0_uid6_T2 :  std_logic_vector(8 downto 0);
signal bh7_w0_2 :  std_logic;
signal bh7_w1_2 :  std_logic;
signal bh7_w2_2 :  std_logic;
signal bh7_w3_2 :  std_logic;
signal bh7_w4_2 :  std_logic;
signal bh7_w5_2 :  std_logic;
signal bh7_w6_2 :  std_logic;
signal bh7_w7_2 :  std_logic;
signal bh7_w8_2 :  std_logic;
signal Compressor_23_3_F0_uid16_bh7_uid17_In0 :  std_logic_vector(2 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid17_In1 :  std_logic_vector(1 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid17_Out0 :  std_logic_vector(2 downto 0);
signal bh7_w0_3 :  std_logic;
signal bh7_w1_3 :  std_logic;
signal bh7_w2_3 :  std_logic;
signal Compressor_23_3_F0_uid16_bh7_uid18_In0 :  std_logic_vector(2 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid18_In1 :  std_logic_vector(1 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid18_Out0 :  std_logic_vector(2 downto 0);
signal bh7_w2_4 :  std_logic;
signal bh7_w3_3 :  std_logic;
signal bh7_w4_3 :  std_logic;
signal Compressor_23_3_F0_uid16_bh7_uid19_In0 :  std_logic_vector(2 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid19_In1 :  std_logic_vector(1 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid19_Out0 :  std_logic_vector(2 downto 0);
signal bh7_w4_4 :  std_logic;
signal bh7_w5_3 :  std_logic;
signal bh7_w6_3 :  std_logic;
signal Compressor_23_3_F0_uid16_bh7_uid20_In0 :  std_logic_vector(2 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid20_In1 :  std_logic_vector(1 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid20_Out0 :  std_logic_vector(2 downto 0);
signal bh7_w6_4 :  std_logic;
signal bh7_w7_3 :  std_logic;
signal bh7_w8_3 :  std_logic;
signal Compressor_23_3_F0_uid16_bh7_uid21_In0 :  std_logic_vector(2 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid21_In1 :  std_logic_vector(1 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid21_Out0 :  std_logic_vector(2 downto 0);
signal bh7_w8_4 :  std_logic;
signal bh7_w9_2 :  std_logic;
signal bh7_w10_2 :  std_logic;
signal Compressor_23_3_F0_uid16_bh7_uid22_In0 :  std_logic_vector(2 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid22_In1 :  std_logic_vector(1 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid22_Out0 :  std_logic_vector(2 downto 0);
signal bh7_w10_3 :  std_logic;
signal bh7_w11_2 :  std_logic;
signal bh7_w12_2 :  std_logic;
signal Compressor_23_3_F0_uid16_bh7_uid23_In0 :  std_logic_vector(2 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid23_In1 :  std_logic_vector(1 downto 0);
signal Compressor_23_3_F0_uid16_bh7_uid23_Out0 :  std_logic_vector(2 downto 0);
signal bh7_w12_3 :  std_logic;
signal bh7_w13_2 :  std_logic;
signal bh7_w14_1 :  std_logic;
signal tmp_bitheapResult_bh7_0 :  std_logic_vector(0 downto 0);
signal bitheapFinalAdd_bh7_In0 :  std_logic_vector(18 downto 0);
signal bitheapFinalAdd_bh7_In1 :  std_logic_vector(18 downto 0);
signal bitheapFinalAdd_bh7_Cin :  std_logic;
signal bitheapFinalAdd_bh7_Out :  std_logic_vector(18 downto 0);
signal bitheapResult_bh7 :  std_logic_vector(18 downto 0);
signal OutRes :  std_logic_vector(18 downto 0);
begin
-- This operator multiplies by pi
   FixRealKCM_F0_uid6_A0 <= X(14 downto 10);-- input address  m=-13  l=-17
   FixRealKCM_F0_uid6_Table0: FixRealKCM_F0_uid6_T0_F0_uid9
      port map ( X => FixRealKCM_F0_uid6_A0,
                 Y => FixRealKCM_F0_uid6_T0);
   bh7_w0_0 <= FixRealKCM_F0_uid6_T0(0);
   bh7_w1_0 <= FixRealKCM_F0_uid6_T0(1);
   bh7_w2_0 <= FixRealKCM_F0_uid6_T0(2);
   bh7_w3_0 <= FixRealKCM_F0_uid6_T0(3);
   bh7_w4_0 <= FixRealKCM_F0_uid6_T0(4);
   bh7_w5_0 <= FixRealKCM_F0_uid6_T0(5);
   bh7_w6_0 <= FixRealKCM_F0_uid6_T0(6);
   bh7_w7_0 <= FixRealKCM_F0_uid6_T0(7);
   bh7_w8_0 <= FixRealKCM_F0_uid6_T0(8);
   bh7_w9_0 <= FixRealKCM_F0_uid6_T0(9);
   bh7_w10_0 <= FixRealKCM_F0_uid6_T0(10);
   bh7_w11_0 <= FixRealKCM_F0_uid6_T0(11);
   bh7_w12_0 <= FixRealKCM_F0_uid6_T0(12);
   bh7_w13_0 <= FixRealKCM_F0_uid6_T0(13);
   bh7_w14_0 <= FixRealKCM_F0_uid6_T0(14);
   bh7_w15_0 <= FixRealKCM_F0_uid6_T0(15);
   bh7_w16_0 <= FixRealKCM_F0_uid6_T0(16);
   bh7_w17_0 <= FixRealKCM_F0_uid6_T0(17);
   bh7_w18_0 <= FixRealKCM_F0_uid6_T0(18);
   FixRealKCM_F0_uid6_A1 <= X(9 downto 5);-- input address  m=-18  l=-22
   FixRealKCM_F0_uid6_Table1: FixRealKCM_F0_uid6_T1_F0_uid11
      port map ( X => FixRealKCM_F0_uid6_A1,
                 Y => FixRealKCM_F0_uid6_T1);
   bh7_w0_1 <= FixRealKCM_F0_uid6_T1(0);
   bh7_w1_1 <= FixRealKCM_F0_uid6_T1(1);
   bh7_w2_1 <= FixRealKCM_F0_uid6_T1(2);
   bh7_w3_1 <= FixRealKCM_F0_uid6_T1(3);
   bh7_w4_1 <= FixRealKCM_F0_uid6_T1(4);
   bh7_w5_1 <= FixRealKCM_F0_uid6_T1(5);
   bh7_w6_1 <= FixRealKCM_F0_uid6_T1(6);
   bh7_w7_1 <= FixRealKCM_F0_uid6_T1(7);
   bh7_w8_1 <= FixRealKCM_F0_uid6_T1(8);
   bh7_w9_1 <= FixRealKCM_F0_uid6_T1(9);
   bh7_w10_1 <= FixRealKCM_F0_uid6_T1(10);
   bh7_w11_1 <= FixRealKCM_F0_uid6_T1(11);
   bh7_w12_1 <= FixRealKCM_F0_uid6_T1(12);
   bh7_w13_1 <= FixRealKCM_F0_uid6_T1(13);
   FixRealKCM_F0_uid6_A2 <= X(4 downto 0);-- input address  m=-23  l=-27
   FixRealKCM_F0_uid6_Table2: FixRealKCM_F0_uid6_T2_F0_uid13
      port map ( X => FixRealKCM_F0_uid6_A2,
                 Y => FixRealKCM_F0_uid6_T2);
   bh7_w0_2 <= FixRealKCM_F0_uid6_T2(0);
   bh7_w1_2 <= FixRealKCM_F0_uid6_T2(1);
   bh7_w2_2 <= FixRealKCM_F0_uid6_T2(2);
   bh7_w3_2 <= FixRealKCM_F0_uid6_T2(3);
   bh7_w4_2 <= FixRealKCM_F0_uid6_T2(4);
   bh7_w5_2 <= FixRealKCM_F0_uid6_T2(5);
   bh7_w6_2 <= FixRealKCM_F0_uid6_T2(6);
   bh7_w7_2 <= FixRealKCM_F0_uid6_T2(7);
   bh7_w8_2 <= FixRealKCM_F0_uid6_T2(8);

   -- Adding the constant bits 
      -- All the constant bits are zero, nothing to add


   Compressor_23_3_F0_uid16_bh7_uid17_In0 <= "" & bh7_w0_2 & bh7_w0_1 & bh7_w0_0;
   Compressor_23_3_F0_uid16_bh7_uid17_In1 <= "" & bh7_w1_2 & bh7_w1_1;
   Compressor_23_3_F0_uid16_uid17: Compressor_23_3_F0_uid16
      port map ( X0 => Compressor_23_3_F0_uid16_bh7_uid17_In0,
                 X1 => Compressor_23_3_F0_uid16_bh7_uid17_In1,
                 R => Compressor_23_3_F0_uid16_bh7_uid17_Out0);

   bh7_w0_3 <= Compressor_23_3_F0_uid16_bh7_uid17_Out0(0);
   bh7_w1_3 <= Compressor_23_3_F0_uid16_bh7_uid17_Out0(1);
   bh7_w2_3 <= Compressor_23_3_F0_uid16_bh7_uid17_Out0(2);

   Compressor_23_3_F0_uid16_bh7_uid18_In0 <= "" & bh7_w2_2 & bh7_w2_1 & bh7_w2_0;
   Compressor_23_3_F0_uid16_bh7_uid18_In1 <= "" & bh7_w3_2 & bh7_w3_1;
   Compressor_23_3_F0_uid16_uid18: Compressor_23_3_F0_uid16
      port map ( X0 => Compressor_23_3_F0_uid16_bh7_uid18_In0,
                 X1 => Compressor_23_3_F0_uid16_bh7_uid18_In1,
                 R => Compressor_23_3_F0_uid16_bh7_uid18_Out0);

   bh7_w2_4 <= Compressor_23_3_F0_uid16_bh7_uid18_Out0(0);
   bh7_w3_3 <= Compressor_23_3_F0_uid16_bh7_uid18_Out0(1);
   bh7_w4_3 <= Compressor_23_3_F0_uid16_bh7_uid18_Out0(2);

   Compressor_23_3_F0_uid16_bh7_uid19_In0 <= "" & bh7_w4_2 & bh7_w4_1 & bh7_w4_0;
   Compressor_23_3_F0_uid16_bh7_uid19_In1 <= "" & bh7_w5_2 & bh7_w5_1;
   Compressor_23_3_F0_uid16_uid19: Compressor_23_3_F0_uid16
      port map ( X0 => Compressor_23_3_F0_uid16_bh7_uid19_In0,
                 X1 => Compressor_23_3_F0_uid16_bh7_uid19_In1,
                 R => Compressor_23_3_F0_uid16_bh7_uid19_Out0);

   bh7_w4_4 <= Compressor_23_3_F0_uid16_bh7_uid19_Out0(0);
   bh7_w5_3 <= Compressor_23_3_F0_uid16_bh7_uid19_Out0(1);
   bh7_w6_3 <= Compressor_23_3_F0_uid16_bh7_uid19_Out0(2);

   Compressor_23_3_F0_uid16_bh7_uid20_In0 <= "" & bh7_w6_2 & bh7_w6_1 & bh7_w6_0;
   Compressor_23_3_F0_uid16_bh7_uid20_In1 <= "" & bh7_w7_2 & bh7_w7_1;
   Compressor_23_3_F0_uid16_uid20: Compressor_23_3_F0_uid16
      port map ( X0 => Compressor_23_3_F0_uid16_bh7_uid20_In0,
                 X1 => Compressor_23_3_F0_uid16_bh7_uid20_In1,
                 R => Compressor_23_3_F0_uid16_bh7_uid20_Out0);

   bh7_w6_4 <= Compressor_23_3_F0_uid16_bh7_uid20_Out0(0);
   bh7_w7_3 <= Compressor_23_3_F0_uid16_bh7_uid20_Out0(1);
   bh7_w8_3 <= Compressor_23_3_F0_uid16_bh7_uid20_Out0(2);

   Compressor_23_3_F0_uid16_bh7_uid21_In0 <= "" & bh7_w8_2 & bh7_w8_1 & bh7_w8_0;
   Compressor_23_3_F0_uid16_bh7_uid21_In1 <= "" & bh7_w9_1 & bh7_w9_0;
   Compressor_23_3_F0_uid16_uid21: Compressor_23_3_F0_uid16
      port map ( X0 => Compressor_23_3_F0_uid16_bh7_uid21_In0,
                 X1 => Compressor_23_3_F0_uid16_bh7_uid21_In1,
                 R => Compressor_23_3_F0_uid16_bh7_uid21_Out0);

   bh7_w8_4 <= Compressor_23_3_F0_uid16_bh7_uid21_Out0(0);
   bh7_w9_2 <= Compressor_23_3_F0_uid16_bh7_uid21_Out0(1);
   bh7_w10_2 <= Compressor_23_3_F0_uid16_bh7_uid21_Out0(2);

   Compressor_23_3_F0_uid16_bh7_uid22_In0 <= "" & bh7_w10_1 & bh7_w10_0 & "0";
   Compressor_23_3_F0_uid16_bh7_uid22_In1 <= "" & bh7_w11_1 & bh7_w11_0;
   Compressor_23_3_F0_uid16_uid22: Compressor_23_3_F0_uid16
      port map ( X0 => Compressor_23_3_F0_uid16_bh7_uid22_In0,
                 X1 => Compressor_23_3_F0_uid16_bh7_uid22_In1,
                 R => Compressor_23_3_F0_uid16_bh7_uid22_Out0);

   bh7_w10_3 <= Compressor_23_3_F0_uid16_bh7_uid22_Out0(0);
   bh7_w11_2 <= Compressor_23_3_F0_uid16_bh7_uid22_Out0(1);
   bh7_w12_2 <= Compressor_23_3_F0_uid16_bh7_uid22_Out0(2);

   Compressor_23_3_F0_uid16_bh7_uid23_In0 <= "" & bh7_w12_1 & bh7_w12_0 & "0";
   Compressor_23_3_F0_uid16_bh7_uid23_In1 <= "" & bh7_w13_1 & bh7_w13_0;
   Compressor_23_3_F0_uid16_uid23: Compressor_23_3_F0_uid16
      port map ( X0 => Compressor_23_3_F0_uid16_bh7_uid23_In0,
                 X1 => Compressor_23_3_F0_uid16_bh7_uid23_In1,
                 R => Compressor_23_3_F0_uid16_bh7_uid23_Out0);

   bh7_w12_3 <= Compressor_23_3_F0_uid16_bh7_uid23_Out0(0);
   bh7_w13_2 <= Compressor_23_3_F0_uid16_bh7_uid23_Out0(1);
   bh7_w14_1 <= Compressor_23_3_F0_uid16_bh7_uid23_Out0(2);
   tmp_bitheapResult_bh7_0(0) <= bh7_w0_3;

   bitheapFinalAdd_bh7_In0 <= "0" & bh7_w18_0 & bh7_w17_0 & bh7_w16_0 & bh7_w15_0 & bh7_w14_1 & bh7_w13_2 & bh7_w12_3 & bh7_w11_2 & bh7_w10_3 & bh7_w9_2 & bh7_w8_4 & bh7_w7_3 & bh7_w6_4 & bh7_w5_3 & bh7_w4_4 & bh7_w3_3 & bh7_w2_4 & bh7_w1_3;
   bitheapFinalAdd_bh7_In1 <= "0" & "0" & "0" & "0" & "0" & bh7_w14_0 & "0" & bh7_w12_2 & "0" & bh7_w10_2 & "0" & bh7_w8_3 & bh7_w7_0 & bh7_w6_3 & bh7_w5_0 & bh7_w4_3 & bh7_w3_0 & bh7_w2_3 & bh7_w1_0;
   bitheapFinalAdd_bh7_Cin <= '0';

   bitheapFinalAdd_bh7: IntAdder_19_F0_uid25
      port map ( Cin => bitheapFinalAdd_bh7_Cin,
                 X => bitheapFinalAdd_bh7_In0,
                 Y => bitheapFinalAdd_bh7_In1,
                 R => bitheapFinalAdd_bh7_Out);
   bitheapResult_bh7 <= bitheapFinalAdd_bh7_Out(17 downto 0) & tmp_bitheapResult_bh7_0;
   OutRes <= bitheapResult_bh7(18 downto 0);
   R <= OutRes(18 downto 2);
end architecture;

--------------------------------------------------------------------------------
--                                  SinCos24
--                       (FixSinCosPoly_LSBm23_F0_uid2)
-- VHDL generated for Kintex7 @ 0MHz
-- This operator is part of the Infinite Virtual Library FloPoCoLib
-- All rights reserved 
-- Authors: Florent de Dinechin, Antoine Martinet, Guillaume Sergent, (2013-2019)
--------------------------------------------------------------------------------
-- combinatorial
-- Clock period (ns): inf
-- Target frequency (MHz): 0
-- Input signals: X
-- Output signals: S C

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use work.fixed_pkg.all;
library std;
use std.textio.all;
library work;

entity SinCos24 is
    port (input : in   sfixed(1 downto -22);   --std_logic_vector(23 downto 0);
          SIN : out  sfixed(0 downto -23);
          COS : out  sfixed(0 downto -23));
end entity;

architecture arch of SinCos24 is
   component sinCosPiATable_F0_uid4 is
      port ( X : in  std_logic_vector(9 downto 0);
             Y : out  std_logic_vector(53 downto 0)   );
   end component;

   component FixRealKCM_F0_uid6 is
      port ( X : in  std_logic_vector(14 downto 0);
             R : out  std_logic_vector(16 downto 0)   );
   end component;

   component FixFunctionByTable_F0_uid27 is
      port ( X : in  std_logic_vector(5 downto 0);
             Y : out  std_logic_vector(6 downto 0)   );
   end component;

signal X_sgn :  std_logic;
signal Q :  std_logic;
signal O :  std_logic;
signal Y :  std_logic_vector(20 downto 0);
signal Yneg :  std_logic_vector(24 downto 0);
signal A :  std_logic_vector(9 downto 0);
signal Y_red :  std_logic_vector(14 downto 0);
signal SCA :  std_logic_vector(53 downto 0);
signal SinPiA :  std_logic_vector(26 downto 0);
signal CosPiA :  std_logic_vector(26 downto 0);
signal Z :  std_logic_vector(16 downto 0);
signal Z_trunc_for_square :  std_logic_vector(5 downto 0);
signal Z2o2_w :  std_logic_vector(6 downto 0);
signal Z2o2 :  std_logic_vector(5 downto 0);
signal CosPiA_trunc_to_z2o2 :  std_logic_vector(5 downto 0);
signal Z2o2CosPiA :  std_logic_vector(11 downto 0);
signal Z2o2CosPiA_aligned :  std_logic_vector(26 downto 0);
signal CosPiACosZ :  std_logic_vector(26 downto 0);
signal SinPiA_trunc_to_z2o2 :  std_logic_vector(5 downto 0);
signal Z2o2SinPiA :  std_logic_vector(11 downto 0);
signal Z2o2SinPiA_aligned :  std_logic_vector(26 downto 0);
signal SinPiACosZ :  std_logic_vector(26 downto 0);
signal CosPiAZ :  std_logic_vector(43 downto 0);
signal CosPiASinZ :  std_logic_vector(26 downto 0);
signal SinPiAZ :  std_logic_vector(43 downto 0);
signal SinPiASinZ :  std_logic_vector(26 downto 0);
signal PreSinX :  std_logic_vector(26 downto 0);
signal PreCosX :  std_logic_vector(26 downto 0);
signal C_out :  std_logic_vector(22 downto 0);
signal S_out :  std_logic_vector(22 downto 0);
signal C_sgn :  std_logic;
signal Exch :  std_logic;
signal S_wo_sgn :  std_logic_vector(22 downto 0);
signal C_wo_sgn :  std_logic_vector(22 downto 0);
signal S_wo_sgn_ext :  std_logic_vector(23 downto 0);
signal C_wo_sgn_ext :  std_logic_vector(23 downto 0);
signal S_wo_sgn_neg :  std_logic_vector(23 downto 0);
signal C_wo_sgn_neg :  std_logic_vector(23 downto 0);
signal input_res    :  sfixed(23 downto 0);
signal X            :  std_logic_vector(23 downto 0);

begin
    
   input_res <= resize(input,0,-23);
   X <= to_slv(input_res);
   -- The argument is reduced into (0,1/4)
   X_sgn <= X(23);  -- sign
   Q <= X(22);  -- quadrant
   O <= X(21);  -- octant
   Y <= X (20 downto 0);
   -- Computing .25-Y :  we do a logic NOT, at a cost of 1 ulp
   Yneg <= ((not Y) & "1111") when O='1' else (Y & "0000");
   A <= Yneg (24 downto 15);
   Y_red <= Yneg(14 downto 0);
   sinCosPiATable: sinCosPiATable_F0_uid4
      port map ( X => A,
                 Y => SCA);
   SinPiA <= SCA (53 downto 27);
   CosPiA <= SCA (26 downto 0);
   MultByPi: FixRealKCM_F0_uid6
      port map ( X => Y_red,
                 R => Z);
   Z_trunc_for_square<= Z (16 downto 11);
   ZSquarer: FixFunctionByTable_F0_uid27
      port map ( X => Z_trunc_for_square,
                 Y => Z2o2_w);
   Z2o2 <= Z2o2_w(5 downto 0); -- get rid of the possible constant 0
   CosPiA_trunc_to_z2o2 <= CosPiA(26 downto 21);
   Z2o2CosPiA <=  CosPiA_trunc_to_z2o2 * Z2o2;
   Z2o2CosPiA_aligned <= "000000000000000000000" & Z2o2CosPiA(11 downto 6);
   CosPiACosZ<= CosPiA - Z2o2CosPiA_aligned;
   SinPiA_trunc_to_z2o2 <= SinPiA(26 downto 21);
   Z2o2SinPiA <=  SinPiA_trunc_to_z2o2 * Z2o2;
   Z2o2SinPiA_aligned <= "000000000000000000000" & Z2o2SinPiA(11 downto 6);
   SinPiACosZ<= SinPiA - Z2o2SinPiA_aligned;
   CosPiAZ <= CosPiA*Z;  -- TODO check it fits DSP
   CosPiASinZ <= "0000000000" & CosPiAZ(43 downto 27);
   SinPiAZ <= SinPiA*Z;  -- TODO check it fits DSP
   SinPiASinZ <= "0000000000" & SinPiAZ(43 downto 27);
   PreSinX <= SinPiACosZ + CosPiASinZ;
   PreCosX <= CosPiACosZ - SinPiASinZ;
   C_out <= PreCosX(26 downto 4);
   S_out <= PreSinX(26 downto 4);
   -- --- Final reconstruction of both sine and cosine ---
   C_sgn <= X_sgn xor Q;
   Exch <= Q xor O;
   S_wo_sgn <= C_out when Exch = '1' else S_out;
   C_wo_sgn <= S_out when Exch = '1' else C_out;
   S_wo_sgn_ext <= '0' & S_wo_sgn;
   C_wo_sgn_ext <= '0' & C_wo_sgn;
   S_wo_sgn_neg <= (not S_wo_sgn_ext) + 1;
   C_wo_sgn_neg <= (not C_wo_sgn_ext) + 1;
   SIN <= to_sfixed(S_wo_sgn_ext,0,-23) when X_sgn = '0' else to_sfixed(S_wo_sgn_neg,0,-23);
   COS <= to_sfixed(C_wo_sgn_ext,0,-23) when C_sgn = '0' else to_sfixed(C_wo_sgn_neg,0,-23);
end architecture;

