"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DelayValueCollector = void 0;
class DelayValueCollector {
    constructor(op, masterSet) {
        this.op = op;
        this.masterSet = masterSet;
        this.masterList = [];
        this.masterIDSet = new Set();
        this.relocation = [];
    }
    addMaster(master) {
        const rec = this.masterSet.getOrPush(master);
        if (rec) {
            this.masterIDSet.add(rec.index);
            this.masterList[rec.index] = master;
            return rec.index;
        }
        else {
            return undefined;
        }
    }
    collect(x) {
        const origin = this.op.originOf(x);
        const deltaMA = [];
        for (const [master, delta] of this.op.varianceOf(x)) {
            if (!delta)
                continue;
            const index = this.addMaster(master);
            if (index === undefined)
                continue;
            deltaMA[index] = (deltaMA[index] || 0) + delta;
        }
        return this.createCollectedValue(origin, deltaMA);
    }
    settleDown() {
        this.relocation = [...this.masterIDSet].sort((a, b) => a - b);
    }
    resolveDeltas(dma) {
        const deltas = [];
        for (let mu = 0; mu < this.relocation.length; mu++) {
            deltas[mu] = dma[this.relocation[mu]] || 0;
        }
        return deltas;
    }
    getMasterList() {
        return this.relocation.map(r => [r, this.masterList[r]]);
    }
    get size() {
        return this.masterSet.size;
    }
}
exports.DelayValueCollector = DelayValueCollector;
//# sourceMappingURL=value-collector.js.map